/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.uml2.diagram.usecase.draw2d;

import org.eclipse.draw2d.AbstractBorder;
import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.swt.graphics.Color;
import org.eclipse.uml2.diagram.usecase.draw2d.AbstractProportionalShape;

public abstract class ShadowShape
extends AbstractProportionalShape {
    private static final Color SHADOW_COLOR = new Color(null, 150, 150, 150);
    private static final int SHADOW_SIZE = 3;
    private static final Insets SHADOW_INSETS = new Insets(0, 0, 3, 3);
    private boolean my3D;
    private Border myBorder;

    public ShadowShape(boolean is3D, Color backgroundColor, Color foregroundColor) {
        this.setForegroundColor(foregroundColor);
        this.setBackgroundColor(backgroundColor);
        this.myBorder = new ShadowBorder();
        this.setBorder(this.myBorder);
        this.set3D(is3D);
    }

    protected boolean is3D() {
        return this.my3D;
    }

    public void set3D(boolean is3D) {
        if (this.my3D == is3D) {
            return;
        }
        this.my3D = is3D;
        this.repaint();
    }

    public Dimension getPreferredSize(int wHint, int hHint) {
        Dimension original = super.getPreferredSize(wHint, hHint);
        if (this.is3D()) {
            original.expand(3, 3);
        }
        return original;
    }

    public void paint(Graphics graphics) {
        this.paintBorder(graphics);
        if (this.getBackgroundColor() != null) {
            graphics.setBackgroundColor(this.getBackgroundColor());
        }
        if (this.getForegroundColor() != null) {
            graphics.setForegroundColor(this.getForegroundColor());
        }
        if (this.getFont() != null) {
            graphics.setFont(this.getFont());
        }
        this.paintFigure(graphics);
        this.paintClientArea(graphics);
    }

    protected void fillShape(Graphics graphics) {
        this.fillShape(graphics, this.getProportionalBounds());
    }

    protected abstract void fillShape(Graphics var1, Rectangle var2);

    protected void outlineShape(Graphics graphics) {
        this.outlineShape(graphics, this.getProportionalBounds());
    }

    protected abstract void outlineShape(Graphics var1, Rectangle var2);

    private class ShadowBorder
    extends AbstractBorder {
        private ShadowBorder() {
        }

        public Insets getInsets(IFigure figure) {
            return ShadowShape.this.is3D() ? SHADOW_INSETS : IFigure.NO_INSETS;
        }

        public boolean isOpaque() {
            return ShadowShape.this.is3D();
        }

        public void paint(IFigure figure, Graphics graphics, Insets insets) {
            if (!ShadowShape.this.is3D()) {
                return;
            }
            graphics.setBackgroundColor(SHADOW_COLOR);
            Rectangle rec = ShadowShape.this.getProportionalBounds().getTranslated(3, 3);
            graphics.pushState();
            graphics.clipRect(rec);
            ShadowShape.this.fillShape(graphics, rec);
            graphics.popState();
        }
    }
}

