/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.uml2.diagram.common.parameter.celleditors;

import org.eclipse.jface.viewers.ICellEditorValidator;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.swt.widgets.Composite;

public class PositiveIntegerCellEditor
extends TextCellEditor {
    public PositiveIntegerCellEditor(Composite parent) {
        super(parent);
        this.setValidator(this.getIntegerValidator());
    }

    protected void doSetValue(Object value) {
        super.doSetValue((Object)((Integer)value).toString());
    }

    protected Object doGetValue() {
        return Integer.parseInt((String)super.doGetValue());
    }

    private ICellEditorValidator getIntegerValidator() {
        return new ICellEditorValidator(){

            public String isValid(Object value) {
                if (value instanceof Integer) {
                    Integer intValue = (Integer)value;
                    return this.isValid(intValue);
                }
                try {
                    Integer intValue = Integer.parseInt((String)value);
                    return this.isValid(intValue);
                }
                catch (NumberFormatException nfe) {
                    return nfe.getMessage();
                }
            }

            private String isValid(Integer intValue) {
                return intValue >= 0 ? null : "Value must be a positive number";
            }
        };
    }
}

