/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.uml2.diagram.common.pathmap;

import java.net.JarURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.eclipse.emf.common.util.URI;
import org.eclipse.uml2.diagram.common.pathmap.PathMapResolver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArchivePathMapResolver
extends PathMapResolver {
    @Override
    public Collection<String> getProfiles(URI uri, String pathmapVarName) throws Exception {
        URL url = new URL(uri.toString());
        JarURLConnection urlConnection = (JarURLConnection)url.openConnection();
        JarFile jarFile = urlConnection.getJarFile();
        JarEntry pathmapEntry = urlConnection.getJarEntry();
        if (!pathmapEntry.isDirectory()) {
            return Collections.emptyList();
        }
        ArrayList<String> pathmaps = new ArrayList<String>();
        String pathmapEntryName = pathmapEntry.getName();
        Enumeration<JarEntry> entries = jarFile.entries();
        while (entries.hasMoreElements()) {
            JarEntry entry = entries.nextElement();
            String entryName = entry.getName();
            if (!entryName.startsWith(pathmapEntryName) || !this.isProfileFile(entryName)) continue;
            String profileName = entryName;
            profileName = profileName.substring(pathmapEntryName.length());
            String pathmap = PATHMAP_FORMAT.format(new Object[]{pathmapVarName, profileName});
            pathmaps.add(pathmap);
        }
        return pathmaps;
    }

    @Override
    public boolean isApplicable(URI uri) {
        return uri.isArchive();
    }
}

