/**
 * Copyright (c) 2006 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *   IBM - Initial API and implementation
 *
 * $Id: RDFSResource.java,v 1.1 2007/03/18 08:10:08 lzhang Exp $
 */
package org.eclipse.eodm.rdf.rdfbase;

import java.util.ArrayList;
import org.eclipse.emf.common.util.EList;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.eodm.exceptions.UnsupportedViewTypeException;

/**
 * <!-- begin-user-doc -->
 * A representation of the model object '<em><b>RDFS Resource</b></em>'.
 * <!-- end-user-doc -->
 *
 * <p>
 * The following ODM features are supported:
 * <ul>
 *   <li>{@link org.eclipse.eodm.rdf.rdfbase.RDFSResource#getRDFSisDefinedBy <em>RDFSisDefinedBy</em>}</li>
 *   <li>{@link org.eclipse.eodm.rdf.rdfbase.RDFSResource#getRDFSseeAlso <em>RDFSseeAlso</em>}</li>
 *   <li>{@link org.eclipse.eodm.rdf.rdfbase.RDFSResource#getRDFtype <em>RDFtype</em>}</li>
 *   <li>{@link org.eclipse.eodm.rdf.rdfbase.RDFSResource#getRDFSmember <em>RDFSmember</em>}</li>
 *   <li>{@link org.eclipse.eodm.rdf.rdfbase.RDFSResource#getNodeID <em>nodeID</em>}</li>
 *   <li>{@link org.eclipse.eodm.rdf.rdfbase.RDFSResource#getRDFScomment <em>RDFScomment</em>}</li>
 *   <li>{@link org.eclipse.eodm.rdf.rdfbase.RDFSResource#getRDFSlabel <em>RDFSlabel</em>}</li>
 *   <li>{@link org.eclipse.eodm.rdf.rdfbase.RDFSResource#getUriRef <em>uriRef</em>}</li>
 *   <li>{@link org.eclipse.eodm.rdf.rdfbase.RDFSResource#getSubjectStatement <em>subjectStatement</em>}</li>
 * </ul>
 * </p>
 *
 * @see org.eclipse.eodm.rdf.rdfbase.util.RDFBasePackage#getRDFSResource()
 * @model
 * @generated
 */
public interface RDFSResource extends EObject {
	
	ArrayList getCustomTriples();
	String getURI();
	
	/**
	 * Returns the value of the '<em><b>RDFSisDefinedBy</b></em>' reference list.
	 * The list contents are of type {@link org.eclipse.eodm.rdf.rdfbase.RDFSResource}.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>RDF Sis Defined By</em>' reference list isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>RDFSisDefinedBy</em>' reference list.
	 * @see org.eclipse.eodm.rdf.rdfbase.util.RDFBasePackage#getRDFSResource_RDFSisDefinedBy()
	 * @model type="org.eclipse.eodm.rdf.rdfbase.RDFSResource"
	 * @generated
	 */
	EList getRDFSisDefinedBy();

	/**
	 * Returns the value of the '<em><b>RDFSseeAlso</b></em>' reference list.
	 * The list contents are of type {@link org.eclipse.eodm.rdf.rdfbase.RDFSResource}.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>RDF Ssee Also</em>' reference list isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>RDFSseeAlso</em>' reference list.
	 * @see org.eclipse.eodm.rdf.rdfbase.util.RDFBasePackage#getRDFSResource_RDFSseeAlso()
	 * @model type="org.eclipse.eodm.rdf.rdfbase.RDFSResource"
	 * @generated
	 */
	EList getRDFSseeAlso();

	/**
	 * Returns the value of the '<em><b>RDFtype</b></em>' reference list.
	 * The list contents are of type {@link org.eclipse.eodm.rdf.rdfs.RDFSClass}.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>RD Ftype</em>' reference list isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>RDFtype</em>' reference list.
	 * @see org.eclipse.eodm.rdf.rdfbase.util.RDFBasePackage#getRDFSResource_RDFtype()
	 * @model type="org.eclipse.eodm.rdf.rdfs.RDFSClass" required="true"
	 * @generated
	 */
	EList getRDFtype();

	/**
	 * Returns the value of the '<em><b>RDFSmember</b></em>' reference list.
	 * The list contents are of type {@link org.eclipse.eodm.rdf.rdfbase.RDFSResource}.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>RDF Smember</em>' reference list isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>RDFSmember</em>' reference list.
	 * @see org.eclipse.eodm.rdf.rdfbase.util.RDFBasePackage#getRDFSResource_RDFSmember()
	 * @model type="org.eclipse.eodm.rdf.rdfbase.RDFSResource"
	 * @generated
	 */
	EList getRDFSmember();

	/**
	 * Returns the value of the '<em><b>nodeID</b></em>' attribute.
	 * The default value is <code>""</code>.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Node ID</em>' attribute isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>nodeID</em>' attribute.
	 * @see #setNodeID(String)
	 * @see org.eclipse.eodm.rdf.rdfbase.util.RDFBasePackage#getRDFSResource_NodeID()
	 * @model default="" required="true"
	 * @generated
	 */
	String getNodeID();

	/**
	 * Sets the value of the '{@link org.eclipse.eodm.rdf.rdfbase.RDFSResource#getNodeID <em>nodeID</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>nodeID</em>' attribute.
	 * @see #getNodeID()
	 * @generated
	 */
	void setNodeID(String value);

	/**
	 * Returns the value of the '<em><b>RDFScomment</b></em>' containment reference list.
	 * The list contents are of type {@link org.eclipse.eodm.rdf.rdfbase.PlainLiteral}.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>RDF Scomment</em>' containment reference list isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>RDFScomment</em>' containment reference list.
	 * @see org.eclipse.eodm.rdf.rdfbase.util.RDFBasePackage#getRDFSResource_RDFScomment()
	 * @model type="org.eclipse.eodm.rdf.rdfbase.PlainLiteral" containment="true"
	 * @generated
	 */
	EList getRDFScomment();

	/**
	 * Returns the value of the '<em><b>RDFSlabel</b></em>' containment reference list.
	 * The list contents are of type {@link org.eclipse.eodm.rdf.rdfbase.PlainLiteral}.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>RDF Slabel</em>' containment reference list isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>RDFSlabel</em>' containment reference list.
	 * @see org.eclipse.eodm.rdf.rdfbase.util.RDFBasePackage#getRDFSResource_RDFSlabel()
	 * @model type="org.eclipse.eodm.rdf.rdfbase.PlainLiteral" containment="true"
	 * @generated
	 */
	EList getRDFSlabel();

	/**
	 * Returns the value of the '<em><b>uriRef</b></em>' containment reference list.
	 * The list contents are of type {@link org.eclipse.eodm.rdf.rdfbase.URIReference}.
	 * It is bidirectional and its opposite is '{@link org.eclipse.eodm.rdf.rdfbase.URIReference#getResource <em>resource</em>}'.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Uri Ref</em>' containment reference list isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>uriRef</em>' containment reference list.
	 * @see org.eclipse.eodm.rdf.rdfbase.util.RDFBasePackage#getRDFSResource_UriRef()
	 * @see org.eclipse.eodm.rdf.rdfbase.URIReference#getResource
	 * @model type="org.eclipse.eodm.rdf.rdfbase.URIReference" opposite="resource" containment="true"
	 * @generated
	 */
	EList getUriRef();

	/**
	 * Returns the value of the '<em><b>subjectStatement</b></em>' reference list.
	 * The list contents are of type {@link org.eclipse.eodm.rdf.rdfbase.RDFStatement}.
	 * It is bidirectional and its opposite is '{@link org.eclipse.eodm.rdf.rdfbase.RDFStatement#getRDFsubject <em>RDFsubject</em>}'.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Subject Statement</em>' reference list isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>subjectStatement</em>' reference list.
	 * @see org.eclipse.eodm.rdf.rdfbase.util.RDFBasePackage#getRDFSResource_SubjectStatement()
	 * @see org.eclipse.eodm.rdf.rdfbase.RDFStatement#getRDFsubject
	 * @model type="org.eclipse.eodm.rdf.rdfbase.RDFStatement" opposite="RDFsubject"
	 * @generated
	 */
	EList getSubjectStatement();
	 /**
     * Get a Java object of type <code>newType</code> that represents the same
     * resource as this object. 
     * 
     * <p>This method is added to support dynamic typing in RDF/OWL. It obtains 
     * another view of the same resource that this object represents. For example,
     * if, in a RDF graph, a resource is declared to be both a class and a property,
     * you can use the following code to access the resource as both a class
     * and a property:<p>
     * <pre>
     *     RDFFactory rdfFactory = ... // obtain a factory from implementation
     *     
     *     // get the class
     *     RDFSClass c = rdfFactory.createRDFSClass( "urn:example.com:poly" );
     *     
     *     // get the the same resource as a property
     *     RDFProperty p = (RDFProperty) c.asType( RDFProperty.class );
     *     
     *     // let's assume that the class c has no label yet
     *     assert( c.getRDFSLabel().size() == 0 );
     *     
     *     // if we add a label to the property
     *     p.getRDFSLabel().add( rdfFactory.createPlainLiteral("poly") );
     *     
     *     // since p and c represent the same resource, the label will also
     *     // appear in the class c
     *     assert( c.getRDFSLabel().size() == 1 );
     * </pre> 
     * <p>When you access the same resource using different types of Java objects, 
     * the implementation will automatically maintain the consisitency among the 
     * different Java objects.</p>
     * 
     * <a name="threeconditions"></a>
     * <p><strong>Three conditions must be met for this method to return successfully.</strong>
     * <ul>
     *   <li> This object itself can not be an instance of {@link org.eclipse.eodm.RDF.RDFWeb.Document Document},
     *   {@link org.eclipse.eodm.RDF.RDFS.RDFBase.RDFGraph RDFGraph} or 
     *   {@link org.eclipse.eodm.OWL.OWLBase.OWLGraph OWLGraph}. 
     *   
     *   <li> The new type must be a subinterface of <code>RDFSResource</code>. 
     *   That is, the assertion <code>RDFSResource.class.isAssignableFrom( newType )</code> 
     *   must hold. This is obvious since RDFResource is the superinterface of
     *   all model resources in RDF/OWL models. In addition, the <code>newType</code>
     *   can not be any of the three: {@link org.eclipse.eodm.RDF.RDFWeb.Document Document},
     *   {@link org.eclipse.eodm.RDF.RDFS.RDFBase.RDFGraph RDFGraph} and 
     *   {@link org.eclipse.eodm.OWL.OWLBase.OWLGraph OWLGraph}. <p>
     *   
     *   <li> The statements in the context graph of this object support viewing
     *   this object as the <code>newType</code>. The semantics of "support" is
     *   delegated to the implementations of this method to clarify. For example,
     *   The new type is supported if there is a rdf:type statement in the graph for this
     *   resource and the new type. However, you can force the conversion of 
     *   a new type using the {@link RDFSResource#forceAsType(Class) forceAsType(newType)}
     *   method. You can also use the {@link #canAsType(Class)} method to check
     *   whether the new type is supported by the statements in the context graph.
     * </ul>
     *   
     * <p>After you obtained the new type object, you can safely cast the object to 
     * the new type as: 
     * <pre>NewType o2 = (NewType) o1.asType( NewType.class )</pre>
     *         
     * @param newType the Java class object representing the new type. 
     * @return a Java object of type <code>newType</code> and represents the same
     *         resource as this object. 
     * @throws UnsupportedViewTypeException if the <a href="#threeconditions">three 
     *         conditions documented above</a> are not met.
     *         
     * @see #canAsType(Class)
     * @see #forceAsType(Class)
     * 
     * @eodmext This method is added by EODM to support dynamic typing capability.         
     */
    RDFSResource asType(Class newType) throws UnsupportedViewTypeException;

    /**
     * Get a Java object of type <code>newType</code> that represents the same
     * resource as this object. 
     * 
     * <p>This method is almost identical to the 
     * {@link #asType(Class) asType(Class)} method except that it does not 
     * require the statements in the context graph of this object support viewing
     * this object as the <code>newType</code>. However, this method still
     * requires the top two conditions of the <a href="#threeconditions">three 
     * conditions documented above</a>.
     * 
     * @param newType the Java class object representing the new type
     * @return a Java object of type <code>newType</code> and represents the same
     *         resource as this object. 
     * @throws UnsupportedViewTypeException if the top two conditions of the
     *         <a href="#threeconditions">three conditions documented above</a> 
     *         are not met.
     *         
     * @see #asType(Class)
     * @see #canAsType(Class)
     * 
     * @eodmext This method is added by EODM to support dynamic typing capability.
     */
    RDFSResource forceAsType(Class newType) throws UnsupportedViewTypeException;

    /**
     * Explicitly check whether we can obtain a new type view of this object.
     *  
     * Explicitly check whether the <a href="#threeconditions">three conditions 
     * documented above</a> are met for obtaining a new type view of this object
     * for the same resource this object represents. Especially, check whether 
     * the statements in the context graph of this object support viewing 
     * this object as the <code>newType</code>. Implementation of this method
     * should clarify the semantics of "support" clearly.
     * 
     * @param newType the Java class object representing the new type
     * @return whether the new type is supported.
     * 
     * @see #asType(Class)
     * @see #forceAsType(Class)
     * 
     * @eodmext This method is added by EODM to support dynamic typing capability.
     */
    boolean canAsType(Class newType);
    
    RDFSResource[] getAllTypeViews();

} // RDFSResource
