/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.am3.tools.tge.editor;

import java.util.Iterator;
import java.util.Set;
import java.util.Vector;
import org.eclipse.am3.tools.tge.editor.AllColor;
import org.eclipse.am3.tools.tge.editor.BlockColor;
import org.eclipse.am3.tools.tge.editor.TextualGenericEditor;
import org.eclipse.am3.tools.tge.editor.WordsColor;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;

public class Lexems {
    private TextualGenericEditor tge;
    private Vector block;
    private Vector group;
    String language_name;
    String plugin_rep;

    public Lexems(TextualGenericEditor tge) {
        this.tge = tge;
        this.init();
    }

    public void init() {
        this.block = new Vector();
        this.group = new Vector();
        this.load();
    }

    public void load() {
        Set elements = this.tge.getHandler().getElementsByType("Editor");
        Iterator it = elements.iterator();
        while (it.hasNext()) {
            EObject eoo = (EObject)it.next();
            TreeIterator it2 = eoo.eAllContents();
            while (it2.hasNext()) {
                EObject eo = (EObject)it2.next();
                if (eo.eClass().getName().equals("Block")) {
                    this.block.add(this.createBlockColor(eo));
                }
                if (!eo.eClass().getName().equals("GroupElement")) continue;
                this.group.add(this.createWordsColor(eo));
            }
        }
    }

    public BlockColor createBlockColor(EObject eo) {
        EStructuralFeature sf2 = eo.eClass().getEStructuralFeature("blockbegin");
        String begin = (String)eo.eGet(sf2);
        EStructuralFeature sf3 = eo.eClass().getEStructuralFeature("blockend");
        String end = (String)eo.eGet(sf3);
        BlockColor bc = new BlockColor(begin, end);
        TreeIterator it = eo.eAllContents();
        while (it.hasNext()) {
            EObject e = (EObject)it.next();
            this.setColorAndStyle(e, bc);
        }
        return bc;
    }

    public void setColorAndStyle(EObject e, AllColor ac) {
        if (e.eClass().getName().equals("Format")) {
            TreeIterator it = e.eAllContents();
            while (it.hasNext()) {
                EObject ee = (EObject)it.next();
                if (ee.eClass().getName().equals("Color")) {
                    ac.setColor(new Color((Device)Display.getCurrent(), new RGB(((Integer)ee.eGet(ee.eClass().getEStructuralFeature("red"))).intValue(), ((Integer)ee.eGet(ee.eClass().getEStructuralFeature("green"))).intValue(), ((Integer)ee.eGet(ee.eClass().getEStructuralFeature("blue"))).intValue())));
                }
                if (!ee.eClass().getName().equals("Font")) continue;
                int style = 0;
                if (ee.eGet(ee.eClass().getEStructuralFeature("bold")) != null && ee.eGet(ee.eClass().getEStructuralFeature("bold")).toString().equals("true")) {
                    ++style;
                }
                if (ee.eGet(ee.eClass().getEStructuralFeature("italic")) != null && ee.eGet(ee.eClass().getEStructuralFeature("italic")).toString().equals("true")) {
                    style += 2;
                }
                ac.setStyle(style);
            }
        }
    }

    public WordsColor createWordsColor(EObject eo) {
        WordsColor wc = new WordsColor();
        TreeIterator it3 = eo.eAllContents();
        while (it3.hasNext()) {
            EObject e = (EObject)it3.next();
            this.setColorAndStyle(e, wc);
            if (!e.eClass().getName().equals("Element")) continue;
            EStructuralFeature sf3 = e.eClass().getEStructuralFeature("element");
            String tname1 = (String)e.eGet(sf3);
            wc.addWord(tname1);
        }
        return wc;
    }

    public Vector getBlock() {
        return this.block;
    }

    public void setBlock(Vector block) {
        this.block = block;
    }

    public Vector getGroup() {
        return this.group;
    }

    public void setGroup(Vector group) {
        this.group = group;
    }
}

