/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.provisional.commons.soap;

import java.rmi.RemoteException;
import java.util.concurrent.Callable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.mylyn.commons.net.AbstractWebLocation;
import org.eclipse.mylyn.commons.net.AuthenticationType;
import org.eclipse.mylyn.commons.net.Policy;
import org.eclipse.mylyn.commons.net.UnsupportedRequestException;
import org.eclipse.mylyn.commons.net.WebRequest;
import org.eclipse.mylyn.commons.net.WebUtil;
import org.eclipse.mylyn.internal.commons.soap.SoapRequest;

public abstract class AbstractSoapClient {
    protected <T> T call(IProgressMonitor monitor, Callable<T> runnable) throws Exception {
        while (true) {
            try {
                return this.callOnce(monitor, runnable);
            }
            catch (Exception e) {
                try {
                    if (this.isAuthenticationException(e) && this.doLogin(monitor)) {
                        return this.callOnce(monitor, runnable);
                    }
                    throw e;
                }
                catch (Exception e2) {
                    if (this.isAuthenticationException(e2)) {
                        try {
                            this.getLocation().requestCredentials(AuthenticationType.REPOSITORY, null, monitor);
                        }
                        catch (UnsupportedRequestException unsupportedRequestException) {
                            throw e2;
                        }
                        continue;
                    }
                    throw e2;
                }
            }
            break;
        }
    }

    protected <T> T callOnce(IProgressMonitor monitor, final Callable<T> runnable) throws Exception {
        try {
            monitor = Policy.monitorFor((IProgressMonitor)monitor);
            final SoapRequest request = new SoapRequest(monitor);
            return (T)WebUtil.execute((IProgressMonitor)monitor, (WebRequest)new WebRequest<T>(){

                public void abort() {
                    request.cancel();
                }

                public T call() throws Exception {
                    try {
                        SoapRequest.setCurrentRequest(request);
                        Object v = runnable.call();
                        return v;
                    }
                    finally {
                        request.done();
                    }
                }
            });
        }
        catch (RemoteException e) {
            throw e;
        }
        catch (Exception e) {
            throw e;
        }
        catch (Error e) {
            throw e;
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }

    protected abstract AbstractWebLocation getLocation();

    protected abstract boolean isAuthenticationException(Exception var1);

    protected abstract boolean doLogin(IProgressMonitor var1);
}

