/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.ui.util;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.mylyn.commons.core.StatusHandler;
import org.eclipse.mylyn.internal.tasks.core.TaskRepositoryManager;
import org.eclipse.mylyn.internal.tasks.core.activity.DefaultTaskActivityMonitor;
import org.eclipse.mylyn.internal.tasks.core.context.DefaultTaskContextStore;
import org.eclipse.mylyn.internal.tasks.core.externalization.TaskListExternalizer;
import org.eclipse.mylyn.internal.tasks.core.util.ContributorBlackList;
import org.eclipse.mylyn.internal.tasks.core.util.RepositoryConnectorExtensionReader;
import org.eclipse.mylyn.internal.tasks.core.util.RepositoryTemplateExtensionReader;
import org.eclipse.mylyn.internal.tasks.ui.IDynamicSubMenuContributor;
import org.eclipse.mylyn.internal.tasks.ui.TasksUiPlugin;
import org.eclipse.mylyn.internal.tasks.ui.util.RepositoryConnectorUiExtensionReader;
import org.eclipse.mylyn.internal.tasks.ui.views.AbstractTaskListPresentation;
import org.eclipse.mylyn.internal.tasks.ui.views.TaskListView;
import org.eclipse.mylyn.tasks.core.AbstractDuplicateDetector;
import org.eclipse.mylyn.tasks.core.activity.AbstractTaskActivityMonitor;
import org.eclipse.mylyn.tasks.core.context.AbstractTaskContextStore;
import org.eclipse.mylyn.tasks.core.spi.RepositoryConnectorDescriptor;
import org.eclipse.mylyn.tasks.ui.AbstractTaskRepositoryLinkProvider;
import org.eclipse.mylyn.tasks.ui.TasksUi;
import org.eclipse.mylyn.tasks.ui.editors.AbstractTaskEditorPageFactory;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class TasksUiExtensionReader {
    public static final String EXTENSION_REPOSITORIES = "org.eclipse.mylyn.tasks.ui.repositories";
    public static final String EXTENSION_REPOSITORY_LINKS_PROVIDERS = "org.eclipse.mylyn.tasks.ui.projectLinkProviders";
    public static final String ELMNT_REPOSITORY_LINK_PROVIDER = "linkProvider";
    public static final String ELMNT_REPOSITORY_UI = "connectorUi";
    public static final String ELMNT_TYPE = "type";
    public static final String ELMNT_QUERY_PAGE = "queryPage";
    public static final String ELMNT_SETTINGS_PAGE = "settingsPage";
    public static final String EXTENSION_TASK_CONTRIBUTOR = "org.eclipse.mylyn.tasks.ui.actions";
    public static final String ATTR_ACTION_CONTRIBUTOR_CLASS = "taskHandlerClass";
    public static final String DYNAMIC_POPUP_ELEMENT = "dynamicPopupMenu";
    public static final String ATTR_CLASS = "class";
    public static final String ATTR_MENU_PATH = "menuPath";
    public static final String EXTENSION_EDITORS = "org.eclipse.mylyn.tasks.ui.editors";
    public static final String ELMNT_TASK_EDITOR_PAGE_FACTORY = "pageFactory";
    public static final String EXTENSION_DUPLICATE_DETECTORS = "org.eclipse.mylyn.tasks.ui.duplicateDetectors";
    public static final String ELMNT_DUPLICATE_DETECTOR = "detector";
    public static final String ATTR_NAME = "name";
    public static final String ATTR_KIND = "kind";
    private static final String EXTENSION_PRESENTATIONS = "org.eclipse.mylyn.tasks.ui.presentations";
    public static final String ELMNT_PRESENTATION = "presentation";
    public static final String ATTR_ICON = "icon";
    public static final String ATTR_PRIMARY = "primary";
    public static final String ATTR_ID = "id";
    private static boolean coreExtensionsRead = false;
    private static ContributorBlackList blackList = new ContributorBlackList();
    private static Set<RepositoryConnectorDescriptor> descriptors = new HashSet<RepositoryConnectorDescriptor>();

    public static void initStartupExtensions(TaskListExternalizer taskListExternalizer, TaskRepositoryManager repositoryManager) {
        if (!coreExtensionsRead) {
            IExtension[] editors;
            IExtension[] presentations;
            IExtensionRegistry registry = Platform.getExtensionRegistry();
            RepositoryConnectorExtensionReader reader = new RepositoryConnectorExtensionReader(taskListExternalizer, repositoryManager);
            reader.loadConnectorsFromRepositoriesExtension();
            reader.loadConnectors(registry.getExtensionPoint(EXTENSION_REPOSITORIES));
            reader.loadConnectorsFromContributors();
            reader.registerConnectors();
            descriptors.addAll(reader.getDescriptors());
            blackList.merge(reader.getBlackList());
            RepositoryTemplateExtensionReader templateExtensionReader = new RepositoryTemplateExtensionReader(TasksUi.getRepositoryManager(), TasksUiPlugin.getRepositoryTemplateManager());
            templateExtensionReader.loadExtensions(blackList);
            IExtensionPoint presentationsExtensionPoint = registry.getExtensionPoint(EXTENSION_PRESENTATIONS);
            IExtension[] iExtensionArray = presentations = presentationsExtensionPoint.getExtensions();
            int n = presentations.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement[] elements;
                IExtension presentation = iExtensionArray[n2];
                IConfigurationElement[] iConfigurationElementArray = elements = presentation.getConfigurationElements();
                int n3 = elements.length;
                int n4 = 0;
                while (n4 < n3) {
                    IConfigurationElement element = iConfigurationElementArray[n4];
                    if (!blackList.isDisabled(element)) {
                        TasksUiExtensionReader.readPresentation(element);
                    }
                    ++n4;
                }
                ++n2;
            }
            IExtensionPoint editorsExtensionPoint = registry.getExtensionPoint(EXTENSION_EDITORS);
            IExtension[] iExtensionArray2 = editors = editorsExtensionPoint.getExtensions();
            int n5 = editors.length;
            int n6 = 0;
            while (n6 < n5) {
                IConfigurationElement[] elements;
                IExtension editor = iExtensionArray2[n6];
                IConfigurationElement[] iConfigurationElementArray = elements = editor.getConfigurationElements();
                int n7 = elements.length;
                int n8 = 0;
                while (n8 < n7) {
                    IConfigurationElement element = iConfigurationElementArray[n8];
                    if (!blackList.isDisabled(element) && element.getName().equals(ELMNT_TASK_EDITOR_PAGE_FACTORY)) {
                        TasksUiExtensionReader.readTaskEditorPageFactory(element);
                    }
                    ++n8;
                }
                ++n6;
            }
            coreExtensionsRead = true;
        }
    }

    public static void initWorkbenchUiExtensions() {
        IExtension[] extensions;
        IExtension[] dulicateDetectorsExtensions;
        IExtension[] linkProvidersExtensions;
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        RepositoryConnectorUiExtensionReader reader = new RepositoryConnectorUiExtensionReader(registry, blackList);
        reader.registerConnectorUis();
        IExtensionPoint linkProvidersExtensionPoint = registry.getExtensionPoint(EXTENSION_REPOSITORY_LINKS_PROVIDERS);
        IExtension[] iExtensionArray = linkProvidersExtensions = linkProvidersExtensionPoint.getExtensions();
        int n = linkProvidersExtensions.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement[] elements;
            IExtension linkProvidersExtension = iExtensionArray[n2];
            IConfigurationElement[] iConfigurationElementArray = elements = linkProvidersExtension.getConfigurationElements();
            int n3 = elements.length;
            int n4 = 0;
            while (n4 < n3) {
                IConfigurationElement element = iConfigurationElementArray[n4];
                if (!blackList.isDisabled(element) && element.getName().equals(ELMNT_REPOSITORY_LINK_PROVIDER)) {
                    TasksUiExtensionReader.readLinkProvider(element);
                }
                ++n4;
            }
            ++n2;
        }
        IExtensionPoint duplicateDetectorsExtensionPoint = registry.getExtensionPoint(EXTENSION_DUPLICATE_DETECTORS);
        IExtension[] iExtensionArray2 = dulicateDetectorsExtensions = duplicateDetectorsExtensionPoint.getExtensions();
        int elements = dulicateDetectorsExtensions.length;
        int n5 = 0;
        while (n5 < elements) {
            IConfigurationElement[] elements2;
            IExtension dulicateDetectorsExtension = iExtensionArray2[n5];
            IConfigurationElement[] iConfigurationElementArray = elements2 = dulicateDetectorsExtension.getConfigurationElements();
            int n6 = elements2.length;
            int n7 = 0;
            while (n7 < n6) {
                IConfigurationElement element = iConfigurationElementArray[n7];
                if (!blackList.isDisabled(element) && element.getName().equals(ELMNT_DUPLICATE_DETECTOR)) {
                    TasksUiExtensionReader.readDuplicateDetector(element);
                }
                ++n7;
            }
            ++n5;
        }
        IExtensionPoint extensionPoint = registry.getExtensionPoint(EXTENSION_TASK_CONTRIBUTOR);
        IExtension[] iExtensionArray3 = extensions = extensionPoint.getExtensions();
        int n8 = extensions.length;
        int n9 = 0;
        while (n9 < n8) {
            IConfigurationElement[] elements3;
            IExtension extension = iExtensionArray3[n9];
            IConfigurationElement[] iConfigurationElementArray = elements3 = extension.getConfigurationElements();
            int n10 = elements3.length;
            int n11 = 0;
            while (n11 < n10) {
                IConfigurationElement element = iConfigurationElementArray[n11];
                if (!blackList.isDisabled(element) && element.getName().equals(DYNAMIC_POPUP_ELEMENT)) {
                    TasksUiExtensionReader.readDynamicPopupContributor(element);
                }
                ++n11;
            }
            ++n9;
        }
    }

    private static void readPresentation(IConfigurationElement element) {
        try {
            String name = element.getAttribute(ATTR_NAME);
            String iconPath = element.getAttribute(ATTR_ICON);
            ImageDescriptor imageDescriptor = AbstractUIPlugin.imageDescriptorFromPlugin((String)element.getContributor().getName(), (String)iconPath);
            AbstractTaskListPresentation presentation = (AbstractTaskListPresentation)element.createExecutableExtension(ATTR_CLASS);
            presentation.setPluginId(element.getNamespaceIdentifier());
            presentation.setImageDescriptor(imageDescriptor);
            presentation.setName(name);
            String primary = element.getAttribute(ATTR_PRIMARY);
            if (primary != null && primary.equals("true")) {
                presentation.setPrimary(true);
            }
            TaskListView.addPresentation(presentation);
        }
        catch (Throwable e) {
            StatusHandler.log((IStatus)new Status(4, "org.eclipse.mylyn.tasks.ui", "Could not load presentation extension", e));
        }
    }

    private static void readDuplicateDetector(IConfigurationElement element) {
        try {
            Object obj = element.createExecutableExtension(ATTR_CLASS);
            if (obj instanceof AbstractDuplicateDetector) {
                AbstractDuplicateDetector duplicateDetector = (AbstractDuplicateDetector)obj;
                duplicateDetector.setName(element.getAttribute(ATTR_NAME));
                duplicateDetector.setConnectorKind(element.getAttribute(ATTR_KIND));
                TasksUiPlugin.getDefault().addDuplicateDetector(duplicateDetector);
            } else {
                StatusHandler.log((IStatus)new Status(4, "org.eclipse.mylyn.tasks.ui", "Could not load duplicate detector " + obj.getClass().getCanonicalName()));
            }
        }
        catch (Throwable e) {
            StatusHandler.log((IStatus)new Status(4, "org.eclipse.mylyn.tasks.ui", "Could not load duplicate detector", e));
        }
    }

    private static void readLinkProvider(IConfigurationElement element) {
        try {
            Object repositoryLinkProvider = element.createExecutableExtension(ATTR_CLASS);
            if (repositoryLinkProvider instanceof AbstractTaskRepositoryLinkProvider) {
                TasksUiPlugin.getDefault().addRepositoryLinkProvider((AbstractTaskRepositoryLinkProvider)repositoryLinkProvider);
            } else {
                StatusHandler.log((IStatus)new Status(4, "org.eclipse.mylyn.tasks.ui", "Could not load repository link provider " + repositoryLinkProvider.getClass().getCanonicalName()));
            }
        }
        catch (Throwable e) {
            StatusHandler.log((IStatus)new Status(4, "org.eclipse.mylyn.tasks.ui", "Could not load repository link provider", e));
        }
    }

    private static void readTaskEditorPageFactory(IConfigurationElement element) {
        String id = element.getAttribute(ATTR_ID);
        if (id == null) {
            StatusHandler.log((IStatus)new Status(4, "org.eclipse.mylyn.tasks.ui", "Editor page factory must specify id"));
            return;
        }
        try {
            Object item = element.createExecutableExtension(ATTR_CLASS);
            if (item instanceof AbstractTaskEditorPageFactory) {
                AbstractTaskEditorPageFactory editorPageFactory = (AbstractTaskEditorPageFactory)item;
                editorPageFactory.setId(id);
                editorPageFactory.setPluginId(element.getNamespaceIdentifier());
                TasksUiPlugin.getDefault().addTaskEditorPageFactory(editorPageFactory);
            } else {
                StatusHandler.log((IStatus)new Status(4, "org.eclipse.mylyn.tasks.ui", "Could not load editor page factory " + item.getClass().getCanonicalName() + " must implement " + AbstractTaskEditorPageFactory.class.getCanonicalName()));
            }
        }
        catch (Throwable e) {
            StatusHandler.log((IStatus)new Status(4, "org.eclipse.mylyn.tasks.ui", "Could not load page editor factory", e));
        }
    }

    private static void readDynamicPopupContributor(IConfigurationElement element) {
        try {
            Object dynamicPopupContributor = element.createExecutableExtension(ATTR_CLASS);
            String menuPath = element.getAttribute(ATTR_MENU_PATH);
            if (dynamicPopupContributor instanceof IDynamicSubMenuContributor) {
                TasksUiPlugin.getDefault().addDynamicPopupContributor(menuPath, (IDynamicSubMenuContributor)dynamicPopupContributor);
            } else {
                StatusHandler.log((IStatus)new Status(4, "org.eclipse.mylyn.tasks.ui", "Could not load dynamic popup menu: " + dynamicPopupContributor.getClass().getCanonicalName() + " must implement " + IDynamicSubMenuContributor.class.getCanonicalName()));
            }
        }
        catch (Throwable e) {
            StatusHandler.log((IStatus)new Status(4, "org.eclipse.mylyn.tasks.ui", "Could not load dynamic popup menu extension", e));
        }
    }

    public static AbstractTaskActivityMonitor loadTaskActivityMonitor() {
        IExtension[] extensions;
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtensionPoint connectorsExtensionPoint = registry.getExtensionPoint("org.eclipse.mylyn.tasks.core.activityMonitor");
        IExtension[] iExtensionArray = extensions = connectorsExtensionPoint.getExtensions();
        int n = extensions.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement[] elements;
            IExtension extension = iExtensionArray[n2];
            IConfigurationElement[] iConfigurationElementArray = elements = extension.getConfigurationElements();
            int n3 = elements.length;
            int n4 = 0;
            while (n4 < n3) {
                IConfigurationElement element = iConfigurationElementArray[n4];
                if ("activityMonitor".equals(element.getName())) {
                    try {
                        Object object = element.createExecutableExtension(ATTR_CLASS);
                        if (object instanceof AbstractTaskActivityMonitor) {
                            return (AbstractTaskActivityMonitor)object;
                        }
                        StatusHandler.log((IStatus)new Status(4, "org.eclipse.mylyn.tasks.core", NLS.bind((String)"Task activity monitor ''{0}'' does not extend expected class for extension contributed by {1}", (Object)object.getClass().getCanonicalName(), (Object)element.getContributor().getName())));
                    }
                    catch (Throwable e) {
                        StatusHandler.log((IStatus)new Status(4, "org.eclipse.mylyn.tasks.core", NLS.bind((String)"Task activity monitor failed to load for extension contributed by {0}", (Object)element.getContributor().getName()), e));
                    }
                }
                ++n4;
            }
            ++n2;
        }
        return new DefaultTaskActivityMonitor();
    }

    public static AbstractTaskContextStore loadTaskContextStore() {
        IExtension[] extensions;
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtensionPoint connectorsExtensionPoint = registry.getExtensionPoint("org.eclipse.mylyn.tasks.core.contextStore");
        IExtension[] iExtensionArray = extensions = connectorsExtensionPoint.getExtensions();
        int n = extensions.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement[] elements;
            IExtension extension = iExtensionArray[n2];
            IConfigurationElement[] iConfigurationElementArray = elements = extension.getConfigurationElements();
            int n3 = elements.length;
            int n4 = 0;
            while (n4 < n3) {
                IConfigurationElement element = iConfigurationElementArray[n4];
                if ("contextStore".equals(element.getName())) {
                    try {
                        Object object = element.createExecutableExtension(ATTR_CLASS);
                        if (object instanceof AbstractTaskContextStore) {
                            return (AbstractTaskContextStore)object;
                        }
                        StatusHandler.log((IStatus)new Status(4, "org.eclipse.mylyn.tasks.core", NLS.bind((String)"Task context store ''{0}'' does not extend expected class for extension contributed by {1}", (Object)object.getClass().getCanonicalName(), (Object)element.getContributor().getName())));
                    }
                    catch (Throwable e) {
                        StatusHandler.log((IStatus)new Status(4, "org.eclipse.mylyn.tasks.core", NLS.bind((String)"Task context store failed to load for extension contributed by {0}", (Object)element.getContributor().getName()), e));
                    }
                }
                ++n4;
            }
            ++n2;
        }
        return new DefaultTaskContextStore();
    }
}

