/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.commons.sdk.util;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.Socket;
import java.net.URL;

public class TestUrl {
    public static final TestUrl DEFAULT = TestUrl.probeLocalhost();
    private final String URL_HTTP_404_NOT_FOUND = "http://mylyn.org/notfound";
    private final String URL_HTTP_CONNECTION_REFUSED = "http://mylyn.org:9999/";
    private final String URL_HTTP_CONNECTION_TIMEOUT = "http://google.com:9999/";
    private final String URL_HTTP_OK = "http://mylyn.org/";
    private final String URL_HTTP_UNKNOWN_HOST = "http://nonexistant.mylyn.org";
    private final String URL_HTTPS_OK = "https://mylyn.org/";
    private final String host;

    public URL getConnectionRefused() {
        return this.createUrl("http://mylyn.org:9999/");
    }

    private static TestUrl probeLocalhost() {
        Socket socket = new Socket();
        try {
            socket.connect(new InetSocketAddress("localhost", 2080), 100);
            return new TestUrl("localhost");
        }
        catch (IOException iOException) {
            return new TestUrl(null);
        }
    }

    public URL getConnectionTimeout() {
        return this.createUrl("http://google.com:9999/");
    }

    public URL getHttpNotFound() {
        return this.createUrl("http://mylyn.org/notfound");
    }

    public URL getHttpOk() {
        return this.createUrl("http://mylyn.org/");
    }

    public URL getHttpsOk() {
        return this.createUrl("https://mylyn.org/");
    }

    public URL getUnknownHost() {
        return this.createUrl("http://nonexistant.mylyn.org");
    }

    private URL createUrl(String url) {
        if (this.host != null) {
            url = url.replace("mylyn.org", this.host);
        }
        try {
            return new URL(url);
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }

    private TestUrl(String host) {
        this.host = host;
    }
}

