/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.gerrit.ui.operations;

import com.google.gerrit.common.data.ChangeDetail;
import com.google.gerrit.reviewdb.PatchSet;
import org.eclipse.mylyn.internal.gerrit.core.operations.GerritOperation;
import org.eclipse.mylyn.internal.gerrit.core.operations.RebaseRequest;
import org.eclipse.mylyn.internal.gerrit.ui.GerritUiPlugin;
import org.eclipse.mylyn.internal.gerrit.ui.operations.GerritOperationDialog;
import org.eclipse.mylyn.tasks.core.ITask;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class RebaseDialog
extends GerritOperationDialog {
    private final PatchSet patchSet;

    public RebaseDialog(Shell parentShell, ITask task, PatchSet patchSet) {
        super(parentShell, task);
        this.patchSet = patchSet;
    }

    public GerritOperation<ChangeDetail> createOperation() {
        int patchSetId = this.patchSet.getId().get();
        RebaseRequest request = new RebaseRequest(this.task.getTaskId(), patchSetId);
        return GerritUiPlugin.getDefault().getOperationFactory().createRebaseOperation(this.task, request);
    }

    protected Control createPageControls(final Composite parent) {
        this.setTitle("Rebase Patch Set");
        this.setMessage("");
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(1, false));
        Label label = new Label(composite, 0);
        label.setText(NLS.bind((String)"Rebase patch set {0}", (Object)this.patchSet.getRefName()));
        parent.getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                if (!parent.isDisposed()) {
                    RebaseDialog.this.setReturnCode(0);
                    RebaseDialog.this.close();
                }
            }
        });
        return composite;
    }
}

