/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.wikitext.ui;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.mylyn.internal.wikitext.core.WikiTextPlugin;
import org.eclipse.mylyn.internal.wikitext.ui.editor.MarkupEditor;
import org.eclipse.mylyn.wikitext.confluence.core.ConfluenceLanguage;
import org.eclipse.mylyn.wikitext.mediawiki.core.MediaWikiLanguage;
import org.eclipse.mylyn.wikitext.tests.AbstractTestInWorkspace;
import org.eclipse.mylyn.wikitext.tests.HeadRequired;
import org.eclipse.mylyn.wikitext.textile.core.TextileLanguage;
import org.eclipse.mylyn.wikitext.tracwiki.core.TracWikiLanguage;
import org.eclipse.mylyn.wikitext.twiki.core.TWikiLanguage;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;

@HeadRequired
public class FileTypesTest
extends AbstractTestInWorkspace {
    private IProject project;

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.project = this.createSimpleProject();
    }

    public void testTextileFileType() throws CoreException {
        IFile file = this.project.getFile("test.textile");
        file.create(this.createSimpleTextileContent(), false, (IProgressMonitor)new NullProgressMonitor());
        this.editorAsserts(file, TextileLanguage.class);
    }

    public void testTextileFileTypeChangeIsSticky() throws CoreException {
        IFile file = this.project.getFile("test.textile");
        file.create(this.createSimpleTextileContent(), false, (IProgressMonitor)new NullProgressMonitor());
        IWorkbenchPage workbenchPage = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        IEditorPart editor = IDE.openEditor((IWorkbenchPage)workbenchPage, (IFile)file);
        this.assertInstanceOf(MarkupEditor.class, editor);
        MarkupEditor markupEditor = (MarkupEditor)editor;
        this.assertInstanceOf(TextileLanguage.class, markupEditor.getMarkupLanguage());
        markupEditor.setMarkupLanguage(WikiTextPlugin.getDefault().getMarkupLanguage("MediaWiki"), true);
        this.assertInstanceOf(MediaWikiLanguage.class, markupEditor.getMarkupLanguage());
        workbenchPage.closeEditor(editor, false);
        editor = IDE.openEditor((IWorkbenchPage)workbenchPage, (IFile)file);
        markupEditor = (MarkupEditor)editor;
        this.assertInstanceOf(MediaWikiLanguage.class, markupEditor.getMarkupLanguage());
    }

    public void testMediaWikiFileType() throws CoreException {
        IFile file = this.project.getFile("test.mediawiki");
        file.create(this.createSimpleMediaWikiContent(), false, (IProgressMonitor)new NullProgressMonitor());
        this.editorAsserts(file, MediaWikiLanguage.class);
    }

    public void testTracWikiFileType() throws CoreException {
        IFile file = this.project.getFile("test.tracwiki");
        file.create(this.createSimpleMediaWikiContent(), false, (IProgressMonitor)new NullProgressMonitor());
        this.editorAsserts(file, TracWikiLanguage.class);
    }

    public void testTWikiFileType() throws CoreException {
        IFile file = this.project.getFile("test.twiki");
        file.create(this.createSimpleMediaWikiContent(), false, (IProgressMonitor)new NullProgressMonitor());
        this.editorAsserts(file, TWikiLanguage.class);
    }

    public void testConfluenceFileType() throws CoreException {
        IFile file = this.project.getFile("test.confluence");
        file.create(this.createSimpleMediaWikiContent(), false, (IProgressMonitor)new NullProgressMonitor());
        this.editorAsserts(file, ConfluenceLanguage.class);
    }

    private void editorAsserts(IFile file, Class<?> markupLanguageClass) throws PartInitException {
        IEditorPart editor = IDE.openEditor((IWorkbenchPage)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage(), (IFile)file);
        this.assertInstanceOf(MarkupEditor.class, editor);
        MarkupEditor markupEditor = (MarkupEditor)editor;
        this.assertInstanceOf(markupLanguageClass, markupEditor.getMarkupLanguage());
    }

    private void assertInstanceOf(Class<?> clazz, Object o) {
        if (o != null && clazz.isAssignableFrom(o.getClass())) {
            return;
        }
        FileTypesTest.fail((String)("Expected instanceof " + clazz.getName() + " but found " + (o == null ? null : o.getClass().getName())));
    }

    private InputStream createSimpleTextileContent() {
        return new ByteArrayInputStream("h1. Heading\n\ncontent\n".getBytes());
    }

    private InputStream createSimpleMediaWikiContent() {
        return new ByteArrayInputStream("= Heading =\n\ncontent\n".getBytes());
    }
}

