/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.wikitext.textile.core;

import java.io.Writer;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import org.eclipse.mylyn.internal.wikitext.textile.core.TextileContentState;
import org.eclipse.mylyn.internal.wikitext.textile.core.TextileDocumentBuilder;
import org.eclipse.mylyn.internal.wikitext.textile.core.block.CodeBlock;
import org.eclipse.mylyn.internal.wikitext.textile.core.block.DefinitionListBlock;
import org.eclipse.mylyn.internal.wikitext.textile.core.block.FootnoteBlock;
import org.eclipse.mylyn.internal.wikitext.textile.core.block.HeadingBlock;
import org.eclipse.mylyn.internal.wikitext.textile.core.block.ListBlock;
import org.eclipse.mylyn.internal.wikitext.textile.core.block.NotextileBlock;
import org.eclipse.mylyn.internal.wikitext.textile.core.block.ParagraphBlock;
import org.eclipse.mylyn.internal.wikitext.textile.core.block.PreformattedBlock;
import org.eclipse.mylyn.internal.wikitext.textile.core.block.QuoteBlock;
import org.eclipse.mylyn.internal.wikitext.textile.core.block.TableBlock;
import org.eclipse.mylyn.internal.wikitext.textile.core.block.TableOfContentsBlock;
import org.eclipse.mylyn.internal.wikitext.textile.core.block.TextileGlossaryBlock;
import org.eclipse.mylyn.internal.wikitext.textile.core.phrase.EscapeTextilePhraseModifier;
import org.eclipse.mylyn.internal.wikitext.textile.core.phrase.HyperlinkPhraseModifier;
import org.eclipse.mylyn.internal.wikitext.textile.core.phrase.ImageTextilePhraseModifier;
import org.eclipse.mylyn.internal.wikitext.textile.core.phrase.SimpleTextilePhraseModifier;
import org.eclipse.mylyn.internal.wikitext.textile.core.token.EntityReplacementToken;
import org.eclipse.mylyn.internal.wikitext.textile.core.token.FootnoteReferenceReplacementToken;
import org.eclipse.mylyn.wikitext.core.parser.DocumentBuilder;
import org.eclipse.mylyn.wikitext.core.parser.MarkupParser;
import org.eclipse.mylyn.wikitext.core.parser.builder.NoOpDocumentBuilder;
import org.eclipse.mylyn.wikitext.core.parser.markup.AbstractMarkupLanguage;
import org.eclipse.mylyn.wikitext.core.parser.markup.Block;
import org.eclipse.mylyn.wikitext.core.parser.markup.ContentState;
import org.eclipse.mylyn.wikitext.core.parser.markup.MarkupLanguage;
import org.eclipse.mylyn.wikitext.core.parser.markup.MarkupLanguageConfiguration;
import org.eclipse.mylyn.wikitext.core.parser.markup.PatternBasedElement;
import org.eclipse.mylyn.wikitext.core.parser.markup.phrase.HtmlEndTagPhraseModifier;
import org.eclipse.mylyn.wikitext.core.parser.markup.phrase.HtmlStartTagPhraseModifier;
import org.eclipse.mylyn.wikitext.core.parser.markup.token.AcronymReplacementToken;
import org.eclipse.mylyn.wikitext.core.parser.markup.token.EntityReferenceReplacementToken;
import org.eclipse.mylyn.wikitext.core.parser.markup.token.EntityWrappingReplacementToken;
import org.eclipse.mylyn.wikitext.core.parser.markup.token.PatternEntityReferenceReplacementToken;

public class TextileLanguage
extends AbstractMarkupLanguage {
    private static final String BUNDLE_NAME = "org.eclipse.mylyn.wikitext.textile.core.language";
    private boolean preprocessFootnotes = false;
    private TextileContentState currentState;

    public TextileLanguage() {
        this.setName("Textile");
    }

    protected void addBlockExtensions(List<Block> blocks, List<Block> paragraphBreakingBlocks) {
        blocks.add((Block)new TextileGlossaryBlock());
        blocks.add(new TableOfContentsBlock());
        super.addBlockExtensions(blocks, paragraphBreakingBlocks);
    }

    protected ContentState createState() {
        if (this.currentState != null) {
            TextileContentState temp = this.currentState;
            this.currentState = null;
            return temp;
        }
        return new TextileContentState();
    }

    protected void addStandardBlocks(List<Block> blocks, List<Block> paragraphBreakingBlocks) {
        blocks.add(new HeadingBlock());
        ListBlock listBlock = new ListBlock();
        DefinitionListBlock definitonListBlock = new DefinitionListBlock();
        blocks.add(listBlock);
        blocks.add(definitonListBlock);
        paragraphBreakingBlocks.add(listBlock);
        paragraphBreakingBlocks.add(definitonListBlock);
        blocks.add(new PreformattedBlock());
        blocks.add(new QuoteBlock());
        blocks.add(new CodeBlock());
        blocks.add(new FootnoteBlock());
        blocks.add(new NotextileBlock());
        TableBlock tableBlock = new TableBlock();
        blocks.add(tableBlock);
        paragraphBreakingBlocks.add(tableBlock);
    }

    protected void addStandardPhraseModifiers(MarkupLanguage.PatternBasedSyntax phraseModifierSyntax) {
        boolean escapingHtml = this.configuration == null ? false : this.configuration.isEscapingHtmlAndXml();
        phraseModifierSyntax.add((PatternBasedElement)new HtmlEndTagPhraseModifier(escapingHtml));
        phraseModifierSyntax.add((PatternBasedElement)new HtmlStartTagPhraseModifier(escapingHtml));
        phraseModifierSyntax.beginGroup("(?:(?<=[\\s\\.,\\\"'?!;:\\)\\(\\{\\}\\[\\]])|^)(?:", 0);
        phraseModifierSyntax.add((PatternBasedElement)new EscapeTextilePhraseModifier());
        phraseModifierSyntax.add((PatternBasedElement)new SimpleTextilePhraseModifier("**", DocumentBuilder.SpanType.BOLD, SimpleTextilePhraseModifier.Mode.NESTING));
        phraseModifierSyntax.add((PatternBasedElement)new SimpleTextilePhraseModifier("??", DocumentBuilder.SpanType.CITATION, SimpleTextilePhraseModifier.Mode.NESTING));
        phraseModifierSyntax.add((PatternBasedElement)new SimpleTextilePhraseModifier("__", DocumentBuilder.SpanType.ITALIC, SimpleTextilePhraseModifier.Mode.NESTING));
        phraseModifierSyntax.add((PatternBasedElement)new SimpleTextilePhraseModifier("_", DocumentBuilder.SpanType.EMPHASIS, SimpleTextilePhraseModifier.Mode.NESTING));
        phraseModifierSyntax.add((PatternBasedElement)new SimpleTextilePhraseModifier("*", DocumentBuilder.SpanType.STRONG, SimpleTextilePhraseModifier.Mode.NESTING));
        phraseModifierSyntax.add((PatternBasedElement)new SimpleTextilePhraseModifier("+", DocumentBuilder.SpanType.INSERTED, SimpleTextilePhraseModifier.Mode.NESTING));
        phraseModifierSyntax.add((PatternBasedElement)new SimpleTextilePhraseModifier("~", DocumentBuilder.SpanType.SUBSCRIPT, SimpleTextilePhraseModifier.Mode.NORMAL));
        phraseModifierSyntax.add((PatternBasedElement)new SimpleTextilePhraseModifier("^", DocumentBuilder.SpanType.SUPERSCRIPT, SimpleTextilePhraseModifier.Mode.NORMAL));
        phraseModifierSyntax.add((PatternBasedElement)new SimpleTextilePhraseModifier("@", DocumentBuilder.SpanType.CODE, SimpleTextilePhraseModifier.Mode.SPECIAL));
        phraseModifierSyntax.add((PatternBasedElement)new SimpleTextilePhraseModifier("%", DocumentBuilder.SpanType.SPAN, SimpleTextilePhraseModifier.Mode.NESTING));
        phraseModifierSyntax.add((PatternBasedElement)new SimpleTextilePhraseModifier("-", DocumentBuilder.SpanType.DELETED, SimpleTextilePhraseModifier.Mode.NESTING));
        phraseModifierSyntax.add((PatternBasedElement)new ImageTextilePhraseModifier());
        phraseModifierSyntax.add((PatternBasedElement)new HyperlinkPhraseModifier());
        phraseModifierSyntax.endGroup(")(?=\\W|$)", 0);
    }

    protected void addStandardTokens(MarkupLanguage.PatternBasedSyntax tokenSyntax) {
        tokenSyntax.add((PatternBasedElement)new EntityReferenceReplacementToken("(tm)", "#8482"));
        tokenSyntax.add((PatternBasedElement)new EntityReferenceReplacementToken("(TM)", "#8482"));
        tokenSyntax.add((PatternBasedElement)new EntityReferenceReplacementToken("(c)", "#169"));
        tokenSyntax.add((PatternBasedElement)new EntityReferenceReplacementToken("(C)", "#169"));
        tokenSyntax.add((PatternBasedElement)new EntityReferenceReplacementToken("(r)", "#174"));
        tokenSyntax.add((PatternBasedElement)new EntityReferenceReplacementToken("(R)", "#174"));
        tokenSyntax.add((PatternBasedElement)new FootnoteReferenceReplacementToken());
        if (this.configuration == null || !this.configuration.isOptimizeForRepositoryUsage()) {
            ResourceBundle res = ResourceBundle.getBundle(BUNDLE_NAME, this.configuration == null || this.configuration.getLocale() == null ? Locale.ENGLISH : this.configuration.getLocale());
            tokenSyntax.add((PatternBasedElement)new EntityWrappingReplacementToken("\"", res.getString("quote_left"), res.getString("quote_right")));
            tokenSyntax.add((PatternBasedElement)new EntityWrappingReplacementToken("'", res.getString("singlequote_left"), res.getString("singlequote_right")));
            tokenSyntax.add((PatternBasedElement)new PatternEntityReferenceReplacementToken("(?:(?<=\\w)(')(?=\\w))", "#8217"));
        }
        tokenSyntax.add((PatternBasedElement)new PatternEntityReferenceReplacementToken("(?:(--)(?=\\s\\w))", "#8212"));
        tokenSyntax.add((PatternBasedElement)new PatternEntityReferenceReplacementToken("(?:(?<=\\w\\s)(-)(?=\\s\\w))", "#8211"));
        tokenSyntax.add((PatternBasedElement)new PatternEntityReferenceReplacementToken("(?:(?<=\\d\\s)(x)(?=\\s\\d))", "#215"));
        if (this.configuration == null || !this.configuration.isOptimizeForRepositoryUsage()) {
            tokenSyntax.add((PatternBasedElement)new AcronymReplacementToken());
        }
        tokenSyntax.add((PatternBasedElement)new EntityReplacementToken());
    }

    protected Block createParagraphBlock() {
        ParagraphBlock paragraphBlock = new ParagraphBlock();
        if (this.configuration != null && !this.configuration.isEnableUnwrappedParagraphs()) {
            paragraphBlock.setEnableUnwrapped(false);
        }
        return paragraphBlock;
    }

    public boolean isPreprocessFootnotes() {
        return this.preprocessFootnotes;
    }

    public void setPreprocessFootnotes(boolean preprocessFootnotes) {
        this.preprocessFootnotes = preprocessFootnotes;
    }

    public void configure(MarkupLanguageConfiguration configuration) throws UnsupportedOperationException {
        if (configuration.isOptimizeForRepositoryUsage()) {
            this.setPreprocessFootnotes(true);
        }
        super.configure(configuration);
    }

    public TextileLanguage clone() {
        TextileLanguage copy = (TextileLanguage)super.clone();
        copy.preprocessFootnotes = this.preprocessFootnotes;
        return copy;
    }

    public void processContent(MarkupParser parser, String markupContent, boolean asDocument) {
        if (this.preprocessFootnotes) {
            boolean previousBlocksOnly = this.isBlocksOnly();
            boolean previousFilterGenerativeContents = this.isFilterGenerativeContents();
            this.setBlocksOnly(true);
            this.setFilterGenerativeContents(true);
            DocumentBuilder builder = parser.getBuilder();
            parser.setBuilder((DocumentBuilder)new NoOpDocumentBuilder());
            TextileContentState preprocessingState = this.currentState = new TextileContentState();
            super.processContent(parser, markupContent, asDocument);
            this.setBlocksOnly(previousBlocksOnly);
            this.setFilterGenerativeContents(previousFilterGenerativeContents);
            this.currentState = new TextileContentState();
            this.currentState.setFootnoteNumbers(preprocessingState.getFootnoteNumbers());
            parser.setBuilder(builder);
            super.processContent(parser, markupContent, asDocument);
            this.currentState = null;
        } else {
            this.currentState = null;
            super.processContent(parser, markupContent, asDocument);
        }
    }

    public DocumentBuilder createDocumentBuilder(Writer out) {
        return new TextileDocumentBuilder(out);
    }
}

