/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.bugzilla.tests;

import java.util.HashSet;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.mylyn.bugzilla.tests.AbstractBugzillaTest;
import org.eclipse.mylyn.bugzilla.tests.support.BugzillaFixture;
import org.eclipse.mylyn.commons.net.AbstractWebLocation;
import org.eclipse.mylyn.commons.net.AuthenticationType;
import org.eclipse.mylyn.commons.net.WebLocation;
import org.eclipse.mylyn.commons.repositories.core.auth.UserCredentials;
import org.eclipse.mylyn.commons.sdk.util.CommonTestUtil;
import org.eclipse.mylyn.internal.bugzilla.core.BugzillaAttribute;
import org.eclipse.mylyn.internal.bugzilla.core.BugzillaClient;
import org.eclipse.mylyn.internal.tasks.ui.TasksUiPlugin;
import org.eclipse.mylyn.internal.tasks.ui.util.TasksUiInternal;
import org.eclipse.mylyn.tasks.core.AbstractRepositoryConnector;
import org.eclipse.mylyn.tasks.core.ITask;
import org.eclipse.mylyn.tasks.core.data.TaskAttribute;
import org.eclipse.mylyn.tasks.core.data.TaskData;
import org.eclipse.mylyn.tasks.core.data.TaskDataModel;
import org.eclipse.mylyn.tasks.ui.TasksUi;

public class EncodingTest
extends AbstractBugzillaTest {
    public void testEncodingSetting() {
        String charset = BugzillaClient.getCharsetFromString((String)"text/html; charset=UTF-8");
        EncodingTest.assertEquals((String)"UTF-8", (String)charset);
        charset = BugzillaClient.getCharsetFromString((String)"text/html");
        EncodingTest.assertEquals(null, (String)charset);
        charset = BugzillaClient.getCharsetFromString((String)"<<meta http-equiv=\"Content-Type\" content=\"text/html; charset=iso-8859-2\">>");
        EncodingTest.assertEquals((String)"iso-8859-2", (String)charset);
        charset = BugzillaClient.getCharsetFromString((String)"<<meta http-equiv=\"Content-Type\" content=\"text/html\">>");
        EncodingTest.assertEquals(null, (String)charset);
    }

    public void testDifferentReportEncoding() throws Exception {
        TaskData data = BugzillaFixture.current().createTask(CommonTestUtil.PrivilegeLevel.USER, "\u00e6", null);
        EncodingTest.assertNotNull((Object)data);
        EncodingTest.assertTrue((boolean)data.getRoot().getMappedAttribute("task.common.summary").getValue().equals("\u00e6"));
        WebLocation location = new WebLocation(this.repository.getRepositoryUrl());
        UserCredentials credentials = CommonTestUtil.getCredentials((CommonTestUtil.PrivilegeLevel)CommonTestUtil.PrivilegeLevel.USER);
        location.setCredentials(AuthenticationType.REPOSITORY, credentials.getUserName(), credentials.getPassword());
        BugzillaClient client2 = BugzillaFixture.current().client((AbstractWebLocation)location, "ISO-8859-1");
        data = BugzillaFixture.current().getTask(data.getTaskId(), client2);
        EncodingTest.assertNotNull((Object)data);
        EncodingTest.assertFalse((boolean)data.getRoot().getMappedAttribute("task.common.summary").getValue().equals("\u00e6"));
    }

    public void testProperEncodingUponPost() throws Exception {
        TaskData data = BugzillaFixture.current().createTask(CommonTestUtil.PrivilegeLevel.USER, "\u00e6", null);
        EncodingTest.assertNotNull((Object)data);
        ITask task = TasksUi.getRepositoryModel().createTask(this.repository, data.getTaskId());
        TasksUiPlugin.getTaskList().addTask(task);
        HashSet<ITask> tasks = new HashSet<ITask>();
        tasks.add(task);
        TasksUiInternal.synchronizeTasks((AbstractRepositoryConnector)this.connector, tasks, (boolean)true, null);
        String priority = null;
        TaskDataModel model = this.createModel(task);
        if (task.getPriority().equals("P1")) {
            priority = "P2";
            TaskAttribute attrPriority = model.getTaskData().getRoot().getAttribute(BugzillaAttribute.PRIORITY.getKey());
            if (attrPriority != null) {
                attrPriority.setValue(priority);
                model.attributeChanged(attrPriority);
            } else {
                EncodingTest.fail();
            }
        } else {
            priority = "P1";
            TaskAttribute attrPriority = model.getTaskData().getRoot().getAttribute(BugzillaAttribute.PRIORITY.getKey());
            if (attrPriority != null) {
                attrPriority.setValue(priority);
                model.attributeChanged(attrPriority);
            } else {
                EncodingTest.fail();
            }
        }
        model.save((IProgressMonitor)new NullProgressMonitor());
        this.submit(model);
        data = BugzillaFixture.current().getTask(data.getTaskId(), this.client);
        EncodingTest.assertNotNull((Object)data);
        EncodingTest.assertTrue((boolean)data.getRoot().getMappedAttribute("task.common.summary").getValue().equals("\u00e6"));
    }
}

