/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.wikitext.ui.properties;

import java.lang.reflect.InvocationTargetException;
import java.util.TreeSet;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.mylyn.internal.wikitext.ui.WikiTextNature;
import org.eclipse.mylyn.internal.wikitext.ui.WikiTextUiPlugin;
import org.eclipse.mylyn.internal.wikitext.ui.properties.Messages;
import org.eclipse.mylyn.wikitext.core.WikiText;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPropertyPage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.ui.dialogs.PropertyPage;

public class ProjectPropertyPage
extends PropertyPage
implements IWorkbenchPropertyPage {
    private IProject project;
    private Button wikiTextNatureButton;

    public ProjectPropertyPage() {
        this.setTitle(Messages.ProjectPropertyPage_wikiText);
        this.setDescription(Messages.ProjectPropertyPage_configureInfo);
    }

    protected Control createContents(Composite parent) {
        Composite container = new Composite(parent, 0);
        container.setLayout((Layout)new GridLayout(1, false));
        this.wikiTextNatureButton = new Button(container, 32);
        this.wikiTextNatureButton.setText(Messages.ProjectPropertyPage_enableValidation);
        StringBuilder buf = new StringBuilder();
        TreeSet extensions = new TreeSet(WikiText.getMarkupFileExtensions());
        for (String extension : extensions) {
            if (buf.length() > 0) {
                buf.append(Messages.ProjectPropertyPage_3);
            }
            buf.append(Messages.ProjectPropertyPage_4);
            buf.append(extension);
        }
        this.wikiTextNatureButton.setToolTipText(NLS.bind((String)Messages.ProjectPropertyPage_validation_tooltip, (Object[])new Object[]{buf.toString()}));
        this.project = (IProject)this.getElement().getAdapter(IProject.class);
        try {
            if (this.project.hasNature("org.eclipse.mylyn.wikitext.ui.wikiTextNature")) {
                this.wikiTextNatureButton.setSelection(true);
            }
        }
        catch (CoreException e) {
            WikiTextUiPlugin.getDefault().log(e);
            container.setEnabled(false);
            this.setErrorMessage(e.getMessage());
            this.setValid(false);
        }
        return container;
    }

    public void performHelp() {
        this.getControl().notifyListeners(28, new Event());
    }

    protected void setControl(Control newControl) {
        super.setControl(newControl);
        PlatformUI.getWorkbench().getHelpSystem().setHelp(newControl, "org.eclipse.mylyn.wikitext.help.ui.projectSettings");
    }

    public boolean performOk() {
        final boolean wantNature = this.wikiTextNatureButton.getSelection();
        final boolean[] ok = new boolean[]{false};
        WorkspaceModifyOperation operation = new WorkspaceModifyOperation((ISchedulingRule)ResourcesPlugin.getWorkspace().getRoot()){

            protected void execute(IProgressMonitor monitor) throws CoreException, InvocationTargetException, InterruptedException {
                if (ProjectPropertyPage.this.project.hasNature("org.eclipse.mylyn.wikitext.ui.wikiTextNature") != wantNature) {
                    if (wantNature) {
                        WikiTextNature.install(ProjectPropertyPage.this.project, monitor);
                    } else {
                        WikiTextNature.uninstall(ProjectPropertyPage.this.project, monitor);
                    }
                }
                ok[0] = true;
            }
        };
        try {
            new ProgressMonitorDialog(this.getShell()).run(true, true, (IRunnableWithProgress)operation);
        }
        catch (InvocationTargetException e) {
            String message = Messages.ProjectPropertyPage_operationError;
            String title = Messages.ProjectPropertyPage_unexpectedError;
            ErrorDialog.openError((Shell)this.getShell(), (String)title, (String)message, (IStatus)WikiTextUiPlugin.getDefault().createStatus(4, e.getCause()));
        }
        catch (InterruptedException interruptedException) {}
        return ok[0];
    }
}

