/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.tasks.tests;

import java.lang.reflect.Field;
import java.util.Date;
import junit.framework.TestCase;
import org.eclipse.mylyn.commons.ui.PlatformUiUtil;
import org.eclipse.mylyn.internal.tasks.core.AbstractTask;
import org.eclipse.mylyn.internal.tasks.core.AbstractTaskContainer;
import org.eclipse.mylyn.internal.tasks.core.LocalTask;
import org.eclipse.mylyn.internal.tasks.core.TaskCategory;
import org.eclipse.mylyn.internal.tasks.core.TaskList;
import org.eclipse.mylyn.internal.tasks.ui.TasksUiPlugin;
import org.eclipse.mylyn.internal.tasks.ui.util.TasksUiInternal;
import org.eclipse.mylyn.tasks.core.ITask;
import org.eclipse.mylyn.tasks.tests.TaskTestUtil;
import org.eclipse.mylyn.tasks.ui.TasksUiUtil;
import org.eclipse.mylyn.tasks.ui.editors.TaskEditor;
import org.eclipse.mylyn.tests.util.TasksUiTestUtil;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.browser.WebBrowserEditor;
import org.eclipse.ui.internal.browser.WebBrowserEditorInput;

public class TasksUiUtilTest
extends TestCase {
    private TaskCategory cat1;
    private AbstractTask cat1task1;
    private AbstractTask cat1task2;
    private IWorkbenchPage activePage;
    private TaskList taskList;

    public void setUp() throws Exception {
        this.taskList = TasksUiPlugin.getTaskList();
        TaskTestUtil.resetTaskListAndRepositories();
        TasksUiPlugin.getDefault().getLocalTaskRepository();
        this.cat1 = new TaskCategory("First Category");
        this.taskList.addCategory(this.cat1);
        this.cat1task1 = TasksUiInternal.createNewLocalTask((String)"task 1");
        this.cat1task1.setPriority(ITask.PriorityLevel.P1.toString());
        this.cat1task1.setCompletionDate(new Date());
        this.taskList.addTask((ITask)this.cat1task1, (AbstractTaskContainer)this.cat1);
        this.cat1task2 = TasksUiInternal.createNewLocalTask((String)"task 2");
        this.cat1task2.setPriority(ITask.PriorityLevel.P2.toString());
        this.taskList.addTask((ITask)this.cat1task2, (AbstractTaskContainer)this.cat1);
        TasksUiUtilTest.assertEquals((int)this.cat1.getChildren().size(), (int)2);
        this.activePage = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        TasksUiUtilTest.assertTrue((boolean)this.activePage.closeAllEditors(false));
        TasksUiUtilTest.assertEquals((int)0, (int)this.activePage.getEditorReferences().length);
        TasksUiTestUtil.ensureTasksUiInitialization();
    }

    public void tearDown() throws Exception {
        TaskTestUtil.resetTaskListAndRepositories();
        this.activePage.closeAllEditors(false);
    }

    public void testOpenTaskFromTask() {
        TasksUiUtil.openTask((ITask)this.cat1task1);
        TasksUiUtilTest.assertEquals((int)1, (int)this.activePage.getEditorReferences().length);
        IEditorPart editor = this.activePage.getEditorReferences()[0].getEditor(true);
        TasksUiUtilTest.assertNotNull((Object)editor);
        TasksUiUtilTest.assertEquals(TaskEditor.class, editor.getClass());
        TasksUiUtil.openTask((ITask)this.cat1task2);
        TasksUiUtilTest.assertEquals((int)2, (int)this.activePage.getEditorReferences().length);
        editor = this.activePage.getEditorReferences()[1].getEditor(true);
        TasksUiUtilTest.assertNotNull((Object)editor);
        TasksUiUtilTest.assertEquals(TaskEditor.class, editor.getClass());
    }

    public void testOpenTaskFromString() {
        if (!PlatformUiUtil.hasInternalBrowser()) {
            return;
        }
        TasksUiUtil.openTask(null);
        TasksUiUtilTest.assertEquals((int)1, (int)this.activePage.getEditorReferences().length);
        IEditorPart editor = this.activePage.getEditorReferences()[0].getEditor(true);
        TasksUiUtilTest.assertEquals(WebBrowserEditor.class, editor.getClass());
    }

    public void testOpenUrl() {
        if (!PlatformUiUtil.hasInternalBrowser()) {
            return;
        }
        TasksUiUtil.openUrl(null);
        TasksUiUtilTest.assertEquals((int)1, (int)this.activePage.getEditorReferences().length);
        IEditorPart editor = this.activePage.getEditorReferences()[0].getEditor(true);
        TasksUiUtilTest.assertEquals(WebBrowserEditor.class, editor.getClass());
        TasksUiUtilTest.assertEquals(WebBrowserEditorInput.class, editor.getEditorInput().getClass());
        TasksUiUtilTest.assertEquals(null, (Object)((WebBrowserEditorInput)editor.getEditorInput()).getURL());
        TasksUiUtil.openUrl((String)"http://eclipse.org/mylyn");
        TasksUiUtilTest.assertEquals((int)2, (int)this.activePage.getEditorReferences().length);
        editor = this.activePage.getEditorReferences()[0].getEditor(true);
        TasksUiUtilTest.assertEquals(WebBrowserEditor.class, editor.getClass());
        TasksUiUtilTest.assertEquals(WebBrowserEditorInput.class, editor.getEditorInput().getClass());
        TasksUiUtilTest.assertEquals(null, (Object)((WebBrowserEditorInput)editor.getEditorInput()).getURL());
        IEditorPart editor2 = this.activePage.getEditorReferences()[1].getEditor(true);
        TasksUiUtilTest.assertEquals(WebBrowserEditor.class, editor2.getClass());
        TasksUiUtilTest.assertEquals(WebBrowserEditorInput.class, editor2.getEditorInput().getClass());
        TasksUiUtilTest.assertNotNull((Object)((WebBrowserEditorInput)editor2.getEditorInput()).getURL());
        TasksUiUtilTest.assertEquals((String)"http://eclipse.org/mylyn", (String)((WebBrowserEditorInput)editor2.getEditorInput()).getURL().toString());
    }

    public void testFlagNoRichEditor() throws Exception {
        if (!PlatformUiUtil.hasInternalBrowser()) {
            return;
        }
        TasksUiUtil.openUrl(null);
        TasksUiUtilTest.assertEquals((int)1, (int)this.activePage.getEditorReferences().length);
        IEditorPart editor = this.activePage.getEditorReferences()[0].getEditor(true);
        TasksUiUtilTest.assertEquals(WebBrowserEditor.class, editor.getClass());
        TasksUiUtilTest.assertEquals(WebBrowserEditorInput.class, editor.getEditorInput().getClass());
        TasksUiUtilTest.assertEquals(null, (Object)((WebBrowserEditorInput)editor.getEditorInput()).getURL());
        WebBrowserEditorInput input = (WebBrowserEditorInput)editor.getEditorInput();
        Field f = input.getClass().getDeclaredField("style");
        f.setAccessible(true);
        int style = (Integer)f.get(input);
        TasksUiUtilTest.assertFalse(((style & 0x20000) == 0 ? 1 : 0) != 0);
        TasksUiUtil.openUrl((String)"http://eclipse.org/mylyn");
        TasksUiUtilTest.assertEquals((int)2, (int)this.activePage.getEditorReferences().length);
        editor = this.activePage.getEditorReferences()[0].getEditor(true);
        TasksUiUtilTest.assertEquals(WebBrowserEditor.class, editor.getClass());
        TasksUiUtilTest.assertEquals(WebBrowserEditorInput.class, editor.getEditorInput().getClass());
        TasksUiUtilTest.assertEquals(null, (Object)((WebBrowserEditorInput)editor.getEditorInput()).getURL());
        input = (WebBrowserEditorInput)editor.getEditorInput();
        f = input.getClass().getDeclaredField("style");
        f.setAccessible(true);
        style = (Integer)f.get(input);
        TasksUiUtilTest.assertFalse(((style & 0x20000) == 0 ? 1 : 0) != 0);
        IEditorPart editor2 = this.activePage.getEditorReferences()[1].getEditor(true);
        TasksUiUtilTest.assertEquals(WebBrowserEditor.class, editor2.getClass());
        TasksUiUtilTest.assertEquals(WebBrowserEditorInput.class, editor2.getEditorInput().getClass());
        TasksUiUtilTest.assertNotNull((Object)((WebBrowserEditorInput)editor2.getEditorInput()).getURL());
        TasksUiUtilTest.assertEquals((String)"http://eclipse.org/mylyn", (String)((WebBrowserEditorInput)editor2.getEditorInput()).getURL().toString());
        input = (WebBrowserEditorInput)editor.getEditorInput();
        f = input.getClass().getDeclaredField("style");
        f.setAccessible(true);
        style = (Integer)f.get(input);
        TasksUiUtilTest.assertFalse(((style & 0x20000) == 0 ? 1 : 0) != 0);
        TasksUiUtil.openTask((String)"http://eclipse.org/mylyn/test");
        TasksUiUtilTest.assertEquals((int)3, (int)this.activePage.getEditorReferences().length);
        editor = this.activePage.getEditorReferences()[2].getEditor(true);
        TasksUiUtilTest.assertEquals(WebBrowserEditor.class, editor.getClass());
        TasksUiUtilTest.assertEquals(WebBrowserEditorInput.class, editor.getEditorInput().getClass());
        TasksUiUtilTest.assertEquals((String)"http://eclipse.org/mylyn/test", (String)((WebBrowserEditorInput)editor.getEditorInput()).getURL().toString());
        input = (WebBrowserEditorInput)editor.getEditorInput();
        f = input.getClass().getDeclaredField("style");
        f.setAccessible(true);
        style = (Integer)f.get(input);
        TasksUiUtilTest.assertTrue(((style & 0x20000) == 0 ? 1 : 0) != 0);
    }

    public void testOpenLocalTask() {
        LocalTask localTask = TasksUiInternal.createNewLocalTask((String)"summary");
        TasksUiUtil.openTask((ITask)localTask);
        TasksUiUtilTest.assertEquals((int)1, (int)this.activePage.getEditorReferences().length);
        IEditorPart editor = this.activePage.getEditorReferences()[0].getEditor(true);
        TasksUiUtilTest.assertEquals(TaskEditor.class, editor.getClass());
    }

    public void testOpenLocalTaskWebBrowserDefault() {
        LocalTask localTask = TasksUiInternal.createNewLocalTask((String)"summary");
        try {
            TasksUiPlugin.getDefault().getPreferenceStore().setValue("org.eclipse.mylyn.tasks.ui.reporting.open.editor", false);
            TasksUiUtil.openTask((ITask)localTask);
            TasksUiUtilTest.assertEquals((int)1, (int)this.activePage.getEditorReferences().length);
            IEditorPart editor = this.activePage.getEditorReferences()[0].getEditor(true);
            TasksUiUtilTest.assertEquals(TaskEditor.class, editor.getClass());
        }
        finally {
            TasksUiPlugin.getDefault().getPreferenceStore().setToDefault("org.eclipse.mylyn.tasks.ui.reporting.open.editor");
        }
    }
}

