/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.tasks.tests.core;

import java.util.HashSet;
import java.util.Iterator;
import junit.framework.TestCase;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.core.data.AbstractTaskSchema;
import org.eclipse.mylyn.tasks.core.data.DefaultTaskSchema;
import org.eclipse.mylyn.tasks.core.data.TaskAttributeMapper;
import org.eclipse.mylyn.tasks.core.data.TaskData;

public class DefaultTaskSchemaTest
extends TestCase {
    public void testInheritFlags() {
        TestSchema schema = new TestSchema();
        DefaultTaskSchemaTest.assertEquals((String)"task.common.summary", (String)schema.SUMMARY.getKey());
        DefaultTaskSchemaTest.assertEquals((String)"task.common.summary", (String)schema.SUMMARY_READ_ONLY.getKey());
        DefaultTaskSchemaTest.assertEquals(null, (String)schema.SUMMARY_READ_ONLY.getKind());
        DefaultTaskSchemaTest.assertTrue((boolean)schema.SUMMARY_READ_ONLY.isReadOnly());
    }

    public void testInheritFlagsAddRemoveFlag() {
        TestSchema schema = new TestSchema();
        DefaultTaskSchemaTest.assertEquals((String)"task.common.kind.people", (String)schema.REPORTER.getKind());
        DefaultTaskSchemaTest.assertTrue((boolean)schema.REPORTER.isReadOnly());
        DefaultTaskSchemaTest.assertEquals((String)"task.common.user.reporter", (String)schema.REPORTER_MODIFIED.getKey());
        DefaultTaskSchemaTest.assertEquals(null, (String)schema.REPORTER_MODIFIED.getKind());
        DefaultTaskSchemaTest.assertFalse((boolean)schema.REPORTER_MODIFIED.isReadOnly());
    }

    public void testIterator() {
        DefaultTaskSchema schema = new DefaultTaskSchema();
        Iterator fields = schema.getFields().iterator();
        int i = 0;
        HashSet<String> attributeIds = new HashSet<String>();
        while (fields.hasNext()) {
            AbstractTaskSchema.Field next = (AbstractTaskSchema.Field)fields.next();
            attributeIds.add(next.getKey());
            ++i;
        }
        DefaultTaskSchemaTest.assertTrue((String)("Actual Attribute Count: " + i), (i >= 40 ? 1 : 0) != 0);
        DefaultTaskSchemaTest.assertTrue((boolean)attributeIds.contains("task.common.addselfcc"));
        DefaultTaskSchemaTest.assertTrue((boolean)attributeIds.contains("task.common.attachment.author"));
        DefaultTaskSchemaTest.assertTrue((boolean)attributeIds.contains("task.common.summary"));
    }

    public void testInitializeTaskData() {
        DefaultTaskSchema schema = new DefaultTaskSchema();
        TaskData testData = new TaskData(new TaskAttributeMapper(new TaskRepository("mock", "http://mock")), "mock", "http://mock", "-1");
        schema.initialize(testData);
        int size = testData.getRoot().getAttributes().values().size();
        DefaultTaskSchemaTest.assertTrue((String)("Actual Attribute Count: " + size), (size >= 40 ? 1 : 0) != 0);
        DefaultTaskSchemaTest.assertNotNull((Object)testData.getRoot().getAttribute("task.common.addselfcc"));
        DefaultTaskSchemaTest.assertNotNull((Object)testData.getRoot().getAttribute("task.common.attachment.id"));
        DefaultTaskSchemaTest.assertNotNull((Object)testData.getRoot().getAttribute("task.common.summary"));
    }

    private class TestSchema
    extends AbstractTaskSchema {
        private final DefaultTaskSchema parent = DefaultTaskSchema.getInstance();
        public final AbstractTaskSchema.Field SUMMARY;
        public final AbstractTaskSchema.Field SUMMARY_READ_ONLY;
        public final AbstractTaskSchema.Field REPORTER;
        public final AbstractTaskSchema.Field REPORTER_MODIFIED;

        private TestSchema() {
            this.SUMMARY = this.inheritFrom(this.parent.SUMMARY).create();
            this.SUMMARY_READ_ONLY = this.inheritFrom(this.parent.SUMMARY).addFlags(new AbstractTaskSchema.Flag[]{AbstractTaskSchema.Flag.READ_ONLY}).create();
            this.REPORTER = this.inheritFrom(this.parent.USER_REPORTER).create();
            this.REPORTER_MODIFIED = this.inheritFrom(this.parent.USER_REPORTER).addFlags(new AbstractTaskSchema.Flag[]{AbstractTaskSchema.Flag.READ_ONLY}).removeFlags(new AbstractTaskSchema.Flag[]{AbstractTaskSchema.Flag.READ_ONLY, AbstractTaskSchema.Flag.PEOPLE}).create();
        }
    }
}

