/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.tasks.tests.ui;

import junit.framework.TestCase;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.mylyn.commons.workbench.WorkbenchUtil;
import org.eclipse.mylyn.internal.tasks.core.AbstractTaskContainer;
import org.eclipse.mylyn.internal.tasks.core.RepositoryQuery;
import org.eclipse.mylyn.internal.tasks.core.TaskCategory;
import org.eclipse.mylyn.internal.tasks.core.TaskList;
import org.eclipse.mylyn.internal.tasks.core.TaskTask;
import org.eclipse.mylyn.internal.tasks.ui.TasksUiPlugin;
import org.eclipse.mylyn.internal.tasks.ui.views.TaskListView;
import org.eclipse.mylyn.tasks.core.ITask;
import org.eclipse.mylyn.tasks.tests.TaskTestUtil;

public class TaskListViewTest
extends TestCase {
    protected void setUp() throws Exception {
        TaskTestUtil.resetTaskListAndRepositories();
        TaskTestUtil.createMockRepository();
    }

    protected void tearDown() throws Exception {
        TaskTestUtil.resetTaskListAndRepositories();
    }

    public void testSelectedAndFocusTaskMultiple() {
        TaskList taskList = TasksUiPlugin.getTaskList();
        TaskCategory category1 = new TaskCategory(taskList.getUniqueHandleIdentifier());
        taskList.addCategory(category1);
        TaskTask task1 = TaskTestUtil.createMockTask("task1");
        TaskTask task2 = TaskTestUtil.createMockTask("task2");
        taskList.addTask((ITask)task1, (AbstractTaskContainer)category1);
        taskList.addTask((ITask)task2, (AbstractTaskContainer)category1);
        TaskListView view = (TaskListView)WorkbenchUtil.showViewInActiveWindow((String)"org.eclipse.mylyn.tasks.ui.views.tasks");
        view.refresh();
        TreeSelection selection = new TreeSelection(new TreePath(new Object[]{category1, task1}));
        view.getViewer().setSelection((ISelection)new StructuredSelection(new Object[]{task1, task2}));
        view.selectedAndFocusTask((ITask)task1);
        TaskListViewTest.assertEquals((String)this.toString(selection), (String)this.toString((TreeSelection)view.getViewer().getSelection()));
    }

    public void testSelectedAndFocusTaskRestore() {
        TaskList taskList = TasksUiPlugin.getTaskList();
        TaskCategory category1 = new TaskCategory(taskList.getUniqueHandleIdentifier());
        taskList.addCategory(category1);
        RepositoryQuery category2 = new RepositoryQuery("mock", taskList.getUniqueHandleIdentifier());
        taskList.addQuery(category2);
        TaskTask task1 = TaskTestUtil.createMockTask("task1");
        taskList.addTask((ITask)task1, (AbstractTaskContainer)category1);
        taskList.addTask((ITask)task1, (AbstractTaskContainer)category2);
        TaskListView view = (TaskListView)WorkbenchUtil.showViewInActiveWindow((String)"org.eclipse.mylyn.tasks.ui.views.tasks");
        view.refresh();
        TreeSelection selection = new TreeSelection(new TreePath(new Object[]{category1, task1}));
        view.getViewer().setSelection((ISelection)selection);
        view.selectedAndFocusTask((ITask)task1);
        TaskListViewTest.assertEquals((String)this.toString(selection), (String)this.toString((TreeSelection)view.getViewer().getSelection()));
        view.getViewer().setSelection((ISelection)new TreeSelection(new TreePath(new Object[]{category2, task1})));
        view.selectedAndFocusTask((ITask)task1);
        TaskListViewTest.assertEquals((Object)selection, (Object)view.getViewer().getSelection());
    }

    private String toString(TreeSelection s1) {
        StringBuilder sb = new StringBuilder();
        TreePath[] treePathArray = s1.getPaths();
        int n = treePathArray.length;
        int n2 = 0;
        while (n2 < n) {
            TreePath path = treePathArray[n2];
            sb.append("[");
            int i = 0;
            while (i < path.getSegmentCount()) {
                sb.append(path.getSegment(i));
                sb.append(", ");
                ++i;
            }
            sb.setLength(sb.length() - 2);
            sb.append("]");
            ++n2;
        }
        return sb.toString();
    }
}

