/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.context.sdk.java;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.mylyn.commons.sdk.util.ResourceTestUtil;
import org.eclipse.mylyn.commons.sdk.util.TestProject;
import org.eclipse.mylyn.context.core.IInteractionContext;
import org.eclipse.mylyn.context.core.IInteractionContextScaling;
import org.eclipse.mylyn.context.sdk.java.TestJavaProject;
import org.eclipse.mylyn.context.sdk.util.AbstractContextTest;
import org.eclipse.mylyn.context.sdk.util.ContextTestUtil;
import org.eclipse.mylyn.internal.context.core.ContextCorePlugin;
import org.eclipse.mylyn.internal.context.core.InteractionContext;
import org.eclipse.mylyn.internal.context.core.InteractionContextManager;
import org.eclipse.mylyn.internal.context.core.InteractionContextScaling;
import org.eclipse.mylyn.internal.context.ui.ContextUiPlugin;
import org.eclipse.mylyn.internal.java.ui.JavaEditingMonitor;
import org.eclipse.mylyn.internal.java.ui.JavaStructureBridge;
import org.eclipse.mylyn.internal.java.ui.JavaUiBridgePlugin;
import org.eclipse.mylyn.internal.resources.ui.ResourcesUiBridgePlugin;

public abstract class AbstractJavaContextTest
extends AbstractContextTest {
    protected InteractionContextManager manager = ContextCorePlugin.getContextManager();
    protected JavaEditingMonitor monitor = new JavaEditingMonitor();
    protected TestJavaProject project;
    protected TestProject nonJavaProject;
    protected IPackageFragment p1;
    protected IType type1;
    protected String contextId = ((Object)((Object)this)).getClass().getSimpleName();
    protected InteractionContext context;
    protected InteractionContextScaling scaling = new InteractionContextScaling();

    protected void setUp() throws Exception {
        super.setUp();
        ContextTestUtil.triggerContextUiLazyStart();
        AbstractJavaContextTest.assertNotNull((Object)JavaPlugin.getDefault());
        AbstractJavaContextTest.assertNotNull((Object)JavaUiBridgePlugin.getDefault());
        AbstractJavaContextTest.assertNotNull((Object)ResourcesUiBridgePlugin.getDefault());
        String bridges = ContextCorePlugin.getDefault().getStructureBridges().toString();
        AbstractJavaContextTest.assertTrue((String)("Expected JavaStructureBridge not available: " + bridges), (bridges.indexOf(JavaStructureBridge.class.getCanonicalName()) != -1 ? 1 : 0) != 0);
        AbstractJavaContextTest.assertTrue((String)"Expected initialized ResourcesUiBridge", (boolean)ResourcesUiBridgePlugin.getDefault().isStarted());
        this.project = new TestJavaProject(((Object)((Object)this)).getClass().getSimpleName());
        this.nonJavaProject = new TestProject(String.valueOf(((Object)((Object)this)).getClass().getSimpleName()) + "nonJava");
        this.p1 = this.project.createPackage("p1");
        this.type1 = this.project.createType(this.p1, "Type1.java", "public class Type1 { }");
        this.context = new InteractionContext(this.contextId, (IInteractionContextScaling)this.scaling);
        this.context.reset();
        this.manager.internalActivateContext((IInteractionContext)this.context);
        ContextUiPlugin.getViewerManager().setSyncRefreshMode(true);
        ResourcesUiBridgePlugin.getDefault().setResourceMonitoringEnabled(false);
    }

    protected void tearDown() throws Exception {
        ResourcesUiBridgePlugin.getDefault().setResourceMonitoringEnabled(true);
        this.context.reset();
        AbstractJavaContextTest.assertTrue((boolean)this.context.getInteresting().isEmpty());
        this.manager.deactivateContext(this.contextId);
        this.manager.deleteContext(this.contextId);
        ContextCorePlugin.getContextStore().getFileForContext(this.contextId).delete();
        ResourceTestUtil.deleteProject((IProject)this.project.getProject());
        ResourceTestUtil.deleteProject((IProject)this.nonJavaProject.getProject());
        for (InteractionContext context : this.manager.getActiveContexts()) {
            this.manager.deactivateContext(context.getHandleIdentifier());
        }
        AbstractJavaContextTest.assertFalse((boolean)this.manager.isContextActive());
        AbstractJavaContextTest.waitForAutoBuild();
        super.tearDown();
    }

    public static void waitForAutoBuild() {
        boolean wasInterrupted = false;
        do {
            try {
                Job.getJobManager().join(ResourcesPlugin.FAMILY_AUTO_BUILD, null);
                wasInterrupted = false;
            }
            catch (OperationCanceledException e) {
                e.printStackTrace();
            }
            catch (InterruptedException interruptedException) {
                wasInterrupted = true;
            }
        } while (wasInterrupted);
    }

    public class TestProgressMonitor
    implements IProgressMonitor {
        boolean done = false;

        public void beginTask(String name, int totalWork) {
        }

        public void done() {
            this.done = true;
        }

        public void internalWorked(double work) {
        }

        public boolean isCanceled() {
            return false;
        }

        public void setCanceled(boolean value) {
        }

        public void setTaskName(String name) {
        }

        public void subTask(String name) {
        }

        public void worked(int work) {
        }

        public boolean isDone() {
            return this.done;
        }
    }
}

