/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.gerrit.dashboard.ui.internal.menus;

import java.util.Map;
import java.util.Set;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.mylyn.gerrit.dashboard.GerritPlugin;
import org.eclipse.mylyn.gerrit.dashboard.ui.GerritUi;
import org.eclipse.mylyn.gerrit.dashboard.ui.internal.utils.GerritServerUtility;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.ui.actions.CompoundContributionItem;
import org.eclipse.ui.menus.CommandContributionItem;
import org.eclipse.ui.menus.CommandContributionItemParameter;
import org.eclipse.ui.menus.IWorkbenchContribution;
import org.eclipse.ui.services.IServiceLocator;

public class DynamicMenuAddition
extends CompoundContributionItem
implements IWorkbenchContribution {
    private static String SELECT_PICTURE_FILE = "icons/select.gif";
    private static ImageRegistry fImageRegistry = new ImageRegistry();
    private IServiceLocator fServiceLocator;
    private GerritServerUtility fServer = null;
    private Map<TaskRepository, String> fMapServer = null;
    private ImageDescriptor fSelectPicture = null;

    static {
        fImageRegistry.put(SELECT_PICTURE_FILE, GerritUi.getImageDescriptor(SELECT_PICTURE_FILE));
    }

    protected IContributionItem[] getContributionItems() {
        GerritPlugin.Ftracer.traceInfo("\t\t DynamicMenuAddition .getContributionItems()");
        CommandContributionItem[] contributionItems = new CommandContributionItem[]{};
        if (this.fServer != null) {
            this.fMapServer = this.fServer.getGerritMapping();
        }
        if (this.fMapServer != null && !this.fMapServer.isEmpty()) {
            Set<TaskRepository> mapSet = this.fMapServer.keySet();
            String lastSelected = this.fServer.getLastSavedGerritServer();
            GerritPlugin.Ftracer.traceInfo("-------------------");
            int size = mapSet.size();
            contributionItems = new CommandContributionItem[size];
            int count = 0;
            for (TaskRepository key : mapSet) {
                GerritPlugin.Ftracer.traceInfo("Map Key: " + key.getRepositoryLabel() + "\t URL: " + this.fMapServer.get(key));
                CommandContributionItemParameter contributionParameter = new CommandContributionItemParameter(this.fServiceLocator, this.fMapServer.get(key), "org.eclipse.mylyn.gerrit.dashboard.ui.addGerritSite", 8);
                contributionParameter.label = key.getRepositoryLabel();
                contributionParameter.visibleEnabled = true;
                if (lastSelected != null && lastSelected.equals(this.fMapServer.get(key))) {
                    contributionParameter.icon = this.fSelectPicture = fImageRegistry.getDescriptor(SELECT_PICTURE_FILE);
                }
                contributionItems[count++] = new CommandContributionItem(contributionParameter);
            }
        }
        return contributionItems;
    }

    public void initialize(IServiceLocator aServiceLocator) {
        this.fServiceLocator = aServiceLocator;
        this.fServer = GerritServerUtility.getInstance();
        GerritPlugin.Ftracer.traceInfo("\t\t DynamicMenuAddition .initialize()()");
    }
}

