/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.gerrit.dashboard.ui.views;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.mylyn.commons.workbench.DelayedRefreshJob;
import org.eclipse.mylyn.gerrit.dashboard.GerritPlugin;
import org.eclipse.mylyn.gerrit.dashboard.core.GerritQueryException;
import org.eclipse.mylyn.gerrit.dashboard.core.GerritTask;
import org.eclipse.mylyn.gerrit.dashboard.core.GerritTaskDataCollector;
import org.eclipse.mylyn.gerrit.dashboard.ui.GerritUi;
import org.eclipse.mylyn.gerrit.dashboard.ui.internal.model.ReviewTableData;
import org.eclipse.mylyn.gerrit.dashboard.ui.internal.model.UIReviewTable;
import org.eclipse.mylyn.gerrit.dashboard.ui.internal.utils.GerritServerUtility;
import org.eclipse.mylyn.gerrit.dashboard.ui.internal.utils.UIUtils;
import org.eclipse.mylyn.internal.gerrit.core.GerritConnector;
import org.eclipse.mylyn.internal.gerrit.core.GerritCorePlugin;
import org.eclipse.mylyn.internal.gerrit.core.client.GerritClient;
import org.eclipse.mylyn.internal.gerrit.core.client.GerritException;
import org.eclipse.mylyn.internal.tasks.core.AbstractTask;
import org.eclipse.mylyn.internal.tasks.core.ITaskListChangeListener;
import org.eclipse.mylyn.internal.tasks.core.RepositoryQuery;
import org.eclipse.mylyn.internal.tasks.core.TaskContainerDelta;
import org.eclipse.mylyn.internal.tasks.core.TaskTask;
import org.eclipse.mylyn.internal.tasks.ui.TasksUiPlugin;
import org.eclipse.mylyn.internal.tasks.ui.actions.SynchronizeEditorAction;
import org.eclipse.mylyn.internal.tasks.ui.util.TasksUiInternal;
import org.eclipse.mylyn.tasks.core.AbstractRepositoryConnector;
import org.eclipse.mylyn.tasks.core.IRepositoryElement;
import org.eclipse.mylyn.tasks.core.IRepositoryModel;
import org.eclipse.mylyn.tasks.core.IRepositoryQuery;
import org.eclipse.mylyn.tasks.core.ITask;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.core.data.TaskData;
import org.eclipse.mylyn.tasks.core.data.TaskDataCollector;
import org.eclipse.mylyn.tasks.ui.AbstractRepositoryConnectorUi;
import org.eclipse.mylyn.tasks.ui.TasksUi;
import org.eclipse.mylyn.tasks.ui.TasksUiUtil;
import org.eclipse.mylyn.tasks.ui.editors.TaskEditor;
import org.eclipse.mylyn.tasks.ui.editors.TaskEditorInput;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.menus.CommandContributionItem;
import org.eclipse.ui.menus.CommandContributionItemParameter;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.ui.services.IServiceLocator;
import org.osgi.framework.Version;

public class GerritTableView
extends ViewPart
implements ITaskListChangeListener {
    public static final String MY_CHANGES_STRING = "owner:self OR reviewer:self";
    public static final String MY_WATCHED_CHANGES_STRING = "is:watched status:open";
    public static final String ALL_OPEN_CHANGES_STRING = "status:open";
    public static final String VIEW_ID = "org.eclipse.mylyn.gerrit.dashboard.ui.views.GerritTableView";
    private static final String COMMAND_MESSAGE = "Search Gerrit info ...";
    private final String SEARCH_BTN = "Search";
    private final String TOTAL_COUNT = "Total reviews: ";
    private final String GERRIT_LABEL = " - Gerrit ";
    private final int SEARCH_WIDTH = 200;
    private final int REPO_WIDTH = 350;
    private final int VERSION_WIDTH = 35;
    private final String SEARCH_TOOLTIP = "Ex. status:open (or is:open) \n status:merged \n is:draft \n status:open project:Foo \n See explanation by selecting in the toolbar \n Documentation > Searching";
    private final int SEARCH_SIZE_MENU_LIST = 4;
    private GerritConnector fConnector = GerritCorePlugin.getDefault().getConnector();
    private TaskRepository fTaskRepository = null;
    private RepositoryQuery fCurrentQuery = null;
    private static GerritTableView rtv = null;
    private Label fRepositoryVersionResulLabel;
    private Label fReviewsTotalLabel;
    private Label fReviewsTotalResultLabel;
    private Combo fSearchRequestText;
    private Button fSearchRequestBtn;
    private LinkedHashSet<String> fRequestList = new LinkedHashSet();
    private static TableViewer fViewer;
    private ReviewTableData fReviewTable = new ReviewTableData();
    private GerritServerUtility fServerUtil = GerritServerUtility.getInstance();
    private Map<TaskRepository, String> fMapRepoServer = null;
    private Action doubleClickAction;
    private final LinkedHashSet<Job> fJobs = new LinkedHashSet();
    private TableRefreshJob fTableRefreshJob;

    public GerritTableView() {
        rtv = this;
    }

    public boolean setConnector(GerritConnector aConnector) {
        boolean b = true;
        this.fConnector = aConnector == null ? GerritCorePlugin.getDefault().getConnector() : aConnector;
        if (this.fConnector == null) {
            b = false;
        }
        return b;
    }

    public void setReviewTableData(ReviewTableData ReviewTable) {
        this.fReviewTable = ReviewTable;
    }

    public void setGerritServerUtility(GerritServerUtility ServerUtil) {
        this.fServerUtil = ServerUtil;
    }

    public void dispose() {
        TasksUiPlugin.getTaskList().removeChangeListener((ITaskListChangeListener)this);
        this.fTableRefreshJob.cancel();
        this.cleanJobs();
        rtv = null;
    }

    private void cleanJobs() {
        for (Job job : this.fJobs) {
            job.sleep();
            job.cancel();
        }
        this.fJobs.clear();
    }

    private void refresh() {
        this.fTableRefreshJob.doRefresh(null);
    }

    public void createPartControl(Composite aParent) {
        ScrolledComposite sc = new ScrolledComposite(aParent, 2816);
        sc.setExpandHorizontal(true);
        Composite c = new Composite((Composite)sc, 0);
        sc.setContent((Control)c);
        sc.setExpandVertical(true);
        this.createSearchSection(c);
        UIReviewTable reviewTable = new UIReviewTable();
        fViewer = reviewTable.createTableViewerSection(c);
        this.createLayout(c);
        this.makeActions();
        this.hookContextMenu();
        this.hookDoubleClickAction();
        this.contributeToActionBars();
        this.fTableRefreshJob = new TableRefreshJob(fViewer, "Refresh table");
        TasksUiPlugin.getTaskList().addChangeListener((ITaskListChangeListener)this);
        sc.setMinSize(c.computeSize(-1, -1));
    }

    private void createLayout(Composite aParent) {
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.verticalSpacing = 1;
        layout.makeColumnsEqualWidth = false;
        aParent.setLayout((Layout)layout);
    }

    private void createSearchSection(Composite aParent) {
        Group formGroup = new Group(aParent, 272);
        GridData gribDataGroup = new GridData(768);
        formGroup.setLayoutData((Object)gribDataGroup);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginTop = 0;
        layout.marginHeight = 0;
        layout.verticalSpacing = 0;
        layout.makeColumnsEqualWidth = false;
        formGroup.setLayout((Layout)layout);
        Composite leftSearchForm = UIUtils.createsGeneralComposite((Composite)formGroup, 0);
        GridData gribDataViewer = new GridData(768);
        leftSearchForm.setLayoutData((Object)gribDataViewer);
        GridLayout leftLayoutForm = new GridLayout();
        leftLayoutForm.numColumns = 3;
        leftLayoutForm.marginHeight = 0;
        leftLayoutForm.makeColumnsEqualWidth = false;
        leftLayoutForm.horizontalSpacing = 0;
        leftSearchForm.setLayout((Layout)leftLayoutForm);
        this.fRepositoryVersionResulLabel = new Label(leftSearchForm, 0);
        this.fRepositoryVersionResulLabel.setLayoutData((Object)new GridData(350, -1));
        this.fReviewsTotalLabel = new Label(leftSearchForm, 0);
        this.fReviewsTotalLabel.setText("Total reviews: ");
        this.fReviewsTotalResultLabel = new Label(leftSearchForm, 0);
        this.fReviewsTotalResultLabel.setLayoutData((Object)new GridData(35, -1));
        Composite rightSsearchForm = UIUtils.createsGeneralComposite((Composite)formGroup, 0);
        GridData gribDataViewer2 = new GridData(896);
        rightSsearchForm.setLayoutData((Object)gribDataViewer2);
        GridLayout rightLayoutForm = new GridLayout();
        rightLayoutForm.numColumns = 2;
        rightLayoutForm.marginHeight = 0;
        rightLayoutForm.makeColumnsEqualWidth = false;
        rightSsearchForm.setLayout((Layout)rightLayoutForm);
        this.fSearchRequestText = new Combo(rightSsearchForm, 0);
        this.fSearchRequestText.setLayoutData((Object)new GridData(200, -1));
        this.fSearchRequestText.setToolTipText("Ex. status:open (or is:open) \n status:merged \n is:draft \n status:open project:Foo \n See explanation by selecting in the toolbar \n Documentation > Searching");
        this.fRequestList = this.fServerUtil.getListLastCommands();
        this.setSearchText("");
        this.fSearchRequestText.addListener(14, new Listener(){

            public void handleEvent(Event event) {
                if (GerritTableView.this.fSearchRequestText.getText().trim().length() > 6) {
                    GerritTableView.this.processCommands("custom");
                }
            }
        });
        this.fSearchRequestBtn = new Button(rightSsearchForm, 0);
        this.fSearchRequestBtn.setText("Search");
        this.fSearchRequestBtn.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                GerritTableView.this.processCommands("custom");
            }
        });
    }

    private void hookContextMenu() {
        MenuManager menuMgr = new MenuManager("#PopupMenu");
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                GerritTableView.this.fillContextMenu(manager);
            }
        });
        Menu menu = menuMgr.createContextMenu(fViewer.getControl());
        fViewer.getControl().setMenu(menu);
        this.getSite().registerContextMenu(menuMgr, (ISelectionProvider)fViewer);
    }

    private void contributeToActionBars() {
        IActionBars bars = this.getViewSite().getActionBars();
        this.fillLocalPullDown(bars.getMenuManager());
        this.fillLocalToolBar(bars.getToolBarManager());
    }

    private void fillLocalPullDown(IMenuManager manager) {
    }

    private void fillContextMenu(IMenuManager manager) {
        CommandContributionItem[] contribItems = this.buildContributions();
        int index = 0;
        while (index < contribItems.length) {
            manager.add((IContributionItem)contribItems[index]);
            ++index;
        }
        manager.add((IContributionItem)new Separator("additions"));
    }

    private void fillLocalToolBar(IToolBarManager manager) {
    }

    private void makeActions() {
        this.doubleClickAction = new Action(){

            public void run() {
                String editorId;
                IEditorPart editorPart;
                ISelection selection = fViewer.getSelection();
                if (!(selection instanceof IStructuredSelection)) {
                    return;
                }
                IStructuredSelection structuredSelection = (IStructuredSelection)selection;
                if (structuredSelection.size() != 1) {
                    return;
                }
                Object element = structuredSelection.getFirstElement();
                if (!(element instanceof AbstractTask)) {
                    return;
                }
                AbstractTask task = (AbstractTask)element;
                AbstractRepositoryConnectorUi connectorUi = TasksUiPlugin.getConnectorUi((String)"org.eclipse.mylyn.gerrit");
                IEditorInput editorInput = connectorUi.getTaskEditorInput(GerritTableView.this.getTaskRepository(), (ITask)task);
                if (editorInput == null) {
                    editorInput = new TaskEditorInput(GerritTableView.this.fTaskRepository, (ITask)task);
                }
                if ((editorPart = TasksUiUtil.openEditor((IEditorInput)editorInput, (String)(editorId = connectorUi.getTaskEditorId((ITask)task)), null)) instanceof TaskEditor) {
                    TaskEditor taskEditor = (TaskEditor)editorPart;
                    SynchronizeEditorAction synchAction = new SynchronizeEditorAction();
                    synchAction.selectionChanged((IStructuredSelection)new StructuredSelection((Object)taskEditor));
                    synchAction.run();
                    if (task instanceof GerritTask) {
                        GerritTableView.this.fReviewTable.updateReviewItem((GerritTask)task);
                        GerritTableView.this.refresh();
                    }
                }
            }
        };
    }

    private void hookDoubleClickAction() {
        fViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                GerritTableView.this.doubleClickAction.run();
            }
        });
    }

    public void setFocus() {
        fViewer.getControl().setFocus();
    }

    private CommandContributionItem[] buildContributions() {
        IServiceLocator serviceLocator = this.getViewSite().getActionBars().getServiceLocator();
        CommandContributionItem[] contributionItems = new CommandContributionItem[1];
        CommandContributionItemParameter contributionParameter = new CommandContributionItemParameter(serviceLocator, "Star Review", "org.eclipse.mylyn.gerrit.dashboard.ui.adjustMyStarred", 8);
        contributionParameter.label = "Star Review";
        contributionParameter.visibleEnabled = true;
        contributionItems[0] = new CommandContributionItem(contributionParameter);
        return contributionItems;
    }

    public static TableViewer getTableViewer() {
        return fViewer;
    }

    public TaskRepository getTaskRepository() {
        this.processCommands("");
        return this.fTaskRepository;
    }

    public static GerritTableView getActiveView() {
        IViewPart viewPart = null;
        if (rtv != null) {
            return rtv;
        }
        IWorkbench workbench = GerritUi.getDefault().getWorkbench();
        IWorkbenchWindow window = workbench.getActiveWorkbenchWindow();
        IWorkbenchPage page = null;
        if (window != null) {
            page = workbench.getActiveWorkbenchWindow().getActivePage();
        }
        if (page != null && (viewPart = page.findView(VIEW_ID)) == null) {
            try {
                viewPart = page.showView(VIEW_ID, null, 3);
            }
            catch (PartInitException e) {
                GerritUi.Ftracer.traceWarning("PartInitException:   " + e.getLocalizedMessage());
                e.printStackTrace();
            }
            GerritUi.Ftracer.traceWarning("getActiveView() SHOULD (JUST) CREATED A NEW Table:" + viewPart);
        }
        return (GerritTableView)viewPart;
    }

    public void openView() {
        IWorkbench workbench = GerritUi.getDefault().getWorkbench();
        IWorkbenchPage page = workbench.getActiveWorkbenchWindow().getActivePage();
        IViewPart viewPart = page.findView(VIEW_ID);
        if (viewPart == null) {
            try {
                viewPart = page.showView(VIEW_ID);
            }
            catch (PartInitException e) {
                GerritUi.Ftracer.traceWarning("PartInitException:   " + e.getLocalizedMessage());
            }
        } else if (!page.isPartVisible((IWorkbenchPart)viewPart)) {
            page.bringToTop((IWorkbenchPart)viewPart);
        }
    }

    public void processCommands(String aQuery) {
        GerritUi.Ftracer.traceInfo("Process command :   " + aQuery);
        String lastSaved = this.fServerUtil.getLastSavedGerritServer();
        if (lastSaved != null) {
            this.fTaskRepository = this.fServerUtil.getTaskRepo(lastSaved);
        }
        if (this.fTaskRepository == null) {
            Set<TaskRepository> mapSet;
            Iterator<TaskRepository> iterator;
            this.fMapRepoServer = GerritServerUtility.getInstance().getGerritMapping();
            if (this.fMapRepoServer.size() == 1 && (iterator = (mapSet = this.fMapRepoServer.keySet()).iterator()).hasNext()) {
                TaskRepository key;
                this.fTaskRepository = key = iterator.next();
                this.fServerUtil.saveLastGerritServer(key.getRepositoryUrl());
            }
        }
        if (this.fTaskRepository == null) {
            String msg = "You need to define a Gerrit repository.";
            String reason = "No Gerrit repository has been selected yet.";
            GerritUi.Ftracer.traceInfo(msg);
            UIUtils.showErrorDialog(msg, reason);
        } else if (aQuery != null && !aQuery.equals("")) {
            this.updateTable(this.fTaskRepository, aQuery);
        }
    }

    public Version getlastGerritServerVersion() {
        Version version = null;
        String lastSaved = this.fServerUtil.getLastSavedGerritServer();
        if (lastSaved != null) {
            this.fTaskRepository = this.fServerUtil.getTaskRepo(lastSaved);
        }
        if (this.fTaskRepository == null) {
            Set<TaskRepository> mapSet;
            Iterator<TaskRepository> iterator;
            this.fMapRepoServer = GerritServerUtility.getInstance().getGerritMapping();
            if (this.fMapRepoServer.size() == 1 && (iterator = (mapSet = this.fMapRepoServer.keySet()).iterator()).hasNext()) {
                TaskRepository key;
                this.fTaskRepository = key = iterator.next();
                this.fServerUtil.saveLastGerritServer(key.getRepositoryUrl());
            }
        }
        if (this.fTaskRepository != null && this.setConnector(this.fConnector)) {
            GerritClient gerritClient = this.fConnector.getClient(this.fTaskRepository);
            try {
                version = gerritClient.getVersion((IProgressMonitor)new NullProgressMonitor());
                GerritUi.Ftracer.traceInfo("Selected version: " + version.toString());
            }
            catch (GerritException e) {
                e.printStackTrace();
            }
        }
        return version;
    }

    public boolean isGerritVersionBefore_2_5() {
        boolean ret = false;
        Version version = this.getlastGerritServerVersion();
        if (version != null && version.getMajor() >= 2 && version.getMinor() < 5) {
            ret = true;
        }
        return ret;
    }

    private Object updateTable(final TaskRepository aTaskRepo, final String aQueryType) {
        String cmdMessage = "Search Gerrit info ... " + aTaskRepo.getUrl() + " : " + aQueryType;
        Job job = new Job(cmdMessage){
            public String familyName;
            {
                super($anonymous0);
                this.familyName = "DASHBOARD_UI";
            }

            public boolean belongsTo(Object aFamily) {
                return this.familyName.equals(aFamily);
            }

            public IStatus run(IProgressMonitor aMonitor) {
                aMonitor.beginTask(GerritTableView.COMMAND_MESSAGE, -1);
                GerritPlugin.Ftracer.traceInfo("repository:   " + aTaskRepo.getUrl() + "\t query: " + aQueryType);
                IStatus status = null;
                try {
                    GerritTableView.this.fReviewTable.createReviewItem(aQueryType, aTaskRepo);
                    GerritTableView.this.getReviews(aTaskRepo, aQueryType);
                    Display.getDefault().syncExec(new Runnable(){

                        @Override
                        public void run() {
                            if (aQueryType != "custom") {
                                String query = GerritTableView.this.fCurrentQuery.getAttribute("gerrit query string");
                                GerritTableView.this.setSearchText(query);
                            } else {
                                GerritTableView.this.setSearchText(GerritTableView.this.getSearchText());
                            }
                            boolean ok = GerritTableView.this.setConnector(GerritTableView.this.fConnector);
                            GerritClient gerritClient = null;
                            if (ok) {
                                gerritClient = GerritTableView.this.fConnector.getClient(aTaskRepo);
                            }
                            if (gerritClient != null) {
                                try {
                                    GerritUi.Ftracer.traceInfo("GerritClient: " + gerritClient.getVersion((IProgressMonitor)new NullProgressMonitor()));
                                    GerritTableView.this.setRepositoryVersionLabel(aTaskRepo.getRepositoryLabel(), gerritClient.getVersion((IProgressMonitor)new NullProgressMonitor()).toString());
                                }
                                catch (GerritException e1) {
                                    e1.printStackTrace();
                                }
                            }
                        }
                    });
                    status = Status.OK_STATUS;
                }
                catch (GerritQueryException e) {
                    status = e.getStatus();
                    GerritPlugin.Ftracer.traceWarning(status.toString());
                }
                aMonitor.done();
                GerritTableView.this.fJobs.remove((Object)this);
                return status;
            }
        };
        this.cleanJobs();
        this.fJobs.add(job);
        job.setUser(true);
        job.schedule();
        return null;
    }

    private void setSearchText(String aSt) {
        if (!this.fSearchRequestText.isDisposed()) {
            if (aSt != null && aSt != "") {
                int index = -1;
                String[] ar = this.fSearchRequestText.getItems();
                int i = 0;
                while (i < ar.length) {
                    if (ar[i].equals(aSt.trim())) {
                        index = i;
                        break;
                    }
                    ++i;
                }
                if (index != -1) {
                    this.fRequestList.remove(this.fRequestList.remove(ar[index]));
                } else if (this.fRequestList.size() > 4) {
                    Object obj = this.fRequestList.iterator().next();
                    this.fRequestList.remove(this.fRequestList.remove(obj));
                }
                this.fRequestList.add(aSt.trim());
                this.fServerUtil.saveLastCommandList(this.fRequestList);
            }
            this.fSearchRequestText.setItems(this.reverseOrder(this.fRequestList.toArray(new String[0])));
            if (aSt != null && aSt != "") {
                this.fSearchRequestText.select(0);
            } else {
                this.fSearchRequestText.setText("");
            }
        }
    }

    private String[] reverseOrder(String[] aList) {
        int size = aList.length;
        int index = size - 1;
        String[] rev = new String[size];
        int i = 0;
        while (i < size) {
            rev[i] = aList[index--];
            ++i;
        }
        return rev;
    }

    private String getSearchText() {
        if (!this.fSearchRequestText.isDisposed()) {
            final String[] str = new String[1];
            Display.getDefault().syncExec(new Runnable(){

                @Override
                public void run() {
                    str[0] = GerritTableView.this.fSearchRequestText.getText().trim();
                    GerritUi.Ftracer.traceInfo("Custom string: " + str[0]);
                }
            });
            return str[0];
        }
        return null;
    }

    private void getReviews(TaskRepository repository, String queryType) throws GerritQueryException {
        block11: {
            String queryId = String.valueOf(rtv.getTitle()) + " - " + queryType;
            Set queries = TasksUiInternal.getTaskList().getQueries();
            RepositoryQuery query = null;
            if (queryType == "custom") {
                queryId = String.valueOf(rtv.getTitle()) + " - " + queryType + "- " + this.getSearchText();
            }
            for (RepositoryQuery rquery : queries) {
                if (!rquery.getRepositoryUrl().equals(repository.getRepositoryUrl()) || !rquery.getSummary().equals(queryId)) continue;
                query = rquery;
                break;
            }
            if (query == null) {
                IRepositoryModel repositoryModel = TasksUi.getRepositoryModel();
                query = (RepositoryQuery)repositoryModel.createRepositoryQuery(repository);
                query.setSummary(queryId);
                query.setAttribute("gerrit query type", queryType);
                query.setAttribute("gerrit query project", null);
                query.setAttribute("task.common.hidden", Boolean.toString(true));
                if (queryType == "custom") {
                    query.setAttribute("gerrit query string", this.getSearchText());
                } else {
                    query.setAttribute("gerrit query string", queryType);
                }
                TasksUiPlugin.getTaskList().addQuery(query);
            } else if (queryType == "custom") {
                query.setAttribute("gerrit query string", this.getSearchText());
            } else {
                String st = this.matchQueryTypeRequest(queryType);
                query.setAttribute("gerrit query string", st);
            }
            this.fCurrentQuery = query;
            GerritTask[] reviews = this.getReviewList(repository, query);
            this.fReviewTable.init(reviews);
            this.refresh();
            GerritConnector connector = GerritCorePlugin.getDefault().getConnector();
            if (this.isGerritVersionBefore_2_5()) {
                Job job = null;
                try {
                    job = TasksUiInternal.synchronizeQuery((AbstractRepositoryConnector)connector, (RepositoryQuery)query, null, (boolean)true);
                }
                catch (Exception exception) {
                    if (job == null) break block11;
                    job.cancel();
                }
            }
        }
    }

    private String matchQueryTypeRequest(String queryType) {
        if (queryType.equals("all open changes")) {
            return ALL_OPEN_CHANGES_STRING;
        }
        if (queryType.equals("my changes")) {
            return MY_CHANGES_STRING;
        }
        if (queryType.equals("my watched changes")) {
            return MY_WATCHED_CHANGES_STRING;
        }
        return queryType;
    }

    private GerritTask[] getReviewList(TaskRepository repository, RepositoryQuery aQuery) throws GerritQueryException {
        GerritTaskDataCollector resultCollector = new GerritTaskDataCollector();
        Object status = null;
        boolean ok = this.setConnector(this.fConnector);
        status = ok ? this.fConnector.performQuery(repository, (IRepositoryQuery)aQuery, (TaskDataCollector)resultCollector, null, (IProgressMonitor)new NullProgressMonitor()) : new Status(4, "org.eclipse.mylyn.gerrit.core", NLS.bind((String)"Missing Git connector for : {0}", (Object)aQuery.getAttribute("gerrit query project")));
        if (!status.isOK()) {
            String msg = "Unable to read the Gerrit server.";
            throw new GerritQueryException(status, msg);
        }
        ArrayList<GerritTask> reviews = new ArrayList<GerritTask>();
        List tasksData = resultCollector.getResults();
        for (TaskData taskData : tasksData) {
            GerritTask review = new GerritTask(taskData);
            reviews.add(review);
        }
        return reviews.toArray(new GerritTask[0]);
    }

    public void containersChanged(Set<TaskContainerDelta> deltas) {
        for (TaskContainerDelta taskContainerDelta : deltas) {
            IRepositoryElement element = taskContainerDelta.getElement();
            switch (taskContainerDelta.getKind()) {
                case ROOT: {
                    this.refresh();
                    break;
                }
                case ADDED: 
                case CONTENT: {
                    if (element != null && element instanceof TaskTask) {
                        this.updateReview((TaskTask)element);
                    }
                    this.refresh();
                    break;
                }
                case REMOVED: 
                case DELETED: {
                    if (element != null && element instanceof TaskTask) {
                        this.deleteReview((TaskTask)element);
                    }
                    this.refresh();
                    break;
                }
            }
        }
    }

    private synchronized void deleteReview(TaskTask task) {
        this.fReviewTable.deleteReviewItem(task.getTaskId());
    }

    private synchronized void updateReview(TaskTask task) {
        String summary = task.getSummary();
        boolean ourQuery = task.getParentContainers().contains(this.fCurrentQuery);
        if (ourQuery && summary != null && !summary.equals("")) {
            try {
                TaskData taskData = this.fConnector.getTaskData(this.getTaskRepository(), task.getTaskId(), (IProgressMonitor)new NullProgressMonitor());
                GerritTask gtask = new GerritTask(taskData);
                if (gtask.getAttribute("task.common.date.completed") == null) {
                    this.fReviewTable.updateReviewItem(gtask);
                }
            }
            catch (CoreException coreException) {}
        }
    }

    private void setRepositoryVersionLabel(String aRepo, String aVersion) {
        if (!this.fRepositoryVersionResulLabel.isDisposed()) {
            String s = String.valueOf(aRepo) + " - Gerrit " + aVersion;
            this.fRepositoryVersionResulLabel.setText(s);
        }
    }

    private void setReviewsTotalResultLabel(String aSt) {
        if (!this.fReviewsTotalResultLabel.isDisposed()) {
            this.fReviewsTotalResultLabel.setText(aSt);
        }
    }

    private final class TableRefreshJob
    extends DelayedRefreshJob {
        private TableRefreshJob(TableViewer viewer, String name) {
            super((StructuredViewer)viewer, name);
        }

        protected void doRefresh(Object[] items) {
            Display.getDefault().syncExec(new Runnable(){

                @Override
                public void run() {
                    fViewer.setInput((Object)GerritTableView.this.fReviewTable.getReviews());
                    GerritTableView.this.setReviewsTotalResultLabel(Integer.toString(GerritTableView.this.fReviewTable.getReviews().length));
                    fViewer.refresh(false, false);
                }
            });
        }
    }
}

