/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.gerrit.ui.operations;

import com.google.gerrit.common.data.GerritConfig;
import java.lang.reflect.InvocationTargetException;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.fieldassist.IContentProposalProvider;
import org.eclipse.jface.fieldassist.IControlContentAdapter;
import org.eclipse.jface.fieldassist.TextContentAdapter;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.text.TextViewer;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.mylyn.commons.workbench.editors.CommonTextSupport;
import org.eclipse.mylyn.commons.workbench.forms.CommonFormUtil;
import org.eclipse.mylyn.internal.gerrit.core.GerritOperationFactory;
import org.eclipse.mylyn.internal.gerrit.core.client.GerritConfiguration;
import org.eclipse.mylyn.internal.gerrit.core.client.compat.GerritConfigX;
import org.eclipse.mylyn.internal.gerrit.core.operations.GerritOperation;
import org.eclipse.mylyn.internal.gerrit.core.operations.RefreshConfigRequest;
import org.eclipse.mylyn.internal.gerrit.ui.GerritUiPlugin;
import org.eclipse.mylyn.internal.tasks.ui.actions.SynchronizeEditorAction;
import org.eclipse.mylyn.internal.tasks.ui.editors.RichTextEditor;
import org.eclipse.mylyn.internal.tasks.ui.editors.TaskEditorExtensions;
import org.eclipse.mylyn.reviews.ui.ProgressDialog;
import org.eclipse.mylyn.tasks.core.ITask;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.ui.ITasksUiFactory;
import org.eclipse.mylyn.tasks.ui.TasksUi;
import org.eclipse.mylyn.tasks.ui.editors.AbstractTaskEditorExtension;
import org.eclipse.mylyn.tasks.ui.editors.TaskEditor;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.fieldassist.ContentAssistCommandAdapter;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.ui.statushandlers.StatusManager;

public abstract class GerritOperationDialog
extends ProgressDialog {
    private boolean needsConfig;
    protected final ITask task;
    protected FormToolkit toolkit;
    private CommonTextSupport textSupport;

    public GerritOperationDialog(Shell parentShell, ITask task) {
        super(parentShell);
        this.task = task;
    }

    public boolean close() {
        boolean shouldClose;
        if (this.getReturnCode() == 0 && !(shouldClose = this.performOperation(this.createOperation()))) {
            return false;
        }
        if (this.textSupport != null) {
            this.textSupport.dispose();
        }
        return super.close();
    }

    public abstract GerritOperation<?> createOperation();

    public GerritOperationFactory getOperationFactory() {
        return GerritUiPlugin.getDefault().getOperationFactory();
    }

    public ITask getTask() {
        return this.task;
    }

    public boolean needsConfig() {
        return this.needsConfig;
    }

    public void setNeedsConfig(boolean needsConfig) {
        this.needsConfig = needsConfig;
    }

    private boolean performOperation(final GerritOperation<?> operation) {
        final AtomicReference result = new AtomicReference();
        try {
            this.run(true, true, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    result.set(operation.run(monitor));
                }
            });
        }
        catch (InvocationTargetException e) {
            StatusManager.getManager().handle((IStatus)new Status(4, "org.eclipse.mylyn.gerrit.ui", "Unexpected error during execution of Gerrit operation", (Throwable)e), 3);
        }
        catch (InterruptedException interruptedException) {
            return false;
        }
        if (((IStatus)result.get()).getSeverity() == 8) {
            return false;
        }
        if (!((IStatus)result.get()).isOK()) {
            StatusManager.getManager().handle((IStatus)result.get(), 3);
            return false;
        }
        return this.processOperationResult(operation);
    }

    protected boolean processOperationResult(GerritOperation<?> operation) {
        return true;
    }

    protected Control createDialogArea(Composite parent) {
        this.toolkit = new FormToolkit(CommonFormUtil.getSharedColors());
        Control control = super.createDialogArea(parent);
        if (this.needsConfig()) {
            GerritConfigX config = this.getOperationFactory().getClient(this.getTask()).getGerritConfig();
            if (config == null) {
                GerritOperation operation = this.getOperationFactory().createRefreshConfigOperation(this.getTask(), new RefreshConfigRequest());
                this.performOperation(operation);
                config = ((GerritConfiguration)operation.getOperationResult()).getGerritConfig();
            }
            this.doRefresh((GerritConfig)config);
        }
        return control;
    }

    protected RichTextEditor createRichTextEditor(Composite composite, String value) {
        int style = 8390722;
        TaskRepository repository = TasksUi.getRepositoryManager().getRepository(this.task.getConnectorKind(), this.task.getRepositoryUrl());
        AbstractTaskEditorExtension extension = TaskEditorExtensions.getTaskEditorExtension((TaskRepository)repository);
        final RichTextEditor editor = new RichTextEditor(repository, style, null, extension, this.task);
        editor.setText(value);
        editor.setSpellCheckingEnabled(true);
        editor.createControl(composite, this.toolkit);
        IHandlerService handlerService = (IHandlerService)PlatformUI.getWorkbench().getService(IHandlerService.class);
        if (handlerService != null) {
            this.textSupport = new CommonTextSupport(handlerService);
            this.textSupport.install((TextViewer)editor.getViewer(), true);
        }
        editor.getViewer().getTextWidget().addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent e) {
            }

            public void focusLost(FocusEvent e) {
                editor.getViewer().getTextWidget().setSelection(0);
            }
        });
        return editor;
    }

    protected Text createPersonTextEditor(Composite composite, String value) {
        int style = 8390722;
        Text editor = new Text(composite, style);
        if (value != null) {
            editor.setText(value);
        }
        TaskRepository repository = TasksUi.getRepositoryManager().getRepository(this.task.getConnectorKind(), this.task.getRepositoryUrl());
        ITasksUiFactory uiFactory = TasksUi.getUiFactory();
        IContentProposalProvider proposalProvider = uiFactory.createPersonContentProposalProvider(repository);
        ILabelProvider proposalLabelProvider = uiFactory.createPersonContentProposalLabelProvider(repository);
        ContentAssistCommandAdapter adapter = new ContentAssistCommandAdapter((Control)editor, (IControlContentAdapter)new TextContentAdapter(), proposalProvider, "org.eclipse.ui.edit.text.contentAssist.proposals", new char[0], true);
        adapter.setLabelProvider(proposalLabelProvider);
        adapter.setProposalAcceptanceStyle(2);
        return editor;
    }

    protected void doRefresh(GerritConfig config) {
    }

    public int open(TaskEditor editor) {
        int open = this.open();
        if (open == 0 && editor != null) {
            SynchronizeEditorAction action = new SynchronizeEditorAction();
            action.selectionChanged((IStructuredSelection)new StructuredSelection((Object)editor));
            action.run();
        }
        return open;
    }
}

