/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.tasks.ui.wizards;

import java.lang.reflect.InvocationTargetException;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.httpclient.URI;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.preference.PreferenceDialog;
import org.eclipse.jface.preference.StringFieldEditor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.mylyn.commons.core.StatusHandler;
import org.eclipse.mylyn.commons.net.AuthenticationCredentials;
import org.eclipse.mylyn.commons.net.AuthenticationType;
import org.eclipse.mylyn.commons.ui.CommonImages;
import org.eclipse.mylyn.commons.ui.dialogs.IValidatable;
import org.eclipse.mylyn.commons.ui.dialogs.ValidatableWizardDialog;
import org.eclipse.mylyn.commons.workbench.browser.BrowserUtil;
import org.eclipse.mylyn.commons.workbench.forms.SectionComposite;
import org.eclipse.mylyn.internal.tasks.core.RepositoryTemplateManager;
import org.eclipse.mylyn.internal.tasks.core.TaskRepositoryManager;
import org.eclipse.mylyn.internal.tasks.ui.TasksUiPlugin;
import org.eclipse.mylyn.internal.tasks.ui.wizards.Messages;
import org.eclipse.mylyn.tasks.core.AbstractRepositoryConnector;
import org.eclipse.mylyn.tasks.core.RepositoryInfo;
import org.eclipse.mylyn.tasks.core.RepositoryTemplate;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.ui.TasksUi;
import org.eclipse.mylyn.tasks.ui.wizards.AbstractTaskRepositoryPage;
import org.eclipse.mylyn.tasks.ui.wizards.ITaskRepositoryPage;
import org.eclipse.mylyn.tasks.ui.wizards.TaskRepositoryWizardDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.dialogs.PreferencesUtil;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.ExpandableComposite;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Hyperlink;
import org.eclipse.ui.statushandlers.StatusManager;

public abstract class AbstractRepositorySettingsPage
extends AbstractTaskRepositoryPage
implements ITaskRepositoryPage,
IAdaptable {
    protected static final String PREFS_PAGE_ID_NET_PROXY = "org.eclipse.ui.net.NetPreferences";
    protected static final String LABEL_REPOSITORY_LABEL = Messages.AbstractRepositorySettingsPage_Label_;
    protected static final String LABEL_SERVER = Messages.AbstractRepositorySettingsPage_Server_;
    protected static final String LABEL_USER = Messages.AbstractRepositorySettingsPage_User_ID_;
    protected static final String LABEL_PASSWORD = Messages.AbstractRepositorySettingsPage_Password_;
    protected static final String URL_PREFIX_HTTPS = "https://";
    protected static final String URL_PREFIX_HTTP = "http://";
    protected static final String INVALID_REPOSITORY_URL = Messages.AbstractRepositorySettingsPage_Repository_url_is_invalid;
    protected static final String INVALID_LOGIN = Messages.AbstractRepositorySettingsPage_Unable_to_authenticate_with_repository;
    protected AbstractRepositoryConnector connector;
    protected StringFieldEditor repositoryLabelEditor;
    protected Combo serverUrlCombo;
    private String serverVersion = "unknown";
    protected StringFieldEditor repositoryUserNameEditor;
    protected StringFieldEditor repositoryPasswordEditor;
    protected StringFieldEditor httpAuthUserNameEditor;
    protected StringFieldEditor httpAuthPasswordEditor;
    private StringFieldEditor certAuthFileNameEditor;
    private Button certBrowseButton;
    private StringFieldEditor certAuthPasswordEditor;
    protected StringFieldEditor proxyHostnameEditor;
    protected StringFieldEditor proxyPortEditor;
    protected StringFieldEditor proxyUserNameEditor;
    protected StringFieldEditor proxyPasswordEditor;
    protected TaskRepository repository;
    private Combo otherEncodingCombo;
    private Button defaultEncoding;
    protected Button anonymousButton;
    private String oldUsername;
    private String oldPassword;
    private String oldHttpAuthUserId;
    private String oldHttpAuthPassword;
    private String oldCertAuthFileName;
    private String oldCertAuthPassword;
    private boolean needsAnonymousLogin;
    private boolean needsTimeZone;
    private boolean needsEncoding;
    private boolean needsCertAuth;
    private boolean needsHttpAuth;
    private boolean needsValidation;
    private boolean needsValidateOnFinish;
    private boolean needsAdvanced;
    private boolean needsRepositoryCredentials;
    protected Composite compositeContainer;
    private Composite advancedComp;
    private Composite certAuthComp;
    private Composite httpAuthComp;
    private Composite proxyAuthComp;
    private Set<String> repositoryUrls;
    private String originalUrl;
    private Button otherEncoding;
    private Button certAuthButton;
    private Button httpAuthButton;
    private boolean needsProxy;
    protected Button systemProxyButton;
    protected Hyperlink changeProxySettingsLink;
    private String oldProxyUsername = "";
    private String oldProxyPassword = "";
    private String oldProxyHostname = "";
    private String oldProxyPort = "";
    private Button proxyAuthButton;
    private Hyperlink createAccountHyperlink;
    private Hyperlink manageAccountHyperlink;
    protected Button savePasswordButton;
    private Button saveHttpPasswordButton;
    private Button saveCertPasswordButton;
    private Button saveProxyPasswordButton;
    private Button disconnectedButton;
    private Button validateOnFinishButton;
    private boolean isValid;
    protected SectionComposite innerComposite;
    private TaskRepository validatedTaskRepository;
    private final Map<AuthenticationType, AuthenticationCredentials> validatedAuthenticationCredentials = new HashMap<AuthenticationType, AuthenticationCredentials>();

    public AbstractRepositorySettingsPage(String title, String description, TaskRepository taskRepository, AbstractRepositoryConnector connector) {
        super(title, description, taskRepository);
        this.repository = taskRepository;
        if (connector == null) {
            connector = TasksUi.getRepositoryManager().getRepositoryConnector(this.getConnectorKind());
        }
        this.connector = connector;
        if (this.repository != null && !this.repository.getConnectorKind().equals(this.getConnectorKind())) {
            throw new IllegalArgumentException("connectorKind of repository does not match connectorKind of page, expected '" + this.getConnectorKind() + "', got '" + this.repository.getConnectorKind() + "'");
        }
        this.setNeedsRepositoryCredentials(true);
        this.setNeedsAnonymousLogin(false);
        this.setNeedsEncoding(true);
        this.setNeedsTimeZone(true);
        this.setNeedsProxy(true);
        this.setNeedsValidation(true);
        this.setNeedsAdvanced(true);
        this.setNeedsValidateOnFinish(false);
    }

    public AbstractRepositorySettingsPage(String title, String description, TaskRepository taskRepository) {
        this(title, description, taskRepository, null);
    }

    @Override
    public abstract String getConnectorKind();

    @Override
    public void dispose() {
        super.dispose();
    }

    @Override
    public void createControl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        this.toolkit = new FormToolkit(TasksUiPlugin.getDefault().getFormColors(parent.getDisplay()));
        this.innerComposite = new SectionComposite(parent, 768);
        this.createSettingControls(this.innerComposite.getContent());
        this.createValidationControls(this.innerComposite.getContent());
        if (this.needsValidateOnFinish()) {
            this.validateOnFinishButton = new Button(this.innerComposite.getContent(), 32);
            this.validateOnFinishButton.setText(Messages.AbstractRepositorySettingsPage_Validate_on_Finish);
            this.validateOnFinishButton.setSelection(true);
        }
        Point p = this.innerComposite.getContent().computeSize(-1, -1, true);
        this.innerComposite.setMinSize(p);
        if (this.needsRepositoryCredentials()) {
            this.swapUserNameWithAnonymousInTabList();
        }
        Dialog.applyDialogFont((Control)this.innerComposite);
        this.setControl((Control)this.innerComposite);
    }

    private void swapUserNameWithAnonymousInTabList() {
        List<Control> tabList;
        if (this.compositeContainer != null && this.anonymousButton != null && this.repositoryUserNameEditor != null && (tabList = Arrays.asList(this.compositeContainer.getTabList())).contains(this.repositoryUserNameEditor.getTextControl(this.compositeContainer)) && tabList.contains(this.anonymousButton)) {
            int userNameIndex = tabList.indexOf(this.repositoryUserNameEditor.getTextControl(this.compositeContainer));
            int anonymousIndex = tabList.indexOf(this.anonymousButton);
            Collections.swap(tabList, userNameIndex, anonymousIndex);
            this.compositeContainer.setTabList(tabList.toArray(new Control[tabList.size()]));
        }
    }

    protected void createValidationControls(Composite parent) {
        if (!this.needsValidation() || this.getContainer() instanceof ValidatableWizardDialog || this.getContainer() instanceof TaskRepositoryWizardDialog) {
            return;
        }
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout(1, false);
        layout.marginHeight = 10;
        layout.marginWidth = 0;
        layout.horizontalSpacing = 10;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(16384, 128, false, false, 3, 1));
        Button validateButton = new Button(composite, 8);
        validateButton.setImage(CommonImages.getImage((ImageDescriptor)CommonImages.VALIDATE));
        validateButton.setText(Messages.AbstractRepositorySettingsPage_Validate_Settings_Button_Label);
        validateButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AbstractRepositorySettingsPage.this.validateSettings();
            }
        });
    }

    @Override
    protected void createSettingControls(Composite parent) {
        this.compositeContainer = parent;
        this.initializeOldValues();
        Label serverLabel = new Label(this.compositeContainer, 0);
        serverLabel.setText(LABEL_SERVER);
        this.serverUrlCombo = new Combo(this.compositeContainer, 4);
        this.serverUrlCombo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (AbstractRepositorySettingsPage.this.getWizard() != null) {
                    AbstractRepositorySettingsPage.this.getWizard().getContainer().updateButtons();
                }
            }
        });
        this.serverUrlCombo.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusLost(FocusEvent e) {
                AbstractRepositorySettingsPage.this.updateHyperlinks();
            }
        });
        this.serverUrlCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (AbstractRepositorySettingsPage.this.getWizard() != null) {
                    AbstractRepositorySettingsPage.this.getWizard().getContainer().updateButtons();
                }
            }
        });
        GridDataFactory.fillDefaults().hint(300, -1).grab(true, false).span(2, -1).applyTo((Control)this.serverUrlCombo);
        this.repositoryLabelEditor = new StringFieldEditor("", LABEL_REPOSITORY_LABEL, StringFieldEditor.UNLIMITED, this.compositeContainer){

            protected boolean doCheckState() {
                return true;
            }

            protected void valueChanged() {
                super.valueChanged();
                if (AbstractRepositorySettingsPage.this.getWizard() != null) {
                    AbstractRepositorySettingsPage.this.getWizard().getContainer().updateButtons();
                }
            }

            public int getNumberOfControls() {
                return 2;
            }
        };
        this.disconnectedButton = new Button(this.compositeContainer, 32);
        this.disconnectedButton.setText(Messages.AbstractRepositorySettingsPage_Disconnected);
        this.disconnectedButton.setSelection(this.repository != null ? this.repository.isOffline() : false);
        this.disconnectedButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                super.widgetSelected(e);
                AbstractRepositorySettingsPage.this.isPageComplete();
                if (AbstractRepositorySettingsPage.this.getWizard() != null) {
                    AbstractRepositorySettingsPage.this.getWizard().getContainer().updateButtons();
                }
            }
        });
        if (this.needsRepositoryCredentials()) {
            this.createRepositoryCredentialsSection();
        }
        if (this.needsAdvanced() || this.needsEncoding()) {
            this.createAdvancedSection();
        }
        if (this.needsCertAuth()) {
            this.createCertAuthSection();
        }
        if (this.needsHttpAuth()) {
            this.createHttpAuthSection();
        }
        if (this.needsProxy()) {
            this.createProxySection();
        }
        this.createContributionControls((Composite)this.innerComposite);
        Composite managementComposite = new Composite(this.compositeContainer, 0);
        GridLayout managementLayout = new GridLayout(4, false);
        managementLayout.marginHeight = 0;
        managementLayout.marginWidth = 0;
        managementLayout.horizontalSpacing = 10;
        managementComposite.setLayout((Layout)managementLayout);
        managementComposite.setLayoutData((Object)new GridData(16384, 128, false, false, 2, 1));
        this.createAccountHyperlink = this.toolkit.createHyperlink(managementComposite, Messages.AbstractRepositorySettingsPage_Create_new_account, 0);
        this.createAccountHyperlink.setBackground(managementComposite.getBackground());
        this.createAccountHyperlink.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                String accountCreationUrl;
                TaskRepository repository = AbstractRepositorySettingsPage.this.createTaskRepository();
                if (repository != null && (accountCreationUrl = TasksUiPlugin.getConnectorUi(AbstractRepositorySettingsPage.this.connector.getConnectorKind()).getAccountCreationUrl(repository)) != null) {
                    BrowserUtil.openUrl((String)accountCreationUrl, (int)128);
                }
            }
        });
        this.manageAccountHyperlink = this.toolkit.createHyperlink(managementComposite, Messages.AbstractRepositorySettingsPage_Change_account_settings, 0);
        this.manageAccountHyperlink.setBackground(managementComposite.getBackground());
        this.manageAccountHyperlink.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                String accountManagementUrl;
                TaskRepository repository = AbstractRepositorySettingsPage.this.getRepository();
                if (repository == null && AbstractRepositorySettingsPage.this.getRepositoryUrl() != null && AbstractRepositorySettingsPage.this.getRepositoryUrl().length() > 0) {
                    repository = AbstractRepositorySettingsPage.this.createTaskRepository();
                }
                if (repository != null && (accountManagementUrl = TasksUiPlugin.getConnectorUi(AbstractRepositorySettingsPage.this.connector.getConnectorKind()).getAccountManagementUrl(repository)) != null) {
                    BrowserUtil.openUrl((String)accountManagementUrl, (int)128);
                }
            }
        });
        if (this.needsRepositoryCredentials()) {
            ((RepositoryStringFieldEditor)this.repositoryPasswordEditor).getTextControl().setEchoChar('*');
            if (this.needsAnonymousLogin() && this.repository != null) {
                this.setAnonymous(this.isAnonymousAccess());
            }
        }
        this.updateHyperlinks();
        if (this.repository != null) {
            this.saveToValidatedProperties(this.createTaskRepository());
        }
        GridLayout layout = new GridLayout(3, false);
        this.compositeContainer.setLayout((Layout)layout);
    }

    private void createRepositoryCredentialsSection() {
        this.repositoryUserNameEditor = new StringFieldEditor("", LABEL_USER, StringFieldEditor.UNLIMITED, this.compositeContainer){

            protected boolean doCheckState() {
                return true;
            }

            protected void valueChanged() {
                super.valueChanged();
                AbstractRepositorySettingsPage.this.isPageComplete();
                if (AbstractRepositorySettingsPage.this.getWizard() != null) {
                    AbstractRepositorySettingsPage.this.getWizard().getContainer().updateButtons();
                }
            }

            public int getNumberOfControls() {
                return 2;
            }
        };
        if (this.needsAnonymousLogin()) {
            this.anonymousButton = new Button(this.compositeContainer, 32);
            this.anonymousButton.setText(Messages.AbstractRepositorySettingsPage_Anonymous_Access);
            this.anonymousButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    AbstractRepositorySettingsPage.this.setAnonymous(AbstractRepositorySettingsPage.this.anonymousButton.getSelection());
                    AbstractRepositorySettingsPage.this.isPageComplete();
                }
            });
        } else {
            Label dummyLabel = new Label(this.compositeContainer, 0);
            GridDataFactory.fillDefaults().applyTo((Control)dummyLabel);
        }
        this.repositoryPasswordEditor = new RepositoryStringFieldEditor("", LABEL_PASSWORD, StringFieldEditor.UNLIMITED, this.compositeContainer){

            protected boolean doCheckState() {
                return true;
            }

            protected void valueChanged() {
                super.valueChanged();
                AbstractRepositorySettingsPage.this.isPageComplete();
                if (AbstractRepositorySettingsPage.this.getWizard() != null) {
                    AbstractRepositorySettingsPage.this.getWizard().getContainer().updateButtons();
                }
            }

            public int getNumberOfControls() {
                return 2;
            }
        };
        this.savePasswordButton = new Button(this.compositeContainer, 32);
        this.savePasswordButton.setText(Messages.AbstractRepositorySettingsPage_Save_Password);
        this.savePasswordButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                super.widgetSelected(e);
                AbstractRepositorySettingsPage.this.isPageComplete();
                if (AbstractRepositorySettingsPage.this.getWizard() != null) {
                    AbstractRepositorySettingsPage.this.getWizard().getContainer().updateButtons();
                }
            }
        });
        if (this.repository != null) {
            try {
                String repositoryLabel = this.repository.getProperty("label");
                if (repositoryLabel != null && repositoryLabel.length() > 0) {
                    this.repositoryLabelEditor.setStringValue(repositoryLabel);
                }
                this.serverUrlCombo.setText(this.repository.getRepositoryUrl());
                AuthenticationCredentials credentials = this.repository.getCredentials(AuthenticationType.REPOSITORY);
                if (credentials != null) {
                    this.repositoryUserNameEditor.setStringValue(credentials.getUserName());
                    this.repositoryPasswordEditor.setStringValue(credentials.getPassword());
                } else {
                    this.repositoryUserNameEditor.setStringValue("");
                    this.repositoryPasswordEditor.setStringValue("");
                }
            }
            catch (Throwable t) {
                StatusHandler.log((IStatus)new Status(4, "org.eclipse.mylyn.tasks.ui", "Could not set field value", t));
            }
        }
        if (this.needsAnonymousLogin()) {
            if (this.repository != null) {
                this.setAnonymous(this.repository.getCredentials(AuthenticationType.REPOSITORY) == null);
            } else {
                this.setAnonymous(true);
            }
        }
        if (this.repository != null) {
            this.savePasswordButton.setSelection(this.repository.getSavePassword(AuthenticationType.REPOSITORY));
        } else {
            this.savePasswordButton.setSelection(false);
        }
    }

    private void createAdvancedSection() {
        ExpandableComposite section = this.createSection((Composite)this.innerComposite, Messages.AbstractRepositorySettingsPage_Additional_Settings);
        this.advancedComp = this.toolkit.createComposite((Composite)section, 0);
        GridLayout gridLayout2 = new GridLayout();
        gridLayout2.numColumns = 2;
        gridLayout2.verticalSpacing = 5;
        gridLayout2.marginWidth = 0;
        this.advancedComp.setLayout((Layout)gridLayout2);
        this.advancedComp.setBackground(this.compositeContainer.getBackground());
        section.setClient((Control)this.advancedComp);
        this.createAdditionalControls(this.advancedComp);
        if (this.needsEncoding()) {
            Label encodingLabel = new Label(this.advancedComp, 256);
            encodingLabel.setText(Messages.AbstractRepositorySettingsPage_Character_encoding);
            GridDataFactory.fillDefaults().align(1, 128).applyTo((Control)encodingLabel);
            Composite encodingContainer = new Composite(this.advancedComp, 0);
            GridLayout gridLayout = new GridLayout(2, false);
            gridLayout.marginWidth = 0;
            gridLayout.marginHeight = 0;
            encodingContainer.setLayout((Layout)gridLayout);
            this.defaultEncoding = new Button(encodingContainer, 16);
            this.defaultEncoding.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 2, 1));
            this.defaultEncoding.setText(String.valueOf(Messages.AbstractRepositorySettingsPage_Default__) + "UTF-8" + ")");
            this.defaultEncoding.setSelection(true);
            this.otherEncoding = new Button(encodingContainer, 16);
            this.otherEncoding.setText(Messages.AbstractRepositorySettingsPage_Other);
            this.otherEncodingCombo = new Combo(encodingContainer, 8);
            try {
                for (String encoding : Charset.availableCharsets().keySet()) {
                    if (encoding.equals("UTF-8")) continue;
                    this.otherEncodingCombo.add(encoding);
                }
            }
            catch (LinkageError e) {
                StatusHandler.log((IStatus)new Status(4, "org.eclipse.mylyn.tasks.ui", Messages.AbstractRepositorySettingsPage_Problems_encountered_determining_available_charsets, (Throwable)e));
                this.otherEncoding.setEnabled(false);
                this.otherEncodingCombo.setEnabled(false);
            }
            this.setDefaultEncoding();
            this.otherEncoding.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    if (AbstractRepositorySettingsPage.this.otherEncoding.getSelection()) {
                        AbstractRepositorySettingsPage.this.defaultEncoding.setSelection(false);
                        AbstractRepositorySettingsPage.this.otherEncodingCombo.setEnabled(true);
                    } else {
                        AbstractRepositorySettingsPage.this.defaultEncoding.setSelection(true);
                        AbstractRepositorySettingsPage.this.otherEncodingCombo.setEnabled(false);
                    }
                }
            });
            if (this.repository != null) {
                try {
                    String repositoryEncoding = this.repository.getCharacterEncoding();
                    if (repositoryEncoding != null) {
                        if (this.otherEncodingCombo.getItemCount() > 0 && this.otherEncodingCombo.indexOf(repositoryEncoding) > -1) {
                            this.otherEncodingCombo.setEnabled(true);
                            this.otherEncoding.setSelection(true);
                            this.defaultEncoding.setSelection(false);
                            this.otherEncodingCombo.select(this.otherEncodingCombo.indexOf(repositoryEncoding));
                        } else {
                            this.setDefaultEncoding();
                        }
                    }
                }
                catch (Throwable t) {
                    StatusHandler.log((IStatus)new Status(4, "org.eclipse.mylyn.tasks.ui", "Could not set field value", t));
                }
            }
        }
    }

    private void createCertAuthSection() {
        ExpandableComposite section = this.createSection((Composite)this.innerComposite, Messages.AbstractRepositorySettingsPage_certificate_settings);
        this.certAuthComp = this.toolkit.createComposite((Composite)section, 0);
        this.certAuthComp.setBackground(this.compositeContainer.getBackground());
        section.setClient((Control)this.certAuthComp);
        this.certAuthButton = new Button(this.certAuthComp, 32);
        GridDataFactory.fillDefaults().indent(0, 5).align(16384, 128).span(3, -1).applyTo((Control)this.certAuthButton);
        this.certAuthButton.setText(Messages.AbstractRepositorySettingsPage_Enable_certificate_authentification);
        this.certAuthButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                AbstractRepositorySettingsPage.this.setCertAuth(AbstractRepositorySettingsPage.this.certAuthButton.getSelection());
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.certAuthFileNameEditor = new StringFieldEditor("", Messages.AbstractRepositorySettingsPage_CertificateFile_, StringFieldEditor.UNLIMITED, this.certAuthComp){

            protected boolean doCheckState() {
                return true;
            }

            protected void valueChanged() {
                super.valueChanged();
                if (AbstractRepositorySettingsPage.this.getWizard() != null) {
                    AbstractRepositorySettingsPage.this.getWizard().getContainer().updateButtons();
                }
            }

            public int getNumberOfControls() {
                return 2;
            }
        };
        this.certBrowseButton = new Button(this.certAuthComp, 8);
        this.certBrowseButton.setText(Messages.AbstractRepositorySettingsPage_ChooseCertificateFile_);
        this.certBrowseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FileDialog fileDialog = new FileDialog(AbstractRepositorySettingsPage.this.getShell(), 4096);
                fileDialog.setFilterPath(System.getProperty("user.home", "."));
                String returnFile = fileDialog.open();
                if (returnFile != null) {
                    AbstractRepositorySettingsPage.this.certAuthFileNameEditor.setStringValue(returnFile);
                }
            }
        });
        this.certAuthPasswordEditor = new RepositoryStringFieldEditor("", Messages.AbstractRepositorySettingsPage_CertificatePassword_, StringFieldEditor.UNLIMITED, this.certAuthComp){

            public int getNumberOfControls() {
                return 2;
            }
        };
        ((RepositoryStringFieldEditor)this.certAuthPasswordEditor).getTextControl().setEchoChar('*');
        this.saveCertPasswordButton = new Button(this.certAuthComp, 32);
        this.saveCertPasswordButton.setText(Messages.AbstractRepositorySettingsPage_Save_Password);
        this.certAuthFileNameEditor.setEnabled(this.certAuthButton.getSelection(), this.certAuthComp);
        this.certBrowseButton.setEnabled(this.certAuthButton.getSelection());
        this.certAuthPasswordEditor.setEnabled(this.certAuthButton.getSelection(), this.certAuthComp);
        this.saveCertPasswordButton.setEnabled(this.certAuthButton.getSelection());
        if (this.repository != null) {
            this.saveCertPasswordButton.setSelection(this.repository.getSavePassword(AuthenticationType.CERTIFICATE));
        } else {
            this.saveCertPasswordButton.setSelection(false);
        }
        this.setCertAuth(this.oldCertAuthPassword != null || this.oldCertAuthFileName != null);
        section.setExpanded(this.certAuthButton.getSelection());
        GridLayout gridLayout2 = new GridLayout();
        gridLayout2.numColumns = 3;
        gridLayout2.marginWidth = 0;
        this.certAuthComp.setLayout((Layout)gridLayout2);
    }

    private void createHttpAuthSection() {
        ExpandableComposite section = this.createSection((Composite)this.innerComposite, Messages.AbstractRepositorySettingsPage_Http_Authentication);
        this.httpAuthComp = this.toolkit.createComposite((Composite)section, 0);
        this.httpAuthComp.setBackground(this.compositeContainer.getBackground());
        section.setClient((Control)this.httpAuthComp);
        this.httpAuthButton = new Button(this.httpAuthComp, 32);
        GridDataFactory.fillDefaults().indent(0, 5).align(16384, 128).span(3, -1).applyTo((Control)this.httpAuthButton);
        this.httpAuthButton.setText(Messages.AbstractRepositorySettingsPage_Enable_http_authentication);
        this.httpAuthButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                AbstractRepositorySettingsPage.this.setHttpAuth(AbstractRepositorySettingsPage.this.httpAuthButton.getSelection());
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.httpAuthUserNameEditor = new StringFieldEditor("", Messages.AbstractRepositorySettingsPage_User_ID_, StringFieldEditor.UNLIMITED, this.httpAuthComp){

            protected boolean doCheckState() {
                return true;
            }

            protected void valueChanged() {
                super.valueChanged();
                if (AbstractRepositorySettingsPage.this.getWizard() != null) {
                    AbstractRepositorySettingsPage.this.getWizard().getContainer().updateButtons();
                }
            }

            public int getNumberOfControls() {
                return 3;
            }
        };
        this.httpAuthPasswordEditor = new RepositoryStringFieldEditor("", Messages.AbstractRepositorySettingsPage_Password_, StringFieldEditor.UNLIMITED, this.httpAuthComp){

            public int getNumberOfControls() {
                return 2;
            }
        };
        ((RepositoryStringFieldEditor)this.httpAuthPasswordEditor).getTextControl().setEchoChar('*');
        this.saveHttpPasswordButton = new Button(this.httpAuthComp, 32);
        this.saveHttpPasswordButton.setText(Messages.AbstractRepositorySettingsPage_Save_Password);
        this.httpAuthUserNameEditor.setEnabled(this.httpAuthButton.getSelection(), this.httpAuthComp);
        this.httpAuthPasswordEditor.setEnabled(this.httpAuthButton.getSelection(), this.httpAuthComp);
        this.saveHttpPasswordButton.setEnabled(this.httpAuthButton.getSelection());
        if (this.repository != null) {
            this.saveHttpPasswordButton.setSelection(this.repository.getSavePassword(AuthenticationType.HTTP));
        } else {
            this.saveHttpPasswordButton.setSelection(false);
        }
        this.setHttpAuth(this.oldHttpAuthPassword != null || this.oldHttpAuthUserId != null);
        section.setExpanded(this.httpAuthButton.getSelection());
        GridLayout gridLayout2 = new GridLayout();
        gridLayout2.numColumns = 3;
        gridLayout2.marginWidth = 0;
        this.httpAuthComp.setLayout((Layout)gridLayout2);
    }

    private void initializeOldValues() {
        if (this.repository != null) {
            AuthenticationCredentials oldProxyCredentials;
            this.originalUrl = this.repository.getRepositoryUrl();
            AuthenticationCredentials oldCredentials = this.repository.getCredentials(AuthenticationType.REPOSITORY);
            if (oldCredentials != null) {
                this.oldUsername = oldCredentials.getUserName();
                this.oldPassword = oldCredentials.getPassword();
            } else {
                this.oldUsername = "";
                this.oldPassword = "";
            }
            AuthenticationCredentials oldCertCredentials = this.repository.getCredentials(AuthenticationType.CERTIFICATE);
            if (oldCertCredentials != null) {
                this.oldCertAuthFileName = oldCertCredentials.getUserName();
                this.oldCertAuthPassword = oldCertCredentials.getPassword();
            } else {
                this.oldCertAuthPassword = null;
                this.oldCertAuthFileName = null;
            }
            AuthenticationCredentials oldHttpCredentials = this.repository.getCredentials(AuthenticationType.HTTP);
            if (oldHttpCredentials != null) {
                this.oldHttpAuthUserId = oldHttpCredentials.getUserName();
                this.oldHttpAuthPassword = oldHttpCredentials.getPassword();
            } else {
                this.oldHttpAuthPassword = null;
                this.oldHttpAuthUserId = null;
            }
            this.oldProxyHostname = this.repository.getProperty("org.eclipse.mylyn.tasklist.repositories.proxy.hostname");
            this.oldProxyPort = this.repository.getProperty("org.eclipse.mylyn.tasklist.repositories.proxy.port");
            if (this.oldProxyHostname == null) {
                this.oldProxyHostname = "";
            }
            if (this.oldProxyPort == null) {
                this.oldProxyPort = "";
            }
            if ((oldProxyCredentials = this.repository.getCredentials(AuthenticationType.PROXY)) != null) {
                this.oldProxyUsername = oldProxyCredentials.getUserName();
                this.oldProxyPassword = oldProxyCredentials.getPassword();
            } else {
                this.oldProxyUsername = null;
                this.oldProxyPassword = null;
            }
        } else {
            this.oldUsername = "";
            this.oldPassword = "";
            this.oldHttpAuthPassword = null;
            this.oldHttpAuthUserId = null;
            this.oldCertAuthFileName = null;
            this.oldCertAuthPassword = null;
        }
    }

    private void createProxySection() {
        ExpandableComposite section = this.createSection((Composite)this.innerComposite, Messages.AbstractRepositorySettingsPage_Proxy_Server_Configuration);
        this.proxyAuthComp = this.toolkit.createComposite((Composite)section, 0);
        GridLayout gridLayout2 = new GridLayout();
        gridLayout2.verticalSpacing = 0;
        gridLayout2.numColumns = 3;
        this.proxyAuthComp.setLayout((Layout)gridLayout2);
        this.proxyAuthComp.setBackground(this.compositeContainer.getBackground());
        section.setClient((Control)this.proxyAuthComp);
        Composite systemSettingsComposite = new Composite(this.proxyAuthComp, 0);
        GridLayout gridLayout3 = new GridLayout();
        gridLayout3.verticalSpacing = 0;
        gridLayout3.numColumns = 2;
        gridLayout3.marginWidth = 0;
        systemSettingsComposite.setLayout((Layout)gridLayout3);
        this.systemProxyButton = new Button(systemSettingsComposite, 32);
        GridDataFactory.fillDefaults().align(16384, 128).span(3, -1).applyTo((Control)systemSettingsComposite);
        this.systemProxyButton.setText(Messages.AbstractRepositorySettingsPage_Use_global_Network_Connections_preferences);
        this.systemProxyButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                AbstractRepositorySettingsPage.this.setUseDefaultProxy(AbstractRepositorySettingsPage.this.systemProxyButton.getSelection());
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.changeProxySettingsLink = this.toolkit.createHyperlink(systemSettingsComposite, Messages.AbstractRepositorySettingsPage_Change_Settings, 0);
        this.changeProxySettingsLink.setBackground(this.compositeContainer.getBackground());
        this.changeProxySettingsLink.addHyperlinkListener(new IHyperlinkListener(){

            public void linkActivated(HyperlinkEvent e) {
                PreferenceDialog dlg = PreferencesUtil.createPreferenceDialogOn((Shell)AbstractRepositorySettingsPage.this.getShell(), (String)AbstractRepositorySettingsPage.PREFS_PAGE_ID_NET_PROXY, (String[])new String[]{AbstractRepositorySettingsPage.PREFS_PAGE_ID_NET_PROXY}, null);
                dlg.open();
            }

            public void linkEntered(HyperlinkEvent e) {
            }

            public void linkExited(HyperlinkEvent e) {
            }
        });
        this.proxyHostnameEditor = new StringFieldEditor("", Messages.AbstractRepositorySettingsPage_Proxy_host_address_, StringFieldEditor.UNLIMITED, this.proxyAuthComp){

            protected boolean doCheckState() {
                return true;
            }

            protected void valueChanged() {
                super.valueChanged();
                if (AbstractRepositorySettingsPage.this.getWizard() != null) {
                    AbstractRepositorySettingsPage.this.getWizard().getContainer().updateButtons();
                }
            }

            public int getNumberOfControls() {
                return 3;
            }
        };
        this.proxyHostnameEditor.setStringValue(this.oldProxyHostname);
        this.proxyPortEditor = new RepositoryStringFieldEditor("", Messages.AbstractRepositorySettingsPage_Proxy_host_port_, StringFieldEditor.UNLIMITED, this.proxyAuthComp){

            protected boolean doCheckState() {
                return true;
            }

            protected void valueChanged() {
                super.valueChanged();
                if (AbstractRepositorySettingsPage.this.getWizard() != null) {
                    AbstractRepositorySettingsPage.this.getWizard().getContainer().updateButtons();
                }
            }

            public int getNumberOfControls() {
                return 3;
            }
        };
        this.proxyPortEditor.setStringValue(this.oldProxyPort);
        this.proxyHostnameEditor.setEnabled(this.systemProxyButton.getSelection(), this.proxyAuthComp);
        this.proxyPortEditor.setEnabled(this.systemProxyButton.getSelection(), this.proxyAuthComp);
        this.proxyAuthButton = new Button(this.proxyAuthComp, 32);
        GridDataFactory.fillDefaults().span(3, -1).applyTo((Control)this.proxyAuthButton);
        this.proxyAuthButton.setText(Messages.AbstractRepositorySettingsPage_Enable_proxy_authentication);
        this.proxyAuthButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                AbstractRepositorySettingsPage.this.setProxyAuth(AbstractRepositorySettingsPage.this.proxyAuthButton.getSelection());
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.proxyUserNameEditor = new StringFieldEditor("", Messages.AbstractRepositorySettingsPage_User_ID_, StringFieldEditor.UNLIMITED, this.proxyAuthComp){

            protected boolean doCheckState() {
                return true;
            }

            protected void valueChanged() {
                super.valueChanged();
                if (AbstractRepositorySettingsPage.this.getWizard() != null) {
                    AbstractRepositorySettingsPage.this.getWizard().getContainer().updateButtons();
                }
            }

            public int getNumberOfControls() {
                return 3;
            }
        };
        this.proxyPasswordEditor = new RepositoryStringFieldEditor("", Messages.AbstractRepositorySettingsPage_Password_, StringFieldEditor.UNLIMITED, this.proxyAuthComp){

            public int getNumberOfControls() {
                return 2;
            }
        };
        ((RepositoryStringFieldEditor)this.proxyPasswordEditor).getTextControl().setEchoChar('*');
        ++((GridLayout)this.proxyAuthComp.getLayout()).numColumns;
        this.saveProxyPasswordButton = new Button(this.proxyAuthComp, 32);
        this.saveProxyPasswordButton.setText(Messages.AbstractRepositorySettingsPage_Save_Password);
        this.saveProxyPasswordButton.setEnabled(this.proxyAuthButton.getSelection());
        if (this.repository != null) {
            this.saveProxyPasswordButton.setSelection(this.repository.getSavePassword(AuthenticationType.PROXY));
        } else {
            this.saveProxyPasswordButton.setSelection(false);
        }
        this.setProxyAuth(this.oldProxyUsername != null || this.oldProxyPassword != null);
        this.setUseDefaultProxy(this.repository != null ? this.repository.isDefaultProxyEnabled() : true);
        section.setExpanded(!this.systemProxyButton.getSelection());
    }

    protected void setEncoding(String encoding) {
        if (encoding.equals("UTF-8")) {
            this.setDefaultEncoding();
        } else if (this.otherEncodingCombo.indexOf(encoding) != -1) {
            this.defaultEncoding.setSelection(false);
            this.otherEncodingCombo.setEnabled(true);
            this.otherEncoding.setSelection(true);
            this.otherEncodingCombo.select(this.otherEncodingCombo.indexOf(encoding));
        } else {
            this.setDefaultEncoding();
        }
    }

    private void setDefaultEncoding() {
        this.defaultEncoding.setSelection(true);
        this.otherEncoding.setSelection(false);
        this.otherEncodingCombo.setEnabled(false);
        if (this.otherEncodingCombo.getItemCount() > 0) {
            this.otherEncodingCombo.select(0);
        }
    }

    public void setAnonymous(boolean selected) {
        if (!this.needsAnonymousLogin) {
            return;
        }
        this.anonymousButton.setSelection(selected);
        if (selected) {
            this.oldUsername = this.repositoryUserNameEditor.getStringValue();
            this.oldPassword = this.repositoryPasswordEditor.getStringValue();
            this.repositoryUserNameEditor.setStringValue("");
            this.repositoryPasswordEditor.setStringValue("");
        } else {
            this.repositoryUserNameEditor.setStringValue(this.oldUsername);
            this.repositoryPasswordEditor.setStringValue(this.oldPassword);
        }
        this.repositoryUserNameEditor.setEnabled(!selected, this.compositeContainer);
        this.repositoryPasswordEditor.setEnabled(!selected, this.compositeContainer);
        this.savePasswordButton.setEnabled(!selected);
        if (this.getWizard() != null) {
            this.getWizard().getContainer().updateButtons();
        }
    }

    public void setHttpAuth(boolean selected) {
        if (!this.needsHttpAuth) {
            return;
        }
        this.httpAuthButton.setSelection(selected);
        if (!selected) {
            this.oldHttpAuthUserId = this.httpAuthUserNameEditor.getStringValue();
            this.oldHttpAuthPassword = this.httpAuthPasswordEditor.getStringValue();
            this.httpAuthUserNameEditor.setStringValue(null);
            this.httpAuthPasswordEditor.setStringValue(null);
        } else {
            this.httpAuthUserNameEditor.setStringValue(this.oldHttpAuthUserId);
            this.httpAuthPasswordEditor.setStringValue(this.oldHttpAuthPassword);
        }
        this.httpAuthUserNameEditor.setEnabled(selected, this.httpAuthComp);
        this.httpAuthPasswordEditor.setEnabled(selected, this.httpAuthComp);
        this.saveHttpPasswordButton.setEnabled(selected);
    }

    public void setCertAuth(boolean selected) {
        if (!this.needsCertAuth) {
            return;
        }
        this.certAuthButton.setSelection(selected);
        if (!selected) {
            this.oldCertAuthFileName = this.certAuthFileNameEditor.getStringValue();
            this.oldCertAuthPassword = this.certAuthPasswordEditor.getStringValue();
            this.certAuthFileNameEditor.setStringValue(null);
            this.certAuthPasswordEditor.setStringValue(null);
        } else {
            this.certAuthFileNameEditor.setStringValue(this.oldCertAuthFileName);
            this.certAuthPasswordEditor.setStringValue(this.oldCertAuthPassword);
        }
        this.certAuthFileNameEditor.setEnabled(selected, this.certAuthComp);
        this.certBrowseButton.setEnabled(selected);
        this.certAuthPasswordEditor.setEnabled(selected, this.certAuthComp);
        this.saveCertPasswordButton.setEnabled(selected);
    }

    public boolean getHttpAuth() {
        return this.httpAuthButton.getSelection();
    }

    public boolean getCertAuth() {
        return this.certAuthButton.getSelection();
    }

    public void setUseDefaultProxy(boolean selected) {
        if (!this.needsProxy) {
            return;
        }
        this.systemProxyButton.setSelection(selected);
        if (selected) {
            this.oldProxyHostname = this.proxyHostnameEditor.getStringValue();
            this.oldProxyPort = this.proxyPortEditor.getStringValue();
        } else {
            this.proxyHostnameEditor.setStringValue(this.oldProxyHostname);
            this.proxyPortEditor.setStringValue(this.oldProxyPort);
        }
        this.proxyHostnameEditor.setEnabled(!selected, this.proxyAuthComp);
        this.proxyPortEditor.setEnabled(!selected, this.proxyAuthComp);
        this.proxyAuthButton.setEnabled(!selected);
        this.setProxyAuth(this.proxyAuthButton.getSelection());
    }

    public void setProxyAuth(boolean selected) {
        this.proxyAuthButton.setSelection(selected);
        this.proxyAuthButton.setEnabled(!this.systemProxyButton.getSelection());
        if (!selected) {
            this.oldProxyUsername = this.proxyUserNameEditor.getStringValue();
            this.oldProxyPassword = this.proxyPasswordEditor.getStringValue();
            this.proxyUserNameEditor.setStringValue(null);
            this.proxyPasswordEditor.setStringValue(null);
        } else {
            this.proxyUserNameEditor.setStringValue(this.oldProxyUsername);
            this.proxyPasswordEditor.setStringValue(this.oldProxyPassword);
        }
        this.proxyUserNameEditor.setEnabled(selected && !this.systemProxyButton.getSelection(), this.proxyAuthComp);
        this.proxyPasswordEditor.setEnabled(selected && !this.systemProxyButton.getSelection(), this.proxyAuthComp);
        this.saveProxyPasswordButton.setEnabled(selected && !this.systemProxyButton.getSelection());
    }

    public boolean getProxyAuth() {
        return this.proxyAuthButton.getSelection();
    }

    protected void addRepositoryTemplatesToServerUrlCombo() {
        final RepositoryTemplateManager templateManager = TasksUiPlugin.getRepositoryTemplateManager();
        for (RepositoryTemplate template : templateManager.getTemplates(this.connector.getConnectorKind())) {
            this.serverUrlCombo.add(template.label);
        }
        this.serverUrlCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String text = AbstractRepositorySettingsPage.this.serverUrlCombo.getText();
                RepositoryTemplate template = templateManager.getTemplate(AbstractRepositorySettingsPage.this.connector.getConnectorKind(), text);
                if (template != null) {
                    AbstractRepositorySettingsPage.this.repositoryTemplateSelected(template);
                    return;
                }
            }
        });
    }

    protected void repositoryTemplateSelected(RepositoryTemplate template) {
    }

    protected abstract void createAdditionalControls(@NonNull Composite var1);

    protected boolean isValidUrl(String url) {
        if (url.startsWith(URL_PREFIX_HTTPS) || url.startsWith(URL_PREFIX_HTTP)) {
            try {
                new URI(url, true, "UTF-8");
                return true;
            }
            catch (Exception exception) {
                return false;
            }
        }
        return false;
    }

    private void updateHyperlinks() {
        if (this.getRepositoryUrl() != null && this.getRepositoryUrl().length() > 0) {
            TaskRepository repository = new TaskRepository(this.connector.getConnectorKind(), this.getRepositoryUrl());
            String accountCreationUrl = TasksUiPlugin.getConnectorUi(this.connector.getConnectorKind()).getAccountCreationUrl(repository);
            this.createAccountHyperlink.setEnabled(accountCreationUrl != null);
            this.createAccountHyperlink.setVisible(accountCreationUrl != null);
            String accountManagementUrl = TasksUiPlugin.getConnectorUi(this.connector.getConnectorKind()).getAccountManagementUrl(repository);
            this.manageAccountHyperlink.setEnabled(accountManagementUrl != null);
            this.manageAccountHyperlink.setVisible(accountManagementUrl != null);
        } else {
            this.createAccountHyperlink.setEnabled(false);
            this.createAccountHyperlink.setVisible(false);
            this.manageAccountHyperlink.setEnabled(false);
            this.manageAccountHyperlink.setVisible(false);
        }
    }

    public String getRepositoryLabel() {
        return this.repositoryLabelEditor.getStringValue();
    }

    @Override
    public String getRepositoryUrl() {
        return TaskRepositoryManager.stripSlashes((String)this.serverUrlCombo.getText());
    }

    public String getUserName() {
        return this.repositoryUserNameEditor.getStringValue();
    }

    public String getPassword() {
        return this.repositoryPasswordEditor.getStringValue();
    }

    public String getHttpAuthUserId() {
        if (this.needsHttpAuth()) {
            return this.httpAuthUserNameEditor.getStringValue();
        }
        return "";
    }

    public String getHttpAuthPassword() {
        if (this.needsHttpAuth()) {
            return this.httpAuthPasswordEditor.getStringValue();
        }
        return "";
    }

    public String getCertAuthFileName() {
        if (this.needsCertAuth()) {
            return this.certAuthFileNameEditor.getStringValue();
        }
        return "";
    }

    public String getCertAuthPassword() {
        if (this.needsCertAuth()) {
            return this.certAuthPasswordEditor.getStringValue();
        }
        return "";
    }

    public String getProxyHostname() {
        if (this.needsProxy()) {
            return this.proxyHostnameEditor.getStringValue();
        }
        return "";
    }

    public String getProxyPort() {
        if (this.needsProxy()) {
            return this.proxyPortEditor.getStringValue();
        }
        return "";
    }

    public Boolean getUseDefaultProxy() {
        if (this.needsProxy()) {
            return this.systemProxyButton.getSelection();
        }
        return true;
    }

    public String getProxyUserName() {
        if (this.needsProxy()) {
            return this.proxyUserNameEditor.getStringValue();
        }
        return "";
    }

    public String getProxyPassword() {
        if (this.needsProxy()) {
            return this.proxyPasswordEditor.getStringValue();
        }
        return "";
    }

    public void init(IWorkbench workbench) {
    }

    public boolean isAnonymousAccess() {
        if (this.anonymousButton != null) {
            return this.anonymousButton.getSelection();
        }
        return false;
    }

    @Override
    public boolean isPageComplete() {
        String errorMessage = null;
        String url = this.getRepositoryUrl();
        errorMessage = this.isUniqueUrl(url);
        if (errorMessage == null) {
            for (TaskRepository repository : TasksUi.getRepositoryManager().getAllRepositories()) {
                if (repository.equals((Object)this.getRepository()) || !this.getRepositoryLabel().equals(repository.getRepositoryLabel())) continue;
                errorMessage = Messages.AbstractRepositorySettingsPage_A_repository_with_this_name_already_exists;
                break;
            }
        }
        if (errorMessage == null) {
            if (!this.isValidUrl(url)) {
                errorMessage = Messages.AbstractRepositorySettingsPage_Enter_a_valid_server_url;
            }
            if (errorMessage == null && this.needsRepositoryCredentials() && (!this.needsAnonymousLogin() || !this.anonymousButton.getSelection()) && this.isMissingCredentials()) {
                errorMessage = Messages.AbstractRepositorySettingsPage_Enter_a_user_id_Message0;
            }
            this.setMessage(errorMessage, this.repository == null ? 0 : 3);
        } else {
            this.setMessage(errorMessage, 3);
        }
        return errorMessage == null && super.isPageComplete();
    }

    protected boolean isMissingCredentials() {
        return this.needsRepositoryCredentials() && this.repositoryUserNameEditor.getStringValue().trim().equals("") || this.getSavePassword() != false && this.repositoryPasswordEditor.getStringValue().trim().equals("");
    }

    protected String isUniqueUrl(String urlString) {
        if (!urlString.equals(this.originalUrl)) {
            if (this.repositoryUrls == null) {
                List repositories = TasksUi.getRepositoryManager().getAllRepositories();
                this.repositoryUrls = new HashSet<String>(repositories.size());
                for (TaskRepository repository : repositories) {
                    this.repositoryUrls.add(repository.getRepositoryUrl());
                }
            }
            if (this.repositoryUrls.contains(urlString)) {
                return Messages.AbstractRepositorySettingsPage_Repository_already_exists;
            }
        }
        return null;
    }

    @Deprecated
    public void setRepository(TaskRepository repository) {
        this.repository = repository;
    }

    public void setVersion(String previousVersion) {
        this.serverVersion = previousVersion == null ? "unknown" : previousVersion;
    }

    public String getVersion() {
        return this.serverVersion;
    }

    public TaskRepository getRepository() {
        return this.repository;
    }

    public String getCharacterEncoding() {
        if (this.defaultEncoding == null) {
            return null;
        }
        if (this.defaultEncoding.getSelection()) {
            return "UTF-8";
        }
        if (this.otherEncodingCombo.getSelectionIndex() > -1) {
            return this.otherEncodingCombo.getItem(this.otherEncodingCombo.getSelectionIndex());
        }
        return "UTF-8";
    }

    public TaskRepository createTaskRepository() {
        TaskRepository repository = new TaskRepository(this.connector.getConnectorKind(), this.getRepositoryUrl());
        repository.setShouldPersistCredentials(false);
        this.applyTo(repository);
        return repository;
    }

    @Override
    public void applyTo(@NonNull TaskRepository repository) {
        AuthenticationCredentials webCredentials;
        String category = repository.getCategory();
        if (category == null || category.length() == 0) {
            this.connector.applyDefaultCategory(repository);
        }
        repository.setVersion(this.getVersion());
        if (this.needsEncoding()) {
            repository.setCharacterEncoding(this.getCharacterEncoding());
        }
        if (this.needsRepositoryCredentials()) {
            if (this.isAnonymousAccess()) {
                repository.setCredentials(AuthenticationType.REPOSITORY, null, this.getSavePassword().booleanValue());
            } else {
                AuthenticationCredentials credentials = new AuthenticationCredentials(this.getUserName(), this.getPassword());
                repository.setCredentials(AuthenticationType.REPOSITORY, credentials, this.getSavePassword().booleanValue());
            }
        }
        repository.setRepositoryLabel(this.getRepositoryLabel());
        if (this.needsCertAuth()) {
            if (this.getCertAuth()) {
                webCredentials = new AuthenticationCredentials(this.getCertAuthFileName(), this.getCertAuthPassword());
                repository.setCredentials(AuthenticationType.CERTIFICATE, webCredentials, this.getSaveCertPassword().booleanValue());
            } else {
                repository.setCredentials(AuthenticationType.CERTIFICATE, null, this.getSaveCertPassword().booleanValue());
            }
        }
        if (this.needsHttpAuth()) {
            if (this.getHttpAuth()) {
                webCredentials = new AuthenticationCredentials(this.getHttpAuthUserId(), this.getHttpAuthPassword());
                repository.setCredentials(AuthenticationType.HTTP, webCredentials, this.getSaveHttpPassword().booleanValue());
            } else {
                repository.setCredentials(AuthenticationType.HTTP, null, this.getSaveHttpPassword().booleanValue());
            }
        }
        if (this.needsProxy()) {
            repository.setDefaultProxyEnabled(this.getUseDefaultProxy().booleanValue());
            repository.setProperty("org.eclipse.mylyn.tasklist.repositories.proxy.hostname", this.getProxyHostname());
            repository.setProperty("org.eclipse.mylyn.tasklist.repositories.proxy.port", this.getProxyPort());
            if (this.getProxyAuth()) {
                webCredentials = new AuthenticationCredentials(this.getProxyUserName(), this.getProxyPassword());
                repository.setCredentials(AuthenticationType.PROXY, webCredentials, this.getSaveProxyPassword().booleanValue());
            } else {
                repository.setCredentials(AuthenticationType.PROXY, null, this.getSaveProxyPassword().booleanValue());
            }
        }
        if (this.disconnectedButton != null) {
            repository.setOffline(this.disconnectedButton.getSelection());
        }
        super.applyTo(repository);
    }

    public AbstractRepositoryConnector getConnector() {
        return this.connector;
    }

    public boolean needsEncoding() {
        return this.needsEncoding;
    }

    public boolean needsTimeZone() {
        return this.needsTimeZone;
    }

    public boolean needsAnonymousLogin() {
        return this.needsAnonymousLogin;
    }

    public boolean needsRepositoryCredentials() {
        return this.needsRepositoryCredentials;
    }

    public boolean needsAdvanced() {
        return this.needsAdvanced;
    }

    public void setNeedsEncoding(boolean needsEncoding) {
        this.needsEncoding = needsEncoding;
    }

    public void setNeedsTimeZone(boolean needsTimeZone) {
        this.needsTimeZone = needsTimeZone;
    }

    public void setNeedsAdvanced(boolean needsAdvanced) {
        this.needsAdvanced = needsAdvanced;
    }

    public boolean needsCertAuth() {
        return this.needsCertAuth;
    }

    public void setNeedsCertAuth(boolean needsCertificate) {
        this.needsCertAuth = needsCertificate;
    }

    public boolean needsHttpAuth() {
        return this.needsHttpAuth;
    }

    public void setNeedsHttpAuth(boolean needsHttpAuth) {
        this.needsHttpAuth = needsHttpAuth;
    }

    public void setNeedsProxy(boolean needsProxy) {
        this.needsProxy = needsProxy;
    }

    public boolean needsProxy() {
        return this.needsProxy;
    }

    public void setNeedsAnonymousLogin(boolean needsAnonymousLogin) {
        this.needsAnonymousLogin = needsAnonymousLogin;
    }

    public void setNeedsRepositoryCredentials(boolean needsRepositoryCredentials) {
        this.needsRepositoryCredentials = needsRepositoryCredentials;
    }

    public void setNeedsValidation(boolean needsValidation) {
        this.needsValidation = needsValidation;
    }

    public boolean canValidate() {
        return true;
    }

    public boolean needsValidation() {
        return this.needsValidation;
    }

    public void setUrl(String url) {
        this.serverUrlCombo.setText(url);
    }

    public void setUserId(String id) {
        this.repositoryUserNameEditor.setStringValue(id);
    }

    public void setPassword(String pass) {
        this.repositoryPasswordEditor.setStringValue(pass);
    }

    public Boolean getSavePassword() {
        return this.savePasswordButton.getSelection();
    }

    public Boolean getSaveProxyPassword() {
        if (this.needsProxy()) {
            return this.saveProxyPasswordButton.getSelection();
        }
        return false;
    }

    public Boolean getSaveCertPassword() {
        if (this.needsCertAuth()) {
            return this.saveCertPasswordButton.getSelection();
        }
        return false;
    }

    public Boolean getSaveHttpPassword() {
        if (this.needsHttpAuth()) {
            return this.saveHttpPasswordButton.getSelection();
        }
        return false;
    }

    protected void validateSettings() {
        TaskRepository newTaskRepository = this.createTaskRepository();
        final Validator validator = this.getValidator(newTaskRepository);
        if (validator == null) {
            return;
        }
        try {
            this.getWizard().getContainer().run(true, true, new IRunnableWithProgress(){

                /*
                 * Exception decompiling
                 */
                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    /*
                     * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
                     * 
                     * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [4[CATCHBLOCK]], but top level block is 2[TRYBLOCK]
                     *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
                     *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
                     *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
                     *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
                     *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
                     *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
                     *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
                     *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
                     *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
                     *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
                     *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
                     *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
                     *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
                     *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
                     *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
                     *     at org.benf.cfr.reader.Main.main(Main.java:54)
                     */
                    throw new IllegalStateException("Decompilation failed");
                }
            });
        }
        catch (InvocationTargetException e) {
            StatusManager.getManager().handle((IStatus)new Status(4, "org.eclipse.mylyn.tasks.ui", Messages.AbstractRepositorySettingsPage_Internal_error_validating_repository, (Throwable)e), 3);
            return;
        }
        catch (InterruptedException interruptedException) {
            return;
        }
        this.getWizard().getContainer().updateButtons();
        this.applyValidatorResult(validator);
        if (this.isValid) {
            this.saveToValidatedProperties(newTaskRepository);
        }
    }

    @Override
    protected IStatus validate() {
        return null;
    }

    protected void applyValidatorResult(Validator validator) {
        IStatus status = validator.getStatus();
        String message = status.getMessage();
        if (message == null || message.length() == 0) {
            message = null;
        }
        switch (status.getSeverity()) {
            case 0: {
                if (status == Status.OK_STATUS) {
                    message = this.getUserName().length() > 0 ? Messages.AbstractRepositorySettingsPage_Authentication_credentials_are_valid : Messages.AbstractRepositorySettingsPage_Repository_is_valid;
                }
                this.setMessage(message, 1);
                break;
            }
            case 1: {
                this.setMessage(message, 1);
                break;
            }
            case 2: {
                this.setMessage(message, 2);
                break;
            }
            default: {
                this.setMessage(message, 3);
            }
        }
        this.setErrorMessage(null);
        this.isValid = status.getSeverity() == 0 || status.getSeverity() == 1;
    }

    protected Validator getValidator(final @NonNull TaskRepository repository) {
        return new Validator(this){

            @Override
            public void run(IProgressMonitor monitor) throws CoreException {
                RepositoryInfo repositoryInfo = connector.validateRepository(repository, monitor);
                this.setStatus((IStatus)new Status(0, "org.eclipse.mylyn.tasks.ui", NLS.bind((String)Messages.AbstractRepositorySettingsPage_Settings_are_valid_version, (Object)repositoryInfo.getVersion())));
            }
        };
    }

    public Object getAdapter(Class adapter) {
        if (adapter == IValidatable.class) {
            return new IValidatable(){

                public void validate() {
                    AbstractRepositorySettingsPage.this.validateSettings();
                }

                public boolean needsValidation() {
                    return AbstractRepositorySettingsPage.this.needsValidation();
                }

                public boolean canValidate() {
                    return AbstractRepositorySettingsPage.this.canValidate();
                }
            };
        }
        return null;
    }

    public boolean needsValidateOnFinish() {
        return this.needsValidateOnFinish;
    }

    public void setNeedsValidateOnFinish(boolean needsValidateOnFinish) {
        this.needsValidateOnFinish = needsValidateOnFinish;
    }

    @Override
    public boolean preFinish(TaskRepository repository) {
        if (this.validateOnFinishButton != null && this.validateOnFinishButton.getSelection() && !this.propertiesUnchanged()) {
            this.isValid = false;
            this.validateSettings();
        } else {
            this.isValid = true;
        }
        if (this.isValid) {
            this.isValid = super.preFinish(repository);
        }
        return this.isValid;
    }

    @Override
    protected ExpandableComposite createSection(Composite parentControl, String title) {
        if (parentControl instanceof SectionComposite) {
            return ((SectionComposite)parentControl).createSection(title);
        }
        return super.createSection(parentControl, title);
    }

    protected FormToolkit getToolkit() {
        if (this.toolkit == null) {
            throw new IllegalStateException("Toolkit is not initialized, createControl() must be invoked first");
        }
        return this.toolkit;
    }

    private boolean propertiesUnchanged() {
        TaskRepository newRepository = this.createTaskRepository();
        boolean propertiesUnchanged = false;
        if (this.validatedTaskRepository != null && (propertiesUnchanged = this.validatedTaskRepository.getProperties().equals(newRepository.getProperties()))) {
            AuthenticationType[] authenticationTypeArray = AuthenticationType.values();
            int n = authenticationTypeArray.length;
            int n2 = 0;
            while (n2 < n) {
                AuthenticationType authenticationType = authenticationTypeArray[n2];
                AuthenticationCredentials credentialsOld = this.validatedAuthenticationCredentials.get(authenticationType);
                AuthenticationCredentials credentialsNew = newRepository.getCredentials(authenticationType);
                if (credentialsOld != null) {
                    propertiesUnchanged = credentialsOld.equals((Object)credentialsNew);
                    if (!propertiesUnchanged) {
                        break;
                    }
                } else if (credentialsNew != null) {
                    propertiesUnchanged = false;
                    break;
                }
                ++n2;
            }
        }
        return propertiesUnchanged;
    }

    private void saveToValidatedProperties(TaskRepository taskRepository) {
        this.validatedTaskRepository = taskRepository;
        this.validatedAuthenticationCredentials.clear();
        AuthenticationType[] authenticationTypeArray = AuthenticationType.values();
        int n = authenticationTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            AuthenticationType authenticationType = authenticationTypeArray[n2];
            AuthenticationCredentials ra = this.validatedTaskRepository.getCredentials(authenticationType);
            this.validatedAuthenticationCredentials.put(authenticationType, ra);
            ++n2;
        }
    }

    private static class RepositoryStringFieldEditor
    extends StringFieldEditor {
        public RepositoryStringFieldEditor(String name, String labelText, int style, Composite parent) {
            super(name, labelText, style, parent);
        }

        public void refreshValidState() {
            try {
                super.refreshValidState();
            }
            catch (Exception e) {
                StatusHandler.log((IStatus)new Status(4, "org.eclipse.mylyn.tasks.ui", "Problem refreshing password field", (Throwable)e));
            }
        }

        public Text getTextControl() {
            return super.getTextControl();
        }
    }

    public abstract class Validator {
        private IStatus status;

        public abstract void run(@NonNull IProgressMonitor var1) throws CoreException;

        public IStatus getStatus() {
            return this.status;
        }

        public void setStatus(IStatus status) {
            this.status = status;
        }
    }
}

