/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.reviews.ui.compare;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import org.eclipse.compare.CompareConfiguration;
import org.eclipse.compare.CompareEditorInput;
import org.eclipse.compare.CompareViewerPane;
import org.eclipse.compare.ITypedElement;
import org.eclipse.compare.structuremergeviewer.ICompareInput;
import org.eclipse.compare.structuremergeviewer.IDiffElement;
import org.eclipse.compare.structuremergeviewer.StructureDiffViewer;
import org.eclipse.core.commands.IHandler;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.mylyn.internal.reviews.ui.Messages;
import org.eclipse.mylyn.internal.reviews.ui.ReviewsImages;
import org.eclipse.mylyn.internal.reviews.ui.compare.Direction;
import org.eclipse.mylyn.internal.reviews.ui.compare.FileItemNode;
import org.eclipse.mylyn.internal.reviews.ui.compare.GotoCommentHandler;
import org.eclipse.mylyn.internal.reviews.ui.compare.ReviewCompareAnnotationSupport;
import org.eclipse.mylyn.reviews.ui.ReviewBehavior;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.handlers.IHandlerActivation;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.ui.menus.CommandContributionItem;
import org.eclipse.ui.menus.CommandContributionItemParameter;
import org.eclipse.ui.services.IServiceLocator;

public abstract class ReviewItemCompareEditorInput
extends CompareEditorInput {
    final ReviewBehavior behavior;
    private IHandlerActivation gotoNextCommentHandler;
    private IHandlerActivation gotoPreviousCommentHandler;

    public ReviewItemCompareEditorInput(CompareConfiguration configuration, ReviewBehavior behavior) {
        super(configuration);
        this.behavior = behavior;
    }

    public Viewer findStructureViewer(Viewer oldViewer, ICompareInput input, Composite parent) {
        Viewer structureViewer = super.findStructureViewer(oldViewer, input, parent);
        if (structureViewer instanceof StructureDiffViewer) {
            StructureDiffViewer diffViewer = (StructureDiffViewer)structureViewer;
            diffViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

                public String getText(Object element) {
                    if (element instanceof ITypedElement) {
                        return ((ITypedElement)element).getName();
                    }
                    return "<no name>";
                }

                public Image getImage(Object element) {
                    if (element instanceof IDiffElement) {
                        IDiffElement input = (IDiffElement)element;
                        int kind = input.getKind();
                        if (kind == 1) {
                            kind = 2;
                        } else if (kind == 2) {
                            kind = 1;
                        }
                        return ReviewItemCompareEditorInput.this.getCompareConfiguration().getImage(input.getImage(), kind);
                    }
                    return null;
                }
            });
        }
        return structureViewer;
    }

    public Viewer findContentViewer(Viewer oldViewer, ICompareInput input, Composite parent) {
        Viewer contentViewer = super.findContentViewer(oldViewer, input, parent);
        if (input instanceof FileItemNode && ((FileItemNode)input).getFileItem() != null) {
            ReviewCompareAnnotationSupport support = ReviewCompareAnnotationSupport.getAnnotationSupport(contentViewer);
            support.setReviewItem(((FileItemNode)input).getFileItem(), this.behavior);
            if (this.gotoNextCommentHandler == null && this.gotoPreviousCommentHandler == null) {
                this.initializeGotoCommentHandlers(parent, support);
            }
        }
        return contentViewer;
    }

    private void initializeGotoCommentHandlers(Composite parent, ReviewCompareAnnotationSupport support) {
        IServiceLocator serviceLocator;
        ToolBarManager tbm = CompareViewerPane.getToolBarManager((Composite)parent);
        if (tbm != null && (serviceLocator = this.getServiceLocator()) != null) {
            final IHandlerService handlerService = (IHandlerService)serviceLocator.getService(IHandlerService.class);
            if (handlerService != null) {
                this.gotoNextCommentHandler = handlerService.activateHandler("org.eclipse.mylyn.reviews.ui.commands.navigate.comment.next", (IHandler)new GotoCommentHandler(Direction.FORWARDS, support));
                this.gotoPreviousCommentHandler = handlerService.activateHandler("org.eclipse.mylyn.reviews.ui.commands.navigate.comment.previous", (IHandler)new GotoCommentHandler(Direction.BACKWARDS, support));
                final ArrayList<IHandlerActivation> activations = new ArrayList<IHandlerActivation>(Arrays.asList(this.gotoNextCommentHandler, this.gotoPreviousCommentHandler));
                parent.addDisposeListener(new DisposeListener(){

                    public void widgetDisposed(DisposeEvent e) {
                        handlerService.deactivateHandlers((Collection)activations);
                        activations.clear();
                    }
                });
            }
            CommandContributionItemParameter p = new CommandContributionItemParameter(serviceLocator, "org.eclipse.mylyn.reviews.ui.navigate.comment.next", "org.eclipse.mylyn.reviews.ui.commands.navigate.comment.next", 8);
            p.icon = ReviewsImages.NEXT_COMMENT;
            p.label = Messages.Reviews_NextComment;
            if (p.label.length() > 0) {
                p.mnemonic = p.label.substring(0, 1);
            }
            p.tooltip = Messages.Reviews_NextComment_Tooltip;
            tbm.appendToGroup("navigation", (IContributionItem)new CommandContributionItem(p));
            p = new CommandContributionItemParameter(serviceLocator, "org.eclipse.mylyn.reviews.ui.navigate.comment.previous", "org.eclipse.mylyn.reviews.ui.commands.navigate.comment.previous", 8);
            p.icon = ReviewsImages.PREVIOUS_COMMENT;
            p.label = Messages.Reviews_PreviousComment;
            if (p.label.length() > 0) {
                p.mnemonic = p.label.substring(0, 1);
            }
            p.tooltip = Messages.Reviews_PreviousComment_Tooltip;
            tbm.appendToGroup("navigation", (IContributionItem)new CommandContributionItem(p));
            tbm.update(true);
        }
    }
}

