/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.wikitext.html.core;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.mylyn.internal.wikitext.html.core.ElementStrategies;
import org.eclipse.mylyn.internal.wikitext.html.core.SpanHtmlElementStrategy;
import org.eclipse.mylyn.internal.wikitext.html.core.SpanStrategy;
import org.eclipse.mylyn.internal.wikitext.html.core.SubstitutionSpanStrategy;
import org.eclipse.mylyn.internal.wikitext.html.core.SupportedSpanStrategy;
import org.eclipse.mylyn.internal.wikitext.html.core.UnsupportedSpanStrategy;
import org.eclipse.mylyn.wikitext.core.parser.DocumentBuilder;

public class SpanStrategies
extends ElementStrategies<DocumentBuilder.SpanType, SpanStrategy, SpanHtmlElementStrategy> {
    private static final Map<DocumentBuilder.SpanType, List<DocumentBuilder.SpanType>> spanTypeToAlternatives = SpanStrategies.createSpanTypeToAlternatives();

    private static Map<DocumentBuilder.SpanType, List<DocumentBuilder.SpanType>> createSpanTypeToAlternatives() {
        HashMap alternatives = Maps.newHashMap();
        SpanStrategies.addAlternatives(alternatives, DocumentBuilder.SpanType.BOLD, DocumentBuilder.SpanType.STRONG);
        SpanStrategies.addAlternatives(alternatives, DocumentBuilder.SpanType.STRONG, DocumentBuilder.SpanType.BOLD);
        SpanStrategies.addAlternatives(alternatives, DocumentBuilder.SpanType.CODE, DocumentBuilder.SpanType.MONOSPACE);
        SpanStrategies.addAlternatives(alternatives, DocumentBuilder.SpanType.EMPHASIS, DocumentBuilder.SpanType.ITALIC);
        SpanStrategies.addAlternatives(alternatives, DocumentBuilder.SpanType.INSERTED, DocumentBuilder.SpanType.UNDERLINED);
        SpanStrategies.addAlternatives(alternatives, DocumentBuilder.SpanType.ITALIC, DocumentBuilder.SpanType.EMPHASIS);
        SpanStrategies.addAlternatives(alternatives, DocumentBuilder.SpanType.MONOSPACE, DocumentBuilder.SpanType.CODE);
        return ImmutableMap.copyOf((Map)alternatives);
    }

    private static void addAlternatives(Map<DocumentBuilder.SpanType, List<DocumentBuilder.SpanType>> alternatives, DocumentBuilder.SpanType spanType, DocumentBuilder.SpanType ... spanTypes) {
        Preconditions.checkState((!alternatives.containsKey(spanType) ? 1 : 0) != 0, (String)"Duplicate %s", (Object[])new Object[]{spanType});
        Preconditions.checkArgument((spanTypes.length > 0 ? 1 : 0) != 0);
        alternatives.put(spanType, (List<DocumentBuilder.SpanType>)ImmutableList.copyOf((Object[])spanTypes));
    }

    SpanStrategies(Set<DocumentBuilder.SpanType> elementTypes, List<SpanHtmlElementStrategy> spanElementStrategies) {
        super(DocumentBuilder.SpanType.class, elementTypes, spanElementStrategies);
    }

    @Override
    void addImplicitElementTypes(Map<DocumentBuilder.SpanType, SpanStrategy> blockStrategyByElementType, Set<DocumentBuilder.SpanType> elementTypes) {
    }

    @Override
    SpanStrategy getSupportedStrategy(DocumentBuilder.SpanType elementType) {
        return SupportedSpanStrategy.instance;
    }

    @Override
    SpanStrategy getUnsupportedElementStrategy() {
        return UnsupportedSpanStrategy.instance;
    }

    @Override
    SpanStrategy createSubstitutionElementStrategy(DocumentBuilder.SpanType alternative) {
        return new SubstitutionSpanStrategy(alternative);
    }

    @Override
    Map<DocumentBuilder.SpanType, List<DocumentBuilder.SpanType>> getElementTypeToAlternatives() {
        return spanTypeToAlternatives;
    }

    @Override
    SpanStrategy getElementStrategy(SpanHtmlElementStrategy strategy) {
        return strategy.spanStrategy();
    }
}

