/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.docs.epub.ui;

import java.io.File;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.mylyn.docs.epub.core.EPUB;
import org.eclipse.mylyn.docs.epub.core.OPSPublication;
import org.eclipse.mylyn.docs.epub.core.ValidationMessage;
import org.eclipse.mylyn.docs.epub.core.wikitext.MarkupToOPS;
import org.eclipse.mylyn.internal.docs.epub.ui.EPUB2Bean;
import org.eclipse.mylyn.internal.docs.epub.ui.MainPage;
import org.eclipse.mylyn.internal.docs.epub.ui.Messages;
import org.eclipse.mylyn.wikitext.core.parser.markup.MarkupLanguage;
import org.eclipse.ui.statushandlers.StatusManager;

public class ConvertFromMarkupWizard
extends Wizard {
    private EPUB2Bean bean;
    OPSPublication oebps;
    private IFile epubFile;
    private File epubFolder;
    private IFile markupFile;
    private File markupFolder = null;
    private MarkupLanguage markupLanguage;
    private MainPage page;

    public ConvertFromMarkupWizard() {
        this.setWindowTitle(Messages.ConvertFromMarkupWizard_0);
        this.setNeedsProgressMonitor(true);
    }

    public void addPages() {
        this.oebps = OPSPublication.getVersion2Instance();
        File workingFolder = null;
        this.bean = new EPUB2Bean(this.oebps, this.markupFile.getLocation().toFile(), this.epubFile.getLocation().toFile(), workingFolder);
        this.page = new MainPage(this.bean);
        this.addPage((IWizardPage)this.page);
    }

    private void deleteFolder(File folder) {
        if (folder == null) {
            return;
        }
        if (folder.isDirectory() && folder.exists()) {
            String[] children;
            String[] stringArray = children = folder.list();
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                String element = stringArray[n2];
                this.deleteFolder(new File(folder, element));
                ++n2;
            }
        }
        if (folder.exists()) {
            folder.delete();
        }
    }

    public void init(IFile markupFile, IFile epubFile, MarkupLanguage markupLanguage) {
        this.markupFile = markupFile;
        this.epubFile = epubFile;
        this.markupLanguage = markupLanguage;
    }

    public boolean performFinish() {
        final MarkupToOPS markupToEPUB = new MarkupToOPS();
        markupToEPUB.setMarkupLanguage(this.markupLanguage);
        final MultiStatus ms = new MultiStatus("org.eclipse.mylyn.docs.epub.ui", 0, Messages.ConvertFromMarkupWizard_1, null);
        try {
            this.getContainer().run(false, false, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) {
                    monitor.beginTask(Messages.ConvertFromMarkupWizard_2, 3);
                    try {
                        try {
                            if (ConvertFromMarkupWizard.this.epubFile.exists()) {
                                ConvertFromMarkupWizard.this.epubFile.delete(true, monitor);
                            }
                            ConvertFromMarkupWizard.this.markupFolder = markupToEPUB.parse(ConvertFromMarkupWizard.this.oebps, ConvertFromMarkupWizard.this.markupFile.getLocation().toFile());
                            monitor.worked(1);
                            EPUB publication = new EPUB();
                            publication.add(ConvertFromMarkupWizard.this.oebps);
                            ConvertFromMarkupWizard.this.epubFolder = publication.pack(ConvertFromMarkupWizard.this.epubFile.getLocation().toFile());
                            monitor.worked(1);
                            ConvertFromMarkupWizard.this.epubFile.refreshLocal(1, monitor);
                            monitor.worked(1);
                            List messages = ConvertFromMarkupWizard.this.oebps.getMessages();
                            for (ValidationMessage validationMessage : messages) {
                                ms.add((IStatus)new Status(2, "org.eclipse.mylyn.docs.epub.ui", validationMessage.getMessage()));
                            }
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            ms.add((IStatus)new Status(4, "org.eclipse.mylyn.docs.epub.ui", Messages.ConvertFromMarkupWizard_3, (Throwable)e));
                            ConvertFromMarkupWizard.this.deleteFolder(ConvertFromMarkupWizard.this.epubFolder);
                            ConvertFromMarkupWizard.this.deleteFolder(ConvertFromMarkupWizard.this.markupFolder);
                            monitor.done();
                        }
                    }
                    finally {
                        ConvertFromMarkupWizard.this.deleteFolder(ConvertFromMarkupWizard.this.epubFolder);
                        ConvertFromMarkupWizard.this.deleteFolder(ConvertFromMarkupWizard.this.markupFolder);
                        monitor.done();
                    }
                }
            });
        }
        catch (Throwable e) {
            ms.add((IStatus)new Status(4, "org.eclipse.mylyn.docs.epub.ui", Messages.ConvertFromMarkupWizard_4, e));
            return false;
        }
        if (!ms.isOK()) {
            StatusManager.getManager().handle((IStatus)ms, 4);
        }
        return ms.isOK();
    }
}

