/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.gerrit.dashboard.ui.internal.commands;

import java.util.Map;
import java.util.Set;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.runtime.Status;
import org.eclipse.mylyn.gerrit.dashboard.GerritPlugin;
import org.eclipse.mylyn.gerrit.dashboard.ui.internal.utils.GerritServerUtility;
import org.eclipse.mylyn.gerrit.dashboard.ui.internal.utils.UIUtils;
import org.eclipse.mylyn.gerrit.dashboard.ui.views.GerritTableView;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Widget;

public class AddGerritSiteHandler
extends AbstractHandler {
    private GerritServerUtility fServerUtil = null;
    private Map<TaskRepository, String> fMapRepoServer = null;

    public Object execute(ExecutionEvent aEvent) {
        GerritPlugin.Ftracer.traceInfo("Create the Add button to search the Gerrit location ");
        String menuItemText = "";
        this.fServerUtil = GerritServerUtility.getInstance();
        Object obj = aEvent.getTrigger();
        GerritTableView reviewTableView = GerritTableView.getActiveView();
        if (obj instanceof Event) {
            Event ev = (Event)obj;
            Widget objWidget = ev.widget;
            if (objWidget instanceof MenuItem) {
                MenuItem menuItem = (MenuItem)objWidget;
                menuItemText = menuItem.getText();
                GerritPlugin.Ftracer.traceInfo("MenuItem: " + menuItemText + "\t value: " + aEvent.getParameter(menuItemText) + " VS saved: " + this.fServerUtil.getLastSavedGerritServer());
                this.fMapRepoServer = this.fServerUtil.getGerritMapping();
                String stURL = this.fServerUtil.getMenuSelectionURL(menuItemText);
                GerritPlugin.Ftracer.traceInfo("URL for the menuItemText: " + stURL);
                if (!this.fMapRepoServer.isEmpty()) {
                    Set<TaskRepository> mapSet = this.fMapRepoServer.keySet();
                    GerritPlugin.Ftracer.traceInfo("-------------------");
                    for (TaskRepository key : mapSet) {
                        GerritPlugin.Ftracer.traceInfo("Map Key name: " + key.getRepositoryLabel() + "\t URL: " + this.fMapRepoServer.get(key));
                    }
                }
                reviewTableView.openView();
                if (stURL != null) {
                    if (stURL.equals(this.fServerUtil.getLastSavedGerritServer())) {
                        GerritPlugin.Ftracer.traceInfo("LAST SAVED server is the SAME ");
                        this.fServerUtil.getReviewListFromServer();
                        reviewTableView.processCommands("my watched changes");
                        return Status.OK_STATUS;
                    }
                    this.fServerUtil.saveLastGerritServer(stURL);
                    this.fServerUtil.getReviewListFromServer();
                    reviewTableView.processCommands("my watched changes");
                    return Status.OK_STATUS;
                }
            }
        }
        UIUtils.showErrorDialog("Use Button [Task Repositories...] to define a new Gerrit Server", "Button [Add Gerrit Repository...] is not ready");
        return obj;
    }
}

