/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.bugzilla.tests;

import java.io.PrintStream;
import java.util.List;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.mylyn.bugzilla.tests.AllBugzillaHeadlessStandaloneTests;
import org.eclipse.mylyn.bugzilla.tests.BugzillaAttachmentHandlerTest;
import org.eclipse.mylyn.bugzilla.tests.BugzillaCustomRepositoryTest;
import org.eclipse.mylyn.bugzilla.tests.BugzillaRepositoryConnectorTest;
import org.eclipse.mylyn.bugzilla.tests.BugzillaSearchTest;
import org.eclipse.mylyn.bugzilla.tests.BugzillaTaskDataHandlerTest;
import org.eclipse.mylyn.bugzilla.tests.EncodingTest;
import org.eclipse.mylyn.bugzilla.tests.RepositoryReportFactoryTest;
import org.eclipse.mylyn.bugzilla.tests.core.BugzillaXmlRpcClientTest;
import org.eclipse.mylyn.bugzilla.tests.support.BugzillaFixture;
import org.eclipse.mylyn.bugzilla.tests.ui.BugzillaHyperlinkDetectorTest;
import org.eclipse.mylyn.bugzilla.tests.ui.BugzillaRepositorySettingsPageTest;
import org.eclipse.mylyn.bugzilla.tests.ui.BugzillaSearchPageTest;
import org.eclipse.mylyn.bugzilla.tests.ui.BugzillaTaskEditorTest;
import org.eclipse.mylyn.bugzilla.tests.ui.BugzillaTaskHyperlinkDetectorTest;
import org.eclipse.mylyn.commons.sdk.util.CommonTestUtil;
import org.eclipse.mylyn.commons.sdk.util.ManagedTestSuite;
import org.eclipse.mylyn.commons.sdk.util.TestConfiguration;

public class AllBugzillaTests {
    public static Test suite() {
        if (CommonTestUtil.fixProxyConfiguration()) {
            CommonTestUtil.dumpSystemInfo((PrintStream)System.err);
        }
        ManagedTestSuite suite = new ManagedTestSuite(AllBugzillaTests.class.getName());
        AllBugzillaTests.addTests((TestSuite)suite, TestConfiguration.getDefault());
        return suite;
    }

    public static Test suite(TestConfiguration configuration) {
        TestSuite suite = new TestSuite(AllBugzillaTests.class.getName());
        AllBugzillaTests.addTests(suite, configuration);
        return suite;
    }

    public static void addTests(TestSuite suite, TestConfiguration configuration) {
        suite.addTest(AllBugzillaHeadlessStandaloneTests.suite(configuration));
        suite.addTestSuite(BugzillaTaskHyperlinkDetectorTest.class);
        suite.addTestSuite(BugzillaHyperlinkDetectorTest.class);
        if (!configuration.isLocalOnly()) {
            suite.addTestSuite(BugzillaTaskEditorTest.class);
            suite.addTestSuite(BugzillaSearchPageTest.class);
            suite.addTestSuite(BugzillaRepositorySettingsPageTest.class);
            List fixtures = configuration.discover(BugzillaFixture.class, "bugzilla");
            for (BugzillaFixture fixture : fixtures) {
                AllBugzillaTests.addTests(suite, fixture);
            }
        }
    }

    private static void addTests(TestSuite suite, BugzillaFixture fixture) {
        if (fixture.isExcluded()) {
            return;
        }
        fixture.createSuite(suite);
        fixture.add(RepositoryReportFactoryTest.class);
        fixture.add(BugzillaTaskDataHandlerTest.class);
        fixture.add(BugzillaSearchTest.class);
        fixture.add(EncodingTest.class);
        fixture.add(BugzillaXmlRpcClientTest.class);
        fixture.add(BugzillaRepositoryConnectorTest.class);
        fixture.add(BugzillaAttachmentHandlerTest.class);
        if (fixture.isCustomWorkflowAndStatus()) {
            fixture.add(BugzillaCustomRepositoryTest.class);
        }
        fixture.done();
    }
}

