/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.bugzilla.tests;

import java.util.HashSet;
import org.eclipse.mylyn.bugzilla.tests.AbstractBugzillaTest;
import org.eclipse.mylyn.bugzilla.tests.support.BugzillaFixture;
import org.eclipse.mylyn.internal.bugzilla.core.Messages;
import org.eclipse.mylyn.internal.tasks.core.AbstractTask;
import org.eclipse.mylyn.internal.tasks.ui.util.TasksUiInternal;
import org.eclipse.mylyn.tasks.core.ITask;
import org.eclipse.mylyn.tasks.core.ITaskMapping;
import org.eclipse.mylyn.tasks.core.RepositoryResponse;
import org.eclipse.mylyn.tasks.core.TaskMapping;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.core.data.ITaskDataWorkingCopy;
import org.eclipse.mylyn.tasks.core.data.TaskAttribute;
import org.eclipse.mylyn.tasks.core.data.TaskData;
import org.eclipse.mylyn.tasks.core.data.TaskDataModel;
import org.eclipse.mylyn.tasks.core.data.TaskOperation;
import org.eclipse.mylyn.tasks.ui.TasksUi;
import org.eclipse.mylyn.tasks.ui.TasksUiUtil;

public class BugzillaCustomRepositoryTest
extends AbstractBugzillaTest {
    public void testWorkflow() throws Exception {
        String taskId = this.harness.taskCfBugIdExists();
        if (taskId == null) {
            taskId = this.harness.createCfBugIdTask();
        }
        this.doCustomWorkflow(taskId);
    }

    private void doCustomWorkflow(String DupBugID) throws Exception {
        TaskMapping taskMappingInit = new TaskMapping(){

            public String getProduct() {
                return "TestProduct";
            }
        };
        TaskMapping taskMappingSelect = new TaskMapping(){

            public String getComponent() {
                return "TestComponent";
            }

            public String getSummary() {
                return "test the custom workflow";
            }

            public String getDescription() {
                return "The Description of the custom workflow task";
            }
        };
        TaskData[] taskDataNew = new TaskData[]{TasksUiInternal.createTaskData((TaskRepository)this.repository, (ITaskMapping)taskMappingInit, (ITaskMapping)taskMappingSelect, null)};
        ITask taskNew = TasksUiUtil.createOutgoingNewTask((String)taskDataNew[0].getConnectorKind(), (String)taskDataNew[0].getRepositoryUrl());
        ITaskDataWorkingCopy workingCopy = TasksUi.getTaskDataManager().createWorkingCopy(taskNew, taskDataNew[0]);
        HashSet<TaskAttribute> changed = new HashSet<TaskAttribute>();
        workingCopy.save(changed, null);
        RepositoryResponse response = BugzillaFixture.current().submitTask(taskDataNew[0], this.client);
        ((AbstractTask)taskNew).setSubmitting(true);
        BugzillaCustomRepositoryTest.assertNotNull((Object)response);
        BugzillaCustomRepositoryTest.assertEquals((String)RepositoryResponse.ResponseKind.TASK_CREATED.toString(), (String)response.getReposonseKind().toString());
        String taskId = response.getTaskId();
        ITask task = this.generateLocalTaskAndDownload(taskId);
        BugzillaCustomRepositoryTest.assertNotNull((Object)task);
        TaskDataModel model = this.createModel(task);
        TaskData taskData = model.getTaskData();
        BugzillaCustomRepositoryTest.assertNotNull((Object)taskData);
        TaskAttribute statusAttribute = taskData.getRoot().getMappedAttribute("task.common.status");
        BugzillaCustomRepositoryTest.assertEquals((String)"NEW", (String)statusAttribute.getValue());
        TaskAttribute selectedOperationAttribute = taskData.getRoot().getMappedAttribute("task.common.operation");
        TaskOperation.applyTo((TaskAttribute)selectedOperationAttribute, (String)"accept", (String)Messages.BugzillaOperation_Accept_to_ASSIGNED);
        model.attributeChanged(selectedOperationAttribute);
        changed.clear();
        changed.add(selectedOperationAttribute);
        workingCopy.save(changed, null);
        response = BugzillaFixture.current().submitTask(taskData, this.client);
        BugzillaCustomRepositoryTest.assertEquals((String)RepositoryResponse.ResponseKind.TASK_UPDATED.toString(), (String)response.getReposonseKind().toString());
        task = this.generateLocalTaskAndDownload(taskId);
        BugzillaCustomRepositoryTest.assertNotNull((Object)task);
        model = this.createModel(task);
        taskData = model.getTaskData();
        BugzillaCustomRepositoryTest.assertNotNull((Object)taskData);
        statusAttribute = taskData.getRoot().getMappedAttribute("task.common.status");
        BugzillaCustomRepositoryTest.assertEquals((String)"ASSIGNED", (String)statusAttribute.getValue());
        selectedOperationAttribute = taskData.getRoot().getMappedAttribute("task.common.operation");
        TaskOperation.applyTo((TaskAttribute)selectedOperationAttribute, (String)"markNew", (String)Messages.BugzillaOperation_Mark_as_NEW);
        model.attributeChanged(selectedOperationAttribute);
        changed.clear();
        changed.add(selectedOperationAttribute);
        workingCopy.save(changed, null);
        response = BugzillaFixture.current().submitTask(taskData, this.client);
        BugzillaCustomRepositoryTest.assertNotNull((Object)response);
        BugzillaCustomRepositoryTest.assertEquals((String)RepositoryResponse.ResponseKind.TASK_UPDATED.toString(), (String)response.getReposonseKind().toString());
        task = this.generateLocalTaskAndDownload(taskId);
        BugzillaCustomRepositoryTest.assertNotNull((Object)task);
        model = this.createModel(task);
        taskData = model.getTaskData();
        BugzillaCustomRepositoryTest.assertNotNull((Object)taskData);
        statusAttribute = taskData.getRoot().getMappedAttribute("task.common.status");
        BugzillaCustomRepositoryTest.assertEquals((String)"ASSIGNED", (String)statusAttribute.getValue());
        selectedOperationAttribute = taskData.getRoot().getMappedAttribute("task.common.operation");
        TaskOperation.applyTo((TaskAttribute)selectedOperationAttribute, (String)"duplicate", (String)Messages.BugzillaOperation_Duplicate_of);
        TaskAttribute duplicateAttribute = taskData.getRoot().getAttribute("dup_id");
        duplicateAttribute.setValue(DupBugID);
        model.attributeChanged(selectedOperationAttribute);
        model.attributeChanged(duplicateAttribute);
        changed.clear();
        changed.add(selectedOperationAttribute);
        changed.add(duplicateAttribute);
        workingCopy.save(changed, null);
        response = BugzillaFixture.current().submitTask(taskData, this.client);
        BugzillaCustomRepositoryTest.assertNotNull((Object)response);
        BugzillaCustomRepositoryTest.assertEquals((String)RepositoryResponse.ResponseKind.TASK_UPDATED.toString(), (String)response.getReposonseKind().toString());
        task = this.generateLocalTaskAndDownload(taskId);
        BugzillaCustomRepositoryTest.assertNotNull((Object)task);
        model = this.createModel(task);
        taskData = model.getTaskData();
        BugzillaCustomRepositoryTest.assertNotNull((Object)taskData);
        statusAttribute = taskData.getRoot().getMappedAttribute("task.common.status");
        BugzillaCustomRepositoryTest.assertEquals((String)"CLOSED", (String)statusAttribute.getValue());
        TaskAttribute resolution = taskData.getRoot().getMappedAttribute("task.common.resolution");
        BugzillaCustomRepositoryTest.assertEquals((String)"DUPLICATE", (String)resolution.getValue());
        selectedOperationAttribute = taskData.getRoot().getMappedAttribute("task.common.operation");
        TaskOperation.applyTo((TaskAttribute)selectedOperationAttribute, (String)"verify", (String)Messages.BugzillaOperation_Mark_as_VERIFIED);
        model.attributeChanged(selectedOperationAttribute);
        changed.clear();
        changed.add(selectedOperationAttribute);
        workingCopy.save(changed, null);
        response = BugzillaFixture.current().submitTask(taskData, this.client);
        BugzillaCustomRepositoryTest.assertNotNull((Object)response);
        BugzillaCustomRepositoryTest.assertEquals((String)RepositoryResponse.ResponseKind.TASK_UPDATED.toString(), (String)response.getReposonseKind().toString());
        task = this.generateLocalTaskAndDownload(taskId);
        BugzillaCustomRepositoryTest.assertNotNull((Object)task);
        model = this.createModel(task);
        taskData = model.getTaskData();
        BugzillaCustomRepositoryTest.assertNotNull((Object)taskData);
        statusAttribute = taskData.getRoot().getMappedAttribute("task.common.status");
        BugzillaCustomRepositoryTest.assertEquals((String)"VERIFIED", (String)statusAttribute.getValue());
        selectedOperationAttribute = taskData.getRoot().getMappedAttribute("task.common.operation");
        TaskOperation.applyTo((TaskAttribute)selectedOperationAttribute, (String)"MODIFIED", (String)Messages.BugzillaOperation_Reopen_bug);
        model.attributeChanged(selectedOperationAttribute);
        changed.clear();
        changed.add(selectedOperationAttribute);
        workingCopy.save(changed, null);
        response = BugzillaFixture.current().submitTask(taskData, this.client);
        BugzillaCustomRepositoryTest.assertNotNull((Object)response);
        BugzillaCustomRepositoryTest.assertEquals((String)RepositoryResponse.ResponseKind.TASK_UPDATED.toString(), (String)response.getReposonseKind().toString());
        task = this.generateLocalTaskAndDownload(taskId);
        BugzillaCustomRepositoryTest.assertNotNull((Object)task);
        model = this.createModel(task);
        taskData = model.getTaskData();
        BugzillaCustomRepositoryTest.assertNotNull((Object)taskData);
        statusAttribute = taskData.getRoot().getMappedAttribute("task.common.status");
        BugzillaCustomRepositoryTest.assertEquals((String)"MODIFIED", (String)statusAttribute.getValue());
        selectedOperationAttribute = taskData.getRoot().getMappedAttribute("task.common.operation");
        TaskOperation.applyTo((TaskAttribute)selectedOperationAttribute, (String)"ON_DEV", (String)Messages.BugzillaOperation_Reopen_bug);
        model.attributeChanged(selectedOperationAttribute);
        changed.clear();
        changed.add(selectedOperationAttribute);
        workingCopy.save(changed, null);
        response = BugzillaFixture.current().submitTask(taskData, this.client);
        BugzillaCustomRepositoryTest.assertNotNull((Object)response);
        BugzillaCustomRepositoryTest.assertEquals((String)RepositoryResponse.ResponseKind.TASK_UPDATED.toString(), (String)response.getReposonseKind().toString());
        task = this.generateLocalTaskAndDownload(taskId);
        BugzillaCustomRepositoryTest.assertNotNull((Object)task);
        model = this.createModel(task);
        taskData = model.getTaskData();
        BugzillaCustomRepositoryTest.assertNotNull((Object)taskData);
        statusAttribute = taskData.getRoot().getMappedAttribute("task.common.status");
        BugzillaCustomRepositoryTest.assertEquals((String)"ON_DEV", (String)statusAttribute.getValue());
        selectedOperationAttribute = taskData.getRoot().getMappedAttribute("task.common.operation");
        TaskOperation.applyTo((TaskAttribute)selectedOperationAttribute, (String)"POST", (String)Messages.BugzillaOperation_Resolve_as);
        resolution = taskData.getRoot().getMappedAttribute("task.common.resolution");
        resolution.setValue("FIXED");
        model.attributeChanged(selectedOperationAttribute);
        model.attributeChanged(resolution);
        changed.clear();
        changed.add(selectedOperationAttribute);
        changed.add(resolution);
        workingCopy.save(changed, null);
        response = BugzillaFixture.current().submitTask(taskData, this.client);
        BugzillaCustomRepositoryTest.assertNotNull((Object)response);
        BugzillaCustomRepositoryTest.assertEquals((String)RepositoryResponse.ResponseKind.TASK_UPDATED.toString(), (String)response.getReposonseKind().toString());
        task = this.generateLocalTaskAndDownload(taskId);
        BugzillaCustomRepositoryTest.assertNotNull((Object)task);
        model = this.createModel(task);
        taskData = model.getTaskData();
        BugzillaCustomRepositoryTest.assertNotNull((Object)taskData);
        statusAttribute = taskData.getRoot().getMappedAttribute("task.common.status");
        BugzillaCustomRepositoryTest.assertEquals((String)"POST", (String)statusAttribute.getValue());
        resolution = taskData.getRoot().getMappedAttribute("task.common.resolution");
        BugzillaCustomRepositoryTest.assertEquals((String)"FIXED", (String)resolution.getValue());
        selectedOperationAttribute = taskData.getRoot().getMappedAttribute("task.common.operation");
        TaskOperation.applyTo((TaskAttribute)selectedOperationAttribute, (String)"close", (String)Messages.BugzillaOperation_Resolve_as);
        resolution = taskData.getRoot().getMappedAttribute("task.common.resolution");
        resolution.setValue("FIXED");
        model.attributeChanged(selectedOperationAttribute);
        model.attributeChanged(resolution);
        changed.clear();
        changed.add(selectedOperationAttribute);
        changed.add(resolution);
        workingCopy.save(changed, null);
        response = BugzillaFixture.current().submitTask(taskData, this.client);
        BugzillaCustomRepositoryTest.assertNotNull((Object)response);
        BugzillaCustomRepositoryTest.assertEquals((String)RepositoryResponse.ResponseKind.TASK_UPDATED.toString(), (String)response.getReposonseKind().toString());
        task = this.generateLocalTaskAndDownload(taskId);
        BugzillaCustomRepositoryTest.assertNotNull((Object)task);
        model = this.createModel(task);
        taskData = model.getTaskData();
        BugzillaCustomRepositoryTest.assertNotNull((Object)taskData);
        statusAttribute = taskData.getRoot().getMappedAttribute("task.common.status");
        BugzillaCustomRepositoryTest.assertEquals((String)"CLOSED", (String)statusAttribute.getValue());
        resolution = taskData.getRoot().getMappedAttribute("task.common.resolution");
        BugzillaCustomRepositoryTest.assertEquals((String)"FIXED", (String)resolution.getValue());
        selectedOperationAttribute = taskData.getRoot().getMappedAttribute("task.common.operation");
        TaskOperation.applyTo((TaskAttribute)selectedOperationAttribute, (String)"reopen", (String)Messages.BugzillaOperation_Reopen_bug);
        model.attributeChanged(selectedOperationAttribute);
        changed.clear();
        changed.add(selectedOperationAttribute);
        workingCopy.save(changed, null);
        response = BugzillaFixture.current().submitTask(taskData, this.client);
        BugzillaCustomRepositoryTest.assertNotNull((Object)response);
        BugzillaCustomRepositoryTest.assertEquals((String)RepositoryResponse.ResponseKind.TASK_UPDATED.toString(), (String)response.getReposonseKind().toString());
        task = this.generateLocalTaskAndDownload(taskId);
        BugzillaCustomRepositoryTest.assertNotNull((Object)task);
        model = this.createModel(task);
        taskData = model.getTaskData();
        BugzillaCustomRepositoryTest.assertNotNull((Object)taskData);
        statusAttribute = taskData.getRoot().getMappedAttribute("task.common.status");
        BugzillaCustomRepositoryTest.assertEquals((String)"CLOSED", (String)statusAttribute.getValue());
        resolution = taskData.getRoot().getMappedAttribute("task.common.resolution");
        BugzillaCustomRepositoryTest.assertEquals((String)"FIXED", (String)resolution.getValue());
    }
}

