/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.bugzilla.tests.core;

import java.io.BufferedReader;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import junit.framework.TestCase;
import org.eclipse.mylyn.bugzilla.tests.support.BugzillaFixture;
import org.eclipse.mylyn.commons.core.CoreUtil;
import org.eclipse.mylyn.internal.bugzilla.core.BugzillaAttribute;
import org.eclipse.mylyn.internal.bugzilla.core.BugzillaRepositoryConnector;
import org.eclipse.mylyn.internal.bugzilla.core.RepositoryConfiguration;
import org.eclipse.mylyn.internal.bugzilla.core.SaxConfigurationContentHandler;
import org.eclipse.mylyn.internal.bugzilla.core.XmlCleaner;
import org.xml.sax.ContentHandler;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;

public class BugzillaConfigurationTest
extends TestCase {
    public void testRepositoryConfigurationCachePersistance() throws Exception {
        File file = File.createTempFile("bugzilla", null);
        file.deleteOnExit();
        BugzillaRepositoryConnector connector = new BugzillaRepositoryConnector(file);
        RepositoryConfiguration configuration1 = new RepositoryConfiguration();
        configuration1.setRepositoryUrl("url1");
        configuration1.addProduct("Test Product 1");
        BugzillaConfigurationTest.assertEquals((int)1, (int)configuration1.getOptionValues(BugzillaAttribute.PRODUCT).size());
        RepositoryConfiguration configuration2 = new RepositoryConfiguration();
        configuration1.setRepositoryUrl("url2");
        configuration2.addProduct("Test Product 2");
        BugzillaConfigurationTest.assertEquals((int)1, (int)configuration2.getOptionValues(BugzillaAttribute.PRODUCT).size());
        connector.addRepositoryConfiguration(configuration1);
        connector.addRepositoryConfiguration(configuration2);
        connector.writeRepositoryConfigFile();
        BugzillaConfigurationTest.assertNotNull((Object)connector.getRepositoryConfiguration(configuration1.getRepositoryUrl()));
        BugzillaConfigurationTest.assertNotNull((Object)connector.getRepositoryConfiguration(configuration2.getRepositoryUrl()));
        connector.removeConfiguration(configuration1);
        connector.removeConfiguration(configuration2);
        BugzillaConfigurationTest.assertNull((Object)connector.getRepositoryConfiguration(configuration1.getRepositoryUrl()));
        BugzillaConfigurationTest.assertNull((Object)connector.getRepositoryConfiguration(configuration2.getRepositoryUrl()));
        connector = new BugzillaRepositoryConnector(file);
        connector.readRepositoryConfigurationFile();
        BugzillaConfigurationTest.assertNotNull((Object)connector.getRepositoryConfiguration(configuration1.getRepositoryUrl()));
        BugzillaConfigurationTest.assertNotNull((Object)connector.getRepositoryConfiguration(configuration2.getRepositoryUrl()));
        RepositoryConfiguration testLoadedConfig = connector.getRepositoryConfiguration(configuration1.getRepositoryUrl());
        BugzillaConfigurationTest.assertEquals((int)1, (int)testLoadedConfig.getOptionValues(BugzillaAttribute.PRODUCT).size());
        BugzillaConfigurationTest.assertEquals((String)((String)configuration1.getOptionValues(BugzillaAttribute.PRODUCT).get(0)), (String)((String)testLoadedConfig.getOptionValues(BugzillaAttribute.PRODUCT).get(0)));
    }

    public void testNullCacheFile() {
        BugzillaRepositoryConnector connector = new BugzillaRepositoryConnector();
        connector.readRepositoryConfigurationFile();
        RepositoryConfiguration configuration1 = new RepositoryConfiguration();
        configuration1.setRepositoryUrl("url1");
        configuration1.addProduct("Test Product 1");
        BugzillaConfigurationTest.assertNull((Object)connector.getRepositoryConfiguration(configuration1.getRepositoryUrl()));
        connector.addRepositoryConfiguration(configuration1);
        BugzillaConfigurationTest.assertNotNull((Object)connector.getRepositoryConfiguration(configuration1.getRepositoryUrl()));
        connector = new BugzillaRepositoryConnector();
        connector.readRepositoryConfigurationFile();
        BugzillaConfigurationTest.assertNull((Object)connector.getRepositoryConfiguration(configuration1.getRepositoryUrl()));
    }

    public void testRepositoryConfigurationFromFile() throws Exception {
        BufferedReader inCleaned = null;
        try {
            File tempFile = File.createTempFile("XmlCleaner-", "tmp");
            tempFile.deleteOnExit();
            InputStream stream = BugzillaFixture.getResource("testdata/configuration/rdfconfig218.txt");
            BufferedReader in = new BufferedReader(new InputStreamReader(stream));
            try {
                inCleaned = XmlCleaner.clean((Reader)in, (File)tempFile);
                if (tempFile != null) {
                    tempFile.delete();
                }
            }
            finally {
                in.close();
            }
            SaxConfigurationContentHandler contentHandler = new SaxConfigurationContentHandler();
            XMLReader reader = CoreUtil.newXmlReader();
            reader.setContentHandler((ContentHandler)contentHandler);
            reader.setErrorHandler(new ErrorHandler(){

                @Override
                public void error(SAXParseException exception) throws SAXException {
                    throw exception;
                }

                @Override
                public void fatalError(SAXParseException exception) throws SAXException {
                    throw exception;
                }

                @Override
                public void warning(SAXParseException exception) throws SAXException {
                    throw exception;
                }
            });
            reader.parse(new InputSource(inCleaned));
            RepositoryConfiguration config = contentHandler.getConfiguration();
            BugzillaConfigurationTest.assertNotNull((Object)config);
            BugzillaConfigurationTest.assertTrue((boolean)config.getOptionValues(BugzillaAttribute.PRODUCT).contains("Test-Long-Named-Product-AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA"));
        }
        finally {
            if (inCleaned != null) {
                inCleaned.close();
            }
        }
    }
}

