/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.wikitext.mediawiki.core.tasks;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.taskdefs.Get;
import org.eclipse.mylyn.internal.wikitext.mediawiki.core.tasks.ImageFetchingStrategy;
import org.eclipse.mylyn.wikitext.core.util.IgnoreDtdEntityResolver;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

class MediaWikiApiImageFetchingStrategy
extends ImageFetchingStrategy {
    private final Pattern imageTitlePattern = Pattern.compile("(?:Image|File):(.+)");
    private URL url;
    private String pageName;

    MediaWikiApiImageFetchingStrategy() {
    }

    @Override
    public Set<String> fetchImages() {
        String base;
        if (this.pageName == null || this.pageName.length() == 0) {
            throw new BuildException("please specify @pageName");
        }
        if (!this.pageName.equals(this.pageName.trim())) {
            throw new BuildException("@pageName must not have leading or trailing whitespace");
        }
        try {
            base = this.url.toURI().toString();
        }
        catch (URISyntaxException e) {
            throw new BuildException((Throwable)e);
        }
        if (!base.endsWith("/")) {
            base = String.valueOf(base) + "/";
        }
        ImageFetchingContentHandler contentHandler = new ImageFetchingContentHandler();
        String gimcontinue = null;
        HashSet<String> filenames = new HashSet<String>();
        SAXParserFactory parserFactory = SAXParserFactory.newInstance();
        parserFactory.setNamespaceAware(true);
        parserFactory.setValidating(false);
        int maxloop = 100;
        do {
            InputStreamReader input;
            URL apiUrl;
            contentHandler.setGimcontinue(null);
            try {
                String queryString = String.format("action=query&titles=%s&generator=images&prop=imageinfo&iiprop=url&format=xml%s", URLEncoder.encode(this.pageName, "UTF-8"), gimcontinue == null ? "" : "&gimcontinue=" + URLEncoder.encode(gimcontinue, "UTF-8"));
                apiUrl = new URL(String.valueOf(base) + "api.php?" + queryString);
            }
            catch (Exception e) {
                throw new BuildException("Cannot compose API URL", (Throwable)e);
            }
            try {
                this.log("Fetching " + apiUrl, 3);
                input = new InputStreamReader((InputStream)new BufferedInputStream(apiUrl.openStream()), "UTF-8");
            }
            catch (IOException e) {
                throw new BuildException(String.format("Cannot contact %s: %s", apiUrl, e.getMessage()), (Throwable)e);
            }
            try {
                SAXParser saxParser = parserFactory.newSAXParser();
                XMLReader xmlReader = saxParser.getXMLReader();
                xmlReader.setEntityResolver((EntityResolver)IgnoreDtdEntityResolver.getInstance());
                xmlReader.setContentHandler(contentHandler);
                try {
                    try {
                        xmlReader.parse(new InputSource(input));
                        gimcontinue = contentHandler.getGimcontinue();
                    }
                    catch (IOException e) {
                        throw new BuildException(String.format("Unexpected exception retrieving data from %s", apiUrl), (Throwable)e);
                    }
                }
                catch (Throwable throwable) {
                    try {
                        ((Reader)input).close();
                    }
                    catch (IOException iOException) {}
                    throw throwable;
                }
                try {
                    ((Reader)input).close();
                }
                catch (IOException iOException) {}
            }
            catch (SAXException e) {
                throw new BuildException("Unexpected error in XML content", (Throwable)e);
            }
            catch (ParserConfigurationException e) {
                throw new BuildException("Cannot configure SAX parser", (Throwable)e);
            }
        } while (gimcontinue != null && maxloop-- > 0);
        int fileCount = 0;
        for (Map.Entry ent : contentHandler.imageTitleToUrl.entrySet()) {
            String title = (String)ent.getKey();
            String imageUrl = (String)ent.getValue();
            Matcher titleMatcher = this.imageTitlePattern.matcher(title);
            if (titleMatcher.matches()) {
                String name = titleMatcher.group(1);
                name = name.replace(' ', '_');
                String qualifiedUrl = base;
                qualifiedUrl = imageUrl.matches("https?://.*") ? imageUrl : (imageUrl.startsWith("/") ? String.valueOf(qualifiedUrl) + imageUrl.substring(1) : String.valueOf(qualifiedUrl) + imageUrl);
                this.log("Fetching " + qualifiedUrl, 2);
                Get get = new Get();
                get.setProject(this.getProject());
                get.setLocation(this.getLocation());
                try {
                    get.setSrc(new URL(qualifiedUrl));
                }
                catch (MalformedURLException e) {
                    this.log("Skipping " + this.url + ": " + e.getMessage(), 1);
                    continue;
                }
                get.setDest(new File(this.dest, name));
                get.execute();
                filenames.add(name);
                ++fileCount;
                continue;
            }
            this.log(String.format("Unexpected title format: %s", title), 1);
        }
        this.log("Fetched " + fileCount + " image files for " + this.pageName, 2);
        return filenames;
    }

    public URL getUrl() {
        return this.url;
    }

    public void setUrl(URL url) {
        this.url = url;
    }

    public String getPageName() {
        return this.pageName;
    }

    public void setPageName(String pageName) {
        this.pageName = pageName;
    }

    private class ImageFetchingContentHandler
    implements ContentHandler {
        private final Map<String, String> imageTitleToUrl = new HashMap<String, String>();
        private String currentPage = null;
        private boolean inImageInfo = false;
        private String gimcontinue = null;

        private ImageFetchingContentHandler() {
        }

        public void setGimcontinue(String gimcontinue) {
            this.gimcontinue = gimcontinue;
        }

        public String getGimcontinue() {
            return this.gimcontinue;
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
            if ("page".equals(localName)) {
                this.currentPage = atts.getValue("title");
            } else if ("images".equals(localName)) {
                this.gimcontinue = atts.getValue("gimcontinue");
            } else if ("imageinfo".equals(localName)) {
                this.inImageInfo = true;
            } else if (this.inImageInfo && "ii".equals(localName)) {
                this.imageTitleToUrl.put(this.currentPage, atts.getValue("url"));
            }
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            if ("page".equals(localName)) {
                this.currentPage = null;
            } else if ("imageinfo".equals(localName)) {
                this.inImageInfo = false;
            }
        }

        @Override
        public void characters(char[] ch, int start, int length) throws SAXException {
        }

        @Override
        public void endDocument() throws SAXException {
        }

        @Override
        public void endPrefixMapping(String prefix) throws SAXException {
        }

        @Override
        public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
        }

        @Override
        public void processingInstruction(String target, String data) throws SAXException {
        }

        @Override
        public void setDocumentLocator(Locator locator) {
        }

        @Override
        public void skippedEntity(String name) throws SAXException {
        }

        @Override
        public void startDocument() throws SAXException {
        }

        @Override
        public void startPrefixMapping(String prefix, String uri) throws SAXException {
        }
    }
}

