/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.tasks.tests;

import junit.framework.TestCase;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.mylyn.commons.core.DelegatingProgressMonitor;
import org.eclipse.mylyn.commons.core.IDelegatingProgressMonitor;
import org.eclipse.mylyn.internal.tasks.core.TaskRepositoryManager;
import org.eclipse.mylyn.internal.tasks.core.TaskTask;
import org.eclipse.mylyn.internal.tasks.core.data.TaskDataManager;
import org.eclipse.mylyn.internal.tasks.ui.TasksUiPlugin;
import org.eclipse.mylyn.tasks.core.ITask;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.core.data.ITaskDataWorkingCopy;
import org.eclipse.mylyn.tasks.core.data.TaskAttribute;
import org.eclipse.mylyn.tasks.core.data.TaskData;
import org.eclipse.mylyn.tasks.core.data.TaskDataModel;
import org.eclipse.mylyn.tasks.tests.TaskTestUtil;
import org.eclipse.mylyn.tasks.ui.TasksUi;

public class TaskDataManagerTest
extends TestCase {
    private TaskDataManager taskDataManger;
    TaskRepository taskRepository;
    private TaskRepositoryManager taskRepositoryManager;

    protected void setUp() throws Exception {
        this.taskDataManger = TasksUiPlugin.getTaskDataManager();
        this.taskRepository = TaskTestUtil.createMockRepository();
        this.taskRepositoryManager = (TaskRepositoryManager)TasksUi.getRepositoryManager();
        TasksUi.getRepositoryManager().addRepository(this.taskRepository);
    }

    protected void tearDown() throws Exception {
        this.taskRepositoryManager.clearRepositories();
    }

    public void testPutUpdatedTaskData() throws Exception {
        TaskTask task = TaskTestUtil.createMockTask("1");
        task.setSynchronizationState(ITask.SynchronizationState.SYNCHRONIZED);
        TaskData taskData = TaskTestUtil.createTaskData(this.taskRepository, "1");
        this.taskDataManger.putUpdatedTaskData((ITask)task, taskData, true, null);
        TaskDataManagerTest.assertEquals((Object)ITask.SynchronizationState.SYNCHRONIZED, (Object)task.getSynchronizationState());
    }

    public void testIncomming() throws Exception {
        TaskTask task = TaskTestUtil.createMockTask("1");
        task.setSynchronizationState(ITask.SynchronizationState.SYNCHRONIZED);
        TaskData taskData = TaskTestUtil.createTaskData(this.taskRepository, "1");
        TaskAttribute root = taskData.getRoot();
        root.createAttribute("task.common.summary").setValue("my Task");
        this.taskDataManger.putUpdatedTaskData((ITask)task, taskData, true, null);
        TaskDataManagerTest.assertEquals((Object)ITask.SynchronizationState.INCOMING, (Object)task.getSynchronizationState());
    }

    public void testIncommingSupressed() throws Exception {
        TaskTask task = TaskTestUtil.createMockTask("1");
        task.setSynchronizationState(ITask.SynchronizationState.SYNCHRONIZED);
        TaskData taskData = TaskTestUtil.createTaskData(this.taskRepository, "1");
        TaskAttribute root = taskData.getRoot();
        TaskAttribute version = root.createAttribute("task.common.version");
        version.getMetaData().defaults().setKind("default");
        version.setValue("V1.0");
        this.taskDataManger.putUpdatedTaskData((ITask)task, taskData, true, null);
        TaskDataManagerTest.assertEquals((Object)ITask.SynchronizationState.INCOMING, (Object)task.getSynchronizationState());
        TaskDataManagerTest.assertEquals((String)"true", (String)task.getAttribute("task.common.suppress.incoming"));
    }

    public void testIncommingSupressedWithSave() throws Exception {
        TasksUi.getRepositoryManager().addRepository(this.taskRepository);
        TaskTask task = TaskTestUtil.createMockTask("1");
        task.setSynchronizationState(ITask.SynchronizationState.SYNCHRONIZED);
        TaskData taskData = TaskTestUtil.createTaskData(this.taskRepository, "1");
        this.taskDataManger.putUpdatedTaskData((ITask)task, taskData, true, null);
        ITaskDataWorkingCopy taskDataState1 = TasksUiPlugin.getTaskDataManager().getWorkingCopy((ITask)task);
        TaskDataModel model = new TaskDataModel(this.taskRepository, (ITask)task, taskDataState1);
        TaskAttribute root = model.getTaskData().getRoot();
        TaskAttribute version = root.createAttribute("task.common.version");
        version.getMetaData().defaults().setKind("default");
        version.setValue("V1.0");
        model.attributeChanged(version);
        model.save((IProgressMonitor)new NullProgressMonitor());
        TaskDataManagerTest.assertEquals((Object)ITask.SynchronizationState.OUTGOING, (Object)task.getSynchronizationState());
        this.taskDataManger.putSubmittedTaskData((ITask)task, taskData, (IDelegatingProgressMonitor)new DelegatingProgressMonitor());
        TaskDataManagerTest.assertEquals((Object)ITask.SynchronizationState.SYNCHRONIZED, (Object)task.getSynchronizationState());
        TaskDataManagerTest.assertNull((Object)task.getAttribute("task.common.suppress.incoming"));
    }

    public void testIncommingSupressedWithRead() throws Exception {
        TasksUi.getRepositoryManager().addRepository(this.taskRepository);
        TaskTask task = TaskTestUtil.createMockTask("1");
        task.setSynchronizationState(ITask.SynchronizationState.SYNCHRONIZED);
        TaskData taskData = TaskTestUtil.createTaskData(this.taskRepository, "1");
        this.taskDataManger.putUpdatedTaskData((ITask)task, taskData, true, null);
        ITaskDataWorkingCopy taskDataState1 = TasksUiPlugin.getTaskDataManager().getWorkingCopy((ITask)task);
        TaskDataModel model = new TaskDataModel(this.taskRepository, (ITask)task, taskDataState1);
        taskData = model.getTaskData();
        TaskAttribute root = taskData.getRoot();
        TaskAttribute version = root.createAttribute("task.common.version");
        version.getMetaData().defaults().setKind("default");
        version.setValue("V1.0");
        model.attributeChanged(version);
        model.save((IProgressMonitor)new NullProgressMonitor());
        TaskDataManagerTest.assertEquals((Object)ITask.SynchronizationState.OUTGOING, (Object)task.getSynchronizationState());
        this.taskDataManger.putSubmittedTaskData((ITask)task, taskData, (IDelegatingProgressMonitor)new DelegatingProgressMonitor());
        TaskDataManagerTest.assertEquals((Object)ITask.SynchronizationState.SYNCHRONIZED, (Object)task.getSynchronizationState());
        root = model.getTaskData().getRoot();
        version = root.createAttribute("task.common.version");
        version.getMetaData().defaults().setKind("default");
        version.setValue("V1.1");
        this.taskDataManger.putUpdatedTaskData((ITask)task, taskData, true, null);
        TaskDataManagerTest.assertEquals((Object)ITask.SynchronizationState.INCOMING, (Object)task.getSynchronizationState());
        TaskDataManagerTest.assertEquals((String)"true", (String)task.getAttribute("task.common.suppress.incoming"));
        TasksUiPlugin.getTaskDataManager().setTaskRead((ITask)task, false);
        TaskDataManagerTest.assertEquals((Object)ITask.SynchronizationState.INCOMING, (Object)task.getSynchronizationState());
        TaskDataManagerTest.assertEquals((String)"false", (String)task.getAttribute("task.common.suppress.incoming"));
    }
}

