/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.debug.ui;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IBreakpointsListener;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.mylyn.context.core.AbstractContextContributor;
import org.eclipse.mylyn.context.core.AbstractContextStructureBridge;
import org.eclipse.mylyn.context.core.ContextChangeEvent;
import org.eclipse.mylyn.context.core.ContextCore;
import org.eclipse.mylyn.context.core.IInteractionContext;
import org.eclipse.mylyn.internal.debug.ui.BreakpointsContextUtil;
import org.eclipse.mylyn.internal.debug.ui.BreakpointsListener;
import org.eclipse.mylyn.internal.debug.ui.BreakpointsStateUtil;
import org.eclipse.mylyn.internal.debug.ui.DebugUiPlugin;
import org.eclipse.mylyn.monitor.core.InteractionEvent;
import org.osgi.framework.Bundle;

public class BreakpointsContextContributor
extends AbstractContextContributor {
    public static final String AUTO_MANAGE_BREAKPOINTS = "org.eclipse.mylyn.context.breakpoints.auto.manage";
    private BreakpointsListener breakpointsListener;
    private final AbstractContextStructureBridge structureBridge = ContextCore.getStructureBridge((String)"breakpoint");

    public InputStream getDataAsStream(IInteractionContext context) {
        List<IBreakpoint> breakpoints = this.getContextBreakpoints(context);
        if (breakpoints.size() == 0) {
            return null;
        }
        return BreakpointsContextUtil.exportBreakpoints(breakpoints, (IProgressMonitor)new NullProgressMonitor());
    }

    public String getIdentifier() {
        return DebugUiPlugin.CONTRIBUTOR_ID;
    }

    public void contextChanged(ContextChangeEvent event) {
        if (!DebugUiPlugin.getDefault().getPreferenceStore().getBoolean(AUTO_MANAGE_BREAKPOINTS)) {
            if (event.getEventKind() == ContextChangeEvent.ContextChangeKind.DEACTIVATED && this.breakpointsListener != null) {
                DebugPlugin.getDefault().getBreakpointManager().removeBreakpointListener((IBreakpointsListener)this.breakpointsListener);
            }
            return;
        }
        BreakpointsStateUtil stateUtil = new BreakpointsStateUtil(Platform.getStateLocation((Bundle)DebugUiPlugin.getDefault().getBundle()));
        if (event.getEventKind() == ContextChangeEvent.ContextChangeKind.PRE_ACTIVATED) {
            stateUtil.saveState();
            this.breakpointsListener = new BreakpointsListener();
            DebugPlugin.getDefault().getBreakpointManager().addBreakpointListener((IBreakpointsListener)this.breakpointsListener);
            BreakpointsContextUtil.importBreakpoints(event.getContext(), (IProgressMonitor)new NullProgressMonitor());
        } else if (event.getEventKind() == ContextChangeEvent.ContextChangeKind.DEACTIVATED) {
            if (this.breakpointsListener != null) {
                DebugPlugin.getDefault().getBreakpointManager().removeBreakpointListener((IBreakpointsListener)this.breakpointsListener);
            }
            BreakpointsContextUtil.removeBreakpoints(this.getContextBreakpoints(event.getContext()));
            stateUtil.restoreState();
        }
    }

    private List<IBreakpoint> getContextBreakpoints(IInteractionContext context) {
        ArrayList<IBreakpoint> breakpoints = new ArrayList<IBreakpoint>();
        for (InteractionEvent element : context.getInteractionHistory()) {
            Object object = this.structureBridge.getObjectForHandle(element.getStructureHandle());
            if (object == null || !(object instanceof IBreakpoint)) continue;
            breakpoints.add((IBreakpoint)object);
        }
        return breakpoints;
    }
}

