/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.bugzilla.ui.editor;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.jface.fieldassist.FieldDecoration;
import org.eclipse.jface.fieldassist.FieldDecorationRegistry;
import org.eclipse.mylyn.commons.core.StatusHandler;
import org.eclipse.mylyn.commons.workbench.WorkbenchUtil;
import org.eclipse.mylyn.internal.bugzilla.core.BugzillaAttribute;
import org.eclipse.mylyn.internal.bugzilla.core.BugzillaOperation;
import org.eclipse.mylyn.internal.bugzilla.core.BugzillaRepositoryConnector;
import org.eclipse.mylyn.internal.bugzilla.core.BugzillaRepositoryResponse;
import org.eclipse.mylyn.internal.bugzilla.core.BugzillaStatus;
import org.eclipse.mylyn.internal.bugzilla.core.BugzillaTaskDataHandler;
import org.eclipse.mylyn.internal.bugzilla.core.BugzillaUserMatchResponse;
import org.eclipse.mylyn.internal.bugzilla.core.BugzillaVersion;
import org.eclipse.mylyn.internal.bugzilla.core.RepositoryConfiguration;
import org.eclipse.mylyn.internal.bugzilla.ui.editor.BugzillaCcAttributeEditor;
import org.eclipse.mylyn.internal.bugzilla.ui.editor.BugzillaFlagPart;
import org.eclipse.mylyn.internal.bugzilla.ui.editor.BugzillaKeywordAttributeEditor;
import org.eclipse.mylyn.internal.bugzilla.ui.editor.BugzillaPeoplePart;
import org.eclipse.mylyn.internal.bugzilla.ui.editor.BugzillaPlanningEditorPart;
import org.eclipse.mylyn.internal.bugzilla.ui.editor.BugzillaResponseDetailDialog;
import org.eclipse.mylyn.internal.bugzilla.ui.editor.BugzillaTaskEditorCommentPart;
import org.eclipse.mylyn.internal.bugzilla.ui.editor.BugzillaTaskEditorDescriptionPart;
import org.eclipse.mylyn.internal.bugzilla.ui.editor.BugzillaTaskEditorNewCommentPart;
import org.eclipse.mylyn.internal.bugzilla.ui.editor.BugzillaVotesEditor;
import org.eclipse.mylyn.internal.bugzilla.ui.editor.FlagAttributeEditor;
import org.eclipse.mylyn.internal.bugzilla.ui.editor.Messages;
import org.eclipse.mylyn.internal.tasks.ui.PersonProposalProvider;
import org.eclipse.mylyn.internal.tasks.ui.editors.PersonAttributeEditor;
import org.eclipse.mylyn.internal.tasks.ui.editors.TaskEditorActionPart;
import org.eclipse.mylyn.tasks.core.RepositoryResponse;
import org.eclipse.mylyn.tasks.core.RepositoryStatus;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.core.data.TaskAttribute;
import org.eclipse.mylyn.tasks.core.data.TaskAttributeMetaData;
import org.eclipse.mylyn.tasks.core.data.TaskData;
import org.eclipse.mylyn.tasks.core.data.TaskDataModel;
import org.eclipse.mylyn.tasks.core.data.TaskDataModelEvent;
import org.eclipse.mylyn.tasks.core.data.TaskDataModelListener;
import org.eclipse.mylyn.tasks.core.sync.SubmitJobEvent;
import org.eclipse.mylyn.tasks.ui.TasksUi;
import org.eclipse.mylyn.tasks.ui.TasksUiUtil;
import org.eclipse.mylyn.tasks.ui.editors.AbstractAttributeEditor;
import org.eclipse.mylyn.tasks.ui.editors.AbstractTaskEditorPage;
import org.eclipse.mylyn.tasks.ui.editors.AbstractTaskEditorPart;
import org.eclipse.mylyn.tasks.ui.editors.AttributeEditorFactory;
import org.eclipse.mylyn.tasks.ui.editors.LayoutHint;
import org.eclipse.mylyn.tasks.ui.editors.TaskEditor;
import org.eclipse.mylyn.tasks.ui.editors.TaskEditorInput;
import org.eclipse.mylyn.tasks.ui.editors.TaskEditorPartDescriptor;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.keys.IBindingService;
import org.eclipse.ui.services.IServiceLocator;

public class BugzillaTaskEditorPage
extends AbstractTaskEditorPage {
    public static final String ID_PART_BUGZILLA_PLANNING = "org.eclipse.mylyn.bugzilla.ui.editors.part.planning";
    public static final String ID_PART_BUGZILLA_FLAGS = "org.eclipse.mylyn.bugzilla.ui.editors.part.flags";
    public static final String PATH_FLAGS = "flags";
    private final Map<TaskAttribute, AbstractAttributeEditor> attributeEditorMap;
    private TaskDataModelListener productListener;
    private final List<ControlDecoration> errorDecorations = new ArrayList<ControlDecoration>();
    private final List<PersonAttributeEditor> editorsWithError = new ArrayList<PersonAttributeEditor>(3);

    public BugzillaTaskEditorPage(TaskEditor editor) {
        this(editor, "bugzilla");
    }

    public BugzillaTaskEditorPage(TaskEditor editor, String connectorKind) {
        super(editor, connectorKind);
        this.attributeEditorMap = new HashMap<TaskAttribute, AbstractAttributeEditor>();
        this.setNeedsPrivateSection(true);
        this.setNeedsSubmitButton(true);
    }

    protected Set<TaskEditorPartDescriptor> createPartDescriptors() {
        Set descriptors = super.createPartDescriptors();
        boolean hasPartComments = false;
        boolean hasPartNewComment = false;
        boolean hasPartDescription = false;
        for (TaskEditorPartDescriptor taskEditorPartDescriptor : descriptors) {
            if (!taskEditorPartDescriptor.getId().equals("org.eclipse.mylyn.tasks.ui.editors.parts.people")) continue;
            descriptors.remove(taskEditorPartDescriptor);
            break;
        }
        for (TaskEditorPartDescriptor taskEditorPartDescriptor : descriptors) {
            if (!taskEditorPartDescriptor.getId().equals("org.eclipse.mylyn.tasks.ui.editors.parts.comments")) continue;
            descriptors.remove(taskEditorPartDescriptor);
            hasPartComments = true;
            break;
        }
        for (TaskEditorPartDescriptor taskEditorPartDescriptor : descriptors) {
            if (!taskEditorPartDescriptor.getId().equals("org.eclipse.mylyn.tasks.ui.editors.parts.newComment")) continue;
            descriptors.remove(taskEditorPartDescriptor);
            hasPartNewComment = true;
            break;
        }
        for (TaskEditorPartDescriptor taskEditorPartDescriptor : descriptors) {
            if (!taskEditorPartDescriptor.getId().equals("org.eclipse.mylyn.tasks.ui.editors.parts.descriptions")) continue;
            descriptors.remove(taskEditorPartDescriptor);
            hasPartDescription = true;
            break;
        }
        try {
            TaskData data = TasksUi.getTaskDataManager().getTaskData(this.getTask());
            if (data != null) {
                Map attributes = data.getRoot().getAttributes();
                for (TaskAttribute attribute : attributes.values()) {
                    if (!"task.common.kind.flag".equals(attribute.getMetaData().getKind())) continue;
                    descriptors.add(new TaskEditorPartDescriptor(ID_PART_BUGZILLA_FLAGS){

                        public AbstractTaskEditorPart createPart() {
                            return new BugzillaFlagPart();
                        }
                    }.setPath("org.eclipse.mylyn.tasks.ui.editors.parts.attributes/flags"));
                    break;
                }
                TaskAttribute attrEstimatedTime = data.getRoot().getMappedAttribute(BugzillaAttribute.ESTIMATED_TIME.getKey());
                if (attrEstimatedTime != null) {
                    descriptors.add(new TaskEditorPartDescriptor(ID_PART_BUGZILLA_PLANNING){

                        public AbstractTaskEditorPart createPart() {
                            return new BugzillaPlanningEditorPart();
                        }
                    }.setPath("org.eclipse.mylyn.tasks.ui.editors.parts.attributes/planning"));
                }
            }
            if (hasPartDescription) {
                descriptors.add(new TaskEditorPartDescriptor("org.eclipse.mylyn.tasks.ui.editors.parts.descriptions"){

                    public AbstractTaskEditorPart createPart() {
                        BugzillaTaskEditorDescriptionPart part = new BugzillaTaskEditorDescriptionPart();
                        if (BugzillaTaskEditorPage.this.getModel().getTaskData().isNew()) {
                            part.setExpandVertically(true);
                            part.setSectionStyle(320);
                        }
                        return part;
                    }
                }.setPath("comments"));
            }
            if (hasPartComments) {
                descriptors.add(new TaskEditorPartDescriptor("org.eclipse.mylyn.tasks.ui.editors.parts.comments"){

                    public AbstractTaskEditorPart createPart() {
                        return new BugzillaTaskEditorCommentPart();
                    }
                }.setPath("comments"));
            }
        }
        catch (CoreException coreException) {}
        if (hasPartNewComment) {
            descriptors.add(new TaskEditorPartDescriptor("org.eclipse.mylyn.tasks.ui.editors.parts.newComment"){

                public AbstractTaskEditorPart createPart() {
                    return new BugzillaTaskEditorNewCommentPart();
                }
            }.setPath("comments"));
        }
        descriptors.add(new TaskEditorPartDescriptor("org.eclipse.mylyn.tasks.ui.editors.parts.people"){

            public AbstractTaskEditorPart createPart() {
                return new BugzillaPeoplePart();
            }
        }.setPath("people"));
        return descriptors;
    }

    protected AttributeEditorFactory createAttributeEditorFactory() {
        AttributeEditorFactory factory = new AttributeEditorFactory(this.getModel(), this.getTaskRepository(), (IServiceLocator)this.getEditorSite()){

            public AbstractAttributeEditor createEditor(String type, TaskAttribute taskAttribute) {
                Object editor;
                if ("bugzilla.editor.keywords".equals(type)) {
                    editor = new BugzillaKeywordAttributeEditor(BugzillaTaskEditorPage.this.getModel(), taskAttribute);
                } else if ("bugzilla.editor.removecc".equals(type)) {
                    editor = new BugzillaCcAttributeEditor(BugzillaTaskEditorPage.this.getModel(), taskAttribute);
                } else if ("bugzilla.editor.votes".equals(type)) {
                    editor = new BugzillaVotesEditor(BugzillaTaskEditorPage.this.getModel(), taskAttribute);
                } else if ("bugzilla.editor.flag".equals(type)) {
                    editor = new FlagAttributeEditor(BugzillaTaskEditorPage.this.getModel(), taskAttribute);
                } else {
                    editor = super.createEditor(type, taskAttribute);
                    if ("boolean".equals(type)) {
                        editor.setDecorationEnabled(false);
                    }
                }
                if (editor != null && taskAttribute.getId().startsWith("cf_")) {
                    editor.setLayoutHint(new LayoutHint(editor.getLayoutHint()){

                        public int getPriority() {
                            return super.getPriority() * 10;
                        }
                    });
                }
                TaskAttributeMetaData properties = taskAttribute.getMetaData();
                if (editor != null && "bugzilla.editor.flag".equals(properties.getType())) {
                    editor.setLayoutHint(new LayoutHint(editor.getLayoutHint()){

                        public int getPriority() {
                            return super.getPriority() * 5;
                        }
                    });
                }
                BugzillaTaskEditorPage.this.addToAttributeEditorMap(taskAttribute, (AbstractAttributeEditor)editor);
                return editor;
            }
        };
        return factory;
    }

    public void doSubmit() {
        String tokenString;
        TaskAttribute attrToken;
        String dupValue;
        TaskAttribute inputAttribute;
        TaskAttribute originalOperation;
        String inputAttributeId;
        TaskAttribute summaryAttribute = this.getModel().getTaskData().getRoot().getMappedAttribute("task.common.summary");
        if (summaryAttribute != null && summaryAttribute.getValue().length() == 0) {
            this.getTaskEditor().setMessage(Messages.BugzillaTaskEditorPage_Please_enter_a_short_summary_before_submitting, 3);
            AbstractTaskEditorPart part = this.getPart("org.eclipse.mylyn.tasks.ui.editors.parts.summary");
            if (part != null) {
                part.setFocus();
            }
            return;
        }
        TaskAttribute componentAttribute = this.getModel().getTaskData().getRoot().getMappedAttribute(BugzillaAttribute.COMPONENT.getKey());
        if (componentAttribute != null && componentAttribute.getValue().length() == 0) {
            this.getTaskEditor().setMessage(Messages.BugzillaTaskEditorPage_Please_select_a_component_before_submitting, 3);
            AbstractTaskEditorPart part = this.getPart("org.eclipse.mylyn.tasks.ui.editors.parts.attributes");
            if (part != null) {
                part.setFocus();
            }
            return;
        }
        TaskAttribute descriptionAttribute = this.getModel().getTaskData().getRoot().getMappedAttribute("task.common.description");
        if (descriptionAttribute != null && descriptionAttribute.getValue().length() == 0 && this.getModel().getTaskData().isNew()) {
            this.getTaskEditor().setMessage(Messages.BugzillaTaskEditorPage_Please_enter_a_description_before_submitting, 3);
            AbstractTaskEditorPart descriptionPart = this.getPart("org.eclipse.mylyn.tasks.ui.editors.parts.descriptions");
            if (descriptionPart != null) {
                descriptionPart.setFocus();
            }
            return;
        }
        TaskAttribute targetMilestoneAttribute = this.getModel().getTaskData().getRoot().getMappedAttribute(BugzillaAttribute.TARGET_MILESTONE.getKey());
        if (targetMilestoneAttribute != null && targetMilestoneAttribute.getValue().length() == 0 && this.getModel().getTaskData().isNew()) {
            this.getTaskEditor().setMessage(Messages.BugzillaTaskEditorPage_Please_enter_a_target_milestone_before_submitting, 3);
            AbstractTaskEditorPart descriptionPart = this.getPart("org.eclipse.mylyn.tasks.ui.editors.parts.attributes");
            if (descriptionPart != null) {
                descriptionPart.setFocus();
            }
            return;
        }
        TaskAttribute attributeOperation = this.getModel().getTaskData().getRoot().getMappedAttribute("task.common.operation");
        if (attributeOperation != null && "duplicate".equals(attributeOperation.getValue()) && (inputAttributeId = (originalOperation = this.getModel().getTaskData().getRoot().getAttribute("task.common.operation-" + attributeOperation.getValue())).getMetaData().getValue("task.meta.associated.attribute")) != null && !inputAttributeId.equals("") && (inputAttribute = attributeOperation.getTaskData().getRoot().getAttribute(inputAttributeId)) != null && ((dupValue = inputAttribute.getValue()) == null || dupValue.equals(""))) {
            this.getTaskEditor().setMessage(Messages.BugzillaTaskEditorPage_Please_enter_a_bugid_for_duplicate_of_before_submitting, 3);
            AbstractTaskEditorPart part = this.getPart("org.eclipse.mylyn.tasks.ui.editors.parts.actions");
            if (part != null) {
                part.setFocus();
            }
            return;
        }
        if (this.getModel().getTaskData().isNew()) {
            TaskAttribute componentSelectedAttribute;
            TaskAttribute productAttribute = this.getModel().getTaskData().getRoot().getMappedAttribute("task.common.product");
            if (productAttribute != null && productAttribute.getValue().length() > 0) {
                this.getModel().getTaskRepository().setProperty("last.selection.product", productAttribute.getValue());
            }
            if ((componentSelectedAttribute = this.getModel().getTaskData().getRoot().getMappedAttribute("task.common.component")) != null && componentSelectedAttribute.getValue().length() > 0) {
                this.getModel().getTaskRepository().setProperty("last.selection.component", componentSelectedAttribute.getValue());
            }
        }
        if ((attrToken = this.getModel().getTaskData().getRoot().getAttribute(BugzillaAttribute.TOKEN.getKey())) != null && (tokenString = this.getModel().getTask().getAttribute(BugzillaAttribute.TOKEN.getKey())) != null) {
            attrToken.setValue(tokenString);
        }
        for (ControlDecoration decoration : this.errorDecorations) {
            decoration.hide();
            decoration.dispose();
        }
        this.errorDecorations.clear();
        this.editorsWithError.clear();
        if (!this.checkCanSubmit(3)) {
            return;
        }
        this.getTaskEditor().setMessage("", 0);
        super.doSubmit();
    }

    protected void createParts() {
        this.attributeEditorMap.clear();
        super.createParts();
        this.checkCanSubmit(1);
    }

    protected TaskDataModel createModel(TaskEditorInput input) throws CoreException {
        TaskDataModel model = super.createModel(input);
        this.productListener = new ProductSelectionListener();
        model.addModelListener(this.productListener);
        return model;
    }

    private void addToAttributeEditorMap(TaskAttribute attribute, AbstractAttributeEditor editor) {
        if (this.attributeEditorMap.containsKey(attribute)) {
            this.attributeEditorMap.remove(attribute);
        }
        this.attributeEditorMap.put(attribute, editor);
    }

    private AbstractAttributeEditor getEditorForAttribute(TaskAttribute attribute) {
        return this.attributeEditorMap.get(attribute);
    }

    private void refresh(TaskAttribute attributeComponent) {
        AbstractAttributeEditor editor = this.getEditorForAttribute(attributeComponent);
        if (editor != null) {
            try {
                editor.refresh();
            }
            catch (UnsupportedOperationException unsupportedOperationException) {}
        }
    }

    protected void handleTaskSubmitted(SubmitJobEvent event) {
        if (event.getJob().getStatus() != null) {
            switch (event.getJob().getStatus().getCode()) {
                case 1024: 
                case 1025: {
                    this.showError((BugzillaStatus)event.getJob().getStatus());
                    return;
                }
            }
        }
        if (event.getJob().getResponse() != null && event.getJob().getResponse() instanceof BugzillaRepositoryResponse) {
            RepositoryResponse response = event.getJob().getResponse();
            if (response instanceof BugzillaRepositoryResponse) {
                final BugzillaRepositoryResponse bugzillaResponse = (BugzillaRepositoryResponse)response;
                if (bugzillaResponse.getResponseData().size() > 0) {
                    this.getTaskEditor().setMessage(Messages.BugzillaTaskEditorPage_Changes_Submitted_Message, 1, (IHyperlinkListener)new HyperlinkAdapter(){

                        public void linkActivated(HyperlinkEvent event) {
                            BugzillaTaskEditorPage.this.showSubmitResponse(bugzillaResponse);
                        }
                    });
                } else {
                    this.getTaskEditor().setMessage(Messages.BugzillaTaskEditorPage_Changes_Submitted_Message, 1);
                }
            }
        } else {
            super.handleTaskSubmitted(event);
        }
    }

    public void refresh() {
        super.refresh();
        this.checkCanSubmit(1);
    }

    private boolean checkCanSubmit(final int type) {
        TaskAttribute exporter;
        final TaskRepository taskRepository = this.getModel().getTaskRepository();
        String username = taskRepository.getUserName();
        if (username == null || username.length() == 0) {
            PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    BugzillaTaskEditorPage.this.getTaskEditor().setMessage(Messages.BugzillaTaskEditorPage_Anonymous_can_not_submit_Tasks, type, (IHyperlinkListener)new HyperlinkAdapter(){

                        public void linkActivated(HyperlinkEvent e) {
                            TasksUiUtil.openEditRepositoryWizard((TaskRepository)taskRepository);
                            BugzillaTaskEditorPage.this.refresh();
                        }
                    });
                }
            });
            return false;
        }
        if (!this.getModel().getTaskData().isNew() && ((exporter = this.getModel().getTaskData().getRoot().getAttribute(BugzillaAttribute.EXPORTER_NAME.getKey())) == null || exporter.getValue().equals(""))) {
            PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    BugzillaTaskEditorPage.this.getTaskEditor().setMessage(Messages.BugzillaTaskEditorPage_submit_disabled_please_refresh, type, (IHyperlinkListener)new HyperlinkAdapter(){

                        public void linkActivated(HyperlinkEvent e) {
                            TasksUiUtil.openEditRepositoryWizard((TaskRepository)taskRepository);
                            BugzillaTaskEditorPage.this.refresh();
                        }
                    });
                }
            });
            return false;
        }
        return true;
    }

    private void showError(BugzillaStatus bugzillaStatus) {
        int count = 0;
        BugzillaUserMatchResponse response = bugzillaStatus.getUserMatchResponse();
        FieldDecorationRegistry registry = FieldDecorationRegistry.getDefault();
        FieldDecoration fieldDecoration = registry.getFieldDecoration("DEC_ERROR");
        FieldDecoration fieldDecorationWarning = registry.getFieldDecoration("DEC_WARNING");
        StringBuilder fields = new StringBuilder();
        StringBuilder detail = new StringBuilder();
        count += this.decorateControlsAndUpdateMessages(response.getAssignedToMsg(), response.getAssignedToProposals(), this.getModel().getTaskData().getRoot().getAttribute(BugzillaAttribute.ASSIGNED_TO.getKey()), fields, detail, fieldDecoration, fieldDecorationWarning);
        count += this.decorateControlsAndUpdateMessages(response.getQaContactMsg(), response.getQaContactProposals(), this.getModel().getTaskData().getRoot().getAttribute(BugzillaAttribute.QA_CONTACT.getKey()), fields, detail, fieldDecoration, fieldDecorationWarning);
        this.updateTaskEditorPageMessageWithError(bugzillaStatus, detail.toString(), (count += this.decorateControlsAndUpdateMessages(response.getNewCCMsg(), response.getNewCCProposals(), this.getModel().getTaskData().getRoot().getAttribute(BugzillaAttribute.NEWCC.getKey()), fields, detail, fieldDecoration, fieldDecorationWarning)) == 1, fields.toString());
    }

    private int decorateControlsAndUpdateMessages(String message, List<String> proposals, TaskAttribute attribute, StringBuilder fields, StringBuilder detail, FieldDecoration fieldDecoration, FieldDecoration fieldDecorationWarning) {
        if (attribute == null || message == null && proposals.size() == 0) {
            return 0;
        }
        HashMap<String, String> newPersonProposalMap = new HashMap<String, String>();
        if (fields.length() > 0) {
            fields.append(MessageFormat.format(Messages.BugzillaTaskEditorPage_Error_Label_N, attribute.getMetaData().getLabel()));
        } else {
            fields.append(MessageFormat.format(Messages.BugzillaTaskEditorPage_Error_Label_1, attribute.getMetaData().getLabel()));
        }
        detail.append(String.valueOf(attribute.getMetaData().getLabel()) + "\n");
        if (message != null && !message.equals("")) {
            detail.append(MessageFormat.format(Messages.BugzillaTaskEditorPage_DetailLine, message));
        } else {
            for (String proposalValue : proposals) {
                detail.append(MessageFormat.format(Messages.BugzillaTaskEditorPage_DetailLine, proposalValue));
                newPersonProposalMap.put(proposalValue, proposalValue);
            }
        }
        AbstractAttributeEditor editor = this.getEditorForAttribute(attribute);
        if (editor != null) {
            this.decorateEditorWithError(fieldDecoration, fieldDecorationWarning, message, newPersonProposalMap, editor);
        }
        return 1;
    }

    private int decorateControlsAndUpdateMessages(String message, Map<String, List<String>> proposals, TaskAttribute attribute, StringBuilder fields, StringBuilder detail, FieldDecoration fieldDecoration, FieldDecoration fieldDecorationWarning) {
        if (attribute == null || message == null && proposals.size() == 0) {
            return 0;
        }
        HashMap<String, String> newPersonProposalMap = new HashMap<String, String>();
        if (fields.length() > 0) {
            fields.append(MessageFormat.format(Messages.BugzillaTaskEditorPage_Error_Label_N, attribute.getMetaData().getLabel()));
        } else {
            fields.append(MessageFormat.format(Messages.BugzillaTaskEditorPage_Error_Label_1, attribute.getMetaData().getLabel()));
        }
        detail.append(String.valueOf(attribute.getMetaData().getLabel()) + "\n");
        if (message != null && !message.equals("")) {
            detail.append(MessageFormat.format(Messages.BugzillaTaskEditorPage_DetailLine, message));
        } else {
            for (String key : proposals.keySet()) {
                detail.append(MessageFormat.format(Messages.BugzillaTaskEditorPage_Proposal_Detail, key));
                for (String proposalValue : proposals.get(key)) {
                    detail.append(MessageFormat.format(Messages.BugzillaTaskEditorPage_DetailLine, proposalValue));
                    newPersonProposalMap.put(proposalValue, proposalValue);
                }
            }
        }
        AbstractAttributeEditor editor = this.getEditorForAttribute(attribute);
        if (editor != null) {
            this.decorateEditorWithError(fieldDecoration, fieldDecorationWarning, message, newPersonProposalMap, editor);
        }
        return 1;
    }

    private void updateTaskEditorPageMessageWithError(BugzillaStatus bugzillaStatus, String resultDetail, boolean oneError, String fieldString) {
        String titleString;
        String resultString;
        switch (bugzillaStatus.getCode()) {
            case 1024: {
                resultString = oneError ? MessageFormat.format(Messages.BugzillaTaskEditorPage_Message_one, Messages.BugzillaTaskEditorPage_Confirm, fieldString) : MessageFormat.format(Messages.BugzillaTaskEditorPage_Message_more, Messages.BugzillaTaskEditorPage_Confirm, fieldString);
                titleString = Messages.BugzillaTaskEditorPage_ConfirmDetailTitle;
                break;
            }
            case 1025: {
                resultString = oneError ? MessageFormat.format(Messages.BugzillaTaskEditorPage_Message_one, Messages.BugzillaTaskEditorPage_Error, fieldString) : MessageFormat.format(Messages.BugzillaTaskEditorPage_Message_more, Messages.BugzillaTaskEditorPage_Error, fieldString);
                titleString = Messages.BugzillaTaskEditorPage_ErrorDetailTitle;
                break;
            }
            default: {
                throw new RuntimeException("unexpected BugzillaStatus: " + bugzillaStatus.getCode());
            }
        }
        final String resultDetailString = resultDetail;
        this.getTaskEditor().setMessage(resultString, 3, (IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent event) {
                BugzillaResponseDetailDialog dialog = new BugzillaResponseDetailDialog(WorkbenchUtil.getShell(), titleString, resultDetailString);
                dialog.open();
            }
        });
    }

    private void decorateEditorWithError(FieldDecoration fieldDecoration, FieldDecoration fieldDecorationWarning, String message, Map<String, String> newPersonProposalMap, AbstractAttributeEditor editor) {
        Control control = editor.getControl();
        final ControlDecoration decoration = new ControlDecoration(control, 17408);
        decoration.setImage(newPersonProposalMap.size() == 1 ? fieldDecorationWarning.getImage() : fieldDecoration.getImage());
        IBindingService bindingService = (IBindingService)PlatformUI.getWorkbench().getService(IBindingService.class);
        if (message != null && !message.equals("")) {
            decoration.setDescriptionText(message);
            this.errorDecorations.add(decoration);
        } else {
            decoration.setDescriptionText(NLS.bind((String)Messages.BugzillaTaskEditorPage_Content_Assist_for_Error_Available, (Object)bindingService.getBestActiveBindingFormattedFor("org.eclipse.ui.edit.text.contentAssist.proposals")));
            this.errorDecorations.add(decoration);
            PersonAttributeEditor personEditor = (PersonAttributeEditor)editor;
            final PersonProposalProvider personProposalProvider = (PersonProposalProvider)personEditor.getContentAssistCommandAdapter().getContentProposalProvider();
            personProposalProvider.setErrorProposals(newPersonProposalMap);
            this.editorsWithError.add(personEditor);
            if (newPersonProposalMap.size() == 1) {
                personEditor.setValue(newPersonProposalMap.keySet().iterator().next());
            }
            personEditor.getText().addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    decoration.hide();
                    BugzillaTaskEditorPage.this.errorDecorations.remove(decoration);
                    decoration.dispose();
                    personProposalProvider.setErrorProposals(null);
                }
            });
        }
    }

    private void showSubmitResponse(BugzillaRepositoryResponse bugzillaResponse) {
        StringBuilder message = new StringBuilder();
        for (String iterable_map : bugzillaResponse.getResponseData().keySet()) {
            if (message.length() > 0) {
                message.append("\n");
            }
            message.append(NLS.bind((String)Messages.BugzillaTaskEditorPage_Bug_Line, (Object)iterable_map));
            Map responseMap = (Map)bugzillaResponse.getResponseData().get(iterable_map);
            for (String iterable_list : responseMap.keySet()) {
                message.append(NLS.bind((String)Messages.BugzillaTaskEditorPage_Action_Line, (Object)iterable_list));
                List responseList = (List)responseMap.get(iterable_list);
                for (String string : responseList) {
                    message.append(NLS.bind((String)Messages.BugzillaTaskEditorPage_Email_Line, (Object)string));
                }
            }
        }
        BugzillaResponseDetailDialog dialog = new BugzillaResponseDetailDialog(WorkbenchUtil.getShell(), Messages.BugzillaTaskEditorPage_submitted_Changes_Details, message.toString());
        dialog.open();
    }

    private class ProductSelectionListener
    extends TaskDataModelListener {
        private ProductSelectionListener() {
        }

        public void attributeChanged(TaskDataModelEvent event) {
            TaskAttribute taskAttribute = event.getTaskAttribute();
            if (taskAttribute != null && taskAttribute.getId().equals(BugzillaAttribute.PRODUCT.getKey())) {
                TaskAttribute attributeConfirmeProductChange;
                TaskAttribute attributeDefaultAssignee;
                TaskAttribute attributeVersion;
                TaskAttribute attributeTargetMilestone;
                RepositoryConfiguration repositoryConfiguration = null;
                try {
                    BugzillaRepositoryConnector connector = (BugzillaRepositoryConnector)TasksUi.getRepositoryConnector((String)BugzillaTaskEditorPage.this.getModel().getTaskRepository().getConnectorKind());
                    repositoryConfiguration = connector.getRepositoryConfiguration(BugzillaTaskEditorPage.this.getModel().getTaskRepository(), false, (IProgressMonitor)new NullProgressMonitor());
                }
                catch (CoreException e) {
                    StatusHandler.log((IStatus)new RepositoryStatus(BugzillaTaskEditorPage.this.getTaskRepository(), 4, "org.eclipse.mylyn.bugzilla.ui", 0, "Failed to obtain repository configuration", (Throwable)e));
                    BugzillaTaskEditorPage.this.getTaskEditor().setMessage("Problem occured when updating attributes", 3);
                    return;
                }
                TaskAttribute attributeComponent = taskAttribute.getTaskData().getRoot().getMappedAttribute(BugzillaAttribute.COMPONENT.getKey());
                if (attributeComponent != null) {
                    List optionValues = repositoryConfiguration.getProductOptionValues(BugzillaAttribute.COMPONENT, taskAttribute.getValue());
                    Collections.sort(optionValues);
                    attributeComponent.clearOptions();
                    for (String option : optionValues) {
                        attributeComponent.putOption(option, option);
                    }
                    if (optionValues.size() > 0) {
                        attributeComponent.setValue((String)optionValues.get(0));
                    }
                    BugzillaTaskEditorPage.this.refresh(attributeComponent);
                }
                if ((attributeTargetMilestone = taskAttribute.getTaskData().getRoot().getMappedAttribute(BugzillaAttribute.TARGET_MILESTONE.getKey())) != null) {
                    List optionValues = repositoryConfiguration.getProductOptionValues(BugzillaAttribute.TARGET_MILESTONE, taskAttribute.getValue());
                    Collections.sort(optionValues);
                    attributeTargetMilestone.clearOptions();
                    for (String option : optionValues) {
                        attributeTargetMilestone.putOption(option, option);
                    }
                    String defaultMilestones = repositoryConfiguration.getDefaultMilestones(taskAttribute.getValue());
                    if (defaultMilestones != null) {
                        attributeTargetMilestone.setValue(defaultMilestones);
                    } else if (optionValues.size() == 1) {
                        attributeTargetMilestone.setValue((String)optionValues.get(0));
                    } else {
                        attributeTargetMilestone.setValue("---");
                    }
                    BugzillaTaskEditorPage.this.refresh(attributeTargetMilestone);
                }
                if ((attributeVersion = taskAttribute.getTaskData().getRoot().getMappedAttribute(BugzillaAttribute.VERSION.getKey())) != null) {
                    List optionValues = repositoryConfiguration.getProductOptionValues(BugzillaAttribute.VERSION, taskAttribute.getValue());
                    Collections.sort(optionValues);
                    attributeVersion.clearOptions();
                    for (String option : optionValues) {
                        attributeVersion.putOption(option, option);
                    }
                    if (optionValues.size() == 1) {
                        attributeVersion.setValue((String)optionValues.get(0));
                    } else {
                        attributeVersion.setValue("unspecified");
                    }
                    BugzillaTaskEditorPage.this.refresh(attributeVersion);
                }
                if ((attributeDefaultAssignee = taskAttribute.getTaskData().getRoot().getMappedAttribute(BugzillaAttribute.SET_DEFAULT_ASSIGNEE.getKey())) != null) {
                    attributeDefaultAssignee.setValue("1");
                    BugzillaTaskEditorPage.this.refresh(attributeDefaultAssignee);
                }
                if (taskAttribute.getTaskData().isNew()) {
                    BugzillaVersion bugzillaVersion = repositoryConfiguration.getInstallVersion();
                    if (bugzillaVersion == null) {
                        bugzillaVersion = BugzillaVersion.MIN_VERSION;
                    }
                    if (bugzillaVersion.compareMajorMinorOnly(BugzillaVersion.BUGZILLA_4_0) >= 0) {
                        AbstractTaskEditorPart part = BugzillaTaskEditorPage.this.getPart("org.eclipse.mylyn.tasks.ui.editors.parts.actions");
                        boolean unconfirmedAllowed = repositoryConfiguration.getUnconfirmedAllowed(taskAttribute.getValue());
                        TaskAttribute unconfirmedAttribute = taskAttribute.getTaskData().getRoot().getAttribute("task.common.operation-" + BugzillaOperation.unconfirmed.toString());
                        if (unconfirmedAttribute != null) {
                            unconfirmedAttribute.getMetaData().setReadOnly(!unconfirmedAllowed);
                        }
                        if (part != null) {
                            TaskEditorActionPart actionPart = (TaskEditorActionPart)part;
                            actionPart.refreshOperations();
                        }
                    }
                }
                if ((attributeConfirmeProductChange = taskAttribute.getTaskData().getRoot().getMappedAttribute(BugzillaAttribute.CONFIRM_PRODUCT_CHANGE.getKey())) == null) {
                    attributeConfirmeProductChange = BugzillaTaskDataHandler.createAttribute((TaskAttribute)taskAttribute.getTaskData().getRoot(), (BugzillaAttribute)BugzillaAttribute.CONFIRM_PRODUCT_CHANGE);
                }
                if (attributeConfirmeProductChange != null) {
                    attributeConfirmeProductChange.setValue("1");
                }
            }
        }
    }
}

