/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.gerrit.core.remote;

import com.google.gerrit.common.data.PatchSetDetail;
import com.google.gerrit.reviewdb.PatchSet;
import java.util.Date;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.mylyn.internal.gerrit.core.client.GerritChange;
import org.eclipse.mylyn.internal.gerrit.core.remote.GerritRemoteFactoryProvider;
import org.eclipse.mylyn.internal.gerrit.core.remote.GerritReviewRemoteFactory;
import org.eclipse.mylyn.internal.gerrit.core.remote.Messages;
import org.eclipse.mylyn.reviews.core.model.IReview;
import org.eclipse.mylyn.reviews.core.model.IReviewItemSet;
import org.eclipse.mylyn.reviews.core.model.IReviewsFactory;
import org.eclipse.mylyn.reviews.core.spi.remote.emf.AbstractRemoteEmfFactoryProvider;
import org.eclipse.mylyn.reviews.core.spi.remote.emf.RemoteEmfConsumer;
import org.eclipse.mylyn.reviews.core.spi.remote.review.ReviewItemSetRemoteFactory;
import org.eclipse.osgi.util.NLS;

public class PatchSetDetailRemoteFactory
extends ReviewItemSetRemoteFactory<PatchSetDetail, PatchSetDetail> {
    public PatchSetDetailRemoteFactory(GerritRemoteFactoryProvider gerritRemoteFactoryProvider) {
        super((AbstractRemoteEmfFactoryProvider)gerritRemoteFactoryProvider);
    }

    public PatchSetDetail pull(IReview parent, PatchSetDetail remoteKey, IProgressMonitor monitor) throws CoreException {
        return remoteKey;
    }

    public boolean isAsynchronous() {
        return false;
    }

    public boolean isPullNeeded(IReview parent, IReviewItemSet object, PatchSetDetail remote) {
        return object == null || remote == null;
    }

    public IReviewItemSet createModel(IReview review, PatchSetDetail patchSetDetail) {
        PatchSet patchSet = patchSetDetail.getPatchSet();
        IReviewItemSet itemSet = IReviewsFactory.INSTANCE.createReviewItemSet();
        itemSet.setName(NLS.bind((String)Messages.PatchSetContentRemoteFactory_Patch_Set, (Object)patchSet.getPatchSetId()));
        itemSet.setCreationDate((Date)patchSet.getCreatedOn());
        itemSet.setId(Integer.toString(patchSet.getPatchSetId()));
        itemSet.setReference(patchSet.getRefName());
        itemSet.setRevision(patchSet.getRevision().get());
        review.getSets().add(itemSet);
        return itemSet;
    }

    public PatchSetDetail getRemoteKey(PatchSetDetail remoteObject) {
        return remoteObject;
    }

    public String getLocalKeyForRemoteObject(PatchSetDetail remoteObject) {
        return Integer.toString(remoteObject.getPatchSet().getPatchSetId());
    }

    public String getLocalKeyForRemoteKey(PatchSetDetail remoteKey) {
        return this.getLocalKeyForRemoteObject(remoteKey);
    }

    public PatchSetDetail getRemoteObjectForLocalKey(IReview parentObject, String localKey) {
        GerritReviewRemoteFactory reviewFactory = ((GerritRemoteFactoryProvider)this.getFactoryProvider()).getReviewFactory();
        RemoteEmfConsumer reviewConsumer = reviewFactory.getConsumerForModel((EObject)parentObject.getRepository(), parentObject);
        try {
            GerritChange change;
            int index = Integer.parseInt(localKey) - 1;
            if (reviewConsumer != null && (change = (GerritChange)reviewConsumer.getRemoteObject()) != null && change.getPatchSetDetails().size() > index) {
                PatchSetDetail patchSetDetail = change.getPatchSetDetails().get(index);
                return patchSetDetail;
            }
        }
        catch (NumberFormatException numberFormatException) {
        }
        finally {
            if (reviewConsumer != null) {
                reviewConsumer.release();
            }
        }
        return null;
    }
}

