/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.wikitext.textile.core.token;

import org.eclipse.mylyn.internal.wikitext.textile.core.TextileContentState;
import org.eclipse.mylyn.wikitext.core.parser.Attributes;
import org.eclipse.mylyn.wikitext.core.parser.DocumentBuilder;
import org.eclipse.mylyn.wikitext.core.parser.markup.PatternBasedElement;
import org.eclipse.mylyn.wikitext.core.parser.markup.PatternBasedElementProcessor;
import org.eclipse.mylyn.wikitext.textile.core.TextileLanguage;

public class FootnoteReferenceReplacementToken
extends PatternBasedElement {
    protected String getPattern(int groupOffset) {
        return "(?:\\[(\\d+)\\])";
    }

    protected int getPatternGroupCount() {
        return 1;
    }

    protected PatternBasedElementProcessor newProcessor() {
        return new FootnoteReferenceReplacementTokenProcessor();
    }

    private static class FootnoteReferenceReplacementTokenProcessor
    extends PatternBasedElementProcessor {
        private FootnoteReferenceReplacementTokenProcessor() {
        }

        public void emit() {
            String footnote = this.group(1);
            if (((TextileLanguage)this.getMarkupLanguage()).isPreprocessFootnotes() && !((TextileContentState)this.getState()).hasFootnoteNumber(footnote)) {
                this.builder.characters(this.group(0));
            } else {
                String htmlId = this.state.getFootnoteId(footnote);
                int originalSegmentEndOffset = this.state.getLineSegmentEndOffset();
                this.state.setLineCharacterOffset(this.start(1) - 1);
                this.state.setLineSegmentEndOffset(this.end(1) + 1);
                this.builder.beginSpan(DocumentBuilder.SpanType.SUPERSCRIPT, new Attributes(null, "footnote", null, null));
                this.builder.link("#" + htmlId, footnote);
                this.builder.endSpan();
                this.state.setLineCharacterOffset(originalSegmentEndOffset);
                this.state.setLineSegmentEndOffset(originalSegmentEndOffset);
            }
        }
    }
}

