/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.gerrit.core;

import com.google.gwtorm.client.KeyUtil;
import com.google.gwtorm.server.StandardKeyEncoder;
import java.lang.reflect.Type;
import java.net.UnknownHostException;
import java.util.Date;
import java.util.EnumSet;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.httpclient.HttpStatus;
import org.apache.commons.lang.StringUtils;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.mylyn.commons.core.StatusHandler;
import org.eclipse.mylyn.commons.net.Policy;
import org.eclipse.mylyn.internal.gerrit.core.GerritCorePlugin;
import org.eclipse.mylyn.internal.gerrit.core.GerritTaskDataHandler;
import org.eclipse.mylyn.internal.gerrit.core.Messages;
import org.eclipse.mylyn.internal.gerrit.core.client.GerritAuthenticationState;
import org.eclipse.mylyn.internal.gerrit.core.client.GerritClient;
import org.eclipse.mylyn.internal.gerrit.core.client.GerritConfiguration;
import org.eclipse.mylyn.internal.gerrit.core.client.GerritException;
import org.eclipse.mylyn.internal.gerrit.core.client.GerritHttpException;
import org.eclipse.mylyn.internal.gerrit.core.client.GerritLoginException;
import org.eclipse.mylyn.internal.gerrit.core.client.GerritSystemInfo;
import org.eclipse.mylyn.internal.gerrit.core.client.JSonSupport;
import org.eclipse.mylyn.internal.gerrit.core.client.data.GerritQueryResult;
import org.eclipse.mylyn.reviews.core.model.ReviewStatus;
import org.eclipse.mylyn.reviews.core.spi.ReviewsConnector;
import org.eclipse.mylyn.tasks.core.IRepositoryQuery;
import org.eclipse.mylyn.tasks.core.ITask;
import org.eclipse.mylyn.tasks.core.ITaskMapping;
import org.eclipse.mylyn.tasks.core.RepositoryStatus;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.core.TaskRepositoryLocationFactory;
import org.eclipse.mylyn.tasks.core.data.AbstractTaskDataHandler;
import org.eclipse.mylyn.tasks.core.data.TaskData;
import org.eclipse.mylyn.tasks.core.data.TaskDataCollector;
import org.eclipse.mylyn.tasks.core.data.TaskMapper;
import org.eclipse.mylyn.tasks.core.sync.ISynchronizationSession;
import org.eclipse.osgi.util.NLS;

public class GerritConnector
extends ReviewsConnector {
    static Logger logger = Logger.getLogger("com.google.gson.ParameterizedTypeHandlerMap");
    private static final Pattern CHANGE_ID_PATTERN;
    public static final String CHANGE_PREFIX_OLD = "/#change,";
    public static final String CHANGE_PREFIX_NEW = "/#/c/";
    public static final String CONNECTOR_KIND = "org.eclipse.mylyn.gerrit";
    public static final String CONNECTOR_LABEL = "Gerrit Code Review";
    public static final String KEY_REPOSITORY_CONFIG = "org.eclipse.mylyn.gerrit.config";
    public static final String KEY_REPOSITORY_AUTH = "org.eclipse.mylyn.gerrit.auth";
    public static final String KEY_REPOSITORY_ACCOUNT_ID = "org.eclipse.mylyn.gerrit.accountId";
    public static final String KEY_REPOSITORY_OPEN_ID_ENABLED = "org.eclipse.mylyn.gerrit.openId.enabled";
    public static final String KEY_REPOSITORY_OPEN_ID_PROVIDER = "org.eclipse.mylyn.gerrit.openId.provider";
    public static final String GERRIT_RPC_URI = "/gerrit/rpc/";
    public static final String GERRIT_260_RPC_URI = "/gerrit_ui/rpc/";
    private final GerritTaskDataHandler taskDataHandler = new GerritTaskDataHandler(this);
    private TaskRepositoryLocationFactory taskRepositoryLocationFactory = new TaskRepositoryLocationFactory();
    private final ConcurrentMap<TaskRepository, GerritConfiguration> configurationCache = new ConcurrentHashMap<TaskRepository, GerritConfiguration>();

    static {
        KeyUtil.setEncoderImpl((KeyUtil.Encoder)new StandardKeyEncoder());
        logger.setLevel(Level.OFF);
        CHANGE_ID_PATTERN = Pattern.compile("(/#change,|/#/c/)(\\d+)");
    }

    public GerritConnector() {
        if (GerritCorePlugin.getDefault() != null) {
            GerritCorePlugin.getDefault().setConnector(this);
        }
    }

    public boolean canCreateNewTask(TaskRepository arg0) {
        return false;
    }

    public boolean canCreateTaskFromKey(TaskRepository arg0) {
        return true;
    }

    public GerritClient getClient(TaskRepository repository) {
        return (GerritClient)this.getReviewClient(repository);
    }

    public String getConnectorKind() {
        return CONNECTOR_KIND;
    }

    public String getLabel() {
        return Messages.GerritConnector_Label;
    }

    public TaskData getTaskData(TaskRepository repository, String taskId, IProgressMonitor monitor) throws CoreException {
        return this.taskDataHandler.getTaskData(repository, taskId, monitor);
    }

    public AbstractTaskDataHandler getTaskDataHandler() {
        return this.taskDataHandler;
    }

    public String getRepositoryUrlFromTaskUrl(String url) {
        if (url == null) {
            return null;
        }
        int i = url.indexOf(CHANGE_PREFIX_OLD);
        if (i != -1) {
            return url.substring(0, i);
        }
        i = url.indexOf(CHANGE_PREFIX_NEW);
        if (i != -1) {
            return url.substring(0, i);
        }
        return null;
    }

    public String getTaskIdFromTaskUrl(String url) {
        if (url == null) {
            return null;
        }
        Matcher matcher = CHANGE_ID_PATTERN.matcher(url);
        if (matcher.find()) {
            return matcher.group(2);
        }
        return null;
    }

    public ITaskMapping getTaskMapping(TaskData taskData) {
        return new TaskMapper(taskData);
    }

    public synchronized TaskRepositoryLocationFactory getTaskRepositoryLocationFactory() {
        return this.taskRepositoryLocationFactory;
    }

    public String getTaskUrl(String repositoryUrl, String taskId) {
        repositoryUrl = StringUtils.removeEnd((String)repositoryUrl, (String)"/");
        return String.valueOf(repositoryUrl) + CHANGE_PREFIX_NEW + taskId + "/";
    }

    public boolean hasTaskChanged(TaskRepository repository, ITask task, TaskData taskData) {
        ITaskMapping taskMapping = this.getTaskMapping(taskData);
        Date repositoryDate = taskMapping.getModificationDate();
        Date localDate = task.getModificationDate();
        return repositoryDate == null || !repositoryDate.equals(localDate);
    }

    public IStatus performQuery(TaskRepository repository, IRepositoryQuery query, TaskDataCollector resultCollector, ISynchronizationSession session, IProgressMonitor monitor) {
        try {
            String queryString;
            monitor.beginTask(Messages.GerritConnector_Executing_query, -1);
            GerritClient client = this.getClient(repository);
            client.refreshConfigOnce(monitor);
            List<GerritQueryResult> result = null;
            if ("all open changes".equals(query.getAttribute("gerrit query type"))) {
                result = client.queryAllReviews(monitor);
            } else if ("my changes".equals(query.getAttribute("gerrit query type"))) {
                result = client.queryMyReviews(monitor);
            } else if ("my watched changes".equals(query.getAttribute("gerrit query type"))) {
                result = client.queryWatchedReviews(monitor);
            } else if ("custom".equals(query.getAttribute("gerrit query type"))) {
                queryString = query.getAttribute("gerrit query string");
                result = client.executeQuery(monitor, queryString);
            } else if ("open changes by project".equals(query.getAttribute("gerrit query type"))) {
                String project = query.getAttribute("gerrit query project");
                result = client.queryByProject(monitor, project);
            } else {
                queryString = query.getAttribute("gerrit query string");
                if (StringUtils.isNotBlank((String)queryString)) {
                    result = client.executeQuery(monitor, queryString);
                }
            }
            if (result != null) {
                for (GerritQueryResult changeInfo : result) {
                    TaskData taskData = this.taskDataHandler.createPartialTaskData(repository, Integer.toString(changeInfo.getNumber()), monitor);
                    this.taskDataHandler.updateTaskData(repository, taskData, changeInfo);
                    if (monitor.isCanceled()) break;
                    resultCollector.accept(taskData);
                }
                IStatus iStatus = Status.OK_STATUS;
                return iStatus;
            }
            Status status = new Status(4, "org.eclipse.mylyn.gerrit.core", NLS.bind((String)"Unknown query type: {0}", (Object)query.getAttribute("gerrit query project")));
            return status;
        }
        catch (UnsupportedClassVersionError e) {
            Status status = GerritConnector.toStatus(repository, e);
            return status;
        }
        catch (GerritException e) {
            Status status = this.toStatus(repository, "Problem performing query", e);
            return status;
        }
        finally {
            monitor.done();
        }
    }

    public synchronized void setTaskRepositoryLocationFactory(TaskRepositoryLocationFactory taskRepositoryLocationFactory) {
        this.taskRepositoryLocationFactory = taskRepositoryLocationFactory;
    }

    public void updateRepositoryConfiguration(TaskRepository repository, IProgressMonitor monitor) throws CoreException {
        try {
            this.getClient(repository).refreshConfig(monitor);
        }
        catch (GerritException e) {
            throw this.toCoreException(repository, "Problem updating repository", e);
        }
    }

    public void updateTaskFromTaskData(TaskRepository taskRepository, ITask task, TaskData taskData) {
        Date oldModificationDate = task.getModificationDate();
        TaskMapper mapper = (TaskMapper)this.getTaskMapping(taskData);
        mapper.applyTo(task);
        String key = task.getTaskKey();
        if (key != null) {
            task.setSummary(NLS.bind((String)"{0} [{1}]", (Object)mapper.getSummary(), (Object)key));
            task.setTaskKey(task.getTaskId());
        }
        if (taskData.isPartial()) {
            task.setModificationDate(oldModificationDate);
        }
    }

    public GerritSystemInfo validate(TaskRepository repository, IProgressMonitor monitor) throws CoreException {
        if (!Boolean.parseBoolean(repository.getProperty(KEY_REPOSITORY_OPEN_ID_ENABLED))) {
            monitor = Policy.backgroundMonitorFor((IProgressMonitor)monitor);
        }
        try {
            return this.createTransientReviewClient(repository).getInfo(monitor);
        }
        catch (UnsupportedClassVersionError e) {
            throw GerritConnector.toCoreException(repository, e);
        }
        catch (GerritException e) {
            throw this.toCoreException(repository, "Invalid repository", e);
        }
    }

    protected GerritClient createReviewClient(final TaskRepository repository, boolean b) {
        GerritConfiguration config = this.loadConfiguration(repository);
        GerritAuthenticationState authState = this.loadAuthState(repository);
        return new GerritClient(repository, this.taskRepositoryLocationFactory.createWebLocation(repository), config, authState){

            @Override
            protected void configurationChanged(GerritConfiguration config) {
                GerritConnector.this.saveConfiguration(repository, config);
            }

            @Override
            protected void authStateChanged(GerritAuthenticationState authState) {
                repository.setProperty(GerritConnector.KEY_REPOSITORY_AUTH, GerritClient.authStateToString(authState));
            }
        };
    }

    protected GerritClient createTransientReviewClient(TaskRepository repository) {
        return new GerritClient(repository, this.taskRepositoryLocationFactory.createWebLocation(repository));
    }

    private GerritAuthenticationState loadAuthState(TaskRepository repository) {
        String authState = repository.getProperty(KEY_REPOSITORY_AUTH);
        if (authState != null) {
            return GerritClient.authStateFromString(authState);
        }
        return null;
    }

    protected GerritConfiguration loadConfiguration(TaskRepository repository) {
        GerritConfiguration configuration = (GerritConfiguration)this.configurationCache.get(repository);
        if (configuration == null && (configuration = GerritConnector.configurationFromString(repository.getProperty(KEY_REPOSITORY_CONFIG))) != null) {
            this.configurationCache.put(repository, configuration);
        }
        return configuration;
    }

    protected void saveConfiguration(TaskRepository repository, GerritConfiguration configuration) {
        this.configurationCache.put(repository, configuration);
        repository.setProperty(KEY_REPOSITORY_CONFIG, GerritConnector.configurationToString(configuration));
    }

    public GerritConfiguration getConfiguration(TaskRepository repository) {
        GerritConfiguration configuration = (GerritConfiguration)this.configurationCache.get(repository);
        if (configuration == null) {
            configuration = this.loadConfiguration(repository);
        }
        return configuration;
    }

    private static GerritConfiguration configurationFromString(String token) {
        if (token == null) {
            return null;
        }
        try {
            JSonSupport support = new JSonSupport();
            return (GerritConfiguration)support.parseResponse(token, (Type)((Object)GerritConfiguration.class));
        }
        catch (Exception e) {
            StatusHandler.log((IStatus)new Status(4, "org.eclipse.mylyn.gerrit.core", "Failed to deserialize configuration: '" + token + "'", (Throwable)e));
            return null;
        }
    }

    private static String configurationToString(GerritConfiguration config) {
        try {
            JSonSupport support = new JSonSupport();
            return support.toJson(config);
        }
        catch (Exception e) {
            StatusHandler.log((IStatus)new Status(4, "org.eclipse.mylyn.gerrit.core", "Failed to serialize configuration", (Throwable)e));
            return null;
        }
    }

    public CoreException toCoreException(TaskRepository repository, String qualifier, GerritException e) {
        return new CoreException((IStatus)this.toStatus(repository, qualifier, e));
    }

    public static CoreException toCoreException(TaskRepository repository, UnsupportedClassVersionError e) {
        return new CoreException((IStatus)GerritConnector.toStatus(repository, e));
    }

    Status toStatus(TaskRepository repository, String qualifier, Exception e) {
        if (StringUtils.isEmpty((String)qualifier)) {
            qualifier = "";
        } else if (!StringUtils.endsWith((String)qualifier, (String)": ")) {
            qualifier = String.valueOf(qualifier) + ": ";
        }
        if (e instanceof GerritHttpException) {
            int code = ((GerritHttpException)e).getResponseCode();
            return this.createErrorStatus(repository, String.valueOf(qualifier) + HttpStatus.getStatusText((int)code));
        }
        if (e instanceof GerritLoginException) {
            if (repository != null) {
                return RepositoryStatus.createLoginError((String)repository.getUrl(), (String)"org.eclipse.mylyn.gerrit.core");
            }
            return this.createErrorStatus(null, String.valueOf(qualifier) + "Unknown Host");
        }
        if (e instanceof UnknownHostException) {
            return this.createErrorStatus(repository, String.valueOf(qualifier) + "Unknown Host");
        }
        if (e instanceof GerritException && e.getCause() != null) {
            Throwable cause = e.getCause();
            if (cause instanceof Exception) {
                return this.toStatus(repository, qualifier, (Exception)cause);
            }
        } else if (e instanceof GerritException && e.getMessage() != null) {
            return this.createErrorStatus(repository, NLS.bind((String)"{0}Gerrit connection issue: {1}", (Object)qualifier, (Object)e.getMessage()));
        }
        String message = NLS.bind((String)"{0}Unexpected error while connecting to Gerrit: {1}", (Object)qualifier, (Object)e.getMessage());
        if (repository != null) {
            return RepositoryStatus.createStatus((TaskRepository)repository, (int)4, (String)"org.eclipse.mylyn.gerrit.core", (String)message);
        }
        return this.createErrorStatus(repository, message);
    }

    protected Status createErrorStatus(TaskRepository repository, String message) {
        if (repository != null) {
            return RepositoryStatus.createStatus((TaskRepository)repository, (int)4, (String)"org.eclipse.mylyn.gerrit.core", (String)message);
        }
        return new Status(4, "org.eclipse.mylyn.gerrit.core", String.valueOf(message) + " (Repository Unknown)");
    }

    public static Status toStatus(TaskRepository repository, UnsupportedClassVersionError e) {
        String message = NLS.bind((String)"The Gerrit Connector requires at Java 1.6 or higer (installed version: {0})", (Object)System.getProperty("java.version"));
        return new Status(4, "org.eclipse.mylyn.gerrit.core", message, (Throwable)e);
    }

    public static boolean isClosed(String status) {
        return EnumSet.of(ReviewStatus.MERGED, ReviewStatus.ABANDONED).contains(ReviewStatus.get((String)status));
    }

    public void setStarred(TaskRepository taskRepository, String taskID, boolean starred, IProgressMonitor progressMonitor) throws CoreException {
        GerritClient client = this.getClient(taskRepository);
        try {
            client.setStarred(taskID, starred, progressMonitor);
        }
        catch (GerritException e) {
            throw this.toCoreException(e);
        }
    }

    private CoreException toCoreException(GerritException e) {
        return new CoreException((IStatus)new Status(4, "org.eclipse.mylyn.gerrit.core", "Unable to set the starred flag, the following Status is received", (Throwable)e));
    }
}

