/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.gerrit.ui;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.mylyn.commons.workbench.forms.CommonFormUtil;
import org.eclipse.mylyn.internal.gerrit.core.GerritConnector;
import org.eclipse.mylyn.internal.gerrit.core.client.GerritSystemInfo;
import org.eclipse.mylyn.internal.gerrit.ui.Messages;
import org.eclipse.mylyn.tasks.core.RepositoryTemplate;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.ui.wizards.AbstractRepositorySettingsPage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.ui.forms.widgets.ExpandableComposite;

public class GerritRepositorySettingsPage
extends AbstractRepositorySettingsPage {
    private Button openIdButton;
    private Combo openIdCombo;
    private final List<OpenIdProvider> openIdProviders = new ArrayList<OpenIdProvider>();

    public GerritRepositorySettingsPage(TaskRepository taskRepository) {
        super(Messages.GerritRepositorySettingsPage_Gerrit_Repository_Settings, Messages.GerritRepositorySettingsPage_Gerrit_Repository_Settings_description, taskRepository);
        this.setNeedsAnonymousLogin(true);
        this.setNeedsHttpAuth(true);
        this.setNeedsAdvanced(true);
        this.setNeedsEncoding(false);
        this.setNeedsTimeZone(false);
        this.setNeedsValidation(true);
        this.openIdProviders.add(new OpenIdProvider(Messages.GerritRepositorySettingsPage_Google_Account, "https://www.google.com/accounts/o8/id"));
        this.openIdProviders.add(new OpenIdProvider(Messages.GerritRepositorySettingsPage_Yahoo_Account, "https://me.yahoo.com"));
    }

    public void applyTo(TaskRepository repository) {
        super.applyTo(repository);
        repository.setProperty("org.eclipse.mylyn.gerrit.openId.enabled", Boolean.toString(this.openIdButton.getSelection()));
        repository.setProperty("org.eclipse.mylyn.gerrit.openId.provider", this.openIdCombo.getText());
        repository.setProperty("category", "org.eclipse.mylyn.category.review");
        repository.removeProperty("org.eclipse.mylyn.gerrit.accountId");
        repository.removeProperty("org.eclipse.mylyn.gerrit.auth");
    }

    public void createControl(Composite parent) {
        super.createControl(parent);
        this.addRepositoryTemplatesToServerUrlCombo();
    }

    public String getConnectorKind() {
        return "org.eclipse.mylyn.gerrit";
    }

    private void updateButtons() {
        this.openIdCombo.setEnabled(this.openIdButton.getSelection());
    }

    protected void applyValidatorResult(AbstractRepositorySettingsPage.Validator validator) {
        super.applyValidatorResult(validator);
        if (validator.getStatus() != null && validator.getStatus().isOK()) {
            GerritValidator gerritValidator = (GerritValidator)validator;
            String warning = "";
            if (!gerritValidator.isSupportedVersion()) {
                warning = NLS.bind((String)Messages.GerritRepositorySettingsPage_Gerrit_may_not_be_supported, (Object)gerritValidator.getInfo().getVersion());
            }
            this.setMessage(NLS.bind((String)Messages.GerritRepositorySettingsPage_X_Logged_in_as_Y_dot_Z, (Object[])new String[]{this.getMessage(), gerritValidator.getInfo().getFullName(), warning}), warning.isEmpty() ? 1 : 2);
        }
    }

    protected void createAdditionalControls(Composite parent) {
        this.openIdButton = new Button(parent, 32);
        this.openIdButton.setText(Messages.GerritRepositorySettingsPage_OpenID_Authentication);
        this.openIdButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                GerritRepositorySettingsPage.this.updateButtons();
            }
        });
        GridDataFactory.fillDefaults().span(2, 1).applyTo((Control)this.openIdButton);
        Label providerLabel = new Label(parent, 0);
        providerLabel.setText(Messages.GerritRepositorySettingsPage_Provider);
        this.openIdCombo = new Combo(parent, 0);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.openIdCombo);
        for (OpenIdProvider provider : this.openIdProviders) {
            this.openIdCombo.add(provider.getName());
        }
        this.openIdCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (GerritRepositorySettingsPage.this.openIdCombo.getSelectionIndex() >= 0) {
                    GerritRepositorySettingsPage.this.openIdCombo.setText(((OpenIdProvider)GerritRepositorySettingsPage.this.openIdProviders.get(GerritRepositorySettingsPage.this.openIdCombo.getSelectionIndex())).getUrl());
                }
            }
        });
        if (this.repository != null) {
            this.openIdButton.setSelection(Boolean.parseBoolean(this.repository.getProperty("org.eclipse.mylyn.gerrit.openId.enabled")));
            String value = this.repository.getProperty("org.eclipse.mylyn.gerrit.openId.provider");
            this.openIdCombo.setText(value != null ? value : "");
            if (this.openIdButton.getSelection() && parent.getParent() instanceof ExpandableComposite) {
                CommonFormUtil.setExpanded((ExpandableComposite)((ExpandableComposite)parent.getParent()), (boolean)true);
            }
        }
        this.updateButtons();
    }

    protected AbstractRepositorySettingsPage.Validator getValidator(TaskRepository repository) {
        return new GerritValidator(repository);
    }

    protected void repositoryTemplateSelected(RepositoryTemplate template) {
        this.repositoryLabelEditor.setStringValue(template.label);
        this.setUrl(template.repositoryUrl);
        this.getContainer().updateButtons();
    }

    public class GerritValidator
    extends AbstractRepositorySettingsPage.Validator {
        private GerritSystemInfo info;
        final TaskRepository repository;

        public GerritValidator(TaskRepository repository) {
            super((AbstractRepositorySettingsPage)GerritRepositorySettingsPage.this);
            this.repository = repository;
        }

        public GerritSystemInfo getInfo() {
            return this.info;
        }

        public void run(IProgressMonitor monitor) throws CoreException {
            GerritConnector connector = (GerritConnector)GerritRepositorySettingsPage.this.getConnector();
            this.info = connector.validate(this.repository, monitor);
        }

        private boolean isSupportedVersion() {
            return this.info.getCapabilities().isSupported();
        }
    }

    private class OpenIdProvider {
        private final String name;
        private final String url;

        public OpenIdProvider(String name, String url) {
            this.name = name;
            this.url = url;
        }

        public String getName() {
            return this.name;
        }

        public String getUrl() {
            return this.url;
        }
    }
}

