/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.tasks.tests;

import junit.framework.TestCase;
import org.eclipse.jface.preference.StringFieldEditor;
import org.eclipse.mylyn.commons.net.AuthenticationType;
import org.eclipse.mylyn.internal.tasks.ui.TasksUiPlugin;
import org.eclipse.mylyn.tasks.core.AbstractRepositoryConnector;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.tests.connector.MockRepositoryConnector;
import org.eclipse.mylyn.tasks.tests.connector.MockRepositoryConnectorUi;
import org.eclipse.mylyn.tasks.ui.AbstractRepositoryConnectorUi;
import org.eclipse.mylyn.tasks.ui.wizards.AbstractRepositorySettingsPage;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class RepositorySettingsPageTest
extends TestCase {
    public void testNeedsEncoding() {
        TaskRepository repository = new TaskRepository("mock", "http://localhost/");
        repository.setCharacterEncoding("UTF-8");
        MockRepositorySettingsPage page = new MockRepositorySettingsPage(repository);
        page.setNeedsEncoding(true);
        Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
        page.createControl((Composite)shell);
        page.setVisible(true);
        TaskRepository repository2 = page.createTaskRepository();
        RepositorySettingsPageTest.assertEquals((String)"UTF-8", (String)repository2.getCharacterEncoding());
    }

    public void testNeedsEncodingFalse() {
        MockRepositorySettingsPage page = new MockRepositorySettingsPage(null);
        page.setNeedsEncoding(false);
        Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
        page.createControl((Composite)shell);
        page.setVisible(true);
        page.createTaskRepository();
    }

    public void testNeedsAnonyoumousLoginFalse() {
        MockRepositorySettingsPage page = new MockRepositorySettingsPage(null);
        page.setNeedsAnonymousLogin(false);
        Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
        page.createControl((Composite)shell);
        page.setVisible(true);
        RepositorySettingsPageTest.assertNull((Object)page.getAnonymousButton());
    }

    public void testNeedsAnonyoumousLoginNoRepository() {
        MockRepositorySettingsPage page = new MockRepositorySettingsPage(null);
        page.setNeedsAnonymousLogin(true);
        Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
        page.createControl((Composite)shell);
        page.setVisible(true);
        RepositorySettingsPageTest.assertNotNull((Object)page.getAnonymousButton());
        RepositorySettingsPageTest.assertTrue((boolean)page.getAnonymousButton().getSelection());
        RepositorySettingsPageTest.assertFalse((boolean)page.getUserNameEditor().getTextControl(page.getParent()).isEnabled());
        RepositorySettingsPageTest.assertFalse((boolean)page.getPasswordEditor().getTextControl(page.getParent()).isEnabled());
        RepositorySettingsPageTest.assertEquals((String)"", (String)page.getUserName());
        RepositorySettingsPageTest.assertEquals((String)"", (String)page.getPassword());
        page.getAnonymousButton().setSelection(false);
    }

    public void testNeedsAnonyoumousLogin() {
        TaskRepository repository = new TaskRepository("mock", "http://localhost/");
        TasksUiPlugin.getDefault().addRepositoryConnectorUi((AbstractRepositoryConnectorUi)new MockRepositoryConnectorUi());
        MockRepositorySettingsPage page = new MockRepositorySettingsPage(repository);
        page.setNeedsAnonymousLogin(true);
        Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
        page.createControl((Composite)shell);
        page.setVisible(true);
        RepositorySettingsPageTest.assertNotNull((Object)page.getAnonymousButton());
        RepositorySettingsPageTest.assertTrue((boolean)page.getAnonymousButton().getSelection());
        RepositorySettingsPageTest.assertFalse((boolean)page.getUserNameEditor().getTextControl(page.getParent()).isEnabled());
        RepositorySettingsPageTest.assertFalse((boolean)page.getPasswordEditor().getTextControl(page.getParent()).isEnabled());
        RepositorySettingsPageTest.assertEquals((String)"", (String)page.getUserName());
        RepositorySettingsPageTest.assertEquals((String)"", (String)page.getPassword());
        page.getAnonymousButton().setSelection(false);
        page.getAnonymousButton().notifyListeners(13, new Event());
        RepositorySettingsPageTest.assertTrue((boolean)page.getUserNameEditor().getTextControl(page.getParent()).isEnabled());
        RepositorySettingsPageTest.assertTrue((boolean)page.getPasswordEditor().getTextControl(page.getParent()).isEnabled());
        page.getUserNameEditor().setStringValue("user");
        page.getPasswordEditor().setStringValue("password");
        RepositorySettingsPageTest.assertEquals((String)"user", (String)page.getUserName());
        RepositorySettingsPageTest.assertEquals((String)"password", (String)page.getPassword());
        page.getAnonymousButton().setSelection(true);
        page.getAnonymousButton().notifyListeners(13, new Event());
        RepositorySettingsPageTest.assertFalse((boolean)page.getUserNameEditor().getTextControl(page.getParent()).isEnabled());
        RepositorySettingsPageTest.assertFalse((boolean)page.getPasswordEditor().getTextControl(page.getParent()).isEnabled());
        RepositorySettingsPageTest.assertEquals((String)"", (String)page.getUserName());
        RepositorySettingsPageTest.assertEquals((String)"", (String)page.getPassword());
        page.getAnonymousButton().setSelection(false);
        page.getAnonymousButton().notifyListeners(13, new Event());
        RepositorySettingsPageTest.assertTrue((boolean)page.getUserNameEditor().getTextControl(page.getParent()).isEnabled());
        RepositorySettingsPageTest.assertTrue((boolean)page.getPasswordEditor().getTextControl(page.getParent()).isEnabled());
        RepositorySettingsPageTest.assertEquals((String)"user", (String)page.getUserNameEditor().getStringValue());
        RepositorySettingsPageTest.assertEquals((String)"password", (String)page.getPasswordEditor().getStringValue());
        RepositorySettingsPageTest.assertEquals((String)"user", (String)page.getUserName());
        RepositorySettingsPageTest.assertEquals((String)"password", (String)page.getPassword());
    }

    public void testSavePassword() {
        Shell shell;
        TaskRepository repository = new TaskRepository("mock", "http://localhost/");
        TasksUiPlugin.getDefault().addRepositoryConnectorUi((AbstractRepositoryConnectorUi)new MockRepositoryConnectorUi());
        RepositorySettingsPageTest.assertTrue((boolean)repository.getSavePassword(AuthenticationType.REPOSITORY));
        MockRepositorySettingsPage page = new MockRepositorySettingsPage(repository);
        try {
            shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
            page.createControl((Composite)shell);
            RepositorySettingsPageTest.assertTrue((boolean)page.getSavePassword());
        }
        finally {
            page.dispose();
        }
        repository.setCredentials(AuthenticationType.REPOSITORY, null, false);
        page = new MockRepositorySettingsPage(repository);
        try {
            shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
            page.createControl((Composite)shell);
            RepositorySettingsPageTest.assertFalse((boolean)page.getSavePassword());
        }
        finally {
            page.dispose();
        }
    }

    public void testSaveHttpPassword() {
        Shell shell;
        TaskRepository repository = new TaskRepository("mock", "http://localhost/");
        TasksUiPlugin.getDefault().addRepositoryConnectorUi((AbstractRepositoryConnectorUi)new MockRepositoryConnectorUi());
        RepositorySettingsPageTest.assertTrue((boolean)repository.getSavePassword(AuthenticationType.HTTP));
        MockRepositorySettingsPage page = new MockRepositorySettingsPage(repository);
        page.setNeedsHttpAuth(true);
        try {
            shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
            page.createControl((Composite)shell);
            RepositorySettingsPageTest.assertTrue((boolean)page.getSaveHttpPassword());
        }
        finally {
            page.dispose();
        }
        repository.setCredentials(AuthenticationType.HTTP, null, false);
        page.setNeedsHttpAuth(true);
        try {
            shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
            page.createControl((Composite)shell);
            RepositorySettingsPageTest.assertFalse((boolean)page.getSaveHttpPassword());
        }
        finally {
            page.dispose();
        }
    }

    public void testSaveProxyPassword() {
        Shell shell;
        TaskRepository repository = new TaskRepository("mock", "http://localhost/");
        TasksUiPlugin.getDefault().addRepositoryConnectorUi((AbstractRepositoryConnectorUi)new MockRepositoryConnectorUi());
        RepositorySettingsPageTest.assertTrue((boolean)repository.getSavePassword(AuthenticationType.PROXY));
        MockRepositorySettingsPage page = new MockRepositorySettingsPage(repository);
        page.setNeedsProxy(true);
        try {
            shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
            page.createControl((Composite)shell);
            RepositorySettingsPageTest.assertTrue((boolean)page.getSaveProxyPassword());
        }
        finally {
            page.dispose();
        }
        repository.setCredentials(AuthenticationType.PROXY, null, false);
        page = new MockRepositorySettingsPage(repository);
        page.setNeedsProxy(true);
        try {
            shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
            page.createControl((Composite)shell);
            RepositorySettingsPageTest.assertFalse((boolean)page.getSaveProxyPassword());
        }
        finally {
            page.dispose();
        }
    }

    public void testValidUrl() throws Exception {
        TaskRepository repository = new TaskRepository("mock", "http://localhost/");
        MockRepositorySettingsPage page = new MockRepositorySettingsPage(repository);
        RepositorySettingsPageTest.assertFalse((boolean)page.isValidUrl(""));
        RepositorySettingsPageTest.assertFalse((boolean)page.isValidUrl("http:/google.com"));
        RepositorySettingsPageTest.assertFalse((boolean)page.isValidUrl("http:/google.com/"));
        RepositorySettingsPageTest.assertTrue((boolean)page.isValidUrl("http://google.com"));
        RepositorySettingsPageTest.assertTrue((boolean)page.isValidUrl("https://google.com"));
        RepositorySettingsPageTest.assertTrue((boolean)page.isValidUrl("http://mylyn.org/bugzilla34"));
        RepositorySettingsPageTest.assertTrue((boolean)page.isValidUrl("http://www.mylyn.org/bugzilla34"));
    }

    public void testInjectConnectorIntoSettingsPage() throws Exception {
        TaskRepository repository = new TaskRepository("mock", "http://localhost/");
        MockRepositoryConnector connector = new MockRepositoryConnector();
        MockRepositorySettingsPage page = new MockRepositorySettingsPage(repository, connector);
        RepositorySettingsPageTest.assertSame((Object)page.getConnector(), (Object)((Object)connector));
    }

    public void testNeedsRepositoryCredentialsDefaultsToTrue() {
        TaskRepository repository = new TaskRepository("mock", "http://localhost/");
        MockRepositorySettingsPage page = new MockRepositorySettingsPage(repository);
        RepositorySettingsPageTest.assertTrue((boolean)page.needsRepositoryCredentials());
    }

    public void testNeedsRepositoryCredentialsCanBeSetToFalse() {
        TaskRepository repository = new TaskRepository("mock", "http://localhost/");
        MockRepositorySettingsPage page = new MockRepositorySettingsPage(repository);
        page.setNeedsRepositoryCredentials(false);
        RepositorySettingsPageTest.assertFalse((boolean)page.needsRepositoryCredentials());
    }

    public void testNeedsRepositoryCredentialsPageCompletesWithoutCredentials() {
        TaskRepository repository = new TaskRepository("mock", "http://localhost/");
        MockRepositorySettingsPage page = new MockRepositorySettingsPage(repository);
        page.setNeedsRepositoryCredentials(false);
        try {
            Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
            page.createControl((Composite)shell);
            page.setUrl("http://example.com");
            RepositorySettingsPageTest.assertNull((Object)page.getRepositoryUserNameEditor());
            RepositorySettingsPageTest.assertNull((Object)page.getRepositoryPasswordEditor());
            RepositorySettingsPageTest.assertTrue((boolean)page.isPageComplete());
            RepositorySettingsPageTest.assertNull((Object)page.getMessage());
            RepositorySettingsPageTest.assertNotNull((Object)page.createTaskRepository());
        }
        finally {
            page.dispose();
        }
    }

    private class MockRepositorySettingsPage
    extends AbstractRepositorySettingsPage {
        public MockRepositorySettingsPage(TaskRepository taskRepository) {
            super("title", "summary", taskRepository);
        }

        public MockRepositorySettingsPage(TaskRepository taskRepository, AbstractRepositoryConnector connector) {
            super("title", "summary", taskRepository, connector);
        }

        protected void createAdditionalControls(Composite parent) {
        }

        protected boolean isValidUrl(String url) {
            return super.isValidUrl(url);
        }

        protected void validateSettings() {
        }

        Button getAnonymousButton() {
            return this.anonymousButton;
        }

        StringFieldEditor getUserNameEditor() {
            return this.repositoryUserNameEditor;
        }

        StringFieldEditor getPasswordEditor() {
            return this.repositoryPasswordEditor;
        }

        Composite getParent() {
            return this.compositeContainer;
        }

        protected AbstractRepositorySettingsPage.Validator getValidator(TaskRepository repository) {
            return null;
        }

        public String getConnectorKind() {
            return "mock";
        }

        public StringFieldEditor getRepositoryUserNameEditor() {
            return this.repositoryUserNameEditor;
        }

        public StringFieldEditor getRepositoryPasswordEditor() {
            return this.repositoryPasswordEditor;
        }
    }
}

