/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.tasks.tests.util;

import java.net.MalformedURLException;
import java.net.URL;
import junit.framework.TestCase;
import org.eclipse.mylyn.internal.tasks.core.TaskRepositoryManager;
import org.eclipse.mylyn.internal.tasks.ui.TasksUiPlugin;
import org.eclipse.mylyn.tasks.core.AbstractRepositoryConnector;
import org.eclipse.mylyn.tasks.core.IRepositoryElement;
import org.eclipse.mylyn.tasks.core.ITask;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.tests.connector.MockRepositoryConnector;
import org.eclipse.mylyn.tasks.tests.connector.MockTask;

public class MockRepositoryConnectorTestCase
extends TestCase {
    protected AbstractRepositoryConnector connectorWithUrl;
    protected AbstractRepositoryConnector connectorWithBrowserUrl;
    protected TaskRepository repositoryWithUrl;
    protected TaskRepository repositoryWithBrowserUrl;
    protected MockTask taskWithUrl;
    protected MockTask taskWithBrowserUrl;

    protected MockTask createMockTaskForRepository(final TaskRepository repository, String taskId) {
        return new MockTask(repository.getRepositoryUrl(), taskId){

            @Override
            public String getConnectorKind() {
                return repository.getConnectorKind();
            }

            public String getUrl() {
                AbstractRepositoryConnector connector = TasksUiPlugin.getRepositoryManager().getRepositoryConnector(this.getConnectorKind());
                return connector.getTaskUrl(this.getRepositoryUrl(), this.getTaskId());
            }
        };
    }

    protected void setUp() throws Exception {
        TaskRepositoryManager manager = TasksUiPlugin.getRepositoryManager();
        this.connectorWithUrl = new MockRepositoryWithUrl();
        this.connectorWithBrowserUrl = new MockRepositoryWithBrowserUrl();
        manager.addRepositoryConnector(this.connectorWithUrl);
        manager.addRepositoryConnector(this.connectorWithBrowserUrl);
        this.repositoryWithUrl = new TaskRepository("mock-with-url", "http://mock-repo.com");
        this.repositoryWithBrowserUrl = new TaskRepository("mock-with-browser", "http://mock-repo-evolved.com");
        manager.addRepository(this.repositoryWithUrl);
        manager.addRepository(this.repositoryWithBrowserUrl);
        this.taskWithUrl = this.createMockTaskForRepository(this.repositoryWithUrl, "123");
        TasksUiPlugin.getTaskList().addTask((ITask)this.taskWithUrl);
        this.taskWithBrowserUrl = this.createMockTaskForRepository(this.repositoryWithBrowserUrl, "123");
        TasksUiPlugin.getTaskList().addTask((ITask)this.taskWithBrowserUrl);
    }

    protected void tearDown() throws Exception {
        TaskRepositoryManager manager = TasksUiPlugin.getRepositoryManager();
        manager.removeRepository(this.repositoryWithUrl);
        manager.removeRepository(this.repositoryWithBrowserUrl);
        manager.removeRepositoryConnector("mock-with-url");
        manager.removeRepositoryConnector("mock-with-browser");
    }

    protected class MockRepositoryWithBrowserUrl
    extends MockRepositoryConnector {
        public static final String CONNECTOR_KIND = "mock-with-browser";
        public static final String REPOSITORY_URL = "http://mock-repo-evolved.com";

        protected MockRepositoryWithBrowserUrl() {
        }

        @Override
        public String getConnectorKind() {
            return CONNECTOR_KIND;
        }

        @Override
        public String getTaskUrl(String repositoryUrl, String taskId) {
            return "URI://mock-repo/id/" + taskId;
        }

        public URL getBrowserUrl(TaskRepository repository, IRepositoryElement element) {
            if (element instanceof ITask) {
                try {
                    return new URL(String.valueOf(repository.getRepositoryUrl()) + "/tickets/" + ((ITask)element).getTaskId());
                }
                catch (MalformedURLException malformedURLException) {
                    return null;
                }
            }
            return null;
        }
    }

    protected class MockRepositoryWithUrl
    extends MockRepositoryConnector {
        public static final String CONNECTOR_KIND = "mock-with-url";
        public static final String REPOSITORY_URL = "http://mock-repo.com";

        protected MockRepositoryWithUrl() {
        }

        @Override
        public String getConnectorKind() {
            return CONNECTOR_KIND;
        }

        @Override
        public String getTaskUrl(String repositoryUrl, String taskId) {
            return String.valueOf(repositoryUrl) + "/tickets/" + taskId;
        }
    }
}

