/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.trac.tests.core;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import junit.framework.TestCase;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.mylyn.commons.net.AuthenticationCredentials;
import org.eclipse.mylyn.commons.net.AuthenticationType;
import org.eclipse.mylyn.internal.tasks.core.TaskTask;
import org.eclipse.mylyn.internal.tasks.core.data.TextTaskAttachmentSource;
import org.eclipse.mylyn.internal.tasks.core.sync.SynchronizationSession;
import org.eclipse.mylyn.internal.trac.core.TracAttachmentHandler;
import org.eclipse.mylyn.internal.trac.core.TracAttribute;
import org.eclipse.mylyn.internal.trac.core.TracAttributeMapper;
import org.eclipse.mylyn.internal.trac.core.TracRepositoryConnector;
import org.eclipse.mylyn.internal.trac.core.TracTaskDataHandler;
import org.eclipse.mylyn.internal.trac.core.TracTaskMapper;
import org.eclipse.mylyn.internal.trac.core.client.ITracClient;
import org.eclipse.mylyn.internal.trac.core.model.TracTicket;
import org.eclipse.mylyn.internal.trac.core.util.TracUtil;
import org.eclipse.mylyn.tasks.core.ITask;
import org.eclipse.mylyn.tasks.core.ITaskAttachment;
import org.eclipse.mylyn.tasks.core.ITaskMapping;
import org.eclipse.mylyn.tasks.core.RepositoryStatus;
import org.eclipse.mylyn.tasks.core.TaskMapping;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.core.data.AbstractTaskAttachmentSource;
import org.eclipse.mylyn.tasks.core.data.TaskAttribute;
import org.eclipse.mylyn.tasks.core.data.TaskAttributeMapper;
import org.eclipse.mylyn.tasks.core.data.TaskData;
import org.eclipse.mylyn.tasks.core.data.TaskOperation;
import org.eclipse.mylyn.tasks.core.data.TaskRelation;
import org.eclipse.mylyn.tasks.core.sync.ISynchronizationSession;
import org.eclipse.mylyn.trac.tests.support.TracFixture;
import org.eclipse.mylyn.trac.tests.support.TracHarness;
import org.eclipse.mylyn.trac.tests.support.TracTestUtil;

public class TracTaskDataHandlerXmlRpcTest
extends TestCase {
    private TracRepositoryConnector connector;
    private TaskRepository repository;
    private TracTaskDataHandler taskDataHandler;
    private ITracClient client;
    private TracHarness harness;

    protected void setUp() throws Exception {
        this.harness = TracFixture.current().createHarness();
        this.connector = this.harness.connector();
        this.taskDataHandler = this.connector.getTaskDataHandler();
        this.repository = this.harness.repository();
        this.client = this.connector.getClientManager().getTracClient(this.repository);
    }

    protected void tearDown() throws Exception {
        this.harness.dispose();
    }

    private SynchronizationSession createSession(ITask ... tasks) {
        SynchronizationSession session = new SynchronizationSession();
        session.setNeedsPerformQueries(true);
        session.setTaskRepository(this.repository);
        session.setFullSynchronization(true);
        session.setTasks(new HashSet<ITask>(Arrays.asList(tasks)));
        return session;
    }

    public void testMarkStaleTasks() throws Exception {
        Thread.sleep(1000L);
        TracTicket ticket = this.harness.createTicket("markStaleTasks");
        ITask task = this.harness.getTask(ticket);
        long lastModified = TracUtil.toTracTime((Date)task.getModificationDate());
        this.repository.setSynchronizationTimeStamp(null);
        SynchronizationSession session = this.createSession(task);
        this.connector.preSynchronization((ISynchronizationSession)session, null);
        TracTaskDataHandlerXmlRpcTest.assertTrue((boolean)session.needsPerformQueries());
        TracTaskDataHandlerXmlRpcTest.assertNull((Object)this.repository.getSynchronizationTimeStamp());
        this.repository.setSynchronizationTimeStamp(null);
        session = this.createSession(task);
        this.connector.preSynchronization((ISynchronizationSession)session, null);
        TracTaskDataHandlerXmlRpcTest.assertTrue((boolean)session.needsPerformQueries());
        TracTaskDataHandlerXmlRpcTest.assertEquals(Collections.singleton(task), (Object)session.getStaleTasks());
        this.repository.setSynchronizationTimeStamp(String.valueOf(lastModified));
        session = this.createSession(task);
        this.connector.preSynchronization((ISynchronizationSession)session, null);
        TracTaskDataHandlerXmlRpcTest.assertFalse((boolean)session.needsPerformQueries());
        TracTaskDataHandlerXmlRpcTest.assertEquals(Collections.emptySet(), (Object)session.getStaleTasks());
        this.repository.setSynchronizationTimeStamp(String.valueOf(lastModified + 1L));
        session = this.createSession(task);
        this.connector.preSynchronization((ISynchronizationSession)session, null);
        TracTaskDataHandlerXmlRpcTest.assertFalse((boolean)session.needsPerformQueries());
        TracTaskDataHandlerXmlRpcTest.assertEquals(Collections.emptySet(), (Object)session.getStaleTasks());
        long mostRecentlyModified = 0L;
        int i = 0;
        while (i < 3) {
            ticket = this.client.getTicket(ticket.getId(), null);
            ticket.putBuiltinValue(TracTicket.Key.DESCRIPTION, String.valueOf(lastModified));
            this.client.updateTicket(ticket, "comment", null);
            mostRecentlyModified = TracUtil.toTracTime((Date)ticket.getLastChanged());
            if (mostRecentlyModified >= lastModified + 1L) break;
            if (i == 2) {
                TracTaskDataHandlerXmlRpcTest.fail((String)("Failed to update ticket modification time: ticket id=" + ticket.getId() + ", lastModified=" + lastModified + ", mostRectentlyModified=" + mostRecentlyModified));
            }
            Thread.sleep(1500L);
            ++i;
        }
        this.repository.setSynchronizationTimeStamp(String.valueOf(lastModified + 1L));
        session = this.createSession(task);
        this.connector.preSynchronization((ISynchronizationSession)session, null);
        TracTaskDataHandlerXmlRpcTest.assertTrue((String)("Expected change: ticket id=" + ticket.getId() + ", lastModified=" + lastModified + ", mostRectentlyModified=" + mostRecentlyModified), (boolean)session.needsPerformQueries());
        TracTaskDataHandlerXmlRpcTest.assertEquals(Collections.singleton(task), (Object)session.getStaleTasks());
    }

    public void testMarkStaleTasksNoTimeStamp() throws Exception {
        ITask task = this.harness.createTask("MarkStaleTasksNoTimeStamp");
        SynchronizationSession session = this.createSession(task);
        this.repository.setSynchronizationTimeStamp(null);
        this.connector.preSynchronization((ISynchronizationSession)session, null);
        TracTaskDataHandlerXmlRpcTest.assertTrue((boolean)session.needsPerformQueries());
        TracTaskDataHandlerXmlRpcTest.assertEquals(Collections.singleton(task), (Object)session.getStaleTasks());
        session = this.createSession(task);
        this.repository.setSynchronizationTimeStamp("");
        this.connector.preSynchronization((ISynchronizationSession)session, null);
        TracTaskDataHandlerXmlRpcTest.assertTrue((boolean)session.needsPerformQueries());
        TracTaskDataHandlerXmlRpcTest.assertEquals(Collections.singleton(task), (Object)session.getStaleTasks());
        session = this.createSession(task);
        this.repository.setSynchronizationTimeStamp("0");
        this.connector.preSynchronization((ISynchronizationSession)session, null);
        TracTaskDataHandlerXmlRpcTest.assertTrue((boolean)session.needsPerformQueries());
        TracTaskDataHandlerXmlRpcTest.assertEquals(Collections.singleton(task), (Object)session.getStaleTasks());
        session = this.createSession(task);
        this.repository.setSynchronizationTimeStamp("abc");
        this.connector.preSynchronization((ISynchronizationSession)session, null);
        TracTaskDataHandlerXmlRpcTest.assertTrue((boolean)session.needsPerformQueries());
        TracTaskDataHandlerXmlRpcTest.assertEquals(Collections.singleton(task), (Object)session.getStaleTasks());
    }

    public void testNonNumericTaskId() {
        try {
            this.connector.getTaskData(this.repository, "abc", null);
            TracTaskDataHandlerXmlRpcTest.fail((String)"Expected CoreException");
        }
        catch (CoreException coreException) {}
    }

    public void testAttachmentChangesLastModifiedDate() throws Exception {
        TracAttachmentHandler attachmentHandler = this.connector.getTaskAttachmentHandler();
        ITask task = this.harness.createTask("attachmentChangesLastModifiedDate");
        Date lastModified = task.getModificationDate();
        this.harness.getFixture().waitToGuaranteeTaskUpdate();
        attachmentHandler.postContent(this.repository, task, (AbstractTaskAttachmentSource)new TextTaskAttachmentSource("abc"), "comment", null, null);
        task = this.harness.getTask(task.getTaskId());
        Date newLastModified = task.getModificationDate();
        TracTaskDataHandlerXmlRpcTest.assertTrue((String)("Expected " + newLastModified + " to be more recent than " + lastModified), (boolean)newLastModified.after(lastModified));
    }

    public void testAttachmentUrlEncoding() throws Exception {
        TracAttachmentHandler attachmentHandler = this.connector.getTaskAttachmentHandler();
        TracTicket ticket = this.harness.createTicket("attachment url test");
        ITask task = this.harness.getTask(ticket);
        attachmentHandler.postContent(this.repository, task, (AbstractTaskAttachmentSource)new TextTaskAttachmentSource("abc"){

            public String getName() {
                return "https%3A%2F%2Fbugs.eclipse.org%2Fbugs.xml.zip";
            }
        }, "comment", null, null);
        task = this.harness.getTask(ticket);
        List<ITaskAttachment> attachments = TracTestUtil.getTaskAttachments(task);
        TracTaskDataHandlerXmlRpcTest.assertEquals((int)1, (int)attachments.size());
        TracTaskDataHandlerXmlRpcTest.assertEquals((String)(String.valueOf(this.repository.getUrl()) + "/attachment/ticket/" + ticket.getId() + "/https%253A%252F%252Fbugs.eclipse.org%252Fbugs.xml.zip"), (String)attachments.get(0).getUrl());
    }

    public void testPostTaskDataInvalidCredentials() throws Exception {
        TaskData taskData = this.harness.createTaskData("postTaskDataInvalidCredentials");
        taskData.getRoot().getMappedAttribute("task.common.comment.new").setValue("new comment");
        this.repository.setCredentials(AuthenticationType.REPOSITORY, new AuthenticationCredentials("foo", "bar"), false);
        try {
            this.taskDataHandler.postTaskData(this.repository, taskData, null, null);
        }
        catch (CoreException expected) {
            TracTaskDataHandlerXmlRpcTest.assertEquals((int)3, (int)expected.getStatus().getCode());
        }
        TracTaskDataHandlerXmlRpcTest.assertEquals((String)"new comment", (String)taskData.getRoot().getMappedAttribute("task.common.comment.new").getValue());
    }

    public void testCanInitializeTaskData() throws Exception {
        TaskTask task = new TaskTask("trac", "", "");
        TracTaskDataHandlerXmlRpcTest.assertFalse((boolean)this.taskDataHandler.canInitializeSubTaskData(this.repository, (ITask)task));
        task.setAttribute("SupportsSubtasks", Boolean.TRUE.toString());
        TracTaskDataHandlerXmlRpcTest.assertTrue((boolean)this.taskDataHandler.canInitializeSubTaskData(this.repository, (ITask)task));
    }

    public void testCanInitializeTaskDataRepositoryTask() throws Exception {
        ITask task = this.harness.createTask("canInitializeTaskDataRepositoryTask");
        TaskData taskData = this.taskDataHandler.getTaskData(this.repository, task.getTaskId(), null);
        TracTaskDataHandlerXmlRpcTest.assertFalse((boolean)this.taskDataHandler.canInitializeSubTaskData(this.repository, task));
        taskData.getRoot().createAttribute("blockedby");
        this.connector.updateTaskFromTaskData(this.repository, task, taskData);
        TracTaskDataHandlerXmlRpcTest.assertTrue((boolean)this.taskDataHandler.canInitializeSubTaskData(this.repository, task));
        task.setAttribute("SupportsSubtasks", Boolean.FALSE.toString());
        this.connector.updateTaskFromTaskData(this.repository, task, taskData);
        TracTaskDataHandlerXmlRpcTest.assertTrue((boolean)this.taskDataHandler.canInitializeSubTaskData(this.repository, task));
    }

    public void testInitializeSubTaskDataInvalidParent() throws Exception {
        TaskData parentTaskData = this.harness.createTaskData("initializeSubTaskDataInvalidParent");
        try {
            this.taskDataHandler.initializeSubTaskData(this.repository, parentTaskData, parentTaskData, null);
            TracTaskDataHandlerXmlRpcTest.fail((String)"expected CoreException");
        }
        catch (CoreException coreException) {}
    }

    public void testInitializeSubTaskData() throws Exception {
        TaskData parentTaskData = this.harness.createTaskData("initializeSubTaskData");
        TracTaskMapper parentTaskMapper = new TracTaskMapper(parentTaskData, null);
        parentTaskMapper.setSummary("abc");
        parentTaskMapper.setDescription("def");
        String component = (String)parentTaskData.getRoot().getMappedAttribute(TracAttribute.COMPONENT.getTracKey()).getOptions().get(0);
        parentTaskMapper.setComponent(component);
        parentTaskData.getRoot().createAttribute("blockedby");
        TaskData subTaskData = new TaskData(parentTaskData.getAttributeMapper(), "trac", "", "");
        subTaskData.getRoot().createAttribute("blocking");
        this.taskDataHandler.initializeSubTaskData(this.repository, subTaskData, parentTaskData, (IProgressMonitor)new NullProgressMonitor());
        TracTaskMapper subTaskMapper = new TracTaskMapper(subTaskData, null);
        TracTaskDataHandlerXmlRpcTest.assertEquals((String)"", (String)subTaskMapper.getSummary());
        TracTaskDataHandlerXmlRpcTest.assertEquals((String)"", (String)subTaskMapper.getDescription());
        TracTaskDataHandlerXmlRpcTest.assertEquals((String)component, (String)subTaskMapper.getComponent());
        TaskAttribute attribute = subTaskData.getRoot().getMappedAttribute("blocking");
        TracTaskDataHandlerXmlRpcTest.assertEquals((String)parentTaskData.getTaskId(), (String)attribute.getValue());
        attribute = parentTaskData.getRoot().getMappedAttribute("blockedby");
        TracTaskDataHandlerXmlRpcTest.assertEquals((String)"", (String)attribute.getValue());
    }

    public void testGetSubTaskIds() throws Exception {
        TaskData taskData = new TaskData((TaskAttributeMapper)new TracAttributeMapper(new TaskRepository("", ""), this.client), "trac", "", "");
        TaskAttribute blockedBy = taskData.getRoot().createAttribute("blockedby");
        blockedBy.setValue("123 456");
        Collection<String> subTaskIds = this.getSubTaskIds(taskData);
        TracTaskDataHandlerXmlRpcTest.assertEquals((int)2, (int)subTaskIds.size());
        TracTaskDataHandlerXmlRpcTest.assertTrue((boolean)subTaskIds.contains("123"));
        TracTaskDataHandlerXmlRpcTest.assertTrue((boolean)subTaskIds.contains("456"));
        blockedBy.setValue("7,8");
        subTaskIds = this.getSubTaskIds(taskData);
        TracTaskDataHandlerXmlRpcTest.assertEquals((int)2, (int)subTaskIds.size());
        TracTaskDataHandlerXmlRpcTest.assertTrue((boolean)subTaskIds.contains("7"));
        TracTaskDataHandlerXmlRpcTest.assertTrue((boolean)subTaskIds.contains("8"));
        blockedBy.setValue("  7 ,   8,  ");
        subTaskIds = this.getSubTaskIds(taskData);
        TracTaskDataHandlerXmlRpcTest.assertEquals((int)2, (int)subTaskIds.size());
        TracTaskDataHandlerXmlRpcTest.assertTrue((boolean)subTaskIds.contains("7"));
        TracTaskDataHandlerXmlRpcTest.assertTrue((boolean)subTaskIds.contains("8"));
        blockedBy.setValue("7");
        subTaskIds = this.getSubTaskIds(taskData);
        TracTaskDataHandlerXmlRpcTest.assertEquals((int)1, (int)subTaskIds.size());
        TracTaskDataHandlerXmlRpcTest.assertTrue((boolean)subTaskIds.contains("7"));
        blockedBy.setValue("");
        subTaskIds = this.getSubTaskIds(taskData);
        TracTaskDataHandlerXmlRpcTest.assertEquals((int)0, (int)subTaskIds.size());
        blockedBy.setValue("  ");
        subTaskIds = this.getSubTaskIds(taskData);
        TracTaskDataHandlerXmlRpcTest.assertEquals((int)0, (int)subTaskIds.size());
    }

    private Collection<String> getSubTaskIds(TaskData taskData) {
        ArrayList<String> subTaskIds = new ArrayList<String>();
        Collection relations = this.connector.getTaskRelations(taskData);
        for (TaskRelation taskRelation : relations) {
            subTaskIds.add(taskRelation.getTaskId());
        }
        return subTaskIds;
    }

    public void testInitializeTaskData() throws Exception {
        TaskData taskData = new TaskData(this.taskDataHandler.getAttributeMapper(this.repository), "trac", "", "");
        TaskMapping mapping = new TaskMapping(){

            public String getDescription() {
                return "description";
            }

            public String getSummary() {
                return "summary";
            }
        };
        this.taskDataHandler.initializeTaskData(this.repository, taskData, (ITaskMapping)mapping, (IProgressMonitor)new NullProgressMonitor());
        TracTaskMapper mapper = new TracTaskMapper(taskData, null);
        TracTaskDataHandlerXmlRpcTest.assertEquals(null, (String)mapper.getResolution());
        TracTaskDataHandlerXmlRpcTest.assertEquals((String)"", (String)mapper.getSummary());
        TracTaskDataHandlerXmlRpcTest.assertEquals((String)"", (String)mapper.getDescription());
        TracTaskDataHandlerXmlRpcTest.assertEquals((String)"Defect", (String)mapper.getTaskKind());
        TracTaskDataHandlerXmlRpcTest.assertEquals((String)"major", (String)mapper.getPriority());
        TracTaskDataHandlerXmlRpcTest.assertNull((Object)taskData.getRoot().getAttribute(TracAttribute.SEVERITY.getTracKey()));
    }

    public void testInitializeTaskDataNoMonitor() throws Exception {
        this.connector.getClientManager().repositoryRemoved(this.repository);
        TaskData taskData = new TaskData(new TaskAttributeMapper(this.repository), "trac", "", "");
        boolean initialized = this.taskDataHandler.initializeTaskData(this.repository, taskData, (ITaskMapping)new TaskMapping(), null);
        TracTaskDataHandlerXmlRpcTest.assertTrue((boolean)initialized);
    }

    public void testOperations() throws Exception {
        boolean hasReassign = TracFixture.current().getVersion().compareTo("0.11") >= 0;
        TaskData taskData = this.taskDataHandler.getTaskData(this.repository, "1", (IProgressMonitor)new NullProgressMonitor());
        List operations = taskData.getAttributeMapper().getAttributesByType(taskData, "operation");
        TracTaskDataHandlerXmlRpcTest.assertEquals((String)("Unexpected operations: " + operations), (int)(hasReassign ? 5 : 4), (int)operations.size());
        TaskOperation operation = taskData.getAttributeMapper().getTaskOperation((TaskAttribute)operations.get(0));
        TracTaskDataHandlerXmlRpcTest.assertEquals((String)"task.common.operation", (String)operation.getTaskAttribute().getId());
        operation = taskData.getAttributeMapper().getTaskOperation((TaskAttribute)operations.get(1));
        TracTaskDataHandlerXmlRpcTest.assertEquals((String)"leave", (String)operation.getOperationId());
        TracTaskDataHandlerXmlRpcTest.assertNotNull((Object)operation.getLabel());
        operation = taskData.getAttributeMapper().getTaskOperation((TaskAttribute)operations.get(2));
        TracTaskDataHandlerXmlRpcTest.assertEquals((String)"resolve", (String)operation.getOperationId());
        TracTaskDataHandlerXmlRpcTest.assertNotNull((Object)operation.getLabel());
        String associatedId = operation.getTaskAttribute().getMetaData().getValue("task.meta.associated.attribute");
        TracTaskDataHandlerXmlRpcTest.assertNotNull((Object)associatedId);
        if (hasReassign) {
            operation = taskData.getAttributeMapper().getTaskOperation((TaskAttribute)operations.get(3));
            TracTaskDataHandlerXmlRpcTest.assertEquals((String)"reassign", (String)operation.getOperationId());
            TracTaskDataHandlerXmlRpcTest.assertNotNull((Object)operation.getLabel());
            operation = taskData.getAttributeMapper().getTaskOperation((TaskAttribute)operations.get(4));
            TracTaskDataHandlerXmlRpcTest.assertEquals((String)"accept", (String)operation.getOperationId());
            TracTaskDataHandlerXmlRpcTest.assertNotNull((Object)operation.getLabel());
        } else {
            operation = taskData.getAttributeMapper().getTaskOperation((TaskAttribute)operations.get(3));
            TracTaskDataHandlerXmlRpcTest.assertEquals((String)"accept", (String)operation.getOperationId());
            TracTaskDataHandlerXmlRpcTest.assertNotNull((Object)operation.getLabel());
        }
    }

    public void testPostTaskDataUnsetResolution() throws Exception {
        TracTicket ticket = this.harness.createTicket("postTaskDataUnsetResolution");
        TaskData taskData = this.taskDataHandler.getTaskData(this.repository, String.valueOf(ticket.getId()), (IProgressMonitor)new NullProgressMonitor());
        TaskAttribute attribute = taskData.getRoot().getMappedAttribute("task.common.resolution");
        attribute.setValue("fixed");
        this.taskDataHandler.postTaskData(this.repository, taskData, null, (IProgressMonitor)new NullProgressMonitor());
        taskData = this.taskDataHandler.getTaskData(this.repository, String.valueOf(ticket.getId()), (IProgressMonitor)new NullProgressMonitor());
        attribute = taskData.getRoot().getMappedAttribute("task.common.resolution");
        TracTaskDataHandlerXmlRpcTest.assertEquals((String)"", (String)attribute.getValue());
    }

    public void testPostTaskDataMidAirCollision() throws Exception {
        TracTicket ticket = this.harness.createTicket("midAirCollision");
        if (ticket.getValue(TracTicket.Key.TOKEN) == null) {
            System.err.println("Skipping TracTaskDataHandler.testPostTaskDataMidAirCollision() due to lack of mid-air collision support on " + this.repository.getRepositoryUrl());
            return;
        }
        TaskData taskData = this.taskDataHandler.getTaskData(this.repository, String.valueOf(ticket.getId()), (IProgressMonitor)new NullProgressMonitor());
        TaskAttribute attribute = taskData.getRoot().getMappedAttribute("task.common.priority");
        attribute.setValue("blocker");
        ticket.putBuiltinValue(TracTicket.Key.PRIORITY, "trivial");
        this.client.updateTicket(ticket, "changing priority", null);
        this.harness.getFixture().waitToGuaranteeTaskUpdate();
        try {
            this.taskDataHandler.postTaskData(this.repository, taskData, null, (IProgressMonitor)new NullProgressMonitor());
            TracTaskDataHandlerXmlRpcTest.fail((String)"Expected CoreException due to mid-air collision");
        }
        catch (CoreException e) {
            TracTaskDataHandlerXmlRpcTest.assertEquals((String)RepositoryStatus.createCollisionError((String)this.repository.getRepositoryUrl(), (String)"org.eclipse.mylyn.trac.core").getMessage(), (String)e.getStatus().getMessage());
        }
    }
}

