/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.commons.sdk.util;

import java.lang.annotation.Annotation;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.mylyn.commons.sdk.util.AbstractTestFixture;
import org.eclipse.mylyn.commons.sdk.util.TestConfiguration;
import org.junit.runner.Runner;
import org.junit.runner.notification.RunNotifier;
import org.junit.runners.BlockJUnit4ClassRunner;
import org.junit.runners.Suite;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.InitializationError;
import org.junit.runners.model.Statement;

public class Junit4TestFixtureRunner
extends Suite {
    private final ArrayList<Runner> runners = new ArrayList();

    public Junit4TestFixtureRunner(Class<?> klass) throws Throwable {
        super(klass, Collections.emptyList());
        String restrictProperty = null;
        String restrictValue = null;
        Class<?> fixtureClass = null;
        String fixtureType = null;
        Annotation[] annotationArray = this.getTestClass().getAnnotations();
        int n = annotationArray.length;
        int n2 = 0;
        while (n2 < n) {
            Annotation annotation = annotationArray[n2];
            if ("org.eclipse.mylyn.commons.sdk.util.Junit4TestFixtureRunner.OnlyRunWithProperty".equals(annotation.annotationType().getCanonicalName())) {
                RunOnlyWhenProperty onlyWhenProperty = (RunOnlyWhenProperty)annotation;
                restrictProperty = onlyWhenProperty.property();
                restrictValue = onlyWhenProperty.value();
            }
            if ("org.eclipse.mylyn.commons.sdk.util.Junit4TestFixtureRunner.FixtureDefinition".equals(annotation.annotationType().getCanonicalName())) {
                FixtureDefinition fixtueDef = (FixtureDefinition)annotation;
                fixtureClass = fixtueDef.fixtureClass();
                fixtureType = fixtueDef.fixtureType();
            }
            ++n2;
        }
        if (fixtureType != null) {
            int i;
            List<AbstractTestFixture> parametersList = TestConfiguration.getDefault().discover(fixtureClass, fixtureType);
            ArrayList<AbstractTestFixture> fixturesToExecute = new ArrayList<AbstractTestFixture>();
            if (restrictProperty != null) {
                for (AbstractTestFixture abstractFixture : parametersList) {
                    String tempProperty = abstractFixture.getProperty(restrictProperty);
                    if (tempProperty == null || !tempProperty.equals(restrictValue)) continue;
                    fixturesToExecute.add(abstractFixture);
                }
                if (fixturesToExecute.size() > 0) {
                    i = 0;
                    while (i < fixturesToExecute.size()) {
                        this.runners.add((Runner)new TestClassRunnerForFixture(this.getTestClass().getJavaClass(), fixturesToExecute, i));
                        ++i;
                    }
                }
            } else if (parametersList.size() > 0) {
                i = 0;
                while (i < parametersList.size()) {
                    this.runners.add((Runner)new TestClassRunnerForFixture(this.getTestClass().getJavaClass(), parametersList, i));
                    ++i;
                }
            }
        } else {
            throw new InitializationError("Missing Annotation FixtureDefinition for Junit4TestFixtureRunner");
        }
    }

    protected List<Runner> getChildren() {
        return this.runners;
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.TYPE})
    public static @interface FixtureDefinition {
        public Class<?> fixtureClass();

        public String fixtureType();
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.TYPE})
    public static @interface RunOnlyWhenProperty {
        public String property() default "";

        public String value() default "";
    }

    private class TestClassRunnerForFixture
    extends BlockJUnit4ClassRunner {
        private final int fFixtureSetNumber;
        private final List<AbstractTestFixture> fFixtureList;

        TestClassRunnerForFixture(Class<?> type, List<AbstractTestFixture> fixtureList, int i) throws InitializationError {
            super(type);
            this.fFixtureList = fixtureList;
            this.fFixtureSetNumber = i;
        }

        public Object createTest() throws Exception {
            return this.getTestClass().getOnlyConstructor().newInstance(this.fFixtureList.get(this.fFixtureSetNumber));
        }

        protected String getName() {
            return String.format("[%s %s]", this.fFixtureSetNumber, this.fFixtureList.get(this.fFixtureSetNumber).getDescription());
        }

        protected String testName(FrameworkMethod method) {
            if (Boolean.parseBoolean(System.getProperty("org.eclipse.mylyn.tests.all"))) {
                return String.format("%s[%s %s]", method.getName(), this.fFixtureSetNumber, this.fFixtureList.get(0).getDescription());
            }
            return super.testName(method);
        }

        protected void validateConstructor(List<Throwable> errors) {
            this.validateOnlyOneConstructor(errors);
        }

        protected Statement classBlock(RunNotifier notifier) {
            return this.childrenInvoker(notifier);
        }
    }
}

