/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.tasks.tests;

import junit.framework.TestCase;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.mylyn.internal.tasks.ui.TasksUiPlugin;
import org.eclipse.mylyn.tasks.core.IRepositoryManager;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.ui.AbstractTaskRepositoryLinkProvider;

public class LinkProviderTest
extends TestCase {
    private String defaultTimeout;
    private LinkProviderStub provider;

    protected void setUp() throws Exception {
        this.defaultTimeout = System.getProperty("org.eclipse.mylyn.linkProviderTimeout", "");
        this.provider = new LinkProviderStub();
        TasksUiPlugin.getDefault().addRepositoryLinkProvider((AbstractTaskRepositoryLinkProvider)this.provider);
    }

    protected void tearDown() throws Exception {
        TasksUiPlugin.getDefault().removeRepositoryLinkProvider((AbstractTaskRepositoryLinkProvider)this.provider);
        System.setProperty("org.eclipse.mylyn.linkProviderTimeout", this.defaultTimeout);
    }

    public void testTimeout() {
        System.setProperty("org.eclipse.mylyn.linkProviderTimeout", "500");
        this.provider.timeout = 10;
        TasksUiPlugin.getDefault().getRepositoryForResource((IResource)ResourcesPlugin.getWorkspace().getRoot());
        LinkProviderTest.assertEquals((int)1, (int)this.provider.executions);
        this.provider.timeout = 2000;
        TasksUiPlugin.getDefault().getRepositoryForResource((IResource)ResourcesPlugin.getWorkspace().getRoot());
        LinkProviderTest.assertEquals((int)2, (int)this.provider.executions);
        this.provider.timeout = 10;
        TasksUiPlugin.getDefault().getRepositoryForResource((IResource)ResourcesPlugin.getWorkspace().getRoot());
        LinkProviderTest.assertEquals((int)2, (int)this.provider.executions);
    }

    public void testTimeoutInfinite() {
        System.setProperty("org.eclipse.mylyn.linkProviderTimeout", "50");
        this.provider.timeout = 40;
        TasksUiPlugin.getDefault().getRepositoryForResource((IResource)ResourcesPlugin.getWorkspace().getRoot());
        LinkProviderTest.assertEquals((int)1, (int)this.provider.executions);
        System.setProperty("org.eclipse.mylyn.linkProviderTimeout", "-1");
        this.provider.timeout = 0;
        TasksUiPlugin.getDefault().getRepositoryForResource((IResource)ResourcesPlugin.getWorkspace().getRoot());
        LinkProviderTest.assertEquals((int)2, (int)this.provider.executions);
        this.provider.timeout = 60;
        TasksUiPlugin.getDefault().getRepositoryForResource((IResource)ResourcesPlugin.getWorkspace().getRoot());
        LinkProviderTest.assertEquals((int)3, (int)this.provider.executions);
        TasksUiPlugin.getDefault().getRepositoryForResource((IResource)ResourcesPlugin.getWorkspace().getRoot());
        LinkProviderTest.assertEquals((int)4, (int)this.provider.executions);
    }

    public class LinkProviderStub
    extends AbstractTaskRepositoryLinkProvider {
        int executions = 0;
        int timeout = 0;

        public TaskRepository getTaskRepository(IResource resource, IRepositoryManager repositoryManager) {
            ++this.executions;
            try {
                Thread.sleep(this.timeout);
            }
            catch (InterruptedException interruptedException) {
                LinkProviderTest.fail();
            }
            return null;
        }
    }
}

