/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.tasks.tests.data;

import junit.framework.TestCase;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.core.data.TaskAttribute;
import org.eclipse.mylyn.tasks.core.data.TaskAttributeMapper;
import org.eclipse.mylyn.tasks.core.data.TaskCommentMapper;
import org.eclipse.mylyn.tasks.core.data.TaskData;

public class TaskAttributeMapperTest
extends TestCase {
    TaskRepository taskRepository = new TaskRepository("kind", "repository");
    TaskAttributeMapper mapper = new TaskAttributeMapper(this.taskRepository);
    TaskData data = new TaskData(this.mapper, "kind", "repository", "id");

    public void testEqualsCommentId() {
        TaskCommentMapper comment = new TaskCommentMapper();
        comment.setCommentId("commentid");
        comment.setNumber(Integer.valueOf(1));
        TaskAttribute attributeOld = this.data.getRoot().createAttribute("1");
        comment.applyTo(attributeOld);
        TaskAttribute attributeNew = this.data.getRoot().createAttribute("2");
        comment.applyTo(attributeNew);
        TaskAttributeMapperTest.assertTrue((boolean)this.mapper.equals(attributeNew, attributeOld));
        comment.setCommentId("commentid2");
        comment.applyTo(attributeOld);
        TaskAttributeMapperTest.assertFalse((String)("Expected not equals:\n" + attributeOld + "\n" + attributeNew), (boolean)this.mapper.equals(attributeNew, attributeOld));
    }

    public void testEqualsCommentMylyn37() {
        TaskCommentMapper comment = new TaskCommentMapper();
        comment.setNumber(Integer.valueOf(1));
        TaskAttribute attributeOld = this.data.getRoot().createAttribute("1");
        comment.applyTo(attributeOld);
        attributeOld.setValue("1");
        TaskAttribute attributeNew = this.data.getRoot().createAttribute("2");
        comment.applyTo(attributeNew);
        TaskAttributeMapperTest.assertEquals((String)"", (String)attributeNew.getValue());
        TaskAttributeMapperTest.assertTrue((String)("Expected equals:\n" + attributeOld + "\n" + attributeNew), (boolean)this.mapper.equals(attributeNew, attributeOld));
        TaskAttributeMapperTest.assertFalse((String)("Expected not equals:\n" + attributeOld + "\n" + attributeNew), (boolean)this.mapper.equals(attributeOld, attributeNew));
    }

    public void testEqualsCommentMylyn37CommentId() {
        TaskCommentMapper comment = new TaskCommentMapper();
        comment.setNumber(Integer.valueOf(1));
        comment.setCommentId("2");
        TaskAttribute attributeOld = this.data.getRoot().createAttribute("1");
        comment.applyTo(attributeOld);
        attributeOld.setValue("1");
        TaskAttribute attributeNew = this.data.getRoot().createAttribute("2");
        comment.applyTo(attributeNew);
        TaskAttributeMapperTest.assertEquals((String)"2", (String)attributeNew.getValue());
        TaskAttributeMapperTest.assertFalse((String)("Expected not equals:\n" + attributeOld + "\n" + attributeNew), (boolean)this.mapper.equals(attributeNew, attributeOld));
        TaskAttribute idAttribute = attributeOld.createAttribute("task.common.comment.id");
        idAttribute.setValue("2");
        TaskAttributeMapperTest.assertTrue((String)("Expected equals:\n" + attributeOld + "\n" + attributeNew), (boolean)this.mapper.equals(attributeNew, attributeOld));
        idAttribute.setValue("3");
        TaskAttributeMapperTest.assertFalse((String)("Expected not equals:\n" + attributeOld + "\n" + attributeNew), (boolean)this.mapper.equals(attributeNew, attributeOld));
    }
}

