/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.bugzilla.tests;

import java.io.File;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.mylyn.bugzilla.tests.AbstractBugzillaTest;
import org.eclipse.mylyn.bugzilla.tests.support.BugzillaFixture;
import org.eclipse.mylyn.bugzilla.tests.support.BugzillaTestSupportUtil;
import org.eclipse.mylyn.commons.net.AbstractWebLocation;
import org.eclipse.mylyn.commons.net.AuthenticationCredentials;
import org.eclipse.mylyn.commons.net.AuthenticationType;
import org.eclipse.mylyn.commons.sdk.util.CommonTestUtil;
import org.eclipse.mylyn.internal.bugzilla.core.BugzillaAttribute;
import org.eclipse.mylyn.internal.bugzilla.core.BugzillaClient;
import org.eclipse.mylyn.internal.bugzilla.core.BugzillaOperation;
import org.eclipse.mylyn.internal.bugzilla.core.BugzillaStatus;
import org.eclipse.mylyn.internal.bugzilla.core.BugzillaTaskDataCollector;
import org.eclipse.mylyn.internal.bugzilla.core.BugzillaTaskDataHandler;
import org.eclipse.mylyn.internal.bugzilla.core.BugzillaUserMatchResponse;
import org.eclipse.mylyn.internal.bugzilla.core.BugzillaVersion;
import org.eclipse.mylyn.internal.bugzilla.core.IBugzillaConstants;
import org.eclipse.mylyn.internal.bugzilla.core.RepositoryConfiguration;
import org.eclipse.mylyn.internal.tasks.core.AbstractTask;
import org.eclipse.mylyn.internal.tasks.core.RepositoryQuery;
import org.eclipse.mylyn.internal.tasks.core.TaskRepositoryLocation;
import org.eclipse.mylyn.internal.tasks.core.sync.SynchronizationSession;
import org.eclipse.mylyn.internal.tasks.ui.TasksUiPlugin;
import org.eclipse.mylyn.internal.tasks.ui.util.AttachmentUtil;
import org.eclipse.mylyn.internal.tasks.ui.util.TasksUiInternal;
import org.eclipse.mylyn.tasks.core.AbstractRepositoryConnector;
import org.eclipse.mylyn.tasks.core.IRepositoryQuery;
import org.eclipse.mylyn.tasks.core.ITask;
import org.eclipse.mylyn.tasks.core.ITaskMapping;
import org.eclipse.mylyn.tasks.core.RepositoryResponse;
import org.eclipse.mylyn.tasks.core.TaskMapping;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.core.data.ITaskDataWorkingCopy;
import org.eclipse.mylyn.tasks.core.data.TaskAttribute;
import org.eclipse.mylyn.tasks.core.data.TaskAttributeMapper;
import org.eclipse.mylyn.tasks.core.data.TaskData;
import org.eclipse.mylyn.tasks.core.data.TaskDataCollector;
import org.eclipse.mylyn.tasks.core.data.TaskDataModel;
import org.eclipse.mylyn.tasks.core.data.TaskOperation;
import org.eclipse.mylyn.tasks.core.sync.ISynchronizationSession;
import org.eclipse.mylyn.tasks.ui.TasksUi;
import org.eclipse.mylyn.tasks.ui.TasksUiUtil;

public class BugzillaRepositoryConnectorTest
extends AbstractBugzillaTest {
    public void testSingleRetrievalFailure() throws CoreException {
        try {
            this.connector.getTaskData(this.repository, "99999", (IProgressMonitor)new NullProgressMonitor());
            BugzillaRepositoryConnectorTest.fail((String)"Invalid id error should have resulted");
        }
        catch (CoreException e) {
            if (BugzillaFixture.current().getBugzillaVersion().compareMajorMinorOnly(BugzillaVersion.BUGZILLA_4_4) > 0) {
                BugzillaRepositoryConnectorTest.assertTrue((boolean)e.getStatus().getMessage().contains(IBugzillaConstants.ERROR_MSG_INVALID_BUG_ID));
            }
            BugzillaRepositoryConnectorTest.assertTrue((boolean)e.getStatus().getMessage().contains(IBugzillaConstants.ERROR_MSG_NOT_FOUND_BUG_ID));
        }
    }

    public void testAliasRetrievalFailure() throws CoreException {
        try {
            this.connector.getTaskData(this.repository, "Hugo", (IProgressMonitor)new NullProgressMonitor());
            BugzillaRepositoryConnectorTest.fail((String)"Invalid id error should have resulted");
        }
        catch (CoreException e) {
            BugzillaRepositoryConnectorTest.assertTrue((boolean)e.getStatus().getMessage().contains(IBugzillaConstants.ERROR_MSG_INVALID_BUG_ID));
        }
    }

    public void testAliasRetrieval() throws Exception {
        String taskId = this.harness.taskAliasExists();
        if (taskId == null) {
            taskId = this.harness.createAliasTask();
        }
        String usebugaliases = BugzillaFixture.current().getProperty("usebugaliases");
        boolean bugAliases = Boolean.parseBoolean(usebugaliases);
        try {
            TaskData td = this.connector.getTaskData(this.repository, "Fritz", (IProgressMonitor)new NullProgressMonitor());
            if (BugzillaFixture.current().getBugzillaVersion().compareMajorMinorOnly(BugzillaVersion.BUGZILLA_4_4) >= 0 || bugAliases) {
                BugzillaRepositoryConnectorTest.assertNotNull((Object)td);
            } else {
                BugzillaRepositoryConnectorTest.fail((String)"testAliasRetrieval: never reach this! CoreException expected");
            }
        }
        catch (CoreException e) {
            if (BugzillaFixture.current().getBugzillaVersion().compareMajorMinorOnly(BugzillaVersion.BUGZILLA_4_4) < 0 && !bugAliases) {
                BugzillaRepositoryConnectorTest.assertTrue((boolean)e.getStatus().getMessage().contains(IBugzillaConstants.ERROR_MSG_INVALID_BUG_ID));
            }
            BugzillaRepositoryConnectorTest.fail((String)"testAliasRetrieval: never reach this! no CoreException expected");
        }
    }

    public void testAliasMultiRetrieval() throws Exception {
        String taskId = this.harness.taskAliasExists();
        if (taskId == null) {
            taskId = this.harness.createAliasTask();
        }
        if ((taskId = this.harness.taskAlias2Exists()) == null) {
            taskId = this.harness.createAliasTask2();
        }
        HashSet<String> taskIds = new HashSet<String>();
        taskIds.add("Hugo");
        taskIds.add("Fritz");
        taskIds.add(taskId);
        final HashMap results = new HashMap();
        final HashMap failed = new HashMap();
        TaskDataCollector collector = new TaskDataCollector(){

            public void accept(TaskData taskData) {
                results.put(taskData.getTaskId(), taskData);
            }

            public void failed(String taskId, IStatus status) {
                failed.put(taskId, status);
            }
        };
        this.connector.getTaskDataHandler().getMultiTaskData(this.repository, taskIds, collector, (IProgressMonitor)new NullProgressMonitor());
        String usebugaliases = BugzillaFixture.current().getProperty("usebugaliases");
        if (BugzillaFixture.current().getBugzillaVersion().compareMajorMinorOnly(BugzillaVersion.BUGZILLA_4_4) >= 0 || Boolean.parseBoolean(usebugaliases)) {
            BugzillaRepositoryConnectorTest.assertEquals((int)2, (int)results.size());
            BugzillaRepositoryConnectorTest.assertEquals((int)1, (int)failed.size());
        } else {
            BugzillaRepositoryConnectorTest.assertEquals((int)1, (int)results.size());
            BugzillaRepositoryConnectorTest.assertEquals((int)2, (int)failed.size());
        }
    }

    public void testMultiRetrievalFailure() throws Exception {
        TaskData taskData1 = BugzillaFixture.current().createTask(CommonTestUtil.PrivilegeLevel.USER, null, null);
        TaskData taskData2 = BugzillaFixture.current().createTask(CommonTestUtil.PrivilegeLevel.USER, null, null);
        ITask task1 = TasksUi.getRepositoryModel().createTask(this.repository, taskData1.getTaskId());
        ITask taskX = TasksUi.getRepositoryModel().createTask(this.repository, "99999");
        ITask task2 = TasksUi.getRepositoryModel().createTask(this.repository, taskData2.getTaskId());
        TasksUiPlugin.getTaskList().addTask(task1);
        TasksUiPlugin.getTaskList().addTask(taskX);
        TasksUiPlugin.getTaskList().addTask(task2);
        HashSet<ITask> tasks = new HashSet<ITask>();
        tasks.add(task1);
        tasks.add(taskX);
        tasks.add(task2);
        TasksUiInternal.synchronizeTasks((AbstractRepositoryConnector)this.connector, tasks, (boolean)true, null);
        BugzillaRepositoryConnectorTest.assertNotNull((Object)TasksUiPlugin.getTaskDataManager().getTaskData(task1));
        BugzillaRepositoryConnectorTest.assertNotNull((Object)TasksUiPlugin.getTaskDataManager().getTaskData(task2));
        BugzillaRepositoryConnectorTest.assertNull((Object)TasksUiPlugin.getTaskDataManager().getTaskData(taskX));
        BugzillaRepositoryConnectorTest.assertNull((Object)((AbstractTask)task1).getStatus());
        BugzillaRepositoryConnectorTest.assertNull((Object)((AbstractTask)task2).getStatus());
        BugzillaRepositoryConnectorTest.assertEquals((String)IBugzillaConstants.ERROR_MSG_NO_DATA_RETRIEVED, (String)((AbstractTask)taskX).getStatus().getMessage());
    }

    public void testStdWorkflow() throws Exception {
        String taskId = this.harness.taskCfBugIdExists();
        if (taskId == null) {
            taskId = this.harness.createCfBugIdTask();
        }
        if (BugzillaFixture.current().getBugzillaVersion().compareMajorMinorOnly(BugzillaVersion.BUGZILLA_4_0) < 0) {
            if (!BugzillaFixture.current().isCustomWorkflow() && !BugzillaFixture.current().isCustomWorkflowAndStatus()) {
                this.doStdWorkflow32(taskId);
            }
        } else {
            this.doStdWorkflow40_1(taskId);
            this.doStdWorkflow40_2(taskId);
        }
    }

    private void doStdWorkflow40_1(String dupBugID) throws Exception {
        TaskMapping taskMappingInit = new TaskMapping(){

            public String getProduct() {
                return "TestProduct";
            }
        };
        TaskMapping taskMappingSelect = new TaskMapping(){

            public String getComponent() {
                return "TestComponent";
            }

            public String getSummary() {
                return "test the std workflow";
            }

            public String getDescription() {
                return "The Description of the std workflow task";
            }
        };
        TaskData[] taskDataNew = new TaskData[]{TasksUiInternal.createTaskData((TaskRepository)this.repository, (ITaskMapping)taskMappingInit, (ITaskMapping)taskMappingSelect, null)};
        ITask taskNew = TasksUiUtil.createOutgoingNewTask((String)taskDataNew[0].getConnectorKind(), (String)taskDataNew[0].getRepositoryUrl());
        ITaskDataWorkingCopy workingCopy = TasksUi.getTaskDataManager().createWorkingCopy(taskNew, taskDataNew[0]);
        HashSet<TaskAttribute> changed = new HashSet<TaskAttribute>();
        workingCopy.save(changed, null);
        RepositoryResponse response = BugzillaFixture.current().submitTask(taskDataNew[0], this.client);
        ((AbstractTask)taskNew).setSubmitting(true);
        BugzillaRepositoryConnectorTest.assertNotNull((Object)response);
        BugzillaRepositoryConnectorTest.assertEquals((String)RepositoryResponse.ResponseKind.TASK_CREATED.toString(), (String)response.getReposonseKind().toString());
        String taskId = response.getTaskId();
        ITask task = this.generateLocalTaskAndDownload(taskId);
        BugzillaRepositoryConnectorTest.assertNotNull((Object)task);
        TaskDataModel model = this.createModel(task);
        TaskData taskData = model.getTaskData();
        BugzillaRepositoryConnectorTest.assertNotNull((Object)taskData);
        TaskAttribute statusAttribute = taskData.getRoot().getMappedAttribute("task.common.status");
        BugzillaRepositoryConnectorTest.assertEquals((String)"CONFIRMED", (String)statusAttribute.getValue());
        TaskAttribute selectedOperationAttribute = taskData.getRoot().getMappedAttribute("task.common.operation");
        TaskAttribute operationAttribute = taskData.getRoot().getAttribute("task.common.operation-" + BugzillaOperation.in_progress.toString());
        TaskAttribute operationAttributeUppercase = taskData.getRoot().getAttribute("task.common.operation-" + BugzillaOperation.in_progress.toString().toUpperCase());
        TaskOperation.applyTo((TaskAttribute)selectedOperationAttribute, (String)(operationAttribute != null ? operationAttribute.getValue() : operationAttributeUppercase.getValue()), (String)BugzillaOperation.in_progress.getLabel());
        model.attributeChanged(selectedOperationAttribute);
        changed.clear();
        changed.add(selectedOperationAttribute);
        workingCopy.save(changed, null);
        response = BugzillaFixture.current().submitTask(taskData, this.client);
        BugzillaRepositoryConnectorTest.assertEquals((String)RepositoryResponse.ResponseKind.TASK_UPDATED.toString(), (String)response.getReposonseKind().toString());
        task = this.generateLocalTaskAndDownload(taskId);
        BugzillaRepositoryConnectorTest.assertNotNull((Object)task);
        model = this.createModel(task);
        taskData = model.getTaskData();
        BugzillaRepositoryConnectorTest.assertNotNull((Object)taskData);
        statusAttribute = taskData.getRoot().getMappedAttribute("task.common.status");
        BugzillaRepositoryConnectorTest.assertEquals((String)"IN_PROGRESS", (String)statusAttribute.getValue());
        selectedOperationAttribute = taskData.getRoot().getMappedAttribute("task.common.operation");
        TaskOperation.applyTo((TaskAttribute)selectedOperationAttribute, (String)BugzillaOperation.duplicate.toString(), (String)BugzillaOperation.duplicate.getLabel());
        TaskAttribute duplicateAttribute = taskData.getRoot().getAttribute("dup_id");
        duplicateAttribute.setValue(dupBugID);
        model.attributeChanged(selectedOperationAttribute);
        model.attributeChanged(duplicateAttribute);
        changed.clear();
        changed.add(selectedOperationAttribute);
        changed.add(duplicateAttribute);
        workingCopy.save(changed, null);
        response = BugzillaFixture.current().submitTask(taskData, this.client);
        BugzillaRepositoryConnectorTest.assertNotNull((Object)response);
        BugzillaRepositoryConnectorTest.assertEquals((String)RepositoryResponse.ResponseKind.TASK_UPDATED.toString(), (String)response.getReposonseKind().toString());
        task = this.generateLocalTaskAndDownload(taskId);
        BugzillaRepositoryConnectorTest.assertNotNull((Object)task);
        model = this.createModel(task);
        taskData = model.getTaskData();
        BugzillaRepositoryConnectorTest.assertNotNull((Object)taskData);
        statusAttribute = taskData.getRoot().getMappedAttribute("task.common.status");
        BugzillaRepositoryConnectorTest.assertEquals((String)"RESOLVED", (String)statusAttribute.getValue());
        TaskAttribute resolution = taskData.getRoot().getMappedAttribute("task.common.resolution");
        BugzillaRepositoryConnectorTest.assertEquals((String)"DUPLICATE", (String)resolution.getValue());
        selectedOperationAttribute = taskData.getRoot().getMappedAttribute("task.common.operation");
        TaskOperation.applyTo((TaskAttribute)selectedOperationAttribute, (String)BugzillaOperation.verify.toString(), (String)BugzillaOperation.verify.getLabel());
        model.attributeChanged(selectedOperationAttribute);
        changed.clear();
        changed.add(selectedOperationAttribute);
        workingCopy.save(changed, null);
        response = BugzillaFixture.current().submitTask(taskData, this.client);
        BugzillaRepositoryConnectorTest.assertNotNull((Object)response);
        BugzillaRepositoryConnectorTest.assertEquals((String)RepositoryResponse.ResponseKind.TASK_UPDATED.toString(), (String)response.getReposonseKind().toString());
        task = this.generateLocalTaskAndDownload(taskId);
        BugzillaRepositoryConnectorTest.assertNotNull((Object)task);
        model = this.createModel(task);
        taskData = model.getTaskData();
        BugzillaRepositoryConnectorTest.assertNotNull((Object)taskData);
        statusAttribute = taskData.getRoot().getMappedAttribute("task.common.status");
        BugzillaRepositoryConnectorTest.assertEquals((String)"VERIFIED", (String)statusAttribute.getValue());
        selectedOperationAttribute = taskData.getRoot().getMappedAttribute("task.common.operation");
        operationAttribute = taskData.getRoot().getAttribute("task.common.operation-" + BugzillaOperation.confirmed.toString());
        operationAttributeUppercase = taskData.getRoot().getAttribute("task.common.operation-" + BugzillaOperation.confirmed.toString().toUpperCase());
        TaskOperation.applyTo((TaskAttribute)selectedOperationAttribute, (String)(operationAttribute != null ? operationAttribute.getValue() : operationAttributeUppercase.getValue()), (String)BugzillaOperation.confirmed.getLabel());
        model.attributeChanged(selectedOperationAttribute);
        changed.clear();
        changed.add(selectedOperationAttribute);
        workingCopy.save(changed, null);
        response = BugzillaFixture.current().submitTask(taskData, this.client);
        BugzillaRepositoryConnectorTest.assertNotNull((Object)response);
        BugzillaRepositoryConnectorTest.assertEquals((String)RepositoryResponse.ResponseKind.TASK_UPDATED.toString(), (String)response.getReposonseKind().toString());
        task = this.generateLocalTaskAndDownload(taskId);
        BugzillaRepositoryConnectorTest.assertNotNull((Object)task);
        model = this.createModel(task);
        taskData = model.getTaskData();
        BugzillaRepositoryConnectorTest.assertNotNull((Object)taskData);
        statusAttribute = taskData.getRoot().getMappedAttribute("task.common.status");
        BugzillaRepositoryConnectorTest.assertEquals((String)"CONFIRMED", (String)statusAttribute.getValue());
        selectedOperationAttribute = taskData.getRoot().getMappedAttribute("task.common.operation");
        TaskOperation.applyTo((TaskAttribute)selectedOperationAttribute, (String)BugzillaOperation.resolve.toString(), (String)BugzillaOperation.resolve.getLabel());
        resolution = taskData.getRoot().getMappedAttribute("task.common.resolution");
        resolution.setValue("FIXED");
        model.attributeChanged(selectedOperationAttribute);
        changed.clear();
        changed.add(selectedOperationAttribute);
        workingCopy.save(changed, null);
        response = BugzillaFixture.current().submitTask(taskData, this.client);
        BugzillaRepositoryConnectorTest.assertNotNull((Object)response);
        BugzillaRepositoryConnectorTest.assertEquals((String)RepositoryResponse.ResponseKind.TASK_UPDATED.toString(), (String)response.getReposonseKind().toString());
        task = this.generateLocalTaskAndDownload(taskId);
        BugzillaRepositoryConnectorTest.assertNotNull((Object)task);
        model = this.createModel(task);
        taskData = model.getTaskData();
        BugzillaRepositoryConnectorTest.assertNotNull((Object)taskData);
        statusAttribute = taskData.getRoot().getMappedAttribute("task.common.status");
        BugzillaRepositoryConnectorTest.assertEquals((String)"RESOLVED", (String)statusAttribute.getValue());
        resolution = taskData.getRoot().getMappedAttribute("task.common.resolution");
        BugzillaRepositoryConnectorTest.assertEquals((String)"FIXED", (String)resolution.getValue());
    }

    private void doStdWorkflow40_2(String dupBugID) throws Exception {
        TaskMapping taskMappingInit = new TaskMapping(){

            public String getProduct() {
                return "Product with Spaces";
            }
        };
        TaskMapping taskMappingSelect = new TaskMapping(){

            public String getComponent() {
                return "Component 1";
            }

            public String getSummary() {
                return "test the std workflow for Product with Spaces";
            }

            public String getDescription() {
                return "The Description of the std workflow task";
            }
        };
        TaskData[] taskDataNew = new TaskData[]{TasksUiInternal.createTaskData((TaskRepository)this.repository, (ITaskMapping)taskMappingInit, (ITaskMapping)taskMappingSelect, null)};
        ITask taskNew = TasksUiUtil.createOutgoingNewTask((String)taskDataNew[0].getConnectorKind(), (String)taskDataNew[0].getRepositoryUrl());
        ITaskDataWorkingCopy workingCopy = TasksUi.getTaskDataManager().createWorkingCopy(taskNew, taskDataNew[0]);
        TaskAttribute selectedOperationAttribute = taskDataNew[0].getRoot().getMappedAttribute("task.common.operation");
        TaskOperation.applyTo((TaskAttribute)selectedOperationAttribute, (String)BugzillaOperation.unconfirmed.toString(), (String)BugzillaOperation.unconfirmed.getLabel());
        HashSet<TaskAttribute> changed = new HashSet<TaskAttribute>();
        changed.add(selectedOperationAttribute);
        workingCopy.save(changed, null);
        RepositoryResponse response = BugzillaFixture.current().submitTask(taskDataNew[0], this.client);
        ((AbstractTask)taskNew).setSubmitting(true);
        BugzillaRepositoryConnectorTest.assertNotNull((Object)response);
        BugzillaRepositoryConnectorTest.assertEquals((String)RepositoryResponse.ResponseKind.TASK_CREATED.toString(), (String)response.getReposonseKind().toString());
        String taskId = response.getTaskId();
        ITask task = this.generateLocalTaskAndDownload(taskId);
        BugzillaRepositoryConnectorTest.assertNotNull((Object)task);
        TaskDataModel model = this.createModel(task);
        TaskData taskData = model.getTaskData();
        BugzillaRepositoryConnectorTest.assertNotNull((Object)taskData);
        TaskAttribute statusAttribute = taskData.getRoot().getMappedAttribute("task.common.status");
        BugzillaRepositoryConnectorTest.assertEquals((String)"UNCONFIRMED", (String)statusAttribute.getValue());
        selectedOperationAttribute = taskData.getRoot().getMappedAttribute("task.common.operation");
        TaskOperation.applyTo((TaskAttribute)selectedOperationAttribute, (String)BugzillaOperation.duplicate.toString(), (String)BugzillaOperation.duplicate.getLabel());
        TaskAttribute duplicateAttribute = taskData.getRoot().getAttribute("dup_id");
        duplicateAttribute.setValue(dupBugID);
        model.attributeChanged(selectedOperationAttribute);
        model.attributeChanged(duplicateAttribute);
        changed.clear();
        changed.add(selectedOperationAttribute);
        changed.add(duplicateAttribute);
        workingCopy.save(changed, null);
        response = BugzillaFixture.current().submitTask(taskData, this.client);
        BugzillaRepositoryConnectorTest.assertNotNull((Object)response);
        BugzillaRepositoryConnectorTest.assertEquals((String)RepositoryResponse.ResponseKind.TASK_UPDATED.toString(), (String)response.getReposonseKind().toString());
    }

    private void doStdWorkflow32(String dupBugID) throws Exception {
        TaskMapping taskMappingInit = new TaskMapping(){

            public String getProduct() {
                return "TestProduct";
            }
        };
        TaskMapping taskMappingSelect = new TaskMapping(){

            public String getComponent() {
                return "TestComponent";
            }

            public String getSummary() {
                return "test the std workflow";
            }

            public String getDescription() {
                return "The Description of the std workflow task";
            }
        };
        TaskData[] taskDataNew = new TaskData[]{TasksUiInternal.createTaskData((TaskRepository)this.repository, (ITaskMapping)taskMappingInit, (ITaskMapping)taskMappingSelect, null)};
        ITask taskNew = TasksUiUtil.createOutgoingNewTask((String)taskDataNew[0].getConnectorKind(), (String)taskDataNew[0].getRepositoryUrl());
        ITaskDataWorkingCopy workingCopy = TasksUi.getTaskDataManager().createWorkingCopy(taskNew, taskDataNew[0]);
        HashSet<TaskAttribute> changed = new HashSet<TaskAttribute>();
        workingCopy.save(changed, null);
        RepositoryResponse response = BugzillaFixture.current().submitTask(taskDataNew[0], this.client);
        ((AbstractTask)taskNew).setSubmitting(true);
        BugzillaRepositoryConnectorTest.assertNotNull((Object)response);
        BugzillaRepositoryConnectorTest.assertEquals((String)RepositoryResponse.ResponseKind.TASK_CREATED.toString(), (String)response.getReposonseKind().toString());
        String taskId = response.getTaskId();
        ITask task = this.generateLocalTaskAndDownload(taskId);
        BugzillaRepositoryConnectorTest.assertNotNull((Object)task);
        TaskDataModel model = this.createModel(task);
        TaskData taskData = model.getTaskData();
        BugzillaRepositoryConnectorTest.assertNotNull((Object)taskData);
        TaskAttribute statusAttribute = taskData.getRoot().getMappedAttribute("task.common.status");
        BugzillaRepositoryConnectorTest.assertEquals((String)"NEW", (String)statusAttribute.getValue());
        TaskAttribute selectedOperationAttribute = taskData.getRoot().getMappedAttribute("task.common.operation");
        TaskOperation.applyTo((TaskAttribute)selectedOperationAttribute, (String)BugzillaOperation.accept.toString(), (String)BugzillaOperation.accept.getLabel());
        model.attributeChanged(selectedOperationAttribute);
        changed.clear();
        changed.add(selectedOperationAttribute);
        workingCopy.save(changed, null);
        response = BugzillaFixture.current().submitTask(taskData, this.client);
        BugzillaRepositoryConnectorTest.assertEquals((String)RepositoryResponse.ResponseKind.TASK_UPDATED.toString(), (String)response.getReposonseKind().toString());
        task = this.generateLocalTaskAndDownload(taskId);
        BugzillaRepositoryConnectorTest.assertNotNull((Object)task);
        model = this.createModel(task);
        taskData = model.getTaskData();
        BugzillaRepositoryConnectorTest.assertNotNull((Object)taskData);
        statusAttribute = taskData.getRoot().getMappedAttribute("task.common.status");
        BugzillaRepositoryConnectorTest.assertEquals((String)"ASSIGNED", (String)statusAttribute.getValue());
        selectedOperationAttribute = taskData.getRoot().getMappedAttribute("task.common.operation");
        TaskOperation.applyTo((TaskAttribute)selectedOperationAttribute, (String)BugzillaOperation.duplicate.toString(), (String)BugzillaOperation.duplicate.getLabel());
        TaskAttribute duplicateAttribute = taskData.getRoot().getAttribute("dup_id");
        duplicateAttribute.setValue(dupBugID);
        model.attributeChanged(selectedOperationAttribute);
        model.attributeChanged(duplicateAttribute);
        changed.clear();
        changed.add(selectedOperationAttribute);
        changed.add(duplicateAttribute);
        workingCopy.save(changed, null);
        response = BugzillaFixture.current().submitTask(taskData, this.client);
        BugzillaRepositoryConnectorTest.assertNotNull((Object)response);
        BugzillaRepositoryConnectorTest.assertEquals((String)RepositoryResponse.ResponseKind.TASK_UPDATED.toString(), (String)response.getReposonseKind().toString());
        task = this.generateLocalTaskAndDownload(taskId);
        BugzillaRepositoryConnectorTest.assertNotNull((Object)task);
        model = this.createModel(task);
        taskData = model.getTaskData();
        BugzillaRepositoryConnectorTest.assertNotNull((Object)taskData);
        statusAttribute = taskData.getRoot().getMappedAttribute("task.common.status");
        BugzillaRepositoryConnectorTest.assertEquals((String)"RESOLVED", (String)statusAttribute.getValue());
        TaskAttribute resolution = taskData.getRoot().getMappedAttribute("task.common.resolution");
        BugzillaRepositoryConnectorTest.assertEquals((String)"DUPLICATE", (String)resolution.getValue());
        selectedOperationAttribute = taskData.getRoot().getMappedAttribute("task.common.operation");
        TaskOperation.applyTo((TaskAttribute)selectedOperationAttribute, (String)BugzillaOperation.verify.toString(), (String)BugzillaOperation.verify.getLabel());
        model.attributeChanged(selectedOperationAttribute);
        changed.clear();
        changed.add(selectedOperationAttribute);
        workingCopy.save(changed, null);
        response = BugzillaFixture.current().submitTask(taskData, this.client);
        BugzillaRepositoryConnectorTest.assertNotNull((Object)response);
        BugzillaRepositoryConnectorTest.assertEquals((String)RepositoryResponse.ResponseKind.TASK_UPDATED.toString(), (String)response.getReposonseKind().toString());
        task = this.generateLocalTaskAndDownload(taskId);
        BugzillaRepositoryConnectorTest.assertNotNull((Object)task);
        model = this.createModel(task);
        taskData = model.getTaskData();
        BugzillaRepositoryConnectorTest.assertNotNull((Object)taskData);
        statusAttribute = taskData.getRoot().getMappedAttribute("task.common.status");
        BugzillaRepositoryConnectorTest.assertEquals((String)"VERIFIED", (String)statusAttribute.getValue());
        selectedOperationAttribute = taskData.getRoot().getMappedAttribute("task.common.operation");
        TaskOperation.applyTo((TaskAttribute)selectedOperationAttribute, (String)BugzillaOperation.close.toString(), (String)BugzillaOperation.close.getLabel());
        model.attributeChanged(selectedOperationAttribute);
        changed.clear();
        changed.add(selectedOperationAttribute);
        workingCopy.save(changed, null);
        response = BugzillaFixture.current().submitTask(taskData, this.client);
        BugzillaRepositoryConnectorTest.assertNotNull((Object)response);
        BugzillaRepositoryConnectorTest.assertEquals((String)RepositoryResponse.ResponseKind.TASK_UPDATED.toString(), (String)response.getReposonseKind().toString());
        task = this.generateLocalTaskAndDownload(taskId);
        BugzillaRepositoryConnectorTest.assertNotNull((Object)task);
        model = this.createModel(task);
        taskData = model.getTaskData();
        BugzillaRepositoryConnectorTest.assertNotNull((Object)taskData);
        statusAttribute = taskData.getRoot().getMappedAttribute("task.common.status");
        BugzillaRepositoryConnectorTest.assertEquals((String)"CLOSED", (String)statusAttribute.getValue());
        selectedOperationAttribute = taskData.getRoot().getMappedAttribute("task.common.operation");
        TaskOperation.applyTo((TaskAttribute)selectedOperationAttribute, (String)BugzillaOperation.reopen.toString(), (String)BugzillaOperation.reopen.getLabel());
        model.attributeChanged(selectedOperationAttribute);
        changed.clear();
        changed.add(selectedOperationAttribute);
        workingCopy.save(changed, null);
        response = BugzillaFixture.current().submitTask(taskData, this.client);
        BugzillaRepositoryConnectorTest.assertNotNull((Object)response);
        BugzillaRepositoryConnectorTest.assertEquals((String)RepositoryResponse.ResponseKind.TASK_UPDATED.toString(), (String)response.getReposonseKind().toString());
        task = this.generateLocalTaskAndDownload(taskId);
        BugzillaRepositoryConnectorTest.assertNotNull((Object)task);
        model = this.createModel(task);
        taskData = model.getTaskData();
        BugzillaRepositoryConnectorTest.assertNotNull((Object)taskData);
        statusAttribute = taskData.getRoot().getMappedAttribute("task.common.status");
        BugzillaRepositoryConnectorTest.assertEquals((String)"REOPENED", (String)statusAttribute.getValue());
        selectedOperationAttribute = taskData.getRoot().getMappedAttribute("task.common.operation");
        TaskOperation.applyTo((TaskAttribute)selectedOperationAttribute, (String)BugzillaOperation.resolve.toString(), (String)BugzillaOperation.resolve.getLabel());
        resolution = taskData.getRoot().getMappedAttribute("task.common.resolution");
        resolution.setValue("FIXED");
        model.attributeChanged(selectedOperationAttribute);
        model.attributeChanged(resolution);
        changed.clear();
        changed.add(selectedOperationAttribute);
        changed.add(resolution);
        workingCopy.save(changed, null);
        response = BugzillaFixture.current().submitTask(taskData, this.client);
        BugzillaRepositoryConnectorTest.assertNotNull((Object)response);
        BugzillaRepositoryConnectorTest.assertEquals((String)RepositoryResponse.ResponseKind.TASK_UPDATED.toString(), (String)response.getReposonseKind().toString());
        task = this.generateLocalTaskAndDownload(taskId);
        BugzillaRepositoryConnectorTest.assertNotNull((Object)task);
        model = this.createModel(task);
        taskData = model.getTaskData();
        BugzillaRepositoryConnectorTest.assertNotNull((Object)taskData);
        statusAttribute = taskData.getRoot().getMappedAttribute("task.common.status");
        BugzillaRepositoryConnectorTest.assertEquals((String)"RESOLVED", (String)statusAttribute.getValue());
        resolution = taskData.getRoot().getMappedAttribute("task.common.resolution");
        BugzillaRepositoryConnectorTest.assertEquals((String)"FIXED", (String)resolution.getValue());
    }

    public void testGetTaskData() throws Exception {
        TaskData data = BugzillaFixture.current().createTask(CommonTestUtil.PrivilegeLevel.USER, null, null);
        BugzillaRepositoryConnectorTest.assertNotNull((Object)data);
        TaskData data2 = this.connector.getTaskData(this.repository, data.getTaskId(), (IProgressMonitor)new NullProgressMonitor());
        BugzillaRepositoryConnectorTest.assertNotNull((Object)data2);
        for (TaskAttribute attribute : data.getRoot().getAttributes().values()) {
            if (attribute.getId().equals(BugzillaAttribute.TOKEN.getKey())) continue;
            TaskAttribute attr = data2.getRoot().getAttribute(attribute.getId());
            BugzillaRepositoryConnectorTest.assertNotNull((Object)attr);
            BugzillaRepositoryConnectorTest.assertEquals((String)attribute.getValue(), (String)attr.getValue());
        }
    }

    public void testMidAirCollision() throws Exception {
        TaskData data = BugzillaFixture.current().createTask(CommonTestUtil.PrivilegeLevel.USER, null, null);
        BugzillaRepositoryConnectorTest.assertNotNull((Object)data);
        ITask task = this.generateLocalTaskAndDownload(data.getTaskId());
        ITaskDataWorkingCopy workingCopy = TasksUiPlugin.getTaskDataManager().getWorkingCopy(task);
        TaskData taskData = workingCopy.getLocalData();
        BugzillaRepositoryConnectorTest.assertNotNull((Object)taskData);
        String newCommentText = "BugzillaRepositoryClientTest.testMidAirCollision(): test " + new Date().toString();
        TaskAttribute attrNewComment = data.getRoot().getMappedAttribute("task.common.comment.new");
        attrNewComment.setValue(newCommentText);
        HashSet<TaskAttribute> changed = new HashSet<TaskAttribute>();
        changed.add(attrNewComment);
        RepositoryResponse response = BugzillaFixture.current().submitTask(data, this.client);
        workingCopy = TasksUiPlugin.getTaskDataManager().getWorkingCopy(task);
        taskData = workingCopy.getLocalData();
        BugzillaRepositoryConnectorTest.assertNotNull((Object)taskData);
        newCommentText = "BugzillaRepositoryClientTest.testMidAirCollision(): test #### " + new Date().toString();
        attrNewComment = data.getRoot().getMappedAttribute("task.common.comment.new");
        attrNewComment.setValue(newCommentText);
        changed = new HashSet();
        changed.add(attrNewComment);
        TaskAttribute attrDeltaTs = data.getRoot().getMappedAttribute("task.common.date.modified");
        attrDeltaTs.setValue("2007-01-01 00:00:00");
        changed.add(attrDeltaTs);
        try {
            response = BugzillaFixture.current().submitTask(data, this.client);
            BugzillaRepositoryConnectorTest.assertNotNull((Object)response);
            System.err.println("\n\ntestMidAirCollision >>> ResponseKind:" + response.getReposonseKind().toString() + "\n\n");
            BugzillaRepositoryConnectorTest.fail((String)"Mid-air collision expected");
        }
        catch (CoreException e) {
            BugzillaRepositoryConnectorTest.assertTrue((e.getStatus().getMessage().indexOf("Mid-air collision occurred while submitting") != -1 ? 1 : 0) != 0);
            return;
        }
        BugzillaRepositoryConnectorTest.fail((String)"Mid-air collision expected");
    }

    public void testAuthenticationCredentials() throws Exception {
        this.repository = this.client.getTaskRepository();
        TaskData data = BugzillaFixture.current().createTask(CommonTestUtil.PrivilegeLevel.USER, null, null);
        BugzillaRepositoryConnectorTest.assertNotNull((Object)data);
        ITask task = this.generateLocalTaskAndDownload(data.getTaskId());
        BugzillaRepositoryConnectorTest.assertNotNull((Object)task);
        TasksUiPlugin.getTaskActivityManager().activateTask(task);
        File sourceContextFile = TasksUiPlugin.getContextStore().getFileForContext(task);
        BugzillaRepositoryConnectorTest.assertEquals((Object)ITask.SynchronizationState.SYNCHRONIZED, (Object)task.getSynchronizationState());
        sourceContextFile.createNewFile();
        sourceContextFile.deleteOnExit();
        AuthenticationCredentials oldCreds = this.repository.getCredentials(AuthenticationType.REPOSITORY);
        AuthenticationCredentials wrongCreds = new AuthenticationCredentials("wrong", "wrong");
        this.repository.setCredentials(AuthenticationType.REPOSITORY, wrongCreds, false);
        TasksUiPlugin.getRepositoryManager().notifyRepositorySettingsChanged(this.repository);
        TaskData taskData = TasksUiPlugin.getTaskDataManager().getTaskData(task);
        TaskAttributeMapper mapper = taskData.getAttributeMapper();
        TaskAttribute attribute = mapper.createTaskAttachment(taskData);
        try {
            try {
                AttachmentUtil.postContext((AbstractRepositoryConnector)this.connector, (TaskRepository)this.repository, (ITask)task, (String)"test", (TaskAttribute)attribute, (IProgressMonitor)new NullProgressMonitor());
            }
            catch (CoreException e) {
                BugzillaRepositoryConnectorTest.assertEquals((Object)ITask.SynchronizationState.SYNCHRONIZED, (Object)task.getSynchronizationState());
                BugzillaRepositoryConnectorTest.assertTrue((boolean)BugzillaTestSupportUtil.isInvalidLogon(e));
                this.repository.setCredentials(AuthenticationType.REPOSITORY, oldCreds, false);
                TasksUiPlugin.getRepositoryManager().notifyRepositorySettingsChanged(this.repository);
                return;
            }
        }
        finally {
            this.repository.setCredentials(AuthenticationType.REPOSITORY, oldCreds, false);
            TasksUiPlugin.getRepositoryManager().notifyRepositorySettingsChanged(this.repository);
        }
        BugzillaRepositoryConnectorTest.fail((String)"Should have failed due to invalid userid and password.");
    }

    public void testSynchronize() throws CoreException, Exception {
        TaskData data = BugzillaFixture.current().createTask(CommonTestUtil.PrivilegeLevel.USER, null, null);
        BugzillaRepositoryConnectorTest.assertNotNull((Object)data);
        ITask task = this.generateLocalTaskAndDownload(data.getTaskId());
        TasksUi.getTaskDataManager().discardEdits(task);
        TaskDataModel model = this.createModel(task);
        TaskData taskData = model.getTaskData();
        BugzillaRepositoryConnectorTest.assertNotNull((Object)taskData);
        String newCommentText = "BugzillaRepositoryClientTest.testSynchronize(): " + new Date().toString();
        TaskAttribute attrNewComment = taskData.getRoot().getMappedAttribute("task.common.comment.new");
        attrNewComment.setValue(newCommentText);
        model.attributeChanged(attrNewComment);
        model.save((IProgressMonitor)new NullProgressMonitor());
        BugzillaRepositoryConnectorTest.assertEquals((Object)ITask.SynchronizationState.OUTGOING, (Object)task.getSynchronizationState());
        this.submit(model);
        BugzillaRepositoryConnectorTest.assertEquals((Object)ITask.SynchronizationState.SYNCHRONIZED, (Object)task.getSynchronizationState());
    }

    public void testMissingHits() throws Exception {
        ArrayList<String> taskId = this.harness.taskMissingHitsExists();
        if (taskId == null || taskId.isEmpty()) {
            this.harness.createMissingHitsTask();
        }
        String queryString = String.valueOf(BugzillaFixture.current().getRepositoryUrl()) + "/buglist.cgi?" + "short_desc=test%20Missing%20Hits&resolution=---&query_format=advanced" + "&short_desc_type=casesubstring&component=ManualC2&product=ManualTest";
        RepositoryQuery query = new RepositoryQuery("bugzilla", "test");
        query.setRepositoryUrl(this.repository.getRepositoryUrl());
        query.setUrl(queryString);
        TasksUiPlugin.getTaskList().addQuery(query);
        TasksUiInternal.synchronizeQuery((AbstractRepositoryConnector)this.connector, (RepositoryQuery)query, null, (boolean)true);
        for (ITask task : query.getChildren()) {
            BugzillaRepositoryConnectorTest.assertTrue((task.getSynchronizationState() == ITask.SynchronizationState.INCOMING_NEW ? 1 : 0) != 0);
            TasksUiPlugin.getTaskDataManager().setTaskRead(task, true);
            BugzillaRepositoryConnectorTest.assertTrue((task.getSynchronizationState() == ITask.SynchronizationState.SYNCHRONIZED ? 1 : 0) != 0);
        }
        this.repository.setSynchronizationTimeStamp("1970-01-01");
        TasksUiInternal.synchronizeQuery((AbstractRepositoryConnector)this.connector, (RepositoryQuery)query, null, (boolean)true);
        for (ITask task : query.getChildren()) {
            BugzillaRepositoryConnectorTest.assertTrue((task.getSynchronizationState() == ITask.SynchronizationState.SYNCHRONIZED ? 1 : 0) != 0);
        }
    }

    public void testMissingHitsWhileTaskChanged() throws Exception {
        String summary1 = "testMissingHitsWhileTaskChanged" + System.currentTimeMillis();
        TaskData data1 = BugzillaFixture.current().createTask(CommonTestUtil.PrivilegeLevel.USER, summary1, null);
        ITask task1 = this.generateLocalTaskAndDownload(data1.getTaskId());
        Thread.sleep(1000L);
        this.repository = BugzillaFixture.current().repository();
        String stamp = data1.getRoot().getMappedAttribute("task.common.date.modified").getValue();
        this.repository.setSynchronizationTimeStamp(stamp);
        SynchronizationSession session = new SynchronizationSession();
        session.setFullSynchronization(true);
        session.setTasks(Collections.singleton(task1));
        session.setTaskRepository(this.repository);
        this.connector.preSynchronization((ISynchronizationSession)session, null);
        Object data = session.getData();
        BugzillaRepositoryConnectorTest.assertNotNull((Object)session.getData());
        BugzillaRepositoryConnectorTest.assertEquals(Collections.singleton(task1), (Object)session.getStaleTasks());
        data1.getRoot().getMappedAttribute("task.common.summary").setValue(String.valueOf(summary1) + "updated");
        this.connector.getTaskDataHandler().postTaskData(this.repository, data1, null, null);
        IRepositoryQuery query = TasksUi.getRepositoryModel().createRepositoryQuery(this.repository);
        query.setUrl(String.valueOf(this.repository.getUrl()) + "buglist.cgi?query_format=advanced&short_desc_type=allwordssubstr&short_desc=" + summary1);
        BugzillaTaskDataCollector collector = new BugzillaTaskDataCollector();
        this.connector.performQuery(this.repository, query, (TaskDataCollector)collector, (ISynchronizationSession)session, null);
        BugzillaRepositoryConnectorTest.assertEquals((Object)data, (Object)session.getData());
        this.connector.postSynchronization((ISynchronizationSession)session, null);
        BugzillaRepositoryConnectorTest.assertFalse((boolean)stamp.equals(this.repository.getSynchronizationTimeStamp()));
        SynchronizationSession session2 = new SynchronizationSession();
        session2.setTasks(Collections.singleton(task1));
        session2.setTaskRepository(this.repository);
        this.connector.preSynchronization((ISynchronizationSession)session2, null);
        BugzillaRepositoryConnectorTest.assertEquals(Collections.singleton(task1), (Object)session2.getStaleTasks());
    }

    public void testAnonymousRepositoryAccess() throws Exception {
        BugzillaRepositoryConnectorTest.assertNotNull((Object)this.repository);
        AuthenticationCredentials anonymousCreds = new AuthenticationCredentials("", "");
        this.repository.setCredentials(AuthenticationType.REPOSITORY, anonymousCreds, false);
        TasksUiPlugin.getRepositoryManager().notifyRepositorySettingsChanged(this.repository);
        TaskData data = BugzillaFixture.current().createTask(CommonTestUtil.PrivilegeLevel.USER, null, null);
        BugzillaRepositoryConnectorTest.assertNotNull((Object)data);
        ITask task = this.generateLocalTaskAndDownload(data.getTaskId());
        BugzillaRepositoryConnectorTest.assertNotNull((Object)task);
        RepositoryConfiguration config = this.connector.getRepositoryConfiguration(this.repository, false, null);
        BugzillaRepositoryConnectorTest.assertNotNull((Object)config);
        BugzillaRepositoryConnectorTest.assertTrue((config.getOptionValues(BugzillaAttribute.COMPONENT).size() > 0 ? 1 : 0) != 0);
    }

    public void testTimeTracker() throws Exception {
        BugzillaVersion version = new BugzillaVersion(BugzillaFixture.current().getVersion());
        if (version.isSmallerOrEquals(BugzillaVersion.BUGZILLA_3_2)) {
            return;
        }
        boolean enableDeadline = true;
        TaskData data = BugzillaFixture.current().createTask(CommonTestUtil.PrivilegeLevel.USER, null, null);
        BugzillaRepositoryConnectorTest.assertNotNull((Object)data);
        ITask task = this.generateLocalTaskAndDownload(data.getTaskId());
        BugzillaRepositoryConnectorTest.assertNotNull((Object)task);
        TaskDataModel model = this.createModel(task);
        TaskData taskData = model.getTaskData();
        BugzillaRepositoryConnectorTest.assertNotNull((Object)taskData);
        BugzillaRepositoryConnectorTest.assertEquals((Object)ITask.SynchronizationState.SYNCHRONIZED, (Object)task.getSynchronizationState());
        HashSet<ITask> tasks = new HashSet<ITask>();
        tasks.add(task);
        this.synchAndAssertState(tasks, ITask.SynchronizationState.SYNCHRONIZED);
        String deadline = null;
        float estimatedTime = Float.parseFloat(taskData.getRoot().getAttribute(BugzillaAttribute.ESTIMATED_TIME.getKey()).getValue());
        float remainingTime = Float.parseFloat(taskData.getRoot().getAttribute(BugzillaAttribute.REMAINING_TIME.getKey()).getValue());
        float actualTime = Float.parseFloat(taskData.getRoot().getAttribute(BugzillaAttribute.ACTUAL_TIME.getKey()).getValue());
        if (enableDeadline) {
            deadline = taskData.getRoot().getAttribute(BugzillaAttribute.DEADLINE.getKey()).getValue();
        }
        estimatedTime += 2.0f;
        remainingTime = (float)((double)remainingTime + 1.5);
        float addTime = 0.75f;
        if (enableDeadline) {
            deadline = this.generateNewDay();
        }
        taskData.getRoot().getAttribute(BugzillaAttribute.ESTIMATED_TIME.getKey()).setValue("" + estimatedTime);
        taskData.getRoot().getAttribute(BugzillaAttribute.REMAINING_TIME.getKey()).setValue("" + remainingTime);
        TaskAttribute workTime = taskData.getRoot().getAttribute(BugzillaAttribute.WORK_TIME.getKey());
        if (workTime == null) {
            BugzillaTaskDataHandler.createAttribute((TaskAttribute)taskData.getRoot(), (BugzillaAttribute)BugzillaAttribute.WORK_TIME);
            workTime = taskData.getRoot().getAttribute(BugzillaAttribute.WORK_TIME.getKey());
        }
        workTime.setValue("" + addTime);
        if (enableDeadline) {
            taskData.getRoot().getAttribute(BugzillaAttribute.DEADLINE.getKey()).setValue(deadline);
        }
        taskData.getRoot().getAttribute(BugzillaAttribute.NEW_COMMENT.getKey()).setValue("New Estimate: " + estimatedTime + "\nNew Remaining: " + remainingTime + "\nAdd: " + addTime);
        HashSet<TaskAttribute> changed = new HashSet<TaskAttribute>();
        changed.add(taskData.getRoot().getAttribute(BugzillaAttribute.ESTIMATED_TIME.getKey()));
        changed.add(taskData.getRoot().getAttribute(BugzillaAttribute.REMAINING_TIME.getKey()));
        changed.add(taskData.getRoot().getAttribute(BugzillaAttribute.WORK_TIME.getKey()));
        if (enableDeadline) {
            changed.add(taskData.getRoot().getAttribute(BugzillaAttribute.DEADLINE.getKey()));
        }
        changed.add(taskData.getRoot().getAttribute(BugzillaAttribute.NEW_COMMENT.getKey()));
        BugzillaFixture.current().submitTask(taskData, this.client);
        this.synchAndAssertState(tasks, ITask.SynchronizationState.SYNCHRONIZED);
        model = this.createModel(task);
        taskData = model.getTaskData();
        BugzillaRepositoryConnectorTest.assertEquals((Object)Float.valueOf(estimatedTime), (Object)Float.valueOf(Float.parseFloat(taskData.getRoot().getAttribute(BugzillaAttribute.ESTIMATED_TIME.getKey()).getValue())));
        BugzillaRepositoryConnectorTest.assertEquals((Object)Float.valueOf(remainingTime), (Object)Float.valueOf(Float.parseFloat(taskData.getRoot().getAttribute(BugzillaAttribute.REMAINING_TIME.getKey()).getValue())));
        BugzillaRepositoryConnectorTest.assertEquals((Object)Float.valueOf(actualTime + addTime), (Object)Float.valueOf(Float.parseFloat(taskData.getRoot().getAttribute(BugzillaAttribute.ACTUAL_TIME.getKey()).getValue())));
        if (enableDeadline) {
            BugzillaRepositoryConnectorTest.assertEquals((String)deadline, (String)taskData.getRoot().getAttribute(BugzillaAttribute.DEADLINE.getKey()).getValue());
        }
    }

    private String generateNewDay() {
        int year = 2006;
        int month = (int)(Math.random() * 12.0 + 1.0);
        int day = (int)(Math.random() * 28.0 + 1.0);
        return year + "-" + (month <= 9 ? "0" : "") + month + "-" + (day <= 9 ? "0" : "") + day;
    }

    public void testSynchChangedReports() throws Exception {
        TaskData data = BugzillaFixture.current().createTask(CommonTestUtil.PrivilegeLevel.USER, null, null);
        if (BugzillaVersion.BUGZILLA_HEAD.compareTo(BugzillaFixture.current().getBugzillaVersion()) == 0 && BugzillaFixture.current().getRepositoryUrl().contains("mylyn.eclipse.org")) {
            return;
        }
        RepositoryConfiguration repositoryConfiguration = this.connector.getRepositoryConfiguration(this.repository.getRepositoryUrl());
        List priorities = repositoryConfiguration.getOptionValues(BugzillaAttribute.PRIORITY);
        String priority1 = (String)priorities.get(0);
        String priority2 = (String)priorities.get(1);
        BugzillaRepositoryConnectorTest.assertNotNull((Object)data);
        ITask task4 = this.generateLocalTaskAndDownload(data.getTaskId());
        BugzillaRepositoryConnectorTest.assertNotNull((Object)task4);
        TaskDataModel model4 = this.createModel(task4);
        TaskData taskData4 = model4.getTaskData();
        BugzillaRepositoryConnectorTest.assertNotNull((Object)taskData4);
        BugzillaRepositoryConnectorTest.assertEquals((Object)ITask.SynchronizationState.SYNCHRONIZED, (Object)task4.getSynchronizationState());
        TaskData data2 = BugzillaFixture.current().createTask(CommonTestUtil.PrivilegeLevel.USER, null, null);
        BugzillaRepositoryConnectorTest.assertNotNull((Object)data2);
        ITask task5 = this.generateLocalTaskAndDownload(data2.getTaskId());
        BugzillaRepositoryConnectorTest.assertNotNull((Object)task5);
        TaskDataModel model5 = this.createModel(task5);
        TaskData taskData5 = model5.getTaskData();
        BugzillaRepositoryConnectorTest.assertNotNull((Object)taskData5);
        BugzillaRepositoryConnectorTest.assertEquals((Object)ITask.SynchronizationState.SYNCHRONIZED, (Object)task5.getSynchronizationState());
        HashSet<ITask> tasks = new HashSet<ITask>();
        tasks.add(task4);
        tasks.add(task5);
        SimpleDateFormat timeDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Date lastModTime4 = null;
        Date lastModTime5 = null;
        String mostRecentTimeStamp4 = taskData4.getRoot().getAttribute(BugzillaAttribute.DELTA_TS.getKey()).getValue();
        String mostRecentTimeStamp = taskData5.getRoot().getAttribute(BugzillaAttribute.DELTA_TS.getKey()).getValue();
        lastModTime4 = timeDateFormat.parse(mostRecentTimeStamp4);
        lastModTime5 = timeDateFormat.parse(mostRecentTimeStamp);
        BugzillaRepositoryConnectorTest.assertTrue((String)"Precondition not mached", (boolean)lastModTime5.after(lastModTime4));
        this.repository.setSynchronizationTimeStamp(mostRecentTimeStamp);
        SynchronizationSession event = new SynchronizationSession();
        event.setTasks(tasks);
        event.setNeedsPerformQueries(true);
        event.setTaskRepository(this.repository);
        event.setFullSynchronization(true);
        this.connector.preSynchronization((ISynchronizationSession)event, null);
        BugzillaRepositoryConnectorTest.assertTrue((boolean)event.needsPerformQueries());
        BugzillaRepositoryConnectorTest.assertFalse((boolean)event.getStaleTasks().contains(task4));
        BugzillaRepositoryConnectorTest.assertTrue((boolean)event.getStaleTasks().contains(task5));
        String priority4 = null;
        if (task4.getPriority().equals(priority1)) {
            priority4 = priority2;
            taskData4.getRoot().getAttribute(BugzillaAttribute.PRIORITY.getKey()).setValue(priority4);
        } else {
            priority4 = priority1;
            taskData4.getRoot().getAttribute(BugzillaAttribute.PRIORITY.getKey()).setValue(priority4);
        }
        String priority5 = null;
        if (task5.getPriority().equals(priority1)) {
            priority5 = priority2;
            taskData5.getRoot().getAttribute(BugzillaAttribute.PRIORITY.getKey()).setValue(priority5);
        } else {
            priority5 = priority1;
            taskData5.getRoot().getAttribute(BugzillaAttribute.PRIORITY.getKey()).setValue(priority5);
        }
        HashSet<TaskAttribute> changed4 = new HashSet<TaskAttribute>();
        HashSet<TaskAttribute> changed5 = new HashSet<TaskAttribute>();
        changed4.add(taskData4.getRoot().getAttribute(BugzillaAttribute.PRIORITY.getKey()));
        changed5.add(taskData5.getRoot().getAttribute(BugzillaAttribute.PRIORITY.getKey()));
        BugzillaFixture.current().submitTask(taskData4, this.client);
        BugzillaFixture.current().submitTask(taskData5, this.client);
        event = new SynchronizationSession();
        event.setTasks(tasks);
        event.setNeedsPerformQueries(true);
        event.setTaskRepository(this.repository);
        event.setFullSynchronization(true);
        this.connector.preSynchronization((ISynchronizationSession)event, null);
        BugzillaRepositoryConnectorTest.assertTrue((String)("Expected: " + task4.getTaskId() + ", " + task5.getTaskId() + ", got: " + event.getStaleTasks()), (event.getStaleTasks().contains(task4) && event.getStaleTasks().contains(task5) ? 1 : 0) != 0);
        TasksUiInternal.synchronizeTasks((AbstractRepositoryConnector)this.connector, tasks, (boolean)true, null);
        for (ITask task : tasks) {
            if (task.getTaskId() == "4") {
                BugzillaRepositoryConnectorTest.assertEquals((String)priority4, (String)taskData4.getRoot().getAttribute(BugzillaAttribute.PRIORITY.getKey()).getValue());
            }
            if (task.getTaskId() != "5") continue;
            BugzillaRepositoryConnectorTest.assertEquals((String)priority5, (String)taskData5.getRoot().getAttribute(BugzillaAttribute.PRIORITY.getKey()).getValue());
        }
    }

    public void testCredentialsWithoutPassword() throws Exception {
        TaskRepository repository = BugzillaFixture.current().repository();
        AuthenticationCredentials oldCreds = repository.getCredentials(AuthenticationType.REPOSITORY);
        AuthenticationCredentials anonymousCreds = new AuthenticationCredentials(oldCreds.getUserName(), "");
        repository.setCredentials(AuthenticationType.REPOSITORY, anonymousCreds, false);
        TaskRepositoryLocation location = new TaskRepositoryLocation(repository);
        this.client = new BugzillaClient((AbstractWebLocation)location, repository, BugzillaFixture.current().connector());
        try {
            try {
                this.client.validate((IProgressMonitor)new NullProgressMonitor());
            }
            catch (CoreException e) {
                BugzillaRepositoryConnectorTest.assertTrue((e.getStatus().getMessage().indexOf("Please validate credentials via Task Repositories view.") != -1 ? 1 : 0) != 0);
                repository.setCredentials(AuthenticationType.REPOSITORY, oldCreds, false);
                TasksUiPlugin.getRepositoryManager().notifyRepositorySettingsChanged(repository);
                return;
            }
        }
        finally {
            repository.setCredentials(AuthenticationType.REPOSITORY, oldCreds, false);
            TasksUiPlugin.getRepositoryManager().notifyRepositorySettingsChanged(repository);
        }
        BugzillaRepositoryConnectorTest.fail((String)"Should have failed due to an empty password.");
    }

    public void testErrorMatchFailedToShort() throws Exception {
        try {
            this.doUserMatch("st", null);
            BugzillaRepositoryConnectorTest.fail((String)"CoreException expected but not found");
        }
        catch (CoreException e) {
            BugzillaRepositoryConnectorTest.assertEquals((int)1025, (int)e.getStatus().getCode());
            BugzillaStatus status = (BugzillaStatus)e.getStatus();
            BugzillaRepositoryConnectorTest.assertNotNull((Object)status);
            BugzillaUserMatchResponse matchUserResponse = status.getUserMatchResponse();
            BugzillaRepositoryConnectorTest.assertNotNull((Object)matchUserResponse);
            BugzillaRepositoryConnectorTest.assertNotNull((Object)matchUserResponse.getNewCCProposals());
            BugzillaRepositoryConnectorTest.assertNotNull((Object)matchUserResponse.getAssignedToProposals());
            BugzillaRepositoryConnectorTest.assertNotNull((Object)matchUserResponse.getQaContactProposals());
            BugzillaRepositoryConnectorTest.assertEquals((int)0, (int)matchUserResponse.getNewCCProposals().size());
            BugzillaRepositoryConnectorTest.assertEquals((int)0, (int)matchUserResponse.getAssignedToProposals().size());
            BugzillaRepositoryConnectorTest.assertEquals((int)0, (int)matchUserResponse.getQaContactProposals().size());
            BugzillaRepositoryConnectorTest.assertNotNull((Object)matchUserResponse.getNewCCMsg());
            BugzillaRepositoryConnectorTest.assertNull((Object)matchUserResponse.getAssignedToMsg());
            BugzillaRepositoryConnectorTest.assertNull((Object)matchUserResponse.getQaContactMsg());
            if (BugzillaFixture.current().getBugzillaVersion().compareMajorMinorOnly(BugzillaVersion.BUGZILLA_3_6) < 0) {
                BugzillaRepositoryConnectorTest.assertTrue((boolean)matchUserResponse.getNewCCMsg().equals("st  did not match anything "));
            }
            BugzillaRepositoryConnectorTest.assertTrue((boolean)matchUserResponse.getNewCCMsg().equals("st  was too short for substring match (minimum 3 characters) "));
        }
    }

    public void testErrorMatchConfirmMatch() throws Exception {
        try {
            this.doUserMatch("est", null);
            BugzillaRepositoryConnectorTest.fail((String)"CoreException expected but not found");
        }
        catch (CoreException e) {
            if (BugzillaFixture.current().getBugzillaVersion().compareMajorMinorOnly(BugzillaVersion.BUGZILLA_3_6) < 0) {
                BugzillaRepositoryConnectorTest.assertEquals((int)1025, (int)e.getStatus().getCode());
                BugzillaStatus status = (BugzillaStatus)e.getStatus();
                BugzillaRepositoryConnectorTest.assertNotNull((Object)status);
                BugzillaUserMatchResponse matchUserResponse = status.getUserMatchResponse();
                BugzillaRepositoryConnectorTest.assertNotNull((Object)matchUserResponse);
                BugzillaRepositoryConnectorTest.assertNotNull((Object)matchUserResponse.getNewCCProposals());
                BugzillaRepositoryConnectorTest.assertNotNull((Object)matchUserResponse.getAssignedToProposals());
                BugzillaRepositoryConnectorTest.assertNotNull((Object)matchUserResponse.getQaContactProposals());
                BugzillaRepositoryConnectorTest.assertEquals((int)0, (int)matchUserResponse.getNewCCProposals().size());
                BugzillaRepositoryConnectorTest.assertEquals(Collections.emptyList(), (Object)matchUserResponse.getAssignedToProposals());
                BugzillaRepositoryConnectorTest.assertEquals(Collections.emptyList(), (Object)matchUserResponse.getQaContactProposals());
                BugzillaRepositoryConnectorTest.assertNotNull((Object)matchUserResponse.getNewCCMsg());
                BugzillaRepositoryConnectorTest.assertNull((Object)matchUserResponse.getAssignedToMsg());
                BugzillaRepositoryConnectorTest.assertNull((Object)matchUserResponse.getQaContactMsg());
                BugzillaRepositoryConnectorTest.assertTrue((boolean)matchUserResponse.getNewCCMsg().equals("est  did not match anything "));
            }
            BugzillaRepositoryConnectorTest.assertEquals((int)1024, (int)e.getStatus().getCode());
            BugzillaStatus status = (BugzillaStatus)e.getStatus();
            BugzillaRepositoryConnectorTest.assertNotNull((Object)status);
            BugzillaUserMatchResponse matchUserResponse = status.getUserMatchResponse();
            BugzillaRepositoryConnectorTest.assertNotNull((Object)matchUserResponse);
            BugzillaRepositoryConnectorTest.assertNotNull((Object)matchUserResponse.getNewCCProposals());
            BugzillaRepositoryConnectorTest.assertNotNull((Object)matchUserResponse.getAssignedToProposals());
            BugzillaRepositoryConnectorTest.assertNotNull((Object)matchUserResponse.getQaContactProposals());
            BugzillaRepositoryConnectorTest.assertEquals((int)1, (int)matchUserResponse.getNewCCProposals().size());
            BugzillaRepositoryConnectorTest.assertEquals(Collections.emptyList(), (Object)matchUserResponse.getAssignedToProposals());
            BugzillaRepositoryConnectorTest.assertEquals(Collections.emptyList(), (Object)matchUserResponse.getQaContactProposals());
            BugzillaRepositoryConnectorTest.assertNotNull(matchUserResponse.getNewCCProposals().get("est"));
            BugzillaRepositoryConnectorTest.assertTrue((boolean)((List)matchUserResponse.getNewCCProposals().get("est")).contains("tests@mylyn.eclipse.org"));
            BugzillaRepositoryConnectorTest.assertTrue((boolean)((List)matchUserResponse.getNewCCProposals().get("est")).contains("guest@mylyn.eclipse.org"));
            BugzillaRepositoryConnectorTest.assertNull((Object)matchUserResponse.getNewCCMsg());
            BugzillaRepositoryConnectorTest.assertNull((Object)matchUserResponse.getAssignedToMsg());
            BugzillaRepositoryConnectorTest.assertNull((Object)matchUserResponse.getQaContactMsg());
        }
    }

    public void testErrorMatchConfirmMatch2() throws Exception {
        try {
            this.doUserMatch(null, "est");
            BugzillaRepositoryConnectorTest.fail((String)"CoreException expected but not found");
        }
        catch (CoreException e) {
            if (BugzillaFixture.current().getBugzillaVersion().compareMajorMinorOnly(BugzillaVersion.BUGZILLA_3_6) < 0) {
                BugzillaRepositoryConnectorTest.assertEquals((int)1025, (int)e.getStatus().getCode());
                BugzillaStatus status = (BugzillaStatus)e.getStatus();
                BugzillaRepositoryConnectorTest.assertNotNull((Object)status);
                BugzillaUserMatchResponse matchUserResponse = status.getUserMatchResponse();
                BugzillaRepositoryConnectorTest.assertNotNull((Object)matchUserResponse);
                BugzillaRepositoryConnectorTest.assertNotNull((Object)matchUserResponse.getNewCCProposals());
                BugzillaRepositoryConnectorTest.assertNotNull((Object)matchUserResponse.getAssignedToProposals());
                BugzillaRepositoryConnectorTest.assertNotNull((Object)matchUserResponse.getQaContactProposals());
                BugzillaRepositoryConnectorTest.assertEquals((int)0, (int)matchUserResponse.getNewCCProposals().size());
                BugzillaRepositoryConnectorTest.assertEquals(Collections.emptyList(), (Object)matchUserResponse.getAssignedToProposals());
                BugzillaRepositoryConnectorTest.assertEquals(Collections.emptyList(), (Object)matchUserResponse.getQaContactProposals());
                BugzillaRepositoryConnectorTest.assertNull((Object)matchUserResponse.getNewCCMsg());
                BugzillaRepositoryConnectorTest.assertNotNull((Object)matchUserResponse.getAssignedToMsg());
                BugzillaRepositoryConnectorTest.assertNull((Object)matchUserResponse.getQaContactMsg());
                BugzillaRepositoryConnectorTest.assertTrue((boolean)matchUserResponse.getAssignedToMsg().equals("est  did not match anything "));
            }
            BugzillaRepositoryConnectorTest.assertEquals((int)1024, (int)e.getStatus().getCode());
            BugzillaStatus status = (BugzillaStatus)e.getStatus();
            BugzillaRepositoryConnectorTest.assertNotNull((Object)status);
            BugzillaUserMatchResponse matchUserResponse = status.getUserMatchResponse();
            BugzillaRepositoryConnectorTest.assertNotNull((Object)matchUserResponse);
            BugzillaRepositoryConnectorTest.assertNotNull((Object)matchUserResponse.getNewCCProposals());
            BugzillaRepositoryConnectorTest.assertNotNull((Object)matchUserResponse.getAssignedToProposals());
            BugzillaRepositoryConnectorTest.assertNotNull((Object)matchUserResponse.getQaContactProposals());
            BugzillaRepositoryConnectorTest.assertEquals((int)0, (int)matchUserResponse.getNewCCProposals().size());
            BugzillaRepositoryConnectorTest.assertEquals((int)2, (int)matchUserResponse.getAssignedToProposals().size());
            BugzillaRepositoryConnectorTest.assertEquals(Collections.emptyList(), (Object)matchUserResponse.getQaContactProposals());
            BugzillaRepositoryConnectorTest.assertTrue((boolean)matchUserResponse.getAssignedToProposals().contains("tests@mylyn.eclipse.org"));
            BugzillaRepositoryConnectorTest.assertTrue((boolean)matchUserResponse.getAssignedToProposals().contains("guest@mylyn.eclipse.org"));
            BugzillaRepositoryConnectorTest.assertNull((Object)matchUserResponse.getNewCCMsg());
            BugzillaRepositoryConnectorTest.assertNull((Object)matchUserResponse.getAssignedToMsg());
            BugzillaRepositoryConnectorTest.assertNull((Object)matchUserResponse.getQaContactMsg());
        }
    }

    public void testErrorMatchConfirmMatch3() throws Exception {
        try {
            this.doUserMatch("test", "est");
            BugzillaRepositoryConnectorTest.fail((String)"CoreException expected but not found");
        }
        catch (CoreException e) {
            if (BugzillaFixture.current().getBugzillaVersion().compareMajorMinorOnly(BugzillaVersion.BUGZILLA_3_6) < 0) {
                BugzillaRepositoryConnectorTest.assertEquals((int)1025, (int)e.getStatus().getCode());
                BugzillaStatus status = (BugzillaStatus)e.getStatus();
                BugzillaRepositoryConnectorTest.assertNotNull((Object)status);
                BugzillaUserMatchResponse matchUserResponse = status.getUserMatchResponse();
                BugzillaRepositoryConnectorTest.assertNotNull((Object)matchUserResponse);
                BugzillaRepositoryConnectorTest.assertNotNull((Object)matchUserResponse.getNewCCProposals());
                BugzillaRepositoryConnectorTest.assertNotNull((Object)matchUserResponse.getAssignedToProposals());
                BugzillaRepositoryConnectorTest.assertNotNull((Object)matchUserResponse.getQaContactProposals());
                BugzillaRepositoryConnectorTest.assertEquals((int)0, (int)matchUserResponse.getNewCCProposals().size());
                BugzillaRepositoryConnectorTest.assertEquals(Collections.emptyList(), (Object)matchUserResponse.getAssignedToProposals());
                BugzillaRepositoryConnectorTest.assertEquals(Collections.emptyList(), (Object)matchUserResponse.getQaContactProposals());
                BugzillaRepositoryConnectorTest.assertNotNull((Object)matchUserResponse.getNewCCMsg());
                BugzillaRepositoryConnectorTest.assertNotNull((Object)matchUserResponse.getAssignedToMsg());
                BugzillaRepositoryConnectorTest.assertNull((Object)matchUserResponse.getQaContactMsg());
                BugzillaRepositoryConnectorTest.assertTrue((boolean)matchUserResponse.getNewCCMsg().equals("test  did not match anything "));
                BugzillaRepositoryConnectorTest.assertTrue((boolean)matchUserResponse.getAssignedToMsg().equals("est  did not match anything "));
            }
            BugzillaRepositoryConnectorTest.assertEquals((int)1024, (int)e.getStatus().getCode());
            BugzillaStatus status = (BugzillaStatus)e.getStatus();
            BugzillaRepositoryConnectorTest.assertNotNull((Object)status);
            BugzillaUserMatchResponse matchUserResponse = status.getUserMatchResponse();
            BugzillaRepositoryConnectorTest.assertNotNull((Object)matchUserResponse);
            BugzillaRepositoryConnectorTest.assertNotNull((Object)matchUserResponse.getNewCCProposals());
            BugzillaRepositoryConnectorTest.assertNotNull((Object)matchUserResponse.getAssignedToProposals());
            BugzillaRepositoryConnectorTest.assertNotNull((Object)matchUserResponse.getQaContactProposals());
            BugzillaRepositoryConnectorTest.assertEquals((int)1, (int)matchUserResponse.getNewCCProposals().size());
            BugzillaRepositoryConnectorTest.assertEquals((int)2, (int)matchUserResponse.getAssignedToProposals().size());
            BugzillaRepositoryConnectorTest.assertEquals(Collections.emptyList(), (Object)matchUserResponse.getQaContactProposals());
            BugzillaRepositoryConnectorTest.assertNotNull(matchUserResponse.getNewCCProposals().get("test"));
            BugzillaRepositoryConnectorTest.assertTrue((boolean)((List)matchUserResponse.getNewCCProposals().get("test")).contains("tests@mylyn.eclipse.org"));
            BugzillaRepositoryConnectorTest.assertTrue((boolean)matchUserResponse.getAssignedToProposals().contains("tests@mylyn.eclipse.org"));
            BugzillaRepositoryConnectorTest.assertTrue((boolean)matchUserResponse.getAssignedToProposals().contains("guest@mylyn.eclipse.org"));
            BugzillaRepositoryConnectorTest.assertNull((Object)matchUserResponse.getNewCCMsg());
            BugzillaRepositoryConnectorTest.assertNull((Object)matchUserResponse.getAssignedToMsg());
            BugzillaRepositoryConnectorTest.assertNull((Object)matchUserResponse.getQaContactMsg());
        }
    }

    public void testErrorMatchConfirmMatch4() throws Exception {
        try {
            this.doUserMatch("test;guest", null);
            BugzillaRepositoryConnectorTest.fail((String)"CoreException expected but not found");
        }
        catch (CoreException e) {
            if (BugzillaFixture.current().getBugzillaVersion().compareMajorMinorOnly(BugzillaVersion.BUGZILLA_3_6) < 0) {
                BugzillaRepositoryConnectorTest.assertEquals((int)1025, (int)e.getStatus().getCode());
                BugzillaStatus status = (BugzillaStatus)e.getStatus();
                BugzillaRepositoryConnectorTest.assertNotNull((Object)status);
                BugzillaUserMatchResponse matchUserResponse = status.getUserMatchResponse();
                BugzillaRepositoryConnectorTest.assertNotNull((Object)matchUserResponse);
                BugzillaRepositoryConnectorTest.assertNotNull((Object)matchUserResponse.getNewCCProposals());
                BugzillaRepositoryConnectorTest.assertNotNull((Object)matchUserResponse.getAssignedToProposals());
                BugzillaRepositoryConnectorTest.assertNotNull((Object)matchUserResponse.getQaContactProposals());
                BugzillaRepositoryConnectorTest.assertEquals((int)0, (int)matchUserResponse.getNewCCProposals().size());
                BugzillaRepositoryConnectorTest.assertEquals(Collections.emptyList(), (Object)matchUserResponse.getAssignedToProposals());
                BugzillaRepositoryConnectorTest.assertEquals(Collections.emptyList(), (Object)matchUserResponse.getQaContactProposals());
                BugzillaRepositoryConnectorTest.assertNotNull((Object)matchUserResponse.getNewCCMsg());
                BugzillaRepositoryConnectorTest.assertNull((Object)matchUserResponse.getAssignedToMsg());
                BugzillaRepositoryConnectorTest.assertNull((Object)matchUserResponse.getQaContactMsg());
                BugzillaRepositoryConnectorTest.assertTrue((boolean)matchUserResponse.getNewCCMsg().equals("test;guest  did not match anything "));
            }
            BugzillaRepositoryConnectorTest.assertEquals((int)1024, (int)e.getStatus().getCode());
            BugzillaStatus status = (BugzillaStatus)e.getStatus();
            BugzillaRepositoryConnectorTest.assertNotNull((Object)status);
            BugzillaUserMatchResponse matchUserResponse = status.getUserMatchResponse();
            BugzillaRepositoryConnectorTest.assertNotNull((Object)matchUserResponse);
            BugzillaRepositoryConnectorTest.assertNotNull((Object)matchUserResponse.getNewCCProposals());
            BugzillaRepositoryConnectorTest.assertNotNull((Object)matchUserResponse.getAssignedToProposals());
            BugzillaRepositoryConnectorTest.assertNotNull((Object)matchUserResponse.getQaContactProposals());
            BugzillaRepositoryConnectorTest.assertEquals((int)2, (int)matchUserResponse.getNewCCProposals().size());
            BugzillaRepositoryConnectorTest.assertEquals((int)0, (int)matchUserResponse.getAssignedToProposals().size());
            BugzillaRepositoryConnectorTest.assertEquals(Collections.emptyList(), (Object)matchUserResponse.getQaContactProposals());
            BugzillaRepositoryConnectorTest.assertNotNull(matchUserResponse.getNewCCProposals().get("test"));
            BugzillaRepositoryConnectorTest.assertNotNull(matchUserResponse.getNewCCProposals().get("guest"));
            BugzillaRepositoryConnectorTest.assertTrue((boolean)((List)matchUserResponse.getNewCCProposals().get("test")).contains("tests@mylyn.eclipse.org"));
            BugzillaRepositoryConnectorTest.assertTrue((boolean)((List)matchUserResponse.getNewCCProposals().get("guest")).contains("guest@mylyn.eclipse.org"));
            BugzillaRepositoryConnectorTest.assertNull((Object)matchUserResponse.getNewCCMsg());
            BugzillaRepositoryConnectorTest.assertNull((Object)matchUserResponse.getAssignedToMsg());
            BugzillaRepositoryConnectorTest.assertNull((Object)matchUserResponse.getQaContactMsg());
        }
    }

    public void testErrorMatchFailed() throws Exception {
        try {
            this.doUserMatch("tests1@mylyn.eclipse.org", null);
            BugzillaRepositoryConnectorTest.fail((String)"CoreException expected but not found");
        }
        catch (CoreException e) {
            BugzillaRepositoryConnectorTest.assertEquals((int)1025, (int)e.getStatus().getCode());
            BugzillaStatus status = (BugzillaStatus)e.getStatus();
            BugzillaRepositoryConnectorTest.assertNotNull((Object)status);
            BugzillaUserMatchResponse matchUserResponse = status.getUserMatchResponse();
            BugzillaRepositoryConnectorTest.assertNotNull((Object)matchUserResponse);
            BugzillaRepositoryConnectorTest.assertNotNull((Object)matchUserResponse.getNewCCProposals());
            BugzillaRepositoryConnectorTest.assertNotNull((Object)matchUserResponse.getAssignedToProposals());
            BugzillaRepositoryConnectorTest.assertNotNull((Object)matchUserResponse.getQaContactProposals());
            BugzillaRepositoryConnectorTest.assertEquals((int)0, (int)matchUserResponse.getNewCCProposals().size());
            BugzillaRepositoryConnectorTest.assertEquals(Collections.emptyList(), (Object)matchUserResponse.getAssignedToProposals());
            BugzillaRepositoryConnectorTest.assertEquals(Collections.emptyList(), (Object)matchUserResponse.getQaContactProposals());
            BugzillaRepositoryConnectorTest.assertNotNull((Object)matchUserResponse.getNewCCMsg());
            BugzillaRepositoryConnectorTest.assertNull((Object)matchUserResponse.getAssignedToMsg());
            BugzillaRepositoryConnectorTest.assertNull((Object)matchUserResponse.getQaContactMsg());
            BugzillaRepositoryConnectorTest.assertTrue((boolean)matchUserResponse.getNewCCMsg().equals("tests1@mylyn.eclipse.org  did not match anything "));
        }
    }

    public void testErrorMatchFailed2() throws Exception {
        try {
            this.doUserMatch("est", "test1");
            BugzillaRepositoryConnectorTest.fail((String)"CoreException expected but not found");
        }
        catch (CoreException e) {
            if (BugzillaFixture.current().getBugzillaVersion().compareMajorMinorOnly(BugzillaVersion.BUGZILLA_3_6) < 0) {
                BugzillaRepositoryConnectorTest.assertEquals((int)1025, (int)e.getStatus().getCode());
                BugzillaStatus status = (BugzillaStatus)e.getStatus();
                BugzillaRepositoryConnectorTest.assertNotNull((Object)status);
                BugzillaUserMatchResponse matchUserResponse = status.getUserMatchResponse();
                BugzillaRepositoryConnectorTest.assertNotNull((Object)matchUserResponse);
                BugzillaRepositoryConnectorTest.assertNotNull((Object)matchUserResponse.getNewCCProposals());
                BugzillaRepositoryConnectorTest.assertNotNull((Object)matchUserResponse.getAssignedToProposals());
                BugzillaRepositoryConnectorTest.assertNotNull((Object)matchUserResponse.getQaContactProposals());
                BugzillaRepositoryConnectorTest.assertEquals((int)0, (int)matchUserResponse.getNewCCProposals().size());
                BugzillaRepositoryConnectorTest.assertEquals(Collections.emptyList(), (Object)matchUserResponse.getAssignedToProposals());
                BugzillaRepositoryConnectorTest.assertEquals(Collections.emptyList(), (Object)matchUserResponse.getQaContactProposals());
                BugzillaRepositoryConnectorTest.assertNotNull((Object)matchUserResponse.getNewCCMsg());
                BugzillaRepositoryConnectorTest.assertNotNull((Object)matchUserResponse.getAssignedToMsg());
                BugzillaRepositoryConnectorTest.assertNull((Object)matchUserResponse.getQaContactMsg());
                BugzillaRepositoryConnectorTest.assertTrue((boolean)matchUserResponse.getNewCCMsg().equals("est  did not match anything "));
                BugzillaRepositoryConnectorTest.assertTrue((boolean)matchUserResponse.getAssignedToMsg().equals("test1  did not match anything "));
            }
            BugzillaRepositoryConnectorTest.assertEquals((int)1025, (int)e.getStatus().getCode());
            BugzillaStatus status = (BugzillaStatus)e.getStatus();
            BugzillaRepositoryConnectorTest.assertNotNull((Object)status);
            BugzillaUserMatchResponse matchUserResponse = status.getUserMatchResponse();
            BugzillaRepositoryConnectorTest.assertNotNull((Object)matchUserResponse);
            BugzillaRepositoryConnectorTest.assertNotNull((Object)matchUserResponse.getNewCCProposals());
            BugzillaRepositoryConnectorTest.assertNotNull((Object)matchUserResponse.getAssignedToProposals());
            BugzillaRepositoryConnectorTest.assertNotNull((Object)matchUserResponse.getQaContactProposals());
            BugzillaRepositoryConnectorTest.assertEquals((int)1, (int)matchUserResponse.getNewCCProposals().size());
            BugzillaRepositoryConnectorTest.assertEquals(Collections.emptyList(), (Object)matchUserResponse.getAssignedToProposals());
            BugzillaRepositoryConnectorTest.assertEquals(Collections.emptyList(), (Object)matchUserResponse.getQaContactProposals());
            BugzillaRepositoryConnectorTest.assertNotNull(matchUserResponse.getNewCCProposals().get("est"));
            BugzillaRepositoryConnectorTest.assertTrue((boolean)((List)matchUserResponse.getNewCCProposals().get("est")).contains("tests@mylyn.eclipse.org"));
            BugzillaRepositoryConnectorTest.assertTrue((boolean)((List)matchUserResponse.getNewCCProposals().get("est")).contains("guest@mylyn.eclipse.org"));
            BugzillaRepositoryConnectorTest.assertNull((Object)matchUserResponse.getNewCCMsg());
            BugzillaRepositoryConnectorTest.assertNotNull((Object)matchUserResponse.getAssignedToMsg());
            BugzillaRepositoryConnectorTest.assertNull((Object)matchUserResponse.getQaContactMsg());
        }
    }

    public void doUserMatch(String newCCAttributeValue, String assignedToAttributeValue) throws CoreException, IOException {
        TaskMapping taskMappingInit = new TaskMapping(){

            public String getProduct() {
                return "TestProduct";
            }
        };
        TaskMapping taskMappingSelect = new TaskMapping(){

            public String getComponent() {
                return "TestComponent";
            }

            public String getSummary() {
                return "test usermatch";
            }

            public String getDescription() {
                return "The Description of the usermatch";
            }
        };
        TaskData[] taskDataNew = new TaskData[]{TasksUiInternal.createTaskData((TaskRepository)this.repository, (ITaskMapping)taskMappingInit, (ITaskMapping)taskMappingSelect, null)};
        ITask taskNew = TasksUiUtil.createOutgoingNewTask((String)taskDataNew[0].getConnectorKind(), (String)taskDataNew[0].getRepositoryUrl());
        ITaskDataWorkingCopy workingCopy = TasksUi.getTaskDataManager().createWorkingCopy(taskNew, taskDataNew[0]);
        HashSet<TaskAttribute> changed = new HashSet<TaskAttribute>();
        workingCopy.save(changed, null);
        RepositoryResponse response = BugzillaFixture.current().submitTask(taskDataNew[0], this.client);
        ((AbstractTask)taskNew).setSubmitting(true);
        BugzillaRepositoryConnectorTest.assertNotNull((Object)response);
        BugzillaRepositoryConnectorTest.assertEquals((String)RepositoryResponse.ResponseKind.TASK_CREATED.toString(), (String)response.getReposonseKind().toString());
        String taskId = response.getTaskId();
        ITask task = this.generateLocalTaskAndDownload(taskId);
        BugzillaRepositoryConnectorTest.assertNotNull((Object)task);
        TaskDataModel model = this.createModel(task);
        TaskData taskData = model.getTaskData();
        BugzillaRepositoryConnectorTest.assertNotNull((Object)taskData);
        TaskAttribute newCCAttribute = taskData.getRoot().getAttribute(BugzillaAttribute.NEWCC.getKey());
        TaskAttribute assignedToAttribute = taskData.getRoot().getAttribute(BugzillaAttribute.ASSIGNED_TO.getKey());
        changed.clear();
        if (newCCAttribute != null && newCCAttributeValue != null) {
            newCCAttribute.setValue(newCCAttributeValue);
            model.attributeChanged(newCCAttribute);
            changed.add(newCCAttribute);
        }
        if (assignedToAttribute != null && assignedToAttributeValue != null) {
            assignedToAttribute.setValue(assignedToAttributeValue);
            model.attributeChanged(assignedToAttribute);
            changed.add(assignedToAttribute);
        }
        workingCopy.save(changed, null);
        response = BugzillaFixture.current().submitTask(taskData, this.client);
    }

    public void testPrivateDescription() throws Exception {
        TaskAttribute isPrivate;
        TaskMapping taskMappingInit = new TaskMapping(){

            public String getProduct() {
                return "TestProduct";
            }
        };
        TaskMapping taskMappingSelect = new TaskMapping(){

            public String getComponent() {
                return "TestComponent";
            }

            public String getSummary() {
                return "test private comments";
            }

            public String getDescription() {
                return "The Description of the private comments task";
            }
        };
        if (BugzillaVersion.BUGZILLA_3_4.compareTo(BugzillaFixture.current().getBugzillaVersion()) == 0) {
            return;
        }
        TaskData[] taskDataNew = new TaskData[]{TasksUiInternal.createTaskData((TaskRepository)this.repository, (ITaskMapping)taskMappingInit, (ITaskMapping)taskMappingSelect, null)};
        ITask taskNew = TasksUiUtil.createOutgoingNewTask((String)taskDataNew[0].getConnectorKind(), (String)taskDataNew[0].getRepositoryUrl());
        ITaskDataWorkingCopy workingCopy = TasksUi.getTaskDataManager().createWorkingCopy(taskNew, taskDataNew[0]);
        HashSet<TaskAttribute> changed = new HashSet<TaskAttribute>();
        workingCopy.save(changed, null);
        RepositoryResponse response = BugzillaFixture.current().submitTask(taskDataNew[0], this.client);
        ((AbstractTask)taskNew).setSubmitting(true);
        BugzillaRepositoryConnectorTest.assertNotNull((Object)response);
        BugzillaRepositoryConnectorTest.assertEquals((String)RepositoryResponse.ResponseKind.TASK_CREATED.toString(), (String)response.getReposonseKind().toString());
        String taskId = response.getTaskId();
        ITask task = this.generateLocalTaskAndDownload(taskId);
        BugzillaRepositoryConnectorTest.assertNotNull((Object)task);
        TaskDataModel model = this.createModel(task);
        TaskData taskData = model.getTaskData();
        BugzillaRepositoryConnectorTest.assertNotNull((Object)taskData);
        TaskAttribute description = taskData.getRoot().getAttribute(BugzillaAttribute.LONG_DESC.getKey());
        TaskAttribute isPrivateAttribute = description.getAttribute("isprivate");
        BugzillaRepositoryConnectorTest.assertEquals((String)"0", (String)isPrivateAttribute.getValue());
        TaskAttribute idAttribute = description.getAttribute("id");
        String value = idAttribute.getValue();
        TaskAttribute definedIsPrivate = description.getAttribute("defined_isprivate_" + value);
        if (definedIsPrivate == null) {
            definedIsPrivate = description.createAttribute("defined_isprivate_" + value);
        }
        if ((isPrivate = description.getAttribute("isprivate_" + value)) == null) {
            isPrivate = description.createAttribute("isprivate_" + value);
        }
        definedIsPrivate.setValue("1");
        isPrivate.setValue("1");
        model.attributeChanged(description);
        changed.clear();
        changed.add(description);
        workingCopy.save(changed, null);
        response = BugzillaFixture.current().submitTask(taskData, this.client);
        task = this.generateLocalTaskAndDownload(taskId);
        BugzillaRepositoryConnectorTest.assertNotNull((Object)task);
        model = this.createModel(task);
        taskData = model.getTaskData();
        BugzillaRepositoryConnectorTest.assertNotNull((Object)taskData);
        description = taskData.getRoot().getAttribute(BugzillaAttribute.LONG_DESC.getKey());
        isPrivateAttribute = description.getAttribute("isprivate");
        BugzillaRepositoryConnectorTest.assertEquals((String)"1", (String)isPrivateAttribute.getValue());
    }

    public void testPrivateComments() throws Exception {
        TaskAttribute isPrivate;
        TaskMapping taskMappingInit = new TaskMapping(){

            public String getProduct() {
                return "TestProduct";
            }
        };
        TaskMapping taskMappingSelect = new TaskMapping(){

            public String getComponent() {
                return "TestComponent";
            }

            public String getSummary() {
                return "test private comments";
            }

            public String getDescription() {
                return "The Description of the private comments task";
            }
        };
        if (BugzillaVersion.BUGZILLA_3_4.compareTo(BugzillaFixture.current().getBugzillaVersion()) == 0) {
            return;
        }
        TaskData[] taskDataNew = new TaskData[]{TasksUiInternal.createTaskData((TaskRepository)this.repository, (ITaskMapping)taskMappingInit, (ITaskMapping)taskMappingSelect, null)};
        ITask taskNew = TasksUiUtil.createOutgoingNewTask((String)taskDataNew[0].getConnectorKind(), (String)taskDataNew[0].getRepositoryUrl());
        ITaskDataWorkingCopy workingCopy = TasksUi.getTaskDataManager().createWorkingCopy(taskNew, taskDataNew[0]);
        HashSet<TaskAttribute> changed = new HashSet<TaskAttribute>();
        workingCopy.save(changed, null);
        RepositoryResponse response = BugzillaFixture.current().submitTask(taskDataNew[0], this.client);
        ((AbstractTask)taskNew).setSubmitting(true);
        BugzillaRepositoryConnectorTest.assertNotNull((Object)response);
        BugzillaRepositoryConnectorTest.assertEquals((String)RepositoryResponse.ResponseKind.TASK_CREATED.toString(), (String)response.getReposonseKind().toString());
        String taskId = response.getTaskId();
        ITask task = this.generateLocalTaskAndDownload(taskId);
        BugzillaRepositoryConnectorTest.assertNotNull((Object)task);
        TaskDataModel model = this.createModel(task);
        TaskData taskData = model.getTaskData();
        BugzillaRepositoryConnectorTest.assertNotNull((Object)taskData);
        TaskAttribute newComment = taskData.getRoot().getAttribute(BugzillaAttribute.NEW_COMMENT.getKey());
        newComment.setValue("New Comment");
        model.attributeChanged(newComment);
        changed.clear();
        changed.add(newComment);
        workingCopy.save(changed, null);
        response = BugzillaFixture.current().submitTask(taskData, this.client);
        task = this.generateLocalTaskAndDownload(taskId);
        BugzillaRepositoryConnectorTest.assertNotNull((Object)task);
        model = this.createModel(task);
        taskData = model.getTaskData();
        BugzillaRepositoryConnectorTest.assertNotNull((Object)taskData);
        TaskAttribute comment1 = taskData.getRoot().getAttribute("task.common.comment-1");
        TaskAttribute isPrivateAttribute = comment1.getAttribute("isprivate");
        BugzillaRepositoryConnectorTest.assertEquals((String)"0", (String)isPrivateAttribute.getValue());
        String value = comment1.getValue();
        TaskAttribute definedIsPrivate = comment1.getAttribute("defined_isprivate_" + value);
        if (definedIsPrivate == null) {
            definedIsPrivate = comment1.createAttribute("defined_isprivate_" + value);
        }
        if ((isPrivate = comment1.getAttribute("isprivate_" + value)) == null) {
            isPrivate = comment1.createAttribute("isprivate_" + value);
        }
        definedIsPrivate.setValue("1");
        isPrivate.setValue("1");
        model.attributeChanged(comment1);
        changed.clear();
        changed.add(comment1);
        workingCopy.save(changed, null);
        response = BugzillaFixture.current().submitTask(taskData, this.client);
        task = this.generateLocalTaskAndDownload(taskId);
        BugzillaRepositoryConnectorTest.assertNotNull((Object)task);
        model = this.createModel(task);
        taskData = model.getTaskData();
        BugzillaRepositoryConnectorTest.assertNotNull((Object)taskData);
        comment1 = taskData.getRoot().getAttribute("task.common.comment-1");
        isPrivateAttribute = comment1.getAttribute("isprivate");
        BugzillaRepositoryConnectorTest.assertEquals((String)"1", (String)isPrivateAttribute.getValue());
    }
}

