/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.wikitext.confluence.core;

import org.eclipse.mylyn.wikitext.confluence.core.ConfluenceLanguage;
import org.eclipse.mylyn.wikitext.tests.AbstractMarkupGenerationTest;
import org.junit.Test;

public class ConfluenceLineBreakTest
extends AbstractMarkupGenerationTest<ConfluenceLanguage> {
    @Override
    protected ConfluenceLanguage createMarkupLanguage() {
        return new ConfluenceLanguage();
    }

    @Test
    public void testLineBreak() {
        this.assertMarkup("<p>a paragraph with an arbitrary<br/>line break</p>", "a paragraph with an arbitrary\\\\line break");
    }

    @Test
    public void withSpace() {
        this.assertMarkup("<p>a paragraph with an arbitrary<br/><br/>line break</p>", "a paragraph with an arbitrary\\\\ \\\\line break");
    }

    @Test
    public void multipleConsecutive() {
        this.assertMarkup("<p>a<br/><br/><br/>b</p>", "a\\\\\\\\\\\\b");
    }

    @Test
    public void lineStart() {
        this.assertMarkup("<p><br/>b</p>", "\\\\b");
    }

    @Test
    public void lineEnd() {
        this.assertMarkup("<p>b<br/></p>", "b\\\\");
    }

    @Test
    public void onLine() {
        this.assertMarkup("<p>a<br/>b</p>", "a\nb");
    }

    @Test
    public void listItem() {
        this.assertMarkup("<ul><li>one<br/>two</li><li>three</li></ul>", "* one\ntwo\n* three");
    }

    @Test
    public void listItemMultipleConsecutiveBreaks() {
        this.assertMarkup("<ul><li>one<br/><br/><br/>two</li><li>three</li></ul>", "* one\n\\\\\\\\two\n* three");
    }
}

