/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.reviews.ui.annotations;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.PopupDialog;
import org.eclipse.jface.layout.PixelConverter;
import org.eclipse.jface.text.source.LineRange;
import org.eclipse.mylyn.commons.workbench.forms.CommonFormUtil;
import org.eclipse.mylyn.internal.reviews.ui.IReviewActionListener;
import org.eclipse.mylyn.internal.reviews.ui.annotations.CommentAnnotation;
import org.eclipse.mylyn.internal.reviews.ui.annotations.CommentAnnotationHoverInput;
import org.eclipse.mylyn.internal.reviews.ui.annotations.CommentInformationControl;
import org.eclipse.mylyn.internal.reviews.ui.annotations.Messages;
import org.eclipse.mylyn.internal.reviews.ui.dialogs.CommentInputDialog;
import org.eclipse.mylyn.internal.reviews.ui.editors.parts.CommentPart;
import org.eclipse.mylyn.reviews.core.model.ILineLocation;
import org.eclipse.mylyn.reviews.core.model.ILocation;
import org.eclipse.mylyn.reviews.core.model.IReviewItem;
import org.eclipse.mylyn.reviews.internal.core.model.Comment;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseTrackAdapter;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Hyperlink;

public class CommentPopupDialog
extends PopupDialog
implements IReviewActionListener {
    private static final int MAX_WIDTH = 500;
    private int maxWidth;
    private CommentAnnotationHoverInput annotationInput;
    private FormToolkit toolkit;
    private Composite composite;
    private ScrolledComposite scrolledComposite;
    private CommentInformationControl informationControl;
    private IReviewItem reviewitem;
    private LineRange range;
    private static CommentPopupDialog currentPopupDialog;
    private CommentInputDialog currentCommentInputDialog = null;
    public final boolean openDialogOnHover;
    private List<Comment> commentList;

    public CommentPopupDialog(Shell parent, int shellStyle) {
        this(parent, shellStyle, false, null, null);
    }

    public CommentPopupDialog(Shell parent, int shellStyle, boolean openDialogOnHover, IReviewItem reviewitm, LineRange range) {
        super(parent, shellStyle, false, false, false, false, false, null, null);
        this.openDialogOnHover = openDialogOnHover;
        this.reviewitem = reviewitm;
        this.range = range;
    }

    protected Control createDialogArea(Composite parent) {
        this.toolkit = new FormToolkit(CommonFormUtil.getSharedColors());
        this.scrolledComposite = new ScrolledComposite(parent, 512);
        this.scrolledComposite.setExpandHorizontal(true);
        this.scrolledComposite.setExpandVertical(true);
        this.toolkit.adapt((Composite)this.scrolledComposite);
        this.composite = this.toolkit.createComposite((Composite)this.scrolledComposite, 0);
        this.composite.setLayout((Layout)new GridLayout());
        this.scrolledComposite.setContent((Control)this.composite);
        return this.scrolledComposite;
    }

    public void dispose() {
        currentPopupDialog = null;
        this.close();
        this.toolkit.dispose();
    }

    public void setFocus() {
        this.getShell().forceFocus();
        if (this.composite.getChildren().length > 0) {
            this.composite.getChildren()[0].setFocus();
        }
        Point computeSize = this.composite.computeSize(-1, -1);
        if (computeSize.y > this.scrolledComposite.getSize().y) {
            this.scrolledComposite.setExpandVertical(false);
            this.composite.setSize(computeSize);
        }
    }

    public Point computeSizeHint() {
        int widthHint = 500;
        if (this.maxWidth < widthHint) {
            widthHint = this.maxWidth;
        }
        return this.getShell().computeSize(widthHint, -1, true);
    }

    public void removeFocusListener(FocusListener listener) {
        this.currentCommentInputDialog = null;
        this.composite.removeFocusListener(listener);
    }

    public void addFocusListener(FocusListener listener) {
        this.composite.addFocusListener(listener);
    }

    public boolean isFocusControl() {
        return this.getShell().getDisplay().getActiveShell() == this.getShell();
    }

    public void removeDisposeListener(DisposeListener listener) {
        this.getShell().removeDisposeListener(listener);
    }

    public void addDisposeListener(DisposeListener listener) {
        this.getShell().addDisposeListener(listener);
    }

    public Rectangle getBounds() {
        return this.getShell().getBounds();
    }

    public Rectangle computeTrim() {
        return this.getShell().computeTrim(0, 0, 0, 0);
    }

    public void setSizeConstraints(int newMaxWidth, int newMaxHeight) {
        this.maxWidth = newMaxWidth;
    }

    public void setLocation(Point location) {
        Rectangle bounds = this.getShell().getBounds();
        Rectangle monitorBounds = this.getShell().getMonitor().getClientArea();
        bounds.x = this.contrain(location.x, monitorBounds.x, monitorBounds.x + monitorBounds.width - bounds.width);
        bounds.y = this.contrain(location.y, monitorBounds.y, monitorBounds.y + monitorBounds.height - bounds.height);
        this.getShell().setLocation(new Point(bounds.x, bounds.y));
    }

    private int contrain(int value, int min, int max) {
        return Math.max(min, Math.min(max, value));
    }

    public void setSize(int width, int height) {
        Point computeSize = this.composite.computeSize(-1, -1);
        if (computeSize.x > width) {
            width = computeSize.x;
        }
        this.getShell().setSize(width, height);
        this.scrolledComposite.setSize(width, height);
    }

    public void setInput(Object input) {
        if (input instanceof CommentAnnotationHoverInput) {
            this.annotationInput = (CommentAnnotationHoverInput)input;
            Control[] controlArray = this.composite.getChildren();
            int n = controlArray.length;
            int n2 = 0;
            while (n2 < n) {
                Control control = controlArray[n2];
                control.dispose();
                ++n2;
            }
            currentPopupDialog = this;
            this.commentList = new ArrayList<Comment>();
            for (CommentAnnotation annotation : this.annotationInput.getAnnotations()) {
                ILocation location;
                List locations;
                if (this.reviewitem == null && annotation.getComment().getItem() instanceof IReviewItem) {
                    this.reviewitem = (IReviewItem)annotation.getComment().getItem();
                }
                if (this.range == null && !(locations = annotation.getComment().getLocations()).isEmpty() && (location = (ILocation)locations.get(0)) instanceof ILineLocation) {
                    this.range = new LineRange(((ILineLocation)location).getRangeMin(), 1);
                }
                if (this.reviewitem != null && this.reviewitem.getReview() != null && this.reviewitem.getReview().getRepository() != null && this.reviewitem.getReview().getRepository().getAccount() != null && this.reviewitem.getReview().getRepository().getAccount() != ((Comment)annotation.getComment()).getAuthor() && ((Comment)annotation.getComment()).isDraft()) continue;
                CommentPart part = new CommentPart(annotation.getComment(), this.annotationInput.getBehavior());
                this.commentList.add((Comment)annotation.getComment());
                part.hookCustomActionRunListener(this);
                Control control = part.createControl(this.composite, this.toolkit);
                this.toolkit.adapt(control, true, true);
            }
            if (this.openDialogOnHover) {
                this.composite.addMouseTrackListener((MouseTrackListener)new MouseTrackAdapter(){

                    public void mouseEnter(MouseEvent e) {
                        CommentPopupDialog.this.openCommentDialog();
                    }
                });
            } else {
                Hyperlink hyperlink = this.toolkit.createHyperlink(this.composite, Messages.CommentPopupDialog_Edit_discard_or_reply, 0);
                hyperlink.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

                    public void linkActivated(HyperlinkEvent e) {
                        CommentPopupDialog.this.openCommentDialog();
                    }
                });
            }
            this.composite.setBackground(this.toolkit.getColors().getBackground());
            this.scrolledComposite.layout(true, true);
            this.scrolledComposite.setMinSize(this.composite.computeSize(-1, -1));
        } else {
            input = null;
        }
    }

    private void openCommentDialog() {
        PixelConverter Pc = new PixelConverter(this.composite.getFont());
        int lineHeight = Pc.convertHeightInCharsToPixels(1);
        if (this.range != null && this.reviewitem != null && this.currentCommentInputDialog == null) {
            this.dispose();
            Shell ashell = PlatformUI.getWorkbench().getDisplay().getActiveShell();
            this.currentCommentInputDialog = new CommentInputDialog(ashell, this.annotationInput.getBehavior(), this.reviewitem, this.range);
            this.currentCommentInputDialog.setComments(this.commentList);
            this.currentCommentInputDialog.create();
            this.currentCommentInputDialog.getShell().setText(NLS.bind((String)Messages.CommentInputDialog_LineNumber, (Object)this.range.getStartLine(), (Object)new Path(this.reviewitem.getName()).lastSegment()));
            Point size = new Point(550, 150);
            size.y = this.annotationInput.getAnnotations().size() < 5 ? (size.y += this.annotationInput.getAnnotations().size() * 3 * lineHeight) : (size.y += 15 * lineHeight);
            this.currentCommentInputDialog.getShell().setSize(size);
            this.currentCommentInputDialog.open();
        }
    }

    @Override
    public void actionAboutToRun(Action action) {
        this.close();
    }

    @Override
    public void actionRan(Action action) {
        this.close();
    }

    public static CommentPopupDialog getCurrentPopupDialog() {
        return currentPopupDialog;
    }

    public void setInformationControl(CommentInformationControl crucibleInformationControl) {
        this.informationControl = crucibleInformationControl;
    }

    public CommentInformationControl getInformationControl() {
        return this.informationControl;
    }
}

