/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.reviews.ui.providers;

import java.util.ArrayList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.mylyn.internal.reviews.ui.providers.GenericTreeContentProvider;
import org.eclipse.mylyn.internal.reviews.ui.providers.GlobalCommentsNode;
import org.eclipse.mylyn.internal.reviews.ui.providers.RetrievingContentsNode;
import org.eclipse.mylyn.reviews.core.model.IComment;
import org.eclipse.mylyn.reviews.core.model.ICommentContainer;
import org.eclipse.mylyn.reviews.core.model.IFileItem;
import org.eclipse.mylyn.reviews.core.model.IReview;
import org.eclipse.mylyn.reviews.core.model.IReviewItem;
import org.eclipse.mylyn.reviews.core.model.IReviewItemSet;

public class ReviewsTreeContentProvider
extends GenericTreeContentProvider {
    public Object[] getElements(Object element) {
        if (element instanceof GlobalCommentsNode) {
            return ((GlobalCommentsNode)element).getReview().getComments().toArray();
        }
        if (element instanceof EObject) {
            ArrayList<Object> children = new ArrayList<Object>();
            if (element instanceof IReview) {
                children.add(new GlobalCommentsNode((IReview)element));
                children.addAll(((IReview)element).getSets());
                return children.toArray();
            }
            if (element instanceof IReviewItemSet) {
                IReviewItemSet itemSet = (IReviewItemSet)element;
                if (itemSet.getItems().size() > 0) {
                    children.addAll(itemSet.getComments());
                    children.addAll(itemSet.getItems());
                } else {
                    children.add(new RetrievingContentsNode(itemSet));
                }
            }
            if (element instanceof IComment) {
                IComment comment = (IComment)element;
                children.addAll(comment.getReplies());
            }
            if (element instanceof IFileItem) {
                IFileItem item = (IFileItem)element;
                for (IComment comment : item.getBase().getComments()) {
                    children.add(comment);
                }
                for (IComment comment : item.getTarget().getComments()) {
                    children.add(comment);
                }
            }
            return children.toArray();
        }
        return this.getCollectionChildren(element);
    }

    @Override
    public boolean hasChildren(Object element) {
        if (element instanceof IReview) {
            return ((IReview)element).getSets().size() > 0;
        }
        if (element instanceof GlobalCommentsNode) {
            return ((GlobalCommentsNode)element).getReview().getComments().size() > 0;
        }
        return element instanceof ICommentContainer && ((ICommentContainer)element).getAllComments().size() > 0 || element instanceof IReview && ((IReview)element).getSets().size() > 0 || element instanceof GlobalCommentsNode && this.hasChildren(((GlobalCommentsNode)element).getReview()) || element instanceof IReviewItemSet || this.hasCollectionChildren(element);
    }

    @Override
    public Object getParent(Object element) {
        if (element instanceof IReviewItem) {
            return ((IReviewItem)element).getReview();
        }
        return null;
    }
}

