/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.commons.workbench;

import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.mylyn.commons.ui.compatibility.CommonThemes;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Region;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Scrollable;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.themes.IThemeManager;

public abstract class GradientDrawer {
    private final Listener CATEGORY_GRADIENT_DRAWER = new Listener(){

        public void handleEvent(Event event) {
            if (GradientDrawer.this.shouldApplyGradient(event)) {
                Scrollable scrollable = (Scrollable)event.widget;
                GC gc = event.gc;
                Rectangle area = scrollable.getClientArea();
                Rectangle rect = event.getBounds();
                this.expandRegion(event, scrollable, gc, area);
                Color oldForeground = gc.getForeground();
                Color oldBackground = gc.getBackground();
                gc.setForeground(GradientDrawer.this.categoryGradientEnd);
                gc.drawLine(0, rect.y, area.width, rect.y);
                gc.setForeground(GradientDrawer.this.categoryGradientStart);
                gc.setBackground(GradientDrawer.this.categoryGradientEnd);
                gc.fillGradientRectangle(0, rect.y + 1, area.width, rect.height, true);
                gc.setForeground(GradientDrawer.this.categoryGradientEnd);
                gc.drawLine(0, rect.y + rect.height - 1, area.width, rect.y + rect.height - 1);
                gc.setForeground(oldForeground);
                gc.setBackground(oldBackground);
                event.detail &= 0xFFFFFFF7;
            }
        }

        private void expandRegion(Event event, Scrollable scrollable, GC gc, Rectangle area) {
            int width;
            int columnCount = scrollable instanceof Table ? ((Table)scrollable).getColumnCount() : ((Tree)scrollable).getColumnCount();
            if ((event.index == columnCount - 1 || columnCount == 0) && (width = area.x + area.width - event.x) > 0) {
                Region region = new Region();
                gc.getClipping(region);
                region.add(event.x, event.y, width, event.height);
                gc.setClipping(region);
                region.dispose();
            }
        }
    };
    private final IPropertyChangeListener THEME_CHANGE_LISTENER = new IPropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent event) {
            if (event.getProperty().equals("CHANGE_CURRENT_THEME") || event.getProperty().equals("org.eclipse.mylyn.tasks.ui.colors.foreground.past.scheduled") || event.getProperty().equals("org.eclipse.mylyn.tasks.ui.colors.foreground.today.completed") || event.getProperty().equals("org.eclipse.mylyn.tasks.ui.colors.foreground.completed") || event.getProperty().equals("org.eclipse.mylyn.tasks.ui.colors.foreground.past.due") || event.getProperty().equals("org.eclipse.mylyn.tasks.ui.colors.foreground.today.scheduled") || event.getProperty().equals("org.eclipse.mylyn.tasks.ui.colors.foreground.past.scheduled") || event.getProperty().equals("org.eclipse.mylyn.tasks.ui.colors.foreground.today.scheduled") || event.getProperty().equals("org.eclipse.mylyn.tasks.ui.colors.foreground.thisweek.scheduled") || event.getProperty().equals("org.eclipse.mylyn.tasks.ui.colors.foreground.task.active") || CommonThemes.isCommonTheme((String)event.getProperty())) {
                GradientDrawer.this.configureGradientColors();
            }
        }
    };
    private boolean gradientListenerAdded = false;
    private final IThemeManager themeManager;
    private Color categoryGradientStart;
    private Color categoryGradientEnd;
    private final TreeViewer treeViewer;

    protected abstract boolean shouldApplyGradient(Event var1);

    public GradientDrawer(IThemeManager theThemeManager, TreeViewer treeViewer) {
        this.themeManager = theThemeManager;
        this.treeViewer = treeViewer;
        treeViewer.getControl().addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                if (GradientDrawer.this.themeManager != null) {
                    GradientDrawer.this.themeManager.removePropertyChangeListener(GradientDrawer.this.THEME_CHANGE_LISTENER);
                }
            }
        });
        this.configureGradientColors();
        this.themeManager.addPropertyChangeListener(this.THEME_CHANGE_LISTENER);
    }

    private void configureGradientColors() {
        this.categoryGradientStart = this.themeManager.getCurrentTheme().getColorRegistry().get("org.eclipse.mylyn.tasks.ui.colors.category.gradient.start");
        this.categoryGradientEnd = this.themeManager.getCurrentTheme().getColorRegistry().get("org.eclipse.mylyn.tasks.ui.colors.category.gradient.end");
        boolean customized = true;
        if (this.categoryGradientStart != null && this.categoryGradientStart.getRed() == 240 && this.categoryGradientStart.getGreen() == 240 && this.categoryGradientStart.getBlue() == 240 && this.categoryGradientEnd != null && this.categoryGradientEnd.getRed() == 220 && this.categoryGradientEnd.getGreen() == 220 && this.categoryGradientEnd.getBlue() == 220) {
            customized = false;
        }
        if (!this.gradientListenerAdded && this.categoryGradientStart != null && !this.categoryGradientStart.equals((Object)this.categoryGradientEnd)) {
            this.getViewer().getTree().addListener(40, this.CATEGORY_GRADIENT_DRAWER);
            this.gradientListenerAdded = true;
            if (!customized) {
                double GRADIENT_BOTTOM;
                double GRADIENT_TOP;
                Color parentBackground = this.getViewer().getTree().getParent().getBackground();
                if ("Windows 7".equals(System.getProperty("os.name"))) {
                    GRADIENT_TOP = 1.05;
                    GRADIENT_BOTTOM = 1.09;
                } else {
                    GRADIENT_TOP = 1.05;
                    GRADIENT_BOTTOM = 0.995;
                }
                int red = Math.max(0, Math.min(255, (int)((double)parentBackground.getRed() * GRADIENT_TOP)));
                int green = Math.max(0, Math.min(255, (int)((double)parentBackground.getGreen() * GRADIENT_TOP)));
                int blue = Math.max(0, Math.min(255, (int)((double)parentBackground.getBlue() * GRADIENT_TOP)));
                try {
                    this.categoryGradientStart = new Color((Device)Display.getDefault(), red, green, blue);
                }
                catch (Exception exception) {
                    this.categoryGradientStart = this.getViewer().getTree().getParent().getBackground();
                }
                red = Math.min(255, Math.max(0, (int)((double)parentBackground.getRed() / GRADIENT_BOTTOM)));
                green = Math.min(255, Math.max(0, (int)((double)parentBackground.getGreen() / GRADIENT_BOTTOM)));
                blue = Math.min(255, Math.max(0, (int)((double)parentBackground.getBlue() / GRADIENT_BOTTOM)));
                try {
                    this.categoryGradientEnd = new Color((Device)Display.getDefault(), red, green, blue);
                }
                catch (Exception exception) {
                    this.categoryGradientStart = this.getViewer().getTree().getParent().getBackground();
                }
            }
        } else if (this.categoryGradientStart != null && this.categoryGradientStart.equals((Object)this.categoryGradientEnd)) {
            this.getViewer().getTree().removeListener(40, this.CATEGORY_GRADIENT_DRAWER);
            this.gradientListenerAdded = false;
        }
    }

    public TreeViewer getViewer() {
        return this.treeViewer;
    }
}

