/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.wikitext.ui.registry;

import org.eclipse.mylyn.wikitext.core.parser.markup.MarkupLanguage;
import org.eclipse.mylyn.wikitext.tests.EclipseRuntimeRequired;
import org.eclipse.mylyn.wikitext.ui.WikiText;
import org.junit.Assert;
import org.junit.Test;

@EclipseRuntimeRequired
public class WikiTextTest {
    @Test
    public void getFileExtensions() {
        Assert.assertTrue((boolean)WikiText.getMarkupFileExtensions().contains("textile"));
    }

    @Test
    public void getMarkupLanguage() {
        MarkupLanguage markupLanguage = WikiText.getMarkupLanguage((String)"Textile");
        Assert.assertNotNull((Object)markupLanguage);
        Assert.assertEquals((Object)"Textile", (Object)markupLanguage.getName());
    }

    @Test
    public void getMarkupLanguageCopied() {
        MarkupLanguage markupLanguage = WikiText.getMarkupLanguage((String)"Textile");
        Assert.assertNotSame((Object)markupLanguage, (Object)WikiText.getMarkupLanguage((String)"Textile"));
    }

    @Test
    public void getMarkupLanguageForFilename() {
        MarkupLanguage markupLanguage = WikiText.getMarkupLanguageForFilename((String)"test.textile");
        Assert.assertNotNull((Object)markupLanguage);
        Assert.assertEquals((Object)"Textile", (Object)markupLanguage.getName());
    }

    @Test
    public void getMarkupLanguageForFilenameCopied() {
        MarkupLanguage markupLanguage = WikiText.getMarkupLanguageForFilename((String)"test.textile");
        Assert.assertNotSame((Object)markupLanguage, (Object)WikiText.getMarkupLanguageForFilename((String)"test.textile"));
    }

    @Test
    public void getMarkupLanguageNameForFilename() {
        Assert.assertEquals((Object)"Textile", (Object)WikiText.getMarkupLanguageNameForFilename((String)"test.textile"));
        Assert.assertEquals((Object)"Textile", (Object)WikiText.getMarkupLanguageNameForFilename((String)"test.Textile"));
        Assert.assertEquals((Object)"Textile", (Object)WikiText.getMarkupLanguageNameForFilename((String)"test.textiLe"));
        Assert.assertEquals((Object)"Textile", (Object)WikiText.getMarkupLanguageNameForFilename((String)".textile"));
        Assert.assertNull((Object)WikiText.getMarkupLanguageNameForFilename((String)".txt"));
    }

    @Test
    public void getMarkupLanguageNames() {
        Assert.assertTrue((boolean)WikiText.getMarkupLanguageNames().contains("Textile"));
        Assert.assertTrue((boolean)WikiText.getMarkupLanguageNames().contains("Confluence"));
        Assert.assertTrue((boolean)WikiText.getMarkupLanguageNames().contains("MediaWiki"));
    }

    @Test
    public void getMarkupValidator() {
        Assert.assertNotNull((Object)WikiText.getMarkupValidator((String)"Textile"));
    }
}

