/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.builds.ui.console;

import java.io.BufferedReader;
import java.io.IOException;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.mylyn.builds.core.IBuild;
import org.eclipse.mylyn.builds.internal.core.BuildModel;
import org.eclipse.mylyn.builds.internal.core.operations.GetBuildOutputOperation;
import org.eclipse.mylyn.commons.core.operations.IOperationMonitor;
import org.eclipse.mylyn.internal.builds.ui.BuildImages;
import org.eclipse.mylyn.internal.builds.ui.BuildsUiInternal;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.console.IConsole;
import org.eclipse.ui.console.IConsoleManager;
import org.eclipse.ui.console.MessageConsole;
import org.eclipse.ui.console.MessageConsoleStream;

public class BuildConsole {
    private final IBuild build;
    private final IConsoleManager consoleManager;
    private MessageConsole console;
    private GetBuildOutputOperation operation;
    private MessageConsoleStream stream;
    static final String CONSOLE_TYPE = "org.eclipse.mylyn.builds.ui.console.BuildConsole";
    static final String ATTRIBUTE_BUILD = "org.eclipse.mylyn.builds.ui.console.build";

    public BuildConsole(IConsoleManager consoleManager, BuildModel model, IBuild build) {
        Assert.isNotNull((Object)consoleManager);
        Assert.isNotNull((Object)model);
        Assert.isNotNull((Object)build);
        this.consoleManager = consoleManager;
        this.build = build;
    }

    public MessageConsole show() {
        if (this.console == null) {
            this.console = new MessageConsole(NLS.bind((String)"Output for Build {0}", (Object)this.build.getLabel()), CONSOLE_TYPE, BuildImages.CONSOLE, true);
            this.consoleManager.addConsoles(new IConsole[]{this.console});
            this.console.setAttribute(ATTRIBUTE_BUILD, (Object)this.build);
            this.stream = this.console.newMessageStream();
        }
        this.doGetOutput();
        this.consoleManager.showConsoleView((IConsole)this.console);
        return this.console;
    }

    public void close() {
        if (this.operation != null) {
            this.operation.cancel();
        }
    }

    private void doGetOutput() {
        if (this.operation == null) {
            this.operation = new GetBuildOutputOperation(BuildsUiInternal.getOperationService(), this.build, new GetBuildOutputOperation.BuildOutputReader(){

                public void handle(GetBuildOutputOperation.BuildOutputEvent event, IOperationMonitor monitor) throws IOException, CoreException {
                    String line;
                    BufferedReader reader = event.getInput();
                    while ((line = reader.readLine()) != null) {
                        if (BuildConsole.this.stream.isClosed()) {
                            throw new OperationCanceledException();
                        }
                        BuildConsole.this.stream.println(line);
                    }
                }

                public void done() {
                    BuildConsole.this.operation = null;
                }
            });
            this.operation.execute();
        }
    }
}

