/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.tasks.tests;

import junit.framework.TestCase;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.mylyn.internal.tasks.core.AbstractTask;
import org.eclipse.mylyn.internal.tasks.ui.TasksUiPlugin;
import org.eclipse.mylyn.internal.tasks.ui.util.TasksUiInternal;
import org.eclipse.mylyn.internal.tasks.ui.views.TaskListView;
import org.eclipse.mylyn.internal.tasks.ui.wizards.MultiRepositoryAwareWizard;
import org.eclipse.mylyn.internal.tasks.ui.wizards.SelectRepositoryPage;
import org.eclipse.mylyn.tasks.core.ITask;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.tests.connector.MockTask;
import org.eclipse.mylyn.tasks.ui.TasksUiUtil;
import org.eclipse.mylyn.tasks.ui.wizards.NewTaskWizard;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class NewTaskWizardRepositorySelectionTest
extends TestCase {
    public void testRepositorySettingWithTaskListSelection() {
        TaskRepository mockRepository = new TaskRepository("mock", "http://mockrepository.test");
        TasksUiPlugin.getRepositoryManager().addRepository(mockRepository);
        Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
        TaskListView view = (TaskListView)TasksUiUtil.openTasksViewInActivePerspective();
        MockTask mockTask = new MockTask("mock.task");
        TasksUiPlugin.getTaskActivityManager().scheduleNewTask((AbstractTask)mockTask);
        TasksUiPlugin.getTaskList().addTask((ITask)mockTask);
        view.setFocusedMode(true);
        view.getViewer().refresh();
        view.getViewer().expandAll();
        view.getViewer().setSelection((ISelection)new StructuredSelection((Object)mockTask), true);
        NewTaskWizardRepositorySelectionTest.assertEquals((Object)((Object)mockTask), (Object)((StructuredSelection)view.getViewer().getSelection()).getFirstElement());
        MultiRepositoryAwareWizard wizard = TasksUiInternal.createNewTaskWizard(null);
        WizardDialog dialog = null;
        dialog = new WizardDialog(shell, (IWizard)wizard);
        dialog.setBlockOnOpen(false);
        dialog.open();
        SelectRepositoryPage page = (SelectRepositoryPage)wizard.getPages()[0];
        NewTaskWizardRepositorySelectionTest.assertTrue((boolean)page.getRepositories().contains(mockRepository));
        NewTaskWizardRepositorySelectionTest.assertEquals((Object)mockRepository, (Object)((IStructuredSelection)page.getViewer().getSelection()).getFirstElement());
        TasksUiPlugin.getRepositoryManager().removeRepository(mockRepository);
        TasksUiPlugin.getTaskList().deleteTask((ITask)mockTask);
        wizard.dispose();
        dialog.close();
    }

    public void testDefaultWithNoTaskListSelection() {
        TaskListView view = (TaskListView)TasksUiUtil.openTasksViewInActivePerspective();
        view.getViewer().setSelection((ISelection)new StructuredSelection());
        NewTaskWizard wizard = new NewTaskWizard(null, null);
        Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
        WizardDialog dialog = null;
        dialog = new WizardDialog(shell, (IWizard)wizard);
        dialog.setBlockOnOpen(false);
        dialog.open();
        SelectRepositoryPage page = (SelectRepositoryPage)wizard.getPages()[0];
        TaskRepository localRepository = (TaskRepository)TasksUiPlugin.getRepositoryManager().getRepositories("local").iterator().next();
        NewTaskWizardRepositorySelectionTest.assertEquals((Object)localRepository, (Object)((IStructuredSelection)page.getViewer().getSelection()).getFirstElement());
        wizard.dispose();
        dialog.close();
    }
}

